/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.net.udpPacket;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.UdpPacket;
import java.net.SocketAddress;

public class OutgoingUdpPacket
extends UdpPacket {
    private transient int __m_AddressCount;
    private transient Member __m_Member;
    private SocketAddress[] __m_SocketAddresses;

    public OutgoingUdpPacket() {
        this(null, null, true);
    }

    public OutgoingUdpPacket(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addAddress(SocketAddress addr) {
        if (addr != null) {
            int iAddress = this.getAddressCount();
            int cAddress = iAddress + 1;
            this.ensureAddressCapacity(cAddress);
            SocketAddress[] aAddr = this.getSocketAddresses();
            aAddr[iAddress] = addr;
            this.setAddressCount(cAddress);
        }
    }

    public void ensureAddressCapacity(int cAddress) {
        SocketAddress[] aAddr = this.getSocketAddresses();
        if (aAddr == null ? true : aAddr.length < cAddress) {
            SocketAddress[] aAddrNew = new SocketAddress[cAddress];
            if (aAddr != null) {
                System.arraycopy(aAddr, 0, aAddrNew, 0, aAddr.length);
            }
            this.setSocketAddresses(aAddrNew);
        }
    }

    public int getAddressCount() {
        return this.__m_AddressCount;
    }

    public String getAddressDescription() {
        StringBuilder sb = new StringBuilder("[");
        SocketAddress[] aAddr = this.getSocketAddresses();
        int i = 0;
        int c = aAddr.length;
        while (i < c) {
            if (aAddr[i] != null) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(aAddr[i]);
            }
            ++i;
        }
        return sb.append("]").toString();
    }

    public Member getMember() {
        return this.__m_Member;
    }

    public SocketAddress[] getSocketAddresses() {
        return this.__m_SocketAddresses;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/net/udpPacket/OutgoingUdpPacket".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new OutgoingUdpPacket();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isCommonDestination(UdpPacket packet) {
        if (packet instanceof OutgoingUdpPacket) {
            int cAddrThat;
            OutgoingUdpPacket packetThat = (OutgoingUdpPacket)packet;
            if (!(this.getAddressCount() == 1) ? false : packetThat.getAddressCount() == 1) {
                return this.getSocketAddresses()[0].equals(packetThat.getSocketAddresses()[0]);
            }
            SocketAddress[] aAddrThis = this.getSocketAddresses();
            SocketAddress[] aAddrThat = packetThat.getSocketAddresses();
            int cAddrThis = this.getAddressCount();
            if (cAddrThis == (cAddrThat = packetThat.getAddressCount())) {
                int i = 0;
                while (i < cAddrThis) {
                    if (aAddrThis[i].equals(aAddrThat[i]) ^ true) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
        }
        return false;
    }

    public void reset() {
        super.reset();
        this.setAddressCount(0);
    }

    protected void setAddressCount(int c) {
        this.__m_AddressCount = c;
    }

    public void setMember(Member member) {
        this.__m_Member = member;
    }

    protected void setSocketAddresses(SocketAddress[] addr) {
        this.__m_SocketAddresses = addr;
    }
}

