/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Listeners;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import java.util.EventListener;

public class CacheEvent
extends Util
implements Runnable {
    private MapListenerSupport __m_ListenerSupport;
    private Listeners __m_Listeners;
    private MapEvent __m_MapEvent;
    private MapListener __m_MapListener;

    public CacheEvent() {
        this(null, null, true);
    }

    public CacheEvent(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public static void dispatchSafe(MapEvent event, Listeners listeners, Queue queue) {
        if (listeners != null) {
            EventListener[] aListener = listeners.listeners();
            int i = 0;
            int c = aListener.length;
            while (i < c) {
                MapListener listener = (MapListener)aListener[i];
                if (listener instanceof MapListenerSupport.SynchronousListener) {
                    try {
                        event.dispatch(listener);
                    }
                    catch (Throwable e) {
                        Component._trace(String.valueOf("An exception occured while dispatching synchronous event:") + event, 1);
                        Component._trace(e);
                        Component._trace("(The exception has been logged and execution is continuing.)", 1);
                    }
                } else {
                    queue.add(CacheEvent.instantiate(event, listener));
                }
                ++i;
            }
        }
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public Listeners getListeners() {
        return this.__m_Listeners;
    }

    public MapEvent getMapEvent() {
        return this.__m_MapEvent;
    }

    public MapListener getMapListener() {
        return this.__m_MapListener;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/CacheEvent".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new CacheEvent();
    }

    private final Component get_Module() {
        return this;
    }

    public static CacheEvent instantiate(MapEvent event, Listeners listeners) {
        Component._assert(!(event != null) ? false : listeners != null);
        CacheEvent task = new CacheEvent();
        task.setMapEvent(event);
        task.setListeners(listeners);
        return task;
    }

    public static CacheEvent instantiate(MapEvent event, MapListener listener) {
        Component._assert(!(event != null) ? false : listener != null);
        CacheEvent task = new CacheEvent();
        task.setMapEvent(event);
        task.setMapListener(listener);
        return task;
    }

    public static CacheEvent instantiate(MapEvent event, MapListenerSupport support) {
        Component._assert(!(event != null) ? false : support != null);
        CacheEvent task = new CacheEvent();
        task.setMapEvent(event);
        task.setListenerSupport(support);
        return task;
    }

    public void run() {
        MapEvent event = this.getMapEvent();
        NamedCache cache = (NamedCache)event.getSource();
        if (cache.isActive()) {
            MapListenerSupport support = this.getListenerSupport();
            if (support == null) {
                Listeners listeners = this.getListeners();
                if (listeners == null) {
                    event.dispatch(this.getMapListener());
                } else {
                    event.dispatch(listeners, true);
                }
            } else {
                support.fireEvent(event, true);
            }
        }
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    protected void setListeners(Listeners listeners) {
        this.__m_Listeners = listeners;
    }

    protected void setMapEvent(MapEvent event) {
        this.__m_MapEvent = event;
    }

    protected void setMapListener(MapListener listener) {
        this.__m_MapListener = listener;
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + ": " + this.getMapEvent();
    }
}

