/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;

public class Daemon
extends Util
implements Guardian,
Runnable {
    public static final int DAEMON_EXITED = 4;
    public static final int DAEMON_EXITING = 3;
    public static final int DAEMON_INITIAL = 0;
    public static final int DAEMON_RUNNING = 2;
    public static final int DAEMON_STARTING = 1;
    private boolean __m_AutoStart;
    private transient int __m_DaemonState;
    private transient float __m_DefaultGuardRecovery;
    private transient long __m_DefaultGuardTimeout;
    private transient boolean __m_Exiting;
    private GuardSupport __m_GuardSupport;
    private Daemon$Guard __m_Guardable;
    private transient Object __m_Lock;
    private transient boolean __m_Notification;
    private int __m_Priority;
    private transient Throwable __m_StartException;
    private transient long __m_StartTimestamp;
    private transient Thread __m_Thread;
    private transient ThreadGroup __m_ThreadGroup;
    private String __m_ThreadName;
    private long __m_WaitMillis;
    private static transient long __s_ClockResolutionMillis;

    static {
        Daemon._initStatic();
    }

    public Daemon() {
        this(null, null, true);
    }

    public Daemon(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        try {
            Daemon.setClockResolutionMillis(1L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void _initStatic$Default() {
        Daemon.__initStatic();
    }

    protected static void _initStatic() {
        block7: {
            Daemon._initStatic$Default();
            try {
                String sMillis = System.getProperty("tangosol.coherence.clock_resolution");
                if (sMillis == null) {
                    String sOS = System.getProperty("os.name", "");
                    if (sOS.indexOf("Windows") != -1) {
                        if (Runtime.getRuntime().availableProcessors() > 1) {
                            Daemon.setClockResolutionMillis(16);
                        } else {
                            Daemon.setClockResolutionMillis(10);
                        }
                    } else {
                        Daemon.setClockResolutionMillis(20);
                    }
                    break block7;
                }
                Daemon.setClockResolutionMillis(Integer.parseInt(sMillis));
            }
            catch (Exception exception) {}
        }
    }

    protected void checkGuardables() {
        if (this.isGuardian()) {
            this.getGuardSupport().check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GuardSupport ensureGuardSupport() {
        GuardSupport support = this.getGuardSupport();
        if (support == null) {
            Daemon daemon = this;
            synchronized (daemon) {
                if (support == null) {
                    support = new GuardSupport(this);
                    this.setGuardSupport(support);
                }
            }
        }
        return support;
    }

    protected void finalize() throws Throwable {
        try {
            this.stop();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    public static long getClockResolutionMillis() {
        return __s_ClockResolutionMillis;
    }

    public int getDaemonState() {
        return this.__m_DaemonState;
    }

    public float getDefaultGuardRecovery() {
        return this.__m_DefaultGuardRecovery;
    }

    public long getDefaultGuardTimeout() {
        return this.__m_DefaultGuardTimeout;
    }

    public GuardSupport getGuardSupport() {
        return this.__m_GuardSupport;
    }

    public Daemon$Guard getGuardable() {
        return this.__m_Guardable;
    }

    public Object getLock() {
        Object oLock = this.__m_Lock;
        return oLock == null ? this : oLock;
    }

    public int getPriority() {
        return this.__m_Priority;
    }

    public Throwable getStartException() {
        return this.__m_StartException;
    }

    public long getStartTimestamp() {
        return this.__m_StartTimestamp;
    }

    public Thread getThread() {
        return this.__m_Thread;
    }

    public ThreadGroup getThreadGroup() {
        return this.__m_ThreadGroup;
    }

    public String getThreadName() {
        String sName = this.__m_ThreadName;
        return sName == null ? this.get_Name() : sName;
    }

    public long getWaitMillis() {
        return this.__m_WaitMillis;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/Daemon".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new Daemon();
    }

    private final Component get_Module() {
        return this;
    }

    public Guardian.GuardContext guard(Guardable guardable) {
        return this.guard(guardable, this.getDefaultGuardTimeout(), this.getDefaultGuardRecovery());
    }

    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        GuardSupport support = this.ensureGuardSupport();
        support.remove(guardable);
        return cMillis == 0L ? null : support.add(guardable, cMillis, flPctRecover);
    }

    protected void halt() {
        this.setDaemonState(DAEMON_EXITING);
        Thread thread = this.getThread();
        if (thread != null) {
            try {
                thread.interrupt();
                ClassHelper.invoke(thread, "stop", null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setThread(null);
    }

    protected void heartbeat() {
        this.heartbeat(0);
    }

    protected void heartbeat(long cMillis) {
        this.checkGuardables();
        Guardian.GuardContext context = this.getGuardable().getContext();
        if (context != null) {
            if (cMillis == (long)0) {
                context.heartbeat();
            } else {
                context.heartbeat(cMillis);
            }
        }
    }

    public boolean isAutoStart() {
        return this.__m_AutoStart;
    }

    public boolean isExiting() {
        return this.getDaemonState() == DAEMON_EXITING;
    }

    public boolean isGuarded() {
        Daemon$Guard guard = this.getGuardable();
        return !(guard != null) ? false : guard.getContext() != null;
    }

    public boolean isGuardian() {
        GuardSupport support = this.getGuardSupport();
        return !(support != null) ? false : support.getGuardableCount() > 0;
    }

    public boolean isNotification() {
        return this.__m_Notification;
    }

    public boolean isStarted() {
        int nState = this.getDaemonState();
        return !(nState > DAEMON_INITIAL) ? false : nState < DAEMON_EXITED;
    }

    public boolean join(long cMillis) {
        try {
            Thread thread = this.getThread();
            if (thread != null) {
                thread.join(cMillis);
                return thread.isAlive() ^ true;
            }
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    protected void onEnter() {
        this.setStartTimestamp(Base.getSafeTimeMillis());
    }

    protected void onException(Throwable e) {
        if (this.isExiting()) {
            Component._trace(String.valueOf(this.get_Name()) + " caught an unhandled exception (" + e.getClass().getName() + ": " + e.getMessage() + ") while exiting.", 4);
        } else {
            Component._trace(String.valueOf("Terminating ") + this.get_Name() + " due to unhandled exception: " + e.getClass().getName(), 1);
            Component._trace(e);
            this.stop();
        }
    }

    protected void onExit() {
        if (this.isGuarded()) {
            this.getGuardable().getContext().release();
        }
        if (this.isGuardian()) {
            this.getGuardSupport().release();
        }
    }

    public void onInit() {
        super.onInit();
        this.setGuardable((Daemon$Guard)this._findChild("Guard"));
        if (this.isAutoStart()) {
            this.start();
        }
    }

    protected void onInterrupt(InterruptedException e) {
        if (this.isExiting() ^ true) {
            Component._trace(String.valueOf("Interrupted ") + this.get_Name() + ", " + Thread.currentThread());
        }
    }

    protected void onNotify() {
    }

    protected void onUnexpectedThread() {
        String sMsg;
        Thread threadThis;
        Thread threadDaemon = this.getThread();
        Component._assert(threadDaemon != (threadThis = Thread.currentThread()));
        if (!(System.identityHashCode(threadThis) == System.identityHashCode(threadDaemon)) ? false : Base.equals(threadThis.getName(), threadDaemon.getName())) {
            sMsg = String.valueOf("thread identity corruption detected; the running thread ") + threadThis + " has failed a reference equality check with " + threadDaemon + " but matches the daemon's name and " + "identity hash code; this indicates a JVM error.";
            threadThis.setName(new UUID().toString());
            sMsg = Base.equals(threadThis.getName(), threadDaemon.getName()) ? String.valueOf("Positive ") + sMsg : (threadThis.getThreadGroup() == threadDaemon.getThreadGroup() ? String.valueOf("Probable ") + sMsg : String.valueOf("Possible ") + sMsg);
        } else {
            sMsg = String.valueOf("run() invoked on unexpected thread ") + threadThis;
        }
        throw new IllegalStateException(sMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onWait() throws InterruptedException {
        if (this.isNotification() ^ true) {
            Object oLock = this.getLock();
            long cWait = this.getWaitMillis();
            Object object = oLock;
            synchronized (object) {
                if (!(cWait >= (long)0) ? false : this.isNotification() ^ true) {
                    oLock.wait(cWait);
                }
                this.setNotification(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive exception aggregation
     */
    public void run() {
        if (Thread.currentThread() != this.getThread()) {
            this.onUnexpectedThread();
        }
        try {
            try {
                this.onEnter();
            }
            catch (Throwable e) {
                this.setStartException(e);
                this.setExiting(true);
                this.onException(e);
                var2_7 = null;
                try {
                    var3_11 = this;
                    synchronized (var3_11) {
                        try {
                            Thread.interrupted();
                            this.onExit();
                        }
                        finally {
                            var5_17 = null;
                            this.setThread(null);
                            this.setDaemonState(Daemon.DAEMON_EXITED);
                            this.notifyAll();
                        }
                    }
                }
                catch (Throwable e) {
                    this.onException(e);
                }
                return;
            }
            e = this;
            synchronized (e) {
                this.setDaemonState(Daemon.DAEMON_RUNNING);
                this.notifyAll();
                // MONITOREXIT @DISABLED, blocks:[0, 2, 7] lbl42 : MonitorExitStatement: MONITOREXIT : e
                if (true) ** GOTO lbl59
            }
            do {
                try {
                    this.onWait();
                    if (!(this.isExiting() ^ true)) continue;
                    this.onNotify();
                }
                catch (EventDeathException e) {
                }
                catch (InterruptedException e) {
                    this.onInterrupt(e);
                }
                catch (Throwable e) {
                    this.onException(e);
                }
lbl59:
                // 6 sources

            } while (this.isExiting() ^ true);
        }
        finally {
            var2_9 = null;
            try {
                var3_13 = this;
                synchronized (var3_13) {
                    try {
                        Thread.interrupted();
                        this.onExit();
                    }
                    finally {
                        var5_19 = null;
                        this.setThread(null);
                        this.setDaemonState(Daemon.DAEMON_EXITED);
                        this.notifyAll();
                    }
                }
            }
            catch (Throwable e) {
                this.onException(e);
            }
        }
    }

    public void setAutoStart(boolean fAutoStart) {
        this.__m_AutoStart = fAutoStart;
    }

    protected static void setClockResolutionMillis(long cMillis) {
        __s_ClockResolutionMillis = Math.max((long)1, cMillis);
    }

    protected void setDaemonState(int nState) {
        if (nState > this.getDaemonState()) {
            this.__m_DaemonState = nState;
        }
    }

    public void setDefaultGuardRecovery(float flPctRecover) {
        this.__m_DefaultGuardRecovery = flPctRecover;
    }

    public void setDefaultGuardTimeout(long cTimeoutMillis) {
        this.__m_DefaultGuardTimeout = cTimeoutMillis;
    }

    protected synchronized void setExiting(boolean fExiting) {
        this.setDaemonState(DAEMON_EXITING);
    }

    protected void setGuardSupport(GuardSupport guardSupport) {
        this.__m_GuardSupport = guardSupport;
    }

    protected void setGuardable(Daemon$Guard guardable) {
        this.__m_Guardable = guardable;
    }

    public void setLock(Object oLock) {
        this.__m_Lock = oLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotification(boolean fNotify) {
        if (this.is_Constructed()) {
            Object oLock;
            Object object = oLock = this.getLock();
            synchronized (object) {
                Thread thread;
                this.__m_Notification = fNotify;
                if (fNotify && (!((thread = this.getThread()) != null) ? false : thread != Thread.currentThread())) {
                    oLock.notifyAll();
                }
            }
        } else {
            this.__m_Notification = fNotify;
        }
    }

    public void setPriority(int nPriority) {
        this.__m_Priority = nPriority;
    }

    public void setStartException(Throwable e) {
        this.__m_StartException = e;
    }

    protected void setStartTimestamp(long lMillis) {
        this.__m_StartTimestamp = lMillis;
    }

    protected void setThread(Thread thread) {
        this.__m_Thread = thread;
    }

    public void setThreadGroup(ThreadGroup group) {
        this.__m_ThreadGroup = group;
    }

    public void setThreadName(String sName) {
        this.__m_ThreadName = sName;
    }

    public void setWaitMillis(long cMillis) {
        this.__m_WaitMillis = cMillis;
    }

    public static boolean sleep(long lMillis) {
        try {
            if (lMillis == (long)0) {
                Thread.yield();
            } else {
                Thread.sleep(lMillis);
            }
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public synchronized void start() {
        if (this.isStarted()) {
            return;
        }
        if (this.getDaemonState() == DAEMON_EXITED) {
            throw new IllegalStateException("Daemon is not restartable");
        }
        Thread thread = Base.makeThread(this.getThreadGroup(), this, this.getThreadName());
        thread.setDaemon(true);
        int nPriority = this.getPriority();
        if (nPriority != 0) {
            thread.setPriority(nPriority);
        }
        this.setThread(thread);
        this.setStartException(null);
        this.setDaemonState(DAEMON_STARTING);
        thread.start();
        try {
            do {
                this.wait(1000L);
            } while (!(this.getDaemonState() < DAEMON_RUNNING) ? false : thread.isAlive());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new WrapperException(e);
        }
        Throwable e = this.getStartException();
        if (e != null) {
            this.setStartException(null);
            throw new WrapperException(e);
        }
        if (this.getDaemonState() == DAEMON_STARTING) {
            throw new IllegalStateException(String.valueOf("daemon thread start failed: ") + thread);
        }
    }

    public synchronized void stop() {
        block3: {
            if (!this.isStarted()) break block3;
            this.setExiting(true);
            Thread thread = this.getThread();
            if (!(thread != null) ? false : thread != Thread.currentThread()) {
                try {
                    thread.interrupt();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

