/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.Collections;
import com.tangosol.coherence.component.util.collections.wrapperSet.EntrySet;
import com.tangosol.coherence.component.util.collections.wrapperSet.KeySet;
import com.tangosol.net.cache.CacheMap;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.WrapperException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DeltaMap
extends Util
implements CacheMap,
ObservableMap,
Map {
    public static final Object NO_VALUE;
    private Map __m_DeleteMap;
    private transient boolean __m_FullyRead;
    private Map __m_InsertMap;
    private transient MapListenerSupport __m_ListenerSupport;
    private Map __m_OriginalMap;
    private Map __m_ReadMap;
    private boolean __m_RepeatableRead;
    private Map __m_UpdateMap;

    static {
        try {
            NO_VALUE = null;
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    public DeltaMap() {
        this(null, null, true);
    }

    public DeltaMap(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setRepeatableRead(false);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public synchronized void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(listener, filter, fLite);
    }

    public synchronized void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support == null) {
            support = new MapListenerSupport();
            this.setListenerSupport(support);
        }
        support.addListener(listener, oKey, fLite);
    }

    public void clear() {
        this.clearImpl();
    }

    protected void clearImpl() {
        Map mapOrig;
        this.getInsertMap().clear();
        this.getUpdateMap().clear();
        if (this.isRepeatableRead()) {
            this.ensureReadAll();
            mapOrig = this.getReadMap();
        } else {
            mapOrig = this.getOriginalMap();
        }
        Iterator iter = mapOrig.keySet().iterator();
        while (iter.hasNext()) {
            this.getDeleteMap().put(iter.next(), null);
        }
    }

    public boolean containsKey(Object oKey) {
        return this.containsKeyImpl(oKey);
    }

    protected boolean containsKeyImpl(Object oKey) {
        boolean fRepeatableRead = this.isRepeatableRead();
        Object oValueRead = fRepeatableRead ? this.ensureRead(oKey) : null;
        if (this.getInsertMap().containsKey(oKey) ? true : this.getUpdateMap().containsKey(oKey)) {
            return true;
        }
        if (this.getDeleteMap().containsKey(oKey)) {
            return false;
        }
        return fRepeatableRead ? oValueRead != NO_VALUE : this.getOriginalMap().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        return this.containsValueImpl(oValue);
    }

    protected boolean containsValueImpl(Object oValue) {
        boolean fRepeatableRead = this.isRepeatableRead();
        if (fRepeatableRead) {
            this.ensureReadAll();
        }
        if (this.getInsertMap().containsValue(oValue) ? true : this.getUpdateMap().containsValue(oValue)) {
            return true;
        }
        Map mapDelete = this.getDeleteMap();
        if (!(fRepeatableRead ^ true) ? false : mapDelete.isEmpty()) {
            return this.getOriginalMap().containsValue(oValue);
        }
        Map mapOrig = fRepeatableRead ? this.getReadMap() : this.getOriginalMap();
        Iterator iter = mapOrig.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Object oKey = entry.getKey();
            Object oVal = entry.getValue();
            if (!(!(mapDelete.containsKey(oKey) ^ true) ? false : Base.equals(oVal, oValue))) continue;
            return true;
        }
        return false;
    }

    protected Object ensureRead(Object oKey) {
        Map mapRead = this.getReadMap();
        if (this.isFullyRead() ? true : mapRead.containsKey(oKey)) {
            return mapRead.get(oKey);
        }
        Map mapOrig = this.getOriginalMap();
        Object oValue = mapOrig.containsKey(oKey) ? mapOrig.get(oKey) : NO_VALUE;
        mapRead.put(oKey, oValue);
        return oValue;
    }

    protected void ensureReadAll() {
        Map mapRead = this.getReadMap();
        if (this.isFullyRead() ^ true) {
            Map mapOrig = this.getOriginalMap();
            Iterator iter = mapOrig.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Object oKey = entry.getKey();
                Object oVal = entry.getValue();
                if (!(mapRead.containsKey(oKey) ^ true)) continue;
                mapRead.put(oKey, oVal);
            }
            this.setFullyRead(true);
        }
    }

    public Set entrySet() {
        return this.entrySetImpl();
    }

    protected Set entrySetImpl() {
        if (this.isRepeatableRead()) {
            this.ensureReadAll();
        }
        return EntrySet.instantiate(this.getResolvedMap().entrySet(), this);
    }

    public Object get(Object oKey) {
        return this.getImpl(oKey);
    }

    public Map getAll(Collection colKeys) {
        return this.getAllImpl(colKeys);
    }

    protected Map getAllImpl(Collection colKeys) {
        HashMap mapResult;
        block10: {
            boolean fRepeatableRead = this.isRepeatableRead();
            Map mapRead = this.getReadMap();
            mapResult = new HashMap(colKeys.size());
            HashSet colMiss = colKeys;
            if (fRepeatableRead) {
                colMiss = new HashSet();
                Iterator iter = colKeys.iterator();
                while (iter.hasNext()) {
                    Object oKey = iter.next();
                    if (mapRead.containsKey(oKey)) {
                        mapResult.put(oKey, this.getImpl(oKey));
                        continue;
                    }
                    colMiss.add(oKey);
                }
            }
            if (!(colMiss.isEmpty() ^ true)) break block10;
            Map mapOrig = this.getOriginalMap();
            if (mapOrig instanceof CacheMap) {
                Map mapExist = ((CacheMap)mapOrig).getAll(colMiss);
                Iterator iter = colMiss.iterator();
                while (iter.hasNext()) {
                    Object oKey = iter.next();
                    if (fRepeatableRead) {
                        if (mapExist.containsKey(oKey)) {
                            Object oValue = mapExist.get(oKey);
                            mapResult.put(oKey, oValue);
                            mapRead.put(oKey, oValue);
                            continue;
                        }
                        mapRead.put(oKey, NO_VALUE);
                        continue;
                    }
                    if (!mapExist.containsKey(oKey)) continue;
                    mapResult.put(oKey, mapExist.get(oKey));
                }
            } else {
                Iterator iter = colMiss.iterator();
                while (iter.hasNext()) {
                    Object oValue;
                    Object oKey = iter.next();
                    if (fRepeatableRead) {
                        oValue = this.ensureRead(oKey);
                        if (!(oValue != NO_VALUE)) continue;
                        mapResult.put(oKey, oValue);
                        continue;
                    }
                    oValue = mapOrig.get(oKey);
                    if (!(oValue != null ? true : mapOrig.containsKey(oKey))) continue;
                    mapResult.put(oKey, oValue);
                }
            }
        }
        return mapResult;
    }

    public Set getDeleteKeySet() {
        return new HashSet(this.getDeleteMap().keySet());
    }

    protected Map getDeleteMap() {
        return this.__m_DeleteMap;
    }

    protected Object getImpl(Object oKey) {
        boolean fRepeatableRead = this.isRepeatableRead();
        Object oValueRead = fRepeatableRead ? this.ensureRead(oKey) : null;
        Map mapUpdate = this.getUpdateMap();
        if (mapUpdate.containsKey(oKey)) {
            return mapUpdate.get(oKey);
        }
        Map mapInsert = this.getInsertMap();
        if (mapInsert.containsKey(oKey)) {
            return mapInsert.get(oKey);
        }
        Map mapDelete = this.getDeleteMap();
        if (mapDelete.containsKey(oKey)) {
            return null;
        }
        if (fRepeatableRead) {
            return oValueRead == NO_VALUE ? null : oValueRead;
        }
        return this.getOriginalMap().get(oKey);
    }

    public Set getInsertKeySet() {
        return new HashSet(this.getInsertMap().keySet());
    }

    protected Map getInsertMap() {
        return this.__m_InsertMap;
    }

    public MapListenerSupport getListenerSupport() {
        return this.__m_ListenerSupport;
    }

    public Map getOriginalMap() {
        return this.__m_OriginalMap;
    }

    public Set getReadKeySet() {
        HashSet setRead = new HashSet();
        Map mapRead = this.getReadMap();
        Iterator iter = mapRead.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Object oKey = entry.getKey();
            if (!(!(entry.getValue() != NO_VALUE) ? false : this.isModified(oKey) ^ true)) continue;
            setRead.add(oKey);
        }
        return setRead;
    }

    protected Map getReadMap() {
        return this.__m_ReadMap;
    }

    public Map getResolvedMap() {
        HashMap map = new HashMap();
        if (this.isRepeatableRead()) {
            if (this.isFullyRead() ^ true) {
                map.putAll(this.getOriginalMap());
            }
            Map mapRead = this.getReadMap();
            Iterator iter = mapRead.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                Object oKey = entry.getKey();
                Object oVal = entry.getValue();
                if (oVal == NO_VALUE) {
                    map.remove(oKey);
                    continue;
                }
                map.put(oKey, oVal);
            }
        } else {
            map.putAll(this.getOriginalMap());
        }
        this.resolve(map);
        return map;
    }

    public Set getUpdateKeySet() {
        return new HashSet(this.getUpdateMap().keySet());
    }

    protected Map getUpdateMap() {
        return this.__m_UpdateMap;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/DeltaMap".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new DeltaMap();
    }

    private final Component get_Module() {
        return this;
    }

    public void initialize(Map mapOrig, Map mapInsert, Map mapUpdate, Map mapDelete, Map mapRead) {
        Component._assert(!(mapOrig != null) ? false : this.getOriginalMap() == null);
        this.setOriginalMap(mapOrig);
        this.setInsertMap(mapInsert == null ? new SafeHashMap() : mapInsert);
        this.setUpdateMap(mapUpdate == null ? new SafeHashMap() : mapUpdate);
        this.setDeleteMap(mapDelete == null ? new SafeHashMap() : mapDelete);
        this.setReadMap(mapRead == null ? (this.isRepeatableRead() ? new SafeHashMap() : java.util.Collections.EMPTY_MAP) : mapRead);
    }

    public static DeltaMap instantiate(Map mapOrig) {
        DeltaMap map = new DeltaMap();
        map.initialize(mapOrig, null, null, null, null);
        return map;
    }

    protected MapEvent instantiateMapEvent(int nEventId, Object oKey, Object oValueOld, Object oValue) {
        return new MapEvent(this, nEventId, oKey, oValueOld, oValue);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected boolean isFullyRead() {
        return this.__m_FullyRead;
    }

    public boolean isModified(Object oKey) {
        return (this.getInsertMap().containsKey(oKey) ? true : this.getUpdateMap().containsKey(oKey)) ? true : this.getDeleteMap().containsKey(oKey);
    }

    public boolean isRead(Object oKey) {
        return this.isModified(oKey) ? true : this.getReadMap().containsKey(oKey);
    }

    protected boolean isRepeatableRead() {
        return this.__m_RepeatableRead;
    }

    public Set keySet() {
        return this.keySetImpl();
    }

    protected Set keySetImpl() {
        if (this.isRepeatableRead()) {
            this.ensureReadAll();
        }
        return KeySet.instantiate(this.getResolvedMap().keySet(), this);
    }

    public Object put(Object oKey, Object oValue) {
        return this.putImpl(oKey, oValue);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        if (cMillis == (long)0) {
            return this.put(oKey, oValue);
        }
        throw new UnsupportedOperationException();
    }

    public void putAll(Map map) {
        Collections.putAll(this, map);
    }

    protected Object putImpl(Object oKey, Object oValue) {
        boolean fRepeatableRead = this.isRepeatableRead();
        Object oValueRead = fRepeatableRead ? this.ensureRead(oKey) : null;
        Map mapInsert = this.getInsertMap();
        Map mapUpdate = this.getUpdateMap();
        Map mapDelete = this.getDeleteMap();
        if (mapDelete.containsKey(oKey)) {
            mapDelete.remove(oKey);
        }
        Object oValueOld = null;
        boolean fInsert = false;
        if (mapUpdate.containsKey(oKey)) {
            oValueOld = mapUpdate.put(oKey, oValue);
        } else if (mapInsert.containsKey(oKey)) {
            oValueOld = mapInsert.get(oKey);
            mapInsert.put(oKey, oValue);
        } else {
            if (fRepeatableRead) {
                if (oValueRead == NO_VALUE) {
                    fInsert = true;
                } else {
                    oValueOld = oValueRead;
                }
            } else {
                Map mapOrig = this.getOriginalMap();
                if (mapOrig.containsKey(oKey)) {
                    oValueOld = mapOrig.get(oKey);
                } else {
                    fInsert = true;
                }
            }
            if (fInsert) {
                mapInsert.put(oKey, oValue);
            } else {
                mapUpdate.put(oKey, oValue);
            }
        }
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            MapEvent event = this.instantiateMapEvent(fInsert ? MapEvent.ENTRY_INSERTED : MapEvent.ENTRY_UPDATED, oKey, oValueOld, oValue);
            support.fireEvent(event, true);
        }
        return oValueOld;
    }

    public Object remove(Object oKey) {
        return this.removeImpl(oKey);
    }

    protected Object removeImpl(Object oKey) {
        boolean fRepeatableRead = this.isRepeatableRead();
        Object oValueRead = fRepeatableRead ? this.ensureRead(oKey) : null;
        Map mapInsert = this.getInsertMap();
        Map mapUpdate = this.getUpdateMap();
        Map mapDelete = this.getDeleteMap();
        Object oValue = null;
        if (mapDelete.containsKey(oKey) ^ true) {
            oValue = mapUpdate.containsKey(oKey) ? (Object)mapUpdate.remove(oKey) : (mapInsert.containsKey(oKey) ? (Object)mapInsert.remove(oKey) : (fRepeatableRead ? (oValueRead == NO_VALUE ? null : oValueRead) : (Object)this.getOriginalMap().get(oKey)));
            mapDelete.put(oKey, null);
            MapListenerSupport support = this.getListenerSupport();
            if (support != null) {
                MapEvent event = this.instantiateMapEvent(MapEvent.ENTRY_DELETED, oKey, oValue, null);
                support.fireEvent(event, true);
            }
        }
        return oValue;
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public synchronized void removeMapListener(MapListener listener, Filter filter) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(listener, filter);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    public synchronized void removeMapListener(MapListener listener, Object oKey) {
        Component._assert(listener != null);
        MapListenerSupport support = this.getListenerSupport();
        if (support != null) {
            support.removeListener(listener, oKey);
            if (support.isEmpty()) {
                this.setListenerSupport(null);
            }
        }
    }

    public void reset() {
        this.getInsertMap().clear();
        this.getUpdateMap().clear();
        this.getDeleteMap().clear();
        this.getReadMap().clear();
    }

    public void resolve() {
        this.resolve(this.getOriginalMap());
        this.reset();
    }

    /*
     * Unable to fully structure code
     */
    protected void resolve(Map mapOrig) {
        block6: {
            map = this.getInsertMap();
            if (map.isEmpty() ^ true) {
                mapOrig.putAll(map);
            }
            if ((map = this.getUpdateMap()).isEmpty() ^ true) {
                mapOrig.putAll(map);
            }
            if ((map = this.getDeleteMap()).isEmpty() ^ true) {
                try {
                    mapOrig.keySet().removeAll(map.keySet());
                    break block6;
                }
                catch (UnsupportedOperationException e) {
                    iter = map.keySet().iterator();
                    ** while (iter.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    mapOrig.remove(iter.next());
                    continue;
                }
            }
        }
    }

    protected void setDeleteMap(Map map) {
        this.__m_DeleteMap = map;
    }

    protected void setFullyRead(boolean fReadFully) {
        this.__m_FullyRead = fReadFully;
    }

    protected void setInsertMap(Map map) {
        this.__m_InsertMap = map;
    }

    protected void setListenerSupport(MapListenerSupport support) {
        this.__m_ListenerSupport = support;
    }

    protected void setOriginalMap(Map map) {
        this.__m_OriginalMap = map;
    }

    protected void setReadMap(Map pReadMap) {
        this.__m_ReadMap = pReadMap;
    }

    protected void setRepeatableRead(boolean fRepeatableRead) {
        this.__m_RepeatableRead = fRepeatableRead;
    }

    protected void setUpdateMap(Map map) {
        this.__m_UpdateMap = map;
    }

    public int size() {
        return this.sizeImpl();
    }

    protected int sizeImpl() {
        if (this.isRepeatableRead()) {
            this.ensureReadAll();
        }
        return this.getResolvedMap().size();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "\nOriginal=" + this.getOriginalMap() + "\nRead=" + this.getReadMap() + "\nInsert=" + this.getInsertMap() + "\nUpdate=" + this.getUpdateMap() + "\nDelete=" + this.getDeleteMap();
    }

    public Collection values() {
        return this.valuesImpl();
    }

    protected Collection valuesImpl() {
        if (this.isRepeatableRead()) {
            this.ensureReadAll();
        }
        return java.util.Collections.unmodifiableCollection(this.getResolvedMap().values());
    }
}

