/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.packetProcessor;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.PacketBufferPool;
import com.tangosol.coherence.component.net.UdpPacket;
import com.tangosol.coherence.component.net.socket.UdpSocket;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.PacketProcessor;
import com.tangosol.io.WriteBuffer;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.Map;

public class PacketListener
extends PacketProcessor {
    private PacketBufferPool __m_PacketAllocator;
    private int __m_PacketLength;
    private Queue __m_ReceiveQueue;
    private transient long __m_StatsCpu;
    private transient long __m_StatsReset;
    private UdpSocket __m_UdpSocket;
    private static ListMap __mapChildren;

    static {
        PacketListener.__initStatic();
    }

    public PacketListener() {
        this(null, null, true);
    }

    public PacketListener(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    public String formatStats() {
        long cCpu = this.getStatsCpu();
        long cTotal = Base.getSafeTimeMillis() - this.getStartTimestamp();
        double dCpu = cTotal == 0L ? 0.0 : (double)cCpu / (double)cTotal;
        return String.valueOf("Cpu=") + cCpu + "ms (" + (float)dCpu + "%)";
    }

    public PacketBufferPool getPacketAllocator() {
        return this.__m_PacketAllocator;
    }

    public int getPacketLength() {
        return this.__m_PacketLength;
    }

    public Queue getReceiveQueue() {
        return this.__m_ReceiveQueue;
    }

    public long getStatsCpu() {
        return this.__m_StatsCpu;
    }

    public long getStatsReset() {
        return this.__m_StatsReset;
    }

    public UdpSocket getUdpSocket() {
        return this.__m_UdpSocket;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/packetProcessor/PacketListener".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PacketListener();
    }

    private final Component get_Module() {
        return this;
    }

    protected void onEnter() {
        super.onEnter();
        this.resetStats();
    }

    protected void onNotify() {
        Queue queue = this.getReceiveQueue();
        PacketBufferPool pool = this.getPacketAllocator();
        int cbPacket = this.getPacketLength();
        UdpPacket udpPacket = new UdpPacket();
        udpPacket.setUdpSocket(this.getUdpSocket());
        while (this.isExiting() ^ true) {
            WriteBuffer buffer = pool.allocate(cbPacket);
            udpPacket.setWriteBuffer(buffer);
            if (!udpPacket.receive()) continue;
            queue.add(buffer);
        }
    }

    public void onReceiveException(Exception e) {
        throw new EventDeathException(e.toString());
    }

    protected void onWait() throws InterruptedException {
    }

    public void resetStats() {
        this.setStatsCpu(0L);
        this.setStatsReset(Base.getSafeTimeMillis());
    }

    public void setPacketAllocator(PacketBufferPool pPacketAllocator) {
        this.__m_PacketAllocator = pPacketAllocator;
    }

    public void setPacketLength(int pPacketLength) {
        this.__m_PacketLength = pPacketLength;
    }

    public void setReceiveQueue(Queue queue) {
        Component._assert(queue != null);
        Component._assert(this.getReceiveQueue() == null);
        this.__m_ReceiveQueue = queue;
    }

    protected void setStatsCpu(long cMillis) {
        this.__m_StatsCpu = cMillis;
    }

    protected void setStatsReset(long lMillis) {
        this.__m_StatsReset = lMillis;
    }

    public void setUdpSocket(UdpSocket socket) {
        this.__m_UdpSocket = socket;
    }

    public synchronized void start() {
        if (this.getUdpSocket() == null) {
            throw new IllegalStateException("DatagramSocket is required!");
        }
        if (this.getReceiveQueue() == null) {
            throw new IllegalStateException("ReceiveQueue is required!");
        }
        super.start();
    }

    public synchronized void stop() {
        super.stop();
        try {
            this.getUdpSocket().close();
        }
        catch (Throwable throwable) {}
    }

    public String toString() {
        return String.valueOf(this.get_Name()) + ':' + this.formatStats();
    }
}

