/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Packet;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray$PlaceHolder;
import com.tangosol.coherence.component.util.windowedArray.ConcurrentWindowedArray;
import com.tangosol.util.Base;
import com.tangosol.util.InflatableSet;
import com.tangosol.util.ListMap;
import com.tangosol.util.SafeSortedMap;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public class Grid$PollArray
extends ConcurrentWindowedArray {
    public static final long POLL_EXPIRY_RESOLUTION = 256L;
    private SortedMap __m_ExpiryMap;
    private transient long __m_LastNullPollId;
    private static ListMap __mapChildren;

    static {
        Grid$PollArray.__initStatic();
    }

    public Grid$PollArray() {
        this(null, null, true);
    }

    public Grid$PollArray(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setExpiryMap(new SafeSortedMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("PlaceHolder", Grid$PollArray$PlaceHolder.get_CLASS());
    }

    public long add(Object o) {
        Poll poll = (Poll)o;
        Set setExpiry = this.getExpirySet(poll);
        if (setExpiry != null) {
            Set setExpiryPost = setExpiry;
            do {
                setExpiry = setExpiryPost;
                setExpiry.add(poll);
            } while (setExpiry != (setExpiryPost = this.getExpirySet(poll)));
        }
        return super.add(o);
    }

    protected void assignIndexToValue(long lVirtual, Object o) {
        ((Poll)o).setPollId(lVirtual);
    }

    public void checkPolls() {
        long ldtNow = Base.getSafeTimeMillis();
        this.validatePolls(ldtNow);
        this.expirePolls(ldtNow);
    }

    protected void expirePolls(long ldt) {
        Iterator iter = this.getExpiryMap().entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            long ldtExpiry = (Long)entry.getKey();
            if (ldtExpiry > ldt) {
                return;
            }
            iter.remove();
            Iterator iterPoll = ((Set)entry.getValue()).iterator();
            while (iterPoll.hasNext()) {
                ((Poll)iterPoll.next()).close();
            }
        }
    }

    public Object get(long lVirtual) {
        if (lVirtual == 0L) {
            return null;
        }
        Object o = this.optimisticGet(lVirtual);
        return o == null ? super.get(lVirtual) : o;
    }

    public SortedMap getExpiryMap() {
        return this.__m_ExpiryMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set getExpirySet(Poll poll) {
        long ldtExpiry = poll.getExpiryTimeMillis();
        if (ldtExpiry == (long)0) {
            return null;
        }
        long ldtTruncated = ldtExpiry & (POLL_EXPIRY_RESOLUTION - (long)1 ^ 0xFFFFFFFFFFFFFFFFL);
        long ldtGroup = ldtExpiry == ldtTruncated ? ldtExpiry : ldtTruncated + POLL_EXPIRY_RESOLUTION;
        SortedMap mapExpiry = this.getExpiryMap();
        Long LdtGroup = new Long(ldtGroup);
        Set setPoll = (Set)mapExpiry.get(LdtGroup);
        if (setPoll == null) {
            SortedMap sortedMap = mapExpiry;
            synchronized (sortedMap) {
                setPoll = (Set)mapExpiry.get(LdtGroup);
                if (setPoll == null) {
                    setPoll = new InflatableSet();
                }
                mapExpiry.put(LdtGroup, setPoll);
            }
        }
        return setPoll;
    }

    public long getLastNullPollId() {
        return this.__m_LastNullPollId;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/Grid$PollArray".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new Grid$PollArray();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public Object remove(long lVirtual) {
        Set setExpiry;
        Poll poll = (Poll)super.remove(lVirtual);
        if (poll != null && (setExpiry = this.getExpirySet(poll)) != null) {
            setExpiry.remove(poll);
        }
        return poll;
    }

    protected long retrieveIndexFromValue(Object o) {
        return ((Poll)o).getPollId();
    }

    protected void setExpiryMap(SortedMap mapExpiry) {
        this.__m_ExpiryMap = mapExpiry;
    }

    public void setLastNullPollId(long pLastNullPollId) {
        this.__m_LastNullPollId = pLastNullPollId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void validatePolls(long ldtNow) {
        try {
            long lFirst = this.getFirstIndex();
            long lLast = this.getLastIndex();
            if (lFirst > lLast) return;
            boolean bl = false;
            boolean fEmpty = bl;
            if (fEmpty) {
                return;
            }
            Poll poll = (Poll)this.get(lFirst);
            if (poll == null) {
                long lLastNullPollId = this.getLastNullPollId();
                if (!(lLastNullPollId == lFirst)) {
                    this.setLastNullPollId(lFirst);
                    return;
                }
                if (!(this.get(lFirst, 1000L) == null)) return;
                this.remove(lFirst);
                Component._trace(String.valueOf("validatePolls: ") + "Removed empty poll element #" + lFirst + " from array " + this.formatStats(), 1);
                return;
            }
            Grid service = (Grid)this.get_Module();
            long cMillisAge = ldtNow - poll.getInitTimeMillis();
            if (cMillisAge < service.getStartupTimeout() >>> 1) return;
            boolean bl2 = false;
            if (bl2) {
                return;
            }
            String sPoll = poll.getClass().getName();
            try {
                sPoll = poll.toString();
                if (poll.get_Parent() != null) {
                    sPoll = String.valueOf(sPoll) + (String.valueOf("\nRequest=") + poll.get_Parent().toString());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            Poll poll2 = poll;
            // MONITORENTER : poll2
            if (lFirst != this.getFirstIndex()) {
                Object var18_13 = null;
                // MONITOREXIT : poll2
                return;
            }
            if (poll.isClosed()) {
                this.remove(lFirst);
                Component._trace(String.valueOf("validatePolls: ") + "Removed closed poll: " + sPoll + " from array " + this.formatStats(), 1);
                Object var18_14 = null;
                // MONITOREXIT : poll2
                return;
            }
            MemberSet setPoll = poll.getRemainingMemberSet();
            if (setPoll == null ? true : setPoll.isEmpty()) {
                poll.close();
                Component._trace(String.valueOf("validatePolls: ") + "Closed poll that had no remaining members: " + sPoll + " within array " + this.formatStats(), 1);
                Object var18_15 = null;
                // MONITOREXIT : poll2
                return;
            }
            ServiceMemberSet setService = service.getServiceMemberSet();
            MasterMemberSet setMaster = service.getClusterMemberSet();
            boolean fClose = false;
            int i = setPoll.getFirstId();
            int iLast = setPoll.getLastId();
            while (true) {
                if (!(i <= iLast)) {
                    if (!poll.isClosed()) break;
                    Object var18_17 = null;
                    // MONITOREXIT : poll2
                    return;
                }
                if (!setPoll.contains(i) ? false : setService.contains(i) ^ true) {
                    MasterMemberSet masterMemberSet = setMaster;
                    // MONITORENTER : masterMemberSet
                    Member member = setMaster.getMember(i);
                    // MONITOREXIT : masterMemberSet
                    if (member == null) {
                        member = setMaster.getRecycleSet().getMember(i);
                        if (member == null) {
                            fClose = setPoll.size() == 1 ? true : cMillisAge > 60000L;
                        } else if (ldtNow > member.getTimestamp() + 30000L) {
                            poll.onLeft(member);
                            Component._trace(String.valueOf("validatePolls: ") + "Removed missing member " + member + " from poll: " + sPoll + " within array " + this.formatStats(), 1);
                        }
                    }
                }
                ++i;
            }
            if (fClose) {
                poll.close();
                Component._trace(String.valueOf("validatePolls: ") + "Closed poll that had missing member: " + sPoll + " within array " + this.formatStats(), 1);
                Object var18_18 = null;
                // MONITOREXIT : poll2
                return;
            }
            long cGap = lLast - lFirst;
            if (cGap > (long)(Packet.TRINT_MAX_VARIANCE >>> 1)) {
                poll.close();
                Component._trace(String.valueOf("validatePolls: ") + "Manual intervention is required to stop " + "this node or " + "the members that have not responded to this " + "poll (gap size=" + cGap + "): " + sPoll + " within array " + this.formatStats(), 1);
            }
            if (!(service.getServiceState() == Service.SERVICE_STOPPED) ? false : service.isAcceptingClients() ^ true) {
                Component._trace(String.valueOf("validatePolls: ") + "This service timed-out due to unanswered handshake request. " + "Manual intervention is required to stop " + "the members that have not responded to this " + sPoll, 1);
            }
            // MONITOREXIT : poll2
            return;
        }
        catch (Throwable e) {
            Component._trace(String.valueOf("validatePolls: ") + "Non-fatal exception detected during processing:", 1);
            Component._trace(e);
            Component._trace(String.valueOf("validatePolls: ") + "Exception has been logged; continuing processing.", 1);
            return;
        }
    }
}

