/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service;

import com.oracle.common.net.exabus.EndPoint;
import com.oracle.common.net.exabus.MessageBus;
import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.MessageHandler;
import com.tangosol.coherence.component.net.PacketBufferPool;
import com.tangosol.coherence.component.net.Poll;
import com.tangosol.coherence.component.net.RequestContext;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.requestContext.IdempotentContext;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.ServiceConfig$Map;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Acknowledgement;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchNotification;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ReceiveQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ServiceConfig$Map;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$WrapperGuardable;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.internal.net.cluster.DefaultServiceFailurePolicy;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WrapperBufferInput;
import com.tangosol.io.WrapperBufferOutput;
import com.tangosol.io.WrapperDataInputStream;
import com.tangosol.io.WrapperDataOutputStream;
import com.tangosol.io.WrapperStreamFactory;
import com.tangosol.io.WriteBuffer;
import com.tangosol.license.LicenseException;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.GuardSupport;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.PriorityTask;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.net.ServiceInfo;
import com.tangosol.net.internal.ProtocolAwareStream;
import com.tangosol.net.management.Registry;
import com.tangosol.run.component.EventDeathException;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.Listeners;
import com.tangosol.util.LongArray;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.WrapperException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public abstract class Grid
extends Service
implements com.tangosol.net.Service {
    public static final int CONFIG_MAP_SERVICE = 1;
    public static final int MESSAGE_OFFSET = 32;
    public static final long TIME_CLUSTER = -3L;
    public static final long TIME_SAFE = -2L;
    public static final long TIME_SYSTEM = -1L;
    private boolean __m_AcceptingOthers;
    private ActionPolicy __m_ActionPolicy;
    private transient com.tangosol.net.Cluster __m_Cluster;
    private MasterMemberSet __m_ClusterMemberSet;
    private Listeners __m_MemberListeners;
    private Class[] __m_MessageClass;
    private Map __m_MessageClassMap;
    private MessageHandler __m_MessageHandler;
    private PacketBufferPool __m_PacketAllocator;
    private transient LongArray __m_PendingRequestInfo;
    private Grid$PollArray __m_PollArray;
    private Queue __m_QueueDeferred;
    private long __m_RequestTimeout;
    private transient AtomicLong __m_SUIDCounter;
    private Queue __m_SendQueue;
    private Grid$ServiceConfig$Map __m_ServiceConfigMap;
    private ServiceFailurePolicy __m_ServiceFailurePolicy;
    private int __m_ServiceId;
    private ServiceMemberSet __m_ServiceMemberSet;
    private transient long __m_StatsPollCount;
    private transient long __m_StatsPollDuration;
    private transient long __m_StatsPollMaxDuration;
    private volatile transient long __m_StatsTimeoutCount;
    private Object __m_UserContext;
    private List __m_WrapperStreamFactoryAllList;
    private List __m_WrapperStreamFactoryList;
    private static ListMap __mapChildren;

    static {
        Grid.__initStatic();
    }

    public Grid(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
        try {
            this.__m_MemberListeners = new Listeners();
            this.__m_QueueDeferred = new Queue();
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Acknowledgement", Grid$Acknowledgement.get_CLASS());
        Class clazz2 = __mapChildren.put("ConfigRequest", Grid$ConfigRequest.get_CLASS());
        Class clazz3 = __mapChildren.put("ConfigResponse", Grid$ConfigResponse.get_CLASS());
        Class clazz4 = __mapChildren.put("ConfigSync", Grid$ConfigSync.get_CLASS());
        Class clazz5 = __mapChildren.put("ConfigUpdate", Grid$ConfigUpdate.get_CLASS());
        Class clazz6 = __mapChildren.put("DispatchEvent", Grid$DispatchEvent.get_CLASS());
        Class clazz7 = __mapChildren.put("DispatchNotification", Grid$DispatchNotification.get_CLASS());
        Class clazz8 = __mapChildren.put("MemberConfigUpdate", Grid$MemberConfigUpdate.get_CLASS());
        Class clazz9 = __mapChildren.put("MemberWelcome", Grid$MemberWelcome.get_CLASS());
        Class clazz10 = __mapChildren.put("MemberWelcomeRequest", Grid$MemberWelcomeRequest.get_CLASS());
        Class clazz11 = __mapChildren.put("NotifyMemberJoined", Grid$NotifyMemberJoined.get_CLASS());
        Class clazz12 = __mapChildren.put("NotifyMemberLeaving", Grid$NotifyMemberLeaving.get_CLASS());
        Class clazz13 = __mapChildren.put("NotifyMemberLeft", Grid$NotifyMemberLeft.get_CLASS());
        Class clazz14 = __mapChildren.put("NotifyMessageReceipt", Grid$NotifyMessageReceipt.get_CLASS());
        Class clazz15 = __mapChildren.put("NotifyPollClosed", Grid$NotifyPollClosed.get_CLASS());
        Class clazz16 = __mapChildren.put("NotifyResponse", Grid$NotifyResponse.get_CLASS());
        Class clazz17 = __mapChildren.put("NotifyServiceAnnounced", Grid$NotifyServiceAnnounced.get_CLASS());
        Class clazz18 = __mapChildren.put("NotifyServiceJoined", Grid$NotifyServiceJoined.get_CLASS());
        Class clazz19 = __mapChildren.put("NotifyServiceJoining", Grid$NotifyServiceJoining.get_CLASS());
        Class clazz20 = __mapChildren.put("NotifyServiceLeaving", Grid$NotifyServiceLeaving.get_CLASS());
        Class clazz21 = __mapChildren.put("NotifyServiceLeft", Grid$NotifyServiceLeft.get_CLASS());
        Class clazz22 = __mapChildren.put("NotifyShutdown", Grid$NotifyShutdown.get_CLASS());
        Class clazz23 = __mapChildren.put("NotifyStartup", Grid$NotifyStartup.get_CLASS());
        Class clazz24 = __mapChildren.put("ProtocolContext", Grid$ProtocolContext.get_CLASS());
        Class clazz25 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
        Class clazz26 = __mapChildren.put("ReceiveQueue", Grid$ReceiveQueue.get_CLASS());
        Class clazz27 = __mapChildren.put("Response", Grid$Response.get_CLASS());
        Class clazz28 = __mapChildren.put("WrapperGuardable", Grid$WrapperGuardable.get_CLASS());
    }

    public void addMemberListener(MemberListener l) {
        this.ensureEventDispatcher();
        this.getMemberListeners().add(l);
    }

    public long adjustWaitTime(long cWaitMillis, long cAdjustMillis) {
        if (cWaitMillis < 0L) {
            return Long.MAX_VALUE;
        }
        if (cAdjustMillis < 0L) {
            if (cAdjustMillis == TIME_CLUSTER) {
                cAdjustMillis = this.getClusterTime();
            } else if (cAdjustMillis == TIME_SAFE) {
                cAdjustMillis = Base.getSafeTimeMillis();
            } else if (cAdjustMillis == TIME_SYSTEM) {
                cAdjustMillis = System.currentTimeMillis();
            } else {
                throw new IllegalArgumentException(String.valueOf("Invalid adjustment: ") + cAdjustMillis);
            }
        }
        return (cWaitMillis += cAdjustMillis) < 0L ? Long.MAX_VALUE : cWaitMillis;
    }

    public void bindMessageBus(MessageBus bus, Queue queueDatagramOut) {
        MessageHandler handler = this.instantiateMessageHandler();
        handler.initialize(this, bus, queueDatagramOut);
        this.setMessageHandler(handler);
        this.setSendQueue(handler.getOutgoingQueue());
    }

    public long calculateDeferrableMillis(Message msg) {
        long cMillis = msg == null ? 0L : msg.getDeferrableMillis();
        if (cMillis == 0L) {
            cMillis = msg instanceof RequestMessage ? this.calculateRequestTimeout((RequestMessage)msg) : this.getRequestTimeout();
            cMillis = cMillis == 0L ? 0L : Math.max(1L, 2L * cMillis / 3L);
        }
        return cMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static long calculateOldestSUID(LongArray array, int nMember) {
        long lBase = Grid.getBaseSUID(nMember);
        LongArray longArray = array;
        // MONITORENTER : longArray
        LongArray.Iterator iter = array.iterator(lBase);
        if (!iter.hasNext()) {
            long l = -1L;
            Object var10_7 = null;
            // MONITOREXIT : longArray
            return l;
        }
        iter.next();
        long lSUID = iter.getIndex();
        // MONITOREXIT : longArray
        if (Grid.getMemberId(lSUID) != nMember) {
            return -1L;
        }
        boolean bl = true;
        if (!bl) return -1L;
        long l = lSUID;
        return l;
    }

    public long calculateRequestTimeout(RequestMessage msg) {
        long cTimeoutMillis = this.getRequestTimeout();
        if (msg instanceof PriorityTask) {
            cTimeoutMillis = Service.adjustTimeout(cTimeoutMillis, ((PriorityTask)((Object)msg)).getRequestTimeoutMillis());
        }
        return cTimeoutMillis;
    }

    public long checkRequestTimeout(long ldtStart, long cTimeout) {
        long cElapsed = System.currentTimeMillis() - ldtStart;
        if (cElapsed >= cTimeout) {
            this.setStatsTimeoutCount(this.getStatsTimeoutCount() + 1L);
            throw new RequestTimeoutException(String.valueOf("Request timed out after ") + cElapsed + " millis");
        }
        return cTimeout - Math.max(0L, cElapsed);
    }

    private void closeInput(ReadBuffer.BufferInput input) throws IOException {
        input.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closePolls() {
        long lLast;
        long lFirst;
        this.getServiceConfigMap().clearPendingPolls();
        Grid$PollArray waPoll = this.getPollArray();
        waPoll.checkPolls();
        Grid$PollArray grid$PollArray = waPoll;
        synchronized (grid$PollArray) {
            lFirst = waPoll.getFirstIndex();
            lLast = waPoll.getLastIndex();
        }
        long l = lFirst;
        while (l <= lLast) {
            Poll poll = (Poll)waPoll.get(l);
            if (poll != null) {
                poll.close();
            }
            ++l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closePolls(Member member) {
        long lLast;
        long lFirst;
        Grid$PollArray waPoll;
        Component._assert(Thread.currentThread() == this.getThread());
        Grid$PollArray grid$PollArray = waPoll = this.getPollArray();
        synchronized (grid$PollArray) {
            lFirst = waPoll.getFirstIndex();
            lLast = waPoll.getLastIndex();
        }
        long l = lFirst;
        while (l <= lLast) {
            Poll poll = (Poll)waPoll.get(l);
            if (poll != null) {
                poll.onLeft(member);
            }
            ++l;
        }
    }

    public int compareImportance(Member memberThat) {
        return 0;
    }

    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
        if (xml != null) {
            XmlElement xmlListener;
            long cTimeoutMillis = Service.parseTime(xml, "request-timeout", 0L);
            if (cTimeoutMillis > 0L) {
                this.setRequestTimeout(cTimeoutMillis);
            }
            if (XmlHelper.isInstanceConfigEmpty(xmlListener = xml.getSafeElement("member-listener")) ^ true) {
                try {
                    this.addMemberListener((MemberListener)XmlHelper.createInstance(xmlListener, this.getContextClassLoader(), null));
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e, String.valueOf("Invalid MemberListener configuration: ") + xmlListener);
                }
            }
            if ((cTimeoutMillis = Service.parseTime(xml, "guardian-timeout", -1L)) >= 0L) {
                cTimeoutMillis = cTimeoutMillis == (long)0 ? (long)0 : Math.max(cTimeoutMillis, GuardSupport.GUARDIAN_MAX_CHECK_INTERVAL);
                this.setDefaultGuardTimeout(cTimeoutMillis);
            }
            Cluster cluster = (Cluster)this.getCluster();
            if (cTimeoutMillis == (long)0) {
                cluster.warnDisabledGuardian(String.valueOf("service ") + this.getServiceName());
                this.setDefaultGuardTimeout(DefaultServiceFailurePolicy.DEFAULT_LOGGING_INTERVAL);
                this.setServiceFailurePolicy(new DefaultServiceFailurePolicy(DefaultServiceFailurePolicy.POLICY_LOGGING));
            } else {
                XmlElement xmlPolicy = xml.getSafeElement("service-failure-policy");
                this.setServiceFailurePolicy(cluster.instantiateServiceFailurePolicy(xmlPolicy));
            }
        }
    }

    public boolean deserializeMessage(Message msg) {
        try {
            try {
                ReadBuffer.BufferInput input = msg.getReadBuffer().getBufferInput();
                input.readInt();
                boolean fWrapped = this.isProtocolFiltered();
                if (fWrapped) {
                    input = this.wrapStream(input, msg);
                }
                msg.readInternal(input);
                msg.read(input);
                if (fWrapped) {
                    this.closeInput(input);
                }
                boolean bl = true;
                Object var5_8 = null;
                msg.setDeserializationRequired(false);
                msg.releaseIncoming();
                return bl;
            }
            catch (Throwable e) {
                boolean bl = this.onMessageReadException(e, msg);
                Object var5_9 = null;
                msg.setDeserializationRequired(false);
                msg.releaseIncoming();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            msg.setDeserializationRequired(false);
            msg.releaseIncoming();
            throw throwable;
        }
    }

    public void dispatchMemberEvent(Member member, int nEvent) {
        Listeners listeners = this.getMemberListeners();
        if (listeners.isEmpty() ^ true) {
            this.dispatchEvent(new MemberEvent(this, nEvent, member), listeners);
        }
    }

    protected boolean dispatchMessage(Message msg) {
        int nDestination;
        Member memberFrom = msg.getFromMember();
        if (memberFrom == null && (memberFrom = this.getThisMember()) != null) {
            msg.setFromMember(memberFrom);
        }
        MemberSet setMemberTo = msg.getToMemberSet();
        int LOCAL = 1;
        int REMOTE = 2;
        if (setMemberTo == null) {
            if (msg.isInternal()) {
                nDestination = LOCAL;
                MemberSet.writeBarrier(memberFrom);
            } else {
                nDestination = REMOTE;
            }
        } else {
            nDestination = (!(memberFrom != null) ? false : setMemberTo.contains(memberFrom)) ? (setMemberTo.size() == 1 ? LOCAL : LOCAL | REMOTE) : REMOTE;
            setMemberTo.writeBarrier();
        }
        boolean fSent = false;
        if ((nDestination & LOCAL) != 0) {
            fSent = this.getQueue().add(msg);
        }
        if (!((nDestination & REMOTE) != 0) ? false : this.getSendQueue().add(msg)) {
            return true;
        }
        msg.checkNotifySent();
        return fSent;
    }

    public void dispatchNotification(String sName, String sType, String sMsg, Object oData) {
        Registry registry = this.getCluster().getManagement();
        if (!(registry != null) ? false : registry.getNotificationManager().isSubscribedTo(sName)) {
            Grid$DispatchNotification notify = (Grid$DispatchNotification)this._newChild("DispatchNotification");
            notify.setName(sName);
            notify.setType(sType);
            notify.setMessage(sMsg);
            notify.setUserData(oData);
            this.ensureEventDispatcher().getQueue().add(notify);
        }
    }

    protected void doPollClose(RequestMessage msgRequest) {
        Grid$NotifyPollClosed msgNotify = (Grid$NotifyPollClosed)this.instantiateMessage("NotifyPollClosed");
        msgNotify.setNotifyMessage(msgRequest);
        this.getQueue().add(msgNotify);
    }

    protected void doPollMemberLeft(RequestMessage msgRequest, Member member) {
        Grid$NotifyPollClosed msgNotify = (Grid$NotifyPollClosed)this.instantiateMessage("NotifyPollClosed");
        msgNotify.setNotifyMessage(msgRequest);
        msgNotify.setNotifyMember(member);
        this.getQueue().add(msgNotify);
    }

    public void flushSend() {
        this.getSendQueue().flush();
        if (this.getThread() != Thread.currentThread()) {
            this.getQueue().flush();
        }
    }

    public ActionPolicy getActionPolicy() {
        return this.__m_ActionPolicy;
    }

    public static long getBaseSUID(int nMember) {
        return (long)nMember << 48;
    }

    public static long getBaseSUID(long lSUID) {
        return lSUID & 0xFF000000000000L;
    }

    public com.tangosol.net.Cluster getCluster() {
        return this.__m_Cluster;
    }

    public MasterMemberSet getClusterMemberSet() {
        return this.__m_ClusterMemberSet;
    }

    public Member getClusterOldestMember() {
        return this.getClusterMemberSet().getOldestMember();
    }

    public ClusterService getClusterService() {
        return ((Cluster)this.getCluster()).getClusterService();
    }

    public long getClusterTime() {
        return this.getCluster().getTimeMillis();
    }

    public int getClusterTimeVariance() {
        return this.getClusterService().getTimestampMaxVariance();
    }

    public ServiceConfig$Map getConfigMap(int nMapType) {
        if (nMapType == CONFIG_MAP_SERVICE) {
            return this.getServiceConfigMap();
        }
        throw new IllegalArgumentException();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        sb.append("Id=").append(this.getServiceId()).append(", Version=").append(this.getServiceVersion());
        if (!this.isRunning() ? false : this.getServiceOldestMember() != null) {
            sb.append(", OldestMemberId=").append(this.getServiceOldestMember().getId());
        }
        return sb.toString();
    }

    public String getEndPointName() {
        MessageHandler handler = this.getMessageHandler();
        return handler == null ? "" : handler.getMessageBus().getLocalEndPoint().toString();
    }

    public ServiceInfo getInfo() {
        return this.getCluster().getServiceInfo(this.getServiceName());
    }

    public static int getMemberId(long lSUID) {
        return (int)(lSUID >>> 48);
    }

    public Listeners getMemberListeners() {
        return this.__m_MemberListeners;
    }

    private Class[] getMessageClass() {
        return this.__m_MessageClass;
    }

    public Class getMessageClass(int i) {
        Class[] aClass = this.getMessageClass();
        return (!(aClass != null) ? false : (i += MESSAGE_OFFSET) < aClass.length) ? aClass[i] : null;
    }

    public Class getMessageClass(String sMsgName) {
        return (Class)this.getMessageClassMap().get(sMsgName);
    }

    public Map getMessageClassMap() {
        return this.__m_MessageClassMap;
    }

    public MessageHandler getMessageHandler() {
        return this.__m_MessageHandler;
    }

    public long getOldestPendingRequestSUID() {
        return Grid.calculateOldestSUID(this.getPendingRequestInfo(), this.getThisMember().getId());
    }

    public MemberSet getOthersMemberSet() {
        MemberSet set = new MemberSet();
        set.addAll((Collection)this.getServiceMemberSet());
        set.remove(this.getThisMember());
        return set;
    }

    public PacketBufferPool getPacketAllocator() {
        return this.__m_PacketAllocator;
    }

    public LongArray getPendingRequestInfo() {
        return this.__m_PendingRequestInfo;
    }

    public Grid$PollArray getPollArray() {
        return this.__m_PollArray;
    }

    public ProtocolAwareStream.ProtocolContext getProtocolContext(Message msg) {
        Grid$ProtocolContext context = new Grid$ProtocolContext();
        context.setMessage(msg);
        return context;
    }

    private Queue getQueueDeferred() {
        return this.__m_QueueDeferred;
    }

    public long getRequestTimeout() {
        return this.__m_RequestTimeout;
    }

    public long getSUID() {
        return this.getSUIDCounter().incrementAndGet();
    }

    protected AtomicLong getSUIDCounter() {
        return this.__m_SUIDCounter;
    }

    public Queue getSendQueue() {
        return this.__m_SendQueue;
    }

    public Grid$ServiceConfig$Map getServiceConfigMap() {
        Grid$ServiceConfig$Map map = this.__m_ServiceConfigMap;
        if (map == null) {
            map = (Grid$ServiceConfig$Map)((Grid$ServiceConfig)this._findChild("ServiceConfig")).getMap();
            this.setServiceConfigMap(map);
        }
        return map;
    }

    public ServiceFailurePolicy getServiceFailurePolicy() {
        return this.__m_ServiceFailurePolicy;
    }

    public int getServiceId() {
        return this.__m_ServiceId;
    }

    public ServiceMemberSet getServiceMemberSet() {
        return this.__m_ServiceMemberSet;
    }

    public Member getServiceOldestMember() {
        ServiceMemberSet setMember = this.getServiceMemberSet();
        return setMember == null ? null : setMember.getOldestMember();
    }

    public String getServiceType() {
        return null;
    }

    public String getServiceVersion() {
        return null;
    }

    public long getStartupTimeout() {
        long lStartupTimeout = Long.parseLong(System.getProperty("tangosol.coherence.service.startuptimeout", "0"));
        return lStartupTimeout > (long)0 ? lStartupTimeout : (long)this.getClusterService().getDeliveryTimeoutMillis();
    }

    public long getStatsPollCount() {
        return this.__m_StatsPollCount;
    }

    public long getStatsPollDuration() {
        return this.__m_StatsPollDuration;
    }

    public long getStatsPollMaxDuration() {
        return this.__m_StatsPollMaxDuration;
    }

    public long getStatsTimeoutCount() {
        return this.__m_StatsTimeoutCount;
    }

    public Member getThisMember() {
        MasterMemberSet setMembers = this.getClusterMemberSet();
        return setMembers == null ? null : setMembers.getThisMember();
    }

    public ObservableMap getThisMemberConfigMap() {
        Member memberThis = this.getThisMember();
        if (memberThis == null) {
            return null;
        }
        ServiceMemberSet setMemberService = this.getServiceMemberSet();
        return setMemberService == null ? this.getClusterService().getServiceInfo(this.getServiceId()).getMemberSet().ensureMemberConfigMap(memberThis.getId()) : setMemberService.ensureMemberConfigMap(memberThis.getId());
    }

    public String getThreadName() {
        String sServiceType = this.getServiceType();
        String sServiceName = this.getServiceName();
        return sServiceName.equals(sServiceType) ? sServiceName : String.valueOf(sServiceType) + ':' + sServiceName;
    }

    public Object getUserContext() {
        return this.__m_UserContext;
    }

    public long getWaitMillis() {
        long cWait = super.getWaitMillis();
        if (this.isGuardian()) {
            long ldtNow = Base.getLastSafeTimeMillis();
            long cGuardMillis = Math.max(1L, this.getGuardSupport().getNextCheckTime() - ldtNow);
            cWait = cWait == (long)0 ? cGuardMillis : Math.min(cWait, cGuardMillis);
        } else if (this.isGuarded()) {
            cWait = cWait == (long)0 ? 1000L : Math.min(cWait, 1000L);
        }
        return cWait;
    }

    public List getWrapperStreamFactoryAllList() {
        return this.__m_WrapperStreamFactoryAllList;
    }

    public List getWrapperStreamFactoryList() {
        return this.__m_WrapperStreamFactoryList;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/Grid".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        if (guardable instanceof Grid$Guard) {
            Grid service = (Grid)((Grid$Guard)guardable).get_Parent();
            guardable = service.instantiateWrapperGuardable(guardable);
        } else {
            guardable = this.instantiateWrapperGuardable(guardable);
        }
        return super.guard(guardable, cMillis, flPctRecover);
    }

    protected XmlElement initServiceConfig() {
        return new SimpleElement("config");
    }

    protected void initializeSUID() {
        int nMember = this.getThisMember().getId();
        long lMillis = this.getClusterTime();
        long lFirst = (long)nMember << 48 | lMillis & 0xFFFFFFFFFFFFL;
        AtomicLong counter = new AtomicLong();
        counter.getAndSet(lFirst);
        this.setSUIDCounter(counter);
    }

    /*
     * WARNING - void declaration
     */
    public Message instantiateMessage(int nMsgType) {
        Class clz = this.getMessageClass(nMsgType);
        if (clz == null) {
            int nConvertedType = -(65535 - nMsgType + 1);
            clz = this.getMessageClass(nConvertedType);
            if (clz == null) {
                throw new RuntimeException(String.valueOf("Service ") + this.getServiceName() + " was unable to instantiate MessageType=" + nMsgType);
            }
            Component._trace(String.valueOf("Compensated for JIT compilation error (optimized out I2S); ") + "Expected: " + nConvertedType + ", received: " + nMsgType, 2);
        }
        try {
            void e;
            Message msg = (Message)clz.newInstance();
            msg.setService(this);
            return e;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Message instantiateMessage(String sMsgName) {
        Class clz = this.getMessageClass(sMsgName);
        if (clz == null) {
            throw new IllegalArgumentException(String.valueOf("Unable to instantiate Message \"") + sMsgName + '\"');
        }
        try {
            void e;
            Message msg = (Message)clz.newInstance();
            msg.setService(this);
            return e;
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    protected MessageHandler instantiateMessageHandler() {
        return new MessageHandler();
    }

    protected Queue instantiateQueue() {
        Grid$ReceiveQueue queue = new Grid$ReceiveQueue();
        queue.setBatchSize(Integer.parseInt(System.getProperty("tangosol.coherence.service.batch", "4")));
        return queue;
    }

    public RequestContext instantiateRequestContext() {
        return new IdempotentContext();
    }

    public Grid$WrapperGuardable instantiateWrapperGuardable(Guardable guardable) {
        Grid$WrapperGuardable wrapper = (Grid$WrapperGuardable)this._newChild("WrapperGuardable");
        wrapper.setGuardable(guardable);
        return wrapper;
    }

    public boolean isAcceptingOthers() {
        return this.__m_AcceptingOthers;
    }

    public boolean isClusterThread(boolean fStrict) {
        Thread threadService = this.getThread();
        if (threadService == null) {
            return false;
        }
        ThreadGroup groupCluster = threadService.getThreadGroup();
        ThreadGroup groupThis = Thread.currentThread().getThreadGroup();
        return fStrict ? groupCluster == groupThis : groupCluster.parentOf(groupThis);
    }

    public boolean isProtocolFiltered() {
        return this.getWrapperStreamFactoryAllList() != null ? true : this.getWrapperStreamFactoryList() != null;
    }

    protected void notifyServiceJoined() {
        ClusterService clusterService = this.getClusterService();
        if (clusterService != this) {
            this.getServiceMemberSet().setServiceJoined(this.getThisMember().getId());
            clusterService.doServiceJoined(this);
        }
    }

    public void onConfigIOException(IOException e, Member member) {
        StringBuffer sb = new StringBuffer();
        if (this.getServiceId() == 0) {
            sb.append("This cluster node failed to deserialize the config");
        } else {
            sb.append(String.valueOf("The service \"") + this.getServiceName() + '\"');
            String sSerializerThat = (String)this.getServiceMemberSet().getMemberConfigMap(member.getId()).get("Serializer");
            sb.append(" is configured to use serializer ").append(this.getSerializer()).append(", which appears to be different from ").append(sSerializerThat == null ? "the serializer" : (sSerializerThat.length() == 0 ? "default serializer" : sSerializerThat)).append(" used by ").append(member).append('.');
        }
        if (member == this.getServiceOldestMember()) {
            sb.append('\n').append(Component.getStackTrace(e)).append("Stopping the ").append(this.getServiceName()).append(" service.");
            Component._trace(sb.toString(), 1);
            this.stop();
        } else {
            Component._trace(sb.toString(), 6);
        }
    }

    protected void onEnter() {
        this.setStartTimestamp(Base.getSafeTimeMillis());
        this.resetStats();
        if (this.isGuarded()) {
            GuardSupport.setThreadContext(this.getGuardable().getContext());
        }
        if (this.getServiceId() > 0) {
            this.initializeSUID();
            this.getThisMemberConfigMap().put("Serializer", this.ensureSerializer().getClass().getName());
        }
        this.setServiceState(Service.SERVICE_STARTING);
        this.post(this.instantiateMessage("NotifyStartup"));
    }

    protected void onExit() {
        Message msg;
        super.onExit();
        MessageHandler handler = this.getMessageHandler();
        if (handler != null) {
            handler.close();
        }
        Queue queue = this.getQueue();
        while (!((msg = (Message)queue.removeNoWait()) == null)) {
            if (!msg.isDeserializationRequired()) continue;
            msg.releaseIncoming();
        }
    }

    public void onInit() {
        super.onInit();
        Map map = ((Component)this).get_ChildClasses();
        Class clzMessage = Message.get_CLASS();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            String sMsgName = (String)entry.getKey();
            Class clz = (Class)entry.getValue();
            if (!clzMessage.isAssignableFrom(clz)) continue;
            this.registerMessageType(sMsgName, clz);
        }
        Grid$PollArray waPoll = (Grid$PollArray)this._findChild("PollArray");
        this.setPollArray(waPoll);
        waPoll.remove(waPoll.add(new Poll()));
    }

    public void onMessage(Message msg) {
        if (msg != null) {
            block6: {
                try {
                    Member memberFrom = msg.getFromMember();
                    if (memberFrom != null) {
                        int nMemberFrom = memberFrom.getId();
                        ServiceMemberSet setMember = this.getServiceMemberSet();
                        if (!(!(!(setMember != null) ? false : ((MemberSet)setMember).getMember(nMemberFrom) == null) ? false : msg.isInternal() ^ true) ? false : this.getServiceId() > 0) {
                            Component._trace(String.valueOf("Discarding a ") + msg.get_Name() + " message from member " + nMemberFrom + " which does not belong to the service.", 6);
                            return;
                        }
                        MemberSet.readBarrier(nMemberFrom);
                    }
                    msg.onReceived();
                }
                catch (EventDeathException e) {
                    if (!(msg instanceof RequestMessage)) break block6;
                    Component._trace(String.valueOf("Processing for RequestMessage has been interrupted:\n") + msg, 2);
                    Component._trace(Component.getStackTrace(e), 4);
                }
            }
            Poll poll = msg.getPoll();
            if (poll != null) {
                poll.onResponse(msg);
            }
        }
    }

    protected boolean onMessageReadException(Throwable e, Message msg) {
        if (e instanceof SecurityException) {
            Component._trace(String.valueOf("SecurityException received while reading ") + msg + "\n" + Component.getStackTrace(e), 1);
        } else {
            Component._trace(String.valueOf("An exception (") + e.getClass().getName() + ") occurred reading Message " + msg.get_Name() + " Type=" + msg.getMessageType() + " for Service=" + this, 1);
            this.onException(e);
        }
        return false;
    }

    public void onMessageReceipt(Message msg) {
        if (msg != null) {
            Grid$NotifyMessageReceipt msgRecpt = (Grid$NotifyMessageReceipt)this.instantiateMessage("NotifyMessageReceipt");
            msgRecpt.setNotifyMessage(msg);
            this.post(msgRecpt);
        }
    }

    protected void onNotify() {
        long lStart = Base.getSafeTimeMillis();
        long cMsgs = this.getStatsReceived();
        Queue queueDeferred = this.getQueueDeferred();
        Queue queueIn = this.getQueue();
        while (this.isExiting() ^ true) {
            Message msg;
            if ((cMsgs & 0x1FFL) == 511L) {
                this.getPollArray().checkPolls();
                this.heartbeat();
            }
            if ((msg = queueDeferred == null ? (Message)queueIn.removeNoWait() : this.processDeferredQueue()) == null) break;
            if (msg.isDeserializationRequired() ^ true ? true : this.deserializeMessage(msg)) {
                this.onMessage(msg);
            }
            ++cMsgs;
        }
        this.setStatsReceived(cMsgs);
        this.setStatsCpu(this.getStatsCpu() + (Base.getSafeTimeMillis() - lStart));
        super.onNotify();
    }

    public void onPollClosed(Poll poll) {
        this.unregisterPoll(poll);
    }

    public void onServiceStarted() {
        this.validateServiceConfig();
        this.setAcceptingOthers(true);
        this.setAcceptingClients(true);
    }

    protected void onServiceState(int nState) {
        ClusterService clusterservice = this.getClusterService();
        switch (nState) {
            case 1: {
                this.onServiceStarting();
                break;
            }
            case 2: {
                if (this == clusterservice) {
                    this.onServiceStarted();
                    break;
                }
                clusterservice.doServiceJoining(this);
                Member memberSenior = this.getServiceOldestMember();
                Component._trace(String.valueOf("Service ") + this.getServiceName() + " joined the cluster with " + "senior service member " + memberSenior.getId(), 5);
                this.getThisMemberConfigMap().addMapListener((Grid$MemberConfigListener)this._findChild("MemberConfigListener"));
                MessageHandler handler = this.getMessageHandler();
                if (handler != null) {
                    handler.connectAll();
                }
                if (this.getThisMember() == memberSenior) {
                    this.onServiceStarted();
                    break;
                }
                Grid$MemberWelcomeRequest msg = (Grid$MemberWelcomeRequest)this.instantiateMessage("MemberWelcomeRequest");
                msg.setToMemberSet(this.getOthersMemberSet());
                this.post(msg);
                break;
            }
            case 3: {
                this.getServiceMemberSet().setServiceLeaving(this.getThisMember().getId());
                this.onServiceStopping();
                clusterservice.doServiceLeaving(this);
                break;
            }
            case 4: {
                this.onServiceStopped();
                this.closePolls();
                clusterservice.doServiceLeft(this);
                Component._trace(String.valueOf("Service ") + this.getServiceName() + " left the cluster", 5);
                break;
            }
        }
    }

    protected void onStartupTimeout() {
        throw new RequestTimeoutException(String.valueOf("Timeout during service start: ") + this.getInfo());
    }

    protected void onWait() throws InterruptedException {
        this.flushSend();
        super.onWait();
    }

    public Object poll(RequestMessage msg) {
        long cTimeoutMillis = this.calculateRequestTimeout(msg);
        return this.poll(msg, cTimeoutMillis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll(RequestMessage msg, long lMillis) {
        Component._assert(this.getThread() != Thread.currentThread(), "poll() is a blocking call and cannot be called on the Service thread");
        this.waitAcceptingClients();
        Poll poll = msg.ensureRequestPoll();
        this.send(msg);
        Poll poll2 = poll;
        synchronized (poll2) {
            if (poll.isClosed() ^ true) {
                boolean fClosed = false;
                try {
                    block14: {
                        try {
                            if (lMillis == 0L) {
                                do {
                                    poll.wait();
                                } while ((fClosed = poll.isClosed()) ^ true);
                                break block14;
                            }
                            long cWait = lMillis;
                            long ldtStart = System.currentTimeMillis();
                            while (true) {
                                poll.wait(cWait);
                                fClosed = poll.isClosed();
                                if (!fClosed) {
                                    cWait = this.checkRequestTimeout(ldtStart, lMillis);
                                    continue;
                                }
                                break;
                            }
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw this.processPollInterrupt(Collections.singleton(poll), e);
                        }
                    }
                    Object var8_11 = null;
                    if (fClosed ^ true) {
                        this.doPollClose(msg);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_12 = null;
                    if (fClosed ^ true) {
                        this.doPollClose(msg);
                    }
                    throw throwable;
                }
            }
        }
        return poll.getResult();
    }

    public void post(Message msg) {
        Grid$EventDispatcher dispatcher;
        if (msg.getService() == null) {
            msg.setService(this);
        }
        if ((dispatcher = (Grid$EventDispatcher)this.getEventDispatcher()) != null) {
            dispatcher.drainOverflow();
        }
        if (msg instanceof RequestMessage) {
            RequestMessage req = (RequestMessage)msg;
            Poll poll = req.ensureRequestPoll();
            boolean fSuccess = false;
            try {
                long lId = poll.getPollId();
                if (lId == 0L) {
                    poll.configureFrom(req);
                    lId = this.registerPoll(req, poll);
                }
                req.setFromPollId(lId);
                fSuccess = this.dispatchMessage(msg);
            }
            finally {
                Object var7_8 = null;
                if (fSuccess ^ true) {
                    this.doPollClose(req);
                }
            }
        } else {
            this.dispatchMessage(msg);
        }
    }

    protected Message processDeferredQueue() {
        Queue queueDeferred = this.getQueueDeferred();
        Message msg = null;
        if (this.isAcceptingOthers()) {
            if (queueDeferred != null && (msg = (Message)queueDeferred.removeNoWait()) == null) {
                this.setQueueDeferred(null);
            }
        } else {
            msg = (Message)this.getQueue().removeNoWait();
            if (!(msg != null) ? false : msg.isInternal() ^ true) {
                queueDeferred.add(msg);
                msg = null;
            }
        }
        return msg;
    }

    protected RuntimeException processPollInterrupt(Set setPolls, InterruptedException e) {
        StringBuilder sbLog = new StringBuilder();
        TreeMap<Integer, String> mapMbrs = new TreeMap<Integer, String>();
        sbLog.append("This thread was interrupted while waiting for the results ").append("of a request:\n");
        Iterator iter = setPolls.iterator();
        while (iter.hasNext()) {
            Poll poll = (Poll)iter.next();
            if (!(poll.isClosed() ^ true)) continue;
            sbLog.append(poll.toString());
            sbLog.append(',');
            int[] anMbr = poll.getRemainingMemberSet().toIdArray();
            int i = 0;
            while (i < anMbr.length) {
                int nMemberId = anMbr[i];
                Member member = this.getClusterMemberSet().getMember(nMemberId);
                mapMbrs.put(new Integer(nMemberId), member == null ? String.valueOf(nMemberId) : member.toString());
                ++i;
            }
            poll.close();
        }
        Component._trace(sbLog.toString(), 1);
        return new WrapperException(e, String.valueOf("Interrupted while waiting for response from:") + mapMbrs.values());
    }

    protected void register() {
        ClusterService clusterservice = this.getClusterService();
        int nId = clusterservice.ensureService(this.getServiceName(), this.getServiceType());
        Component._assert(nId > 0);
        this.setServiceId(nId);
        this.setClusterMemberSet(clusterservice.getClusterMemberSet());
    }

    public void registerMessageType(String sMsgName, Class clz) {
        try {
            Message msg = (Message)clz.newInstance();
            int nType = msg.getMessageType();
            if (this.getMessageClass(nType) != null) {
                throw new IllegalStateException(String.valueOf(clz) + " - duplicate MessageType: " + nType + " " + this.getMessageClass(nType));
            }
            this.setMessageClass(nType, clz);
            this.getMessageClassMap().put(sMsgName, clz);
        }
        catch (Exception e) {
            Component._trace(String.valueOf("Service.registerMessageType: Unable to instantiate ") + clz, 1);
            Component._trace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long registerPoll(RequestMessage msgRequest, Poll poll) {
        Component._assert(!(!(poll.getService() == null) ? false : poll.getPollId() == 0L) ? false : poll.isClosed() ^ true);
        poll.setService(this);
        long lId = this.getPollArray().add(poll);
        poll.setPollId(lId);
        ServiceMemberSet setMember = this.getServiceMemberSet();
        MemberSet setPoll = poll.getRemainingMemberSet();
        if (this.getServiceState() == Service.SERVICE_STOPPED) {
            poll.close();
        } else if (setPoll.isEmpty()) {
            this.doPollClose(msgRequest);
        } else if (setMember.containsAll((Collection)setPoll) ^ true) {
            MasterMemberSet setMaster = this.getClusterMemberSet();
            int i = setPoll.getFirstId();
            int iLast = setPoll.getLastId();
            while (i <= iLast) {
                if (!setPoll.contains(i) ? false : setMember.contains(i) ^ true) {
                    Member member = setMaster.getMember(i);
                    if (member == null) {
                        MasterMemberSet masterMemberSet = setMaster;
                        synchronized (masterMemberSet) {
                            member = setMaster.getRecycleSet().getMember(i);
                        }
                        Component._assert(member != null);
                    }
                    this.doPollMemberLeft(msgRequest, member);
                }
                ++i;
            }
        }
        return lId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object registerRequestInfo(long lId, Object oValue) {
        LongArray laPending;
        LongArray longArray = laPending = this.getPendingRequestInfo();
        synchronized (longArray) {
            Object object = laPending.set(lId, oValue);
            return object;
        }
    }

    public void removeMemberListener(MemberListener l) {
        this.getMemberListeners().remove(l);
    }

    public static List removeSUIDRange(LongArray array, int nMember, boolean fValues) {
        return Grid.removeSUIDRange(array, Grid.getBaseSUID(nMember), Grid.getBaseSUID(nMember + 1), fValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List removeSUIDRange(LongArray array, long lFrom, long lTo, boolean fValues) {
        LinkedList listValues = fValues ? new LinkedList() : null;
        LongArray longArray = array;
        synchronized (longArray) {
            LongArray.Iterator iter = array.iterator(lFrom);
            while (iter.hasNext()) {
                Object oValue = iter.next();
                if (!(iter.getIndex() < lTo)) break;
                iter.remove();
                if (!fValues) continue;
                listValues.add(oValue);
            }
        }
        return listValues;
    }

    protected void reportTransportMismatch(Member member) {
        ServiceMemberSet setMember = this.getServiceMemberSet();
        Member memberThis = this.getThisMember();
        String sRoleThis = memberThis.getRoleName();
        String sRoleThat = member.getRoleName();
        Component._trace(String.valueOf(member) + " is joining the service using \"" + ServiceMemberSet.formatEndPoint(setMember.getServiceEndPointName(member.getId())) + "\" transport while this member is configured to use \"" + ServiceMemberSet.formatEndPoint(setMember.getServiceEndPointName(memberThis.getId())) + '\"', Base.equals(sRoleThis, sRoleThat) ? 2 : 3);
    }

    public void resetStats() {
        this.setStatsPollCount(0L);
        this.setStatsPollDuration(0L);
        this.setStatsPollMaxDuration(0L);
        this.setStatsTimeoutCount(0L);
        super.resetStats();
    }

    public EndPoint resolveEndPoint(String sEndPoint, Member member) {
        EndPoint peer = null;
        try {
            if (!(sEndPoint != null) ? false : sEndPoint.length() > 0) {
                peer = ((Cluster)this.getCluster()).getSocketManager().getDepot().resolveEndPoint(sEndPoint);
            }
        }
        catch (IllegalArgumentException e) {
            Component._trace(String.valueOf("Failed to resolve the EndPoint name \"") + sEndPoint + "\" to communicate with service " + this.getServiceName() + " at " + member + "; falling back on the datagram transport", 1);
            return null;
        }
        if (!(this.getMessageHandler() != null) ? false : peer == null) {
            this.reportTransportMismatch(member);
        }
        return peer;
    }

    public void send(Message msg) {
        this.post(msg);
        this.flushSend();
    }

    public void serializeMessage(Message msg, WriteBuffer.BufferOutput output) throws IOException {
        output.writeInt(msg.getMessageType());
        if (this.isProtocolFiltered()) {
            output = this.wrapStream(output, msg);
            msg.writeInternal(output);
            msg.write(output);
            output.close();
        } else {
            msg.writeInternal(output);
            msg.write(output);
        }
    }

    public synchronized void setAcceptingClients(boolean fAccepting) {
        boolean fWasAccepting = this.isAcceptingClients();
        super.setAcceptingClients(fAccepting);
        if (!(fWasAccepting ^ true) ? false : fAccepting) {
            ActionPolicy policy;
            long cGuardTimeout;
            this.dispatchMemberEvent(this.getThisMember(), MemberEvent.MEMBER_JOINED);
            ClusterService clusterService = this.getClusterService();
            if (clusterService != this && (cGuardTimeout = this.getDefaultGuardTimeout()) != clusterService.getDefaultGuardTimeout()) {
                clusterService.guard(this.getGuardable(), cGuardTimeout, this.getDefaultGuardRecovery());
            }
            if ((policy = this.getActionPolicy()) != null) {
                policy.init(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAcceptingOthers(boolean fAccepting) {
        boolean fWasAccepting = this.isAcceptingOthers();
        this.__m_AcceptingOthers = fAccepting;
        if (this.is_Constructed()) {
            Object oLock;
            if (!fAccepting ? false : fWasAccepting ^ true) {
                this.notifyServiceJoined();
            }
            Object object = oLock = this.getLock();
            synchronized (object) {
                oLock.notify();
            }
        }
    }

    protected void setActionPolicy(ActionPolicy policy) {
        this.__m_ActionPolicy = policy;
    }

    public void setCluster(com.tangosol.net.Cluster cluster) {
        Component._assert(this.getCluster() == null);
        this.__m_Cluster = cluster;
    }

    public void setClusterMemberSet(MasterMemberSet setMember) {
        Component._assert(this.isStarted() ^ true);
        this.__m_ClusterMemberSet = setMember;
    }

    private void setMemberListeners(Listeners listeners) {
        this.__m_MemberListeners = listeners;
    }

    protected void setMessageClass(int i, Class clz) {
        boolean fBeyondBounds;
        Class[] aClass = this.getMessageClass();
        boolean bl = aClass == null ? true : (fBeyondBounds = (i += MESSAGE_OFFSET) >= aClass.length);
        if (!fBeyondBounds ? false : clz != null) {
            int cNew = Math.max(i + (i >>> 1), i + 4);
            Class[] aClassNew = new Class[cNew];
            if (aClass != null) {
                System.arraycopy(aClass, 0, aClassNew, 0, aClass.length);
            }
            aClass = aClassNew;
            this.setMessageClass(aClassNew);
            fBeyondBounds = false;
        }
        if (fBeyondBounds ^ true) {
            aClass[i] = clz;
        }
    }

    private void setMessageClass(Class[] aclz) {
        this.__m_MessageClass = aclz;
    }

    protected void setMessageClassMap(Map map) {
        this.__m_MessageClassMap = map;
    }

    protected void setMessageHandler(MessageHandler handler) {
        this.__m_MessageHandler = handler;
    }

    public void setPacketAllocator(PacketBufferPool allocator) {
        this.__m_PacketAllocator = allocator;
    }

    protected void setPendingRequestInfo(LongArray array) {
        this.__m_PendingRequestInfo = array;
    }

    protected void setPollArray(Grid$PollArray waPoll) {
        this.__m_PollArray = waPoll;
    }

    private void setQueueDeferred(Queue queue) {
        this.__m_QueueDeferred = queue;
    }

    public void setRequestTimeout(long cMillis) {
        this.__m_RequestTimeout = cMillis;
    }

    protected void setSUIDCounter(AtomicLong counter) {
        this.__m_SUIDCounter = counter;
    }

    public void setSendQueue(Queue queue) {
        Component._assert(this.isStarted() ^ true);
        this.__m_SendQueue = queue;
    }

    protected void setServiceConfigMap(Grid$ServiceConfig$Map map) {
        this.__m_ServiceConfigMap = map;
    }

    public void setServiceFailurePolicy(ServiceFailurePolicy policy) {
        this.__m_ServiceFailurePolicy = policy;
    }

    public void setServiceId(int nId) {
        Component._assert(this.isStarted() ^ true);
        this.__m_ServiceId = nId;
    }

    public void setServiceMemberSet(ServiceMemberSet setMember) {
        Component._assert(this.getServiceMemberSet() == null, "Not resettable");
        this.__m_ServiceMemberSet = setMember;
    }

    public synchronized void setServiceState(int nState) {
        if (nState > this.getServiceState()) {
            switch (nState) {
                case 2: {
                    break;
                }
                case 3: {
                    this.dispatchMemberEvent(this.getThisMember(), MemberEvent.MEMBER_LEAVING);
                    break;
                }
                case 4: {
                    this.dispatchMemberEvent(this.getThisMember(), MemberEvent.MEMBER_LEFT);
                    break;
                }
            }
        }
        super.setServiceState(nState);
    }

    protected void setStatsPollCount(long cPolls) {
        this.__m_StatsPollCount = cPolls;
    }

    protected void setStatsPollDuration(long cMillis) {
        this.__m_StatsPollDuration = cMillis;
    }

    protected void setStatsPollMaxDuration(long cMillis) {
        this.__m_StatsPollMaxDuration = cMillis;
    }

    protected void setStatsTimeoutCount(long cRequests) {
        this.__m_StatsTimeoutCount = cRequests;
    }

    public void setUserContext(Object oCtx) {
        this.__m_UserContext = oCtx;
    }

    public void setWrapperStreamFactoryAllList(List listAll) {
        this.__m_WrapperStreamFactoryAllList = listAll;
    }

    public void setWrapperStreamFactoryList(List list) {
        Component._assert(this.isStarted() ^ true);
        this.__m_WrapperStreamFactoryList = list;
    }

    public synchronized void shutdown() {
        Thread thread;
        if (this.isStarted() && this.getServiceState() < Service.SERVICE_STOPPING) {
            this.send(this.instantiateMessage("NotifyShutdown"));
        }
        if ((thread = this.getThread()) != Thread.currentThread()) {
            while (!this.isStarted() ? false : this.getServiceState() < Service.SERVICE_STOPPED) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new WrapperException(e);
                }
            }
            if (this.getServiceState() != Service.SERVICE_STOPPED) {
                this.stop();
            }
        }
    }

    public synchronized void start() {
        if (this.getServiceState() == Service.SERVICE_INITIAL) {
            this.register();
        }
        super.start();
    }

    public RuntimeException tagException(Throwable e) {
        if (e instanceof LicenseException) {
            return (LicenseException)e;
        }
        String sMsg = null;
        try {
            StackTraceElement[] atrace;
            sMsg = String.valueOf("Failed request execution for ") + this.getServiceName() + " service on " + this.getThisMember();
            if (e instanceof WrapperException) {
                WrapperException we = (WrapperException)e;
                e = we.getOriginalException();
                sMsg = String.valueOf(sMsg) + (String.valueOf(' ') + we.getMessage());
            }
            if (e instanceof OutOfMemoryError && ((atrace = e.getStackTrace()) == null ? true : atrace.length == 0)) {
                e = new OutOfMemoryError();
            }
        }
        catch (Throwable throwable) {}
        return Base.ensureRuntimeException(e, sMsg);
    }

    protected void unregisterPoll(Poll poll) {
        Component._assert(!(poll != null) ? false : poll.getService() == this);
        this.getPollArray().remove(poll.getPollId());
        long cMillis = Base.getSafeTimeMillis() - poll.getInitTimeMillis();
        this.setStatsPollCount(this.getStatsPollCount() + 1L);
        this.setStatsPollDuration(this.getStatsPollDuration() + cMillis);
        if (cMillis > this.getStatsPollMaxDuration()) {
            this.setStatsPollMaxDuration(cMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object unregisterRequestInfo(long lId) {
        LongArray laPending;
        LongArray longArray = laPending = this.getPendingRequestInfo();
        synchronized (longArray) {
            Object object = laPending.remove(lId);
            return object;
        }
    }

    public void unregisterRequestInfoRange(long lFrom, long lTo) {
        if (lFrom == -1L) {
            if (lTo == -1L) {
                return;
            }
            lFrom = Grid.getBaseSUID(lTo);
        }
        Grid.removeSUIDRange(this.getPendingRequestInfo(), lFrom, lTo, false);
    }

    protected void validateServiceConfig() {
        boolean fSenior = this.getThisMember() == this.getServiceOldestMember();
        Character oConfigKey = new Character('$');
        Grid$ServiceConfig$Map mapConfig = this.getServiceConfigMap();
        XmlElement xmlConfig = fSenior ? null : (XmlElement)mapConfig.get(oConfigKey);
        if (xmlConfig == null) {
            Component._assert(fSenior, "The service configuration is missing.");
            xmlConfig = this.initServiceConfig();
            mapConfig.put(oConfigKey, xmlConfig);
        } else if (this.validateServiceConfig(xmlConfig) ^ true) {
            this.stop();
        }
    }

    protected boolean validateServiceConfig(XmlElement xmlConfig) {
        return true;
    }

    protected boolean verifyFeature(String sFeature, Object oValue, Object oTest) {
        if (oValue.equals(oTest)) {
            return true;
        }
        Component._trace(String.valueOf("Incompatible ") + sFeature + " implementation: " + "this node is configured to use " + oValue + ", but the service senior is using " + oTest + "; stopping the service.", 1);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitPolls(Set setPolls, long cWaitMillis) {
        this.flushSend();
        try {
            HashSet hashSet = setPolls;
            synchronized (hashSet) {
                if (setPolls.isEmpty() ^ true) {
                    if (cWaitMillis == 0L) {
                        do {
                            setPolls.wait();
                        } while (setPolls.isEmpty() ^ true);
                    } else {
                        long cWait = cWaitMillis;
                        while (true) {
                            long ldtStart = System.currentTimeMillis();
                            setPolls.wait(cWait);
                            if (setPolls.isEmpty()) break;
                            cWait = this.checkRequestTimeout(ldtStart, cWaitMillis);
                        }
                    }
                }
            }
        }
        catch (InterruptedException e) {
            HashSet hashSet = setPolls;
            synchronized (hashSet) {
                setPolls = new HashSet(setPolls);
            }
            Thread.currentThread().interrupt();
            throw this.processPollInterrupt(setPolls, e);
        }
    }

    protected ReadBuffer.BufferInput wrapStream(ReadBuffer.BufferInput input, Message msg) {
        List listSvc;
        InputStream streamWrap = null;
        List listAll = this.getWrapperStreamFactoryAllList();
        if (listAll != null) {
            streamWrap = new WrapperDataInputStream(input);
            int i = 0;
            int c = listAll.size();
            while (i < c) {
                streamWrap = ((WrapperStreamFactory)listAll.get(i)).getInputStream(streamWrap);
                if (streamWrap instanceof ProtocolAwareStream) {
                    ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
                }
                ++i;
            }
        }
        if ((listSvc = this.getWrapperStreamFactoryList()) != null) {
            if (streamWrap == null) {
                streamWrap = new WrapperDataInputStream(input);
            }
            int i = 0;
            int c = listSvc.size();
            while (i < c) {
                streamWrap = ((WrapperStreamFactory)listSvc.get(i)).getInputStream(streamWrap);
                if (streamWrap instanceof ProtocolAwareStream) {
                    ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
                }
                ++i;
            }
        }
        return streamWrap == null ? input : (streamWrap instanceof ReadBuffer.BufferInput ? (ReadBuffer.BufferInput)((Object)streamWrap) : new WrapperBufferInput(new DataInputStream(streamWrap)));
    }

    public WriteBuffer.BufferOutput wrapStream(WriteBuffer.BufferOutput output, Message msg) {
        List listAll;
        List listSvc = this.getWrapperStreamFactoryList();
        OutputStream streamWrap = null;
        if (listSvc != null) {
            streamWrap = new WrapperDataOutputStream(output);
            int i = 0;
            int c = listSvc.size();
            while (i < c) {
                streamWrap = ((WrapperStreamFactory)listSvc.get(i)).getOutputStream(streamWrap);
                if (streamWrap instanceof ProtocolAwareStream) {
                    ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
                }
                ++i;
            }
        }
        if ((listAll = this.getWrapperStreamFactoryAllList()) != null) {
            if (streamWrap == null) {
                streamWrap = new WrapperDataOutputStream(output);
            }
            int i = 0;
            int c = listAll.size();
            while (i < c) {
                streamWrap = ((WrapperStreamFactory)listAll.get(i)).getOutputStream(streamWrap);
                if (streamWrap instanceof ProtocolAwareStream) {
                    ((ProtocolAwareStream)((Object)streamWrap)).setProtocolContext(this.getProtocolContext(msg));
                }
                ++i;
            }
        }
        return streamWrap == null ? output : (streamWrap instanceof WriteBuffer.BufferOutput ? (WriteBuffer.BufferOutput)((Object)streamWrap) : new WrapperBufferOutput(new DataOutputStream(streamWrap)));
    }
}

