/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.serviceMemberSet.MasterMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.net.message.SimpleResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ClusterService$MemberLeft$Poll;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.UUID;
import com.tangosol.util.WrapperException;
import java.io.IOException;

public class ClusterService$MemberLeft
extends RequestMessage {
    private int __m_MemberId;
    private UUID __m_MemberUID;
    private boolean __m_Request;

    public ClusterService$MemberLeft() {
        this(null, null, true);
    }

    public ClusterService$MemberLeft(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferUsageCounter(1);
            this.setMessageType(36);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new ClusterService$MemberLeft$Poll("Poll", this, true), "Poll");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public String getDescription() {
        return String.valueOf("MemberId=") + this.getMemberId() + "\nMemberUid=" + this.getMemberUID() + "\nRequest=" + this.isRequest();
    }

    public int getMemberId() {
        return this.__m_MemberId;
    }

    public UUID getMemberUID() {
        return this.__m_MemberUID;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ClusterService$MemberLeft".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new ClusterService$MemberLeft();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public boolean isRequest() {
        return this.__m_Request;
    }

    public void onReceived() {
        super.onReceived();
        ClusterService service = (ClusterService)this.getService();
        MasterMemberSet setMembers = service.getClusterMemberSet();
        Member member = setMembers.getMember(this.getMemberId());
        Grid$Response response = (Grid$Response)service.instantiateMessage("Response");
        response.respondTo(this);
        if (member == null) {
            response.setResult(SimpleResponse.RESULT_SUCCESS);
        } else if (this.getMemberUID().equals(member.getUid32())) {
            Member memberFrom = this.getFromMember();
            boolean fRequest = this.isRequest();
            if (memberFrom == member) {
                Component._trace(String.valueOf("MemberLeft announcement from ") + member, 5);
            } else {
                Component._trace(String.valueOf("MemberLeft ") + (fRequest ? "request" : "notification") + " for " + member + " received from " + memberFrom, 5);
            }
            if (fRequest) {
                if (service.isHeuristicallyDead(member) ? true : service.isSlow(member)) {
                    Component._trace(String.valueOf("Confirming the departure request by ") + this.getFromMember().toString(Member.SHOW_STATS) + " regarding " + member.toString(Member.SHOW_STATS), 3);
                    response.setResult(SimpleResponse.RESULT_SUCCESS);
                } else {
                    Component._trace(String.valueOf("Rejecting the departure confirmation request by ") + this.getFromMember().toString(Member.SHOW_STATS) + " regarding " + member.toString(Member.SHOW_STATS), 3);
                    response.setResult(SimpleResponse.RESULT_FAILURE);
                }
            } else {
                service.removeMember(member);
                if (setMembers.getThisMember() == setMembers.getOldestMember()) {
                    MemberSet setTo = service.getOthersMemberSet();
                    setTo.remove(memberFrom);
                    if (setTo.isEmpty() ^ true) {
                        ClusterService$MemberLeft msgNotify = (ClusterService$MemberLeft)service.instantiateMessage("MemberLeft");
                        msgNotify.setToMemberSet(setTo);
                        msgNotify.setMemberId(member.getId());
                        msgNotify.setMemberUID(member.getUid32());
                        ((ClusterService$MemberLeft$Poll)msgNotify.ensureRequestPoll()).setNotificationResponse(response);
                        service.send(msgNotify);
                        return;
                    }
                }
            }
        } else {
            Component._trace(String.valueOf("Received MemberLeft notification ") + this + "\nfor " + member + " with different UID " + member.getUid32(), 1);
            response.setResult(SimpleResponse.RESULT_FAILURE);
        }
        service.send(response);
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        this.setMemberId(input.readUnsignedShort());
        this.setMemberUID(new UUID(input));
        this.setRequest(input.readBoolean());
    }

    public void setMemberId(int nId) {
        this.__m_MemberId = nId;
    }

    public void setMemberUID(UUID uid) {
        this.__m_MemberUID = uid;
    }

    public void setRequest(boolean fRequest) {
        this.__m_Request = fRequest;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        output.writeShort(this.getMemberId());
        this.getMemberUID().writeExternal(output);
        output.writeBoolean(this.isRequest());
    }
}

