/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.net.Member;
import com.tangosol.net.partition.DistributionManager;
import com.tangosol.net.partition.Ownership;
import com.tangosol.net.partition.PartitionSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class PartitionedService$CentralDistribution$DistributionManager
extends Util
implements DistributionManager {
    private Set __m_OwnershipLeavingMembers;
    private Set __m_OwnershipMembers;
    private Map __m_SuggestionMap;

    public PartitionedService$CentralDistribution$DistributionManager() {
        this(null, null, true);
    }

    public PartitionedService$CentralDistribution$DistributionManager(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    public int getBackupCount() {
        return ((PartitionedService)this.getService()).getBackupCount();
    }

    public Member getMember(int nMemberId) {
        return ((MemberSet)this.getOwnershipMembers()).getMember(nMemberId);
    }

    public PartitionSet getOwnedPartitions(Member member, int iStore) {
        int[][] aiOwners = this.getPartitionAssignments();
        int cPartitions = this.getPartitionCount();
        int nMemberId = member.getId();
        PartitionSet parts = new PartitionSet(cPartitions);
        int i = 0;
        while (i < cPartitions) {
            if (aiOwners[i][iStore] == nMemberId) {
                parts.add(i);
            }
            ++i;
        }
        return parts;
    }

    public Set getOwnershipLeavingMembers() {
        return this.__m_OwnershipLeavingMembers;
    }

    public Set getOwnershipMembers() {
        return this.__m_OwnershipMembers;
    }

    public int[][] getPartitionAssignments() {
        return ((PartitionedService)this.getService()).getPartitionAssignments();
    }

    public int getPartitionCount() {
        return ((PartitionedService)this.getService()).getPartitionCount();
    }

    public Ownership getPartitionOwnership(int nPartition) {
        int[][] aaiOwners = this.getPartitionAssignments();
        int cBackups = this.getBackupCount();
        Ownership owners = new Ownership(cBackups);
        int iStore = 0;
        while (iStore <= cBackups) {
            owners.setOwner(iStore, aaiOwners[nPartition][iStore]);
            ++iStore;
        }
        return owners;
    }

    public com.tangosol.net.PartitionedService getService() {
        return (PartitionedService)this.get_Module();
    }

    public Map getSuggestionMap() {
        return this.__m_SuggestionMap;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$CentralDistribution$DistributionManager".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new PartitionedService$CentralDistribution$DistributionManager();
    }

    private final Component get_Module() {
        return this.get_Parent().get_Parent();
    }

    public void reset() {
        this.setOwnershipLeavingMembers(null);
        this.setOwnershipMembers(null);
        this.setSuggestionMap(null);
    }

    public void setOwnershipLeavingMembers(Set setLeaving) {
        this.__m_OwnershipLeavingMembers = setLeaving;
    }

    public void setOwnershipMembers(Set setOwners) {
        this.__m_OwnershipMembers = setOwners;
    }

    protected void setSuggestionMap(Map partsUpdated) {
        this.__m_SuggestionMap = partsUpdated;
    }

    public void suggest(PartitionSet parts, Ownership owners) {
        HashMap<Ownership, PartitionSet> mapSuggestions;
        if (Component._isTraceEnabled(6)) {
            Component._trace(String.valueOf("PartitionAssignmentStrategy suggested the ownership of ") + owners + " for " + parts, 6);
        }
        if ((mapSuggestions = this.getSuggestionMap()) == null) {
            mapSuggestions = new HashMap<Ownership, PartitionSet>();
            this.setSuggestionMap(mapSuggestions);
        }
        if (this.validateSuggestion(parts, owners) ^ true) {
            return;
        }
        PartitionSet partsSuggest = (PartitionSet)mapSuggestions.get(owners);
        if (partsSuggest == null) {
            partsSuggest = new PartitionSet(parts);
            mapSuggestions.put(owners, parts);
        } else {
            partsSuggest.add(parts);
        }
    }

    protected boolean validateSuggestion(PartitionSet parts, Ownership owners) {
        MemberSet setSuggest = new MemberSet();
        MemberSet setOwners = (MemberSet)this.getOwnershipMembers();
        Set setLeaving = this.getOwnershipLeavingMembers();
        int cBackups = this.getBackupCount();
        int iStore = 0;
        while (iStore <= cBackups) {
            int nOwner = owners.getOwner(iStore);
            com.tangosol.coherence.component.net.Member member = setOwners.getMember(nOwner);
            if (member == null) {
                if (!(!(nOwner == 0) ? false : iStore > 0)) {
                    Component._trace(String.valueOf("Distribution suggestion (") + owners + ") for " + parts + " contains unknown member " + nOwner + "; ignoring suggested distribution", 1);
                    return false;
                }
            } else {
                if (setLeaving.contains(member)) {
                    Component._trace(String.valueOf("Distribution suggestion (") + owners + ") for " + parts + " contains member " + nOwner + " which is leaving the service;" + " ignoring suggested distribution", 1);
                    return false;
                }
                if (setSuggest.add(member) ^ true) {
                    Component._trace(String.valueOf("Distribution suggestion (") + owners + ") for " + parts + " contains duplicate storage indices for " + nOwner + ";" + " ignoring suggested distribution", 1);
                    return false;
                }
            }
            ++iStore;
        }
        return true;
    }
}

