/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Member;
import com.tangosol.coherence.component.net.MemberSet;
import com.tangosol.coherence.component.net.memberSet.actualMemberSet.ServiceMemberSet;
import com.tangosol.coherence.component.net.message.RequestMessage;
import com.tangosol.coherence.component.util.DistributionStrategy;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$CentralDistribution$DistributionManager;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$CentralDistribution$DistributionPlanUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$DistributionRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.PartitionedService$TransferControl;
import com.tangosol.net.partition.Ownership;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PartitionedService$CentralDistribution
extends DistributionStrategy {
    private long __m_AnalysisNextMillis;
    private PartitionedService$CentralDistribution$DistributionManager __m_DistributionManager;
    private Map[] __m_PendingChanges;
    private static ListMap __mapChildren;

    static {
        PartitionedService$CentralDistribution.__initStatic();
    }

    public PartitionedService$CentralDistribution() {
        this(null, null, true);
    }

    public PartitionedService$CentralDistribution(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        this._addChild(new PartitionedService$CentralDistribution$DistributionManager("DistributionManager", this, true), "DistributionManager");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DistributionPlanUpdate", PartitionedService$CentralDistribution$DistributionPlanUpdate.get_CLASS());
    }

    public void checkDistribution(MemberSet setOwners, Set setLeaving) {
        super.checkDistribution(setOwners, setLeaving);
        PartitionedService service = this.getService();
        long ldtNow = Base.getSafeTimeMillis();
        long ldtNextDist = ldtNow + 10000L;
        if (this.isCoordinator() && ldtNow > this.getAnalysisNextMillis()) {
            PartitionedService$CentralDistribution$DistributionManager manager = this.getDistributionManager();
            try {
                try {
                    manager.setOwnershipMembers(setOwners);
                    manager.setOwnershipLeavingMembers(setLeaving);
                    long cAnalysisMillis = service.getPartitionAssignmentStrategy().analyzeDistribution();
                    Map mapUpdate = manager.getSuggestionMap();
                    if (!(mapUpdate != null) ? false : mapUpdate.isEmpty() ^ true) {
                        PartitionedService$CentralDistribution$DistributionPlanUpdate msgUpdate = (PartitionedService$CentralDistribution$DistributionPlanUpdate)service.instantiateMessage("DistributionPlanUpdate");
                        msgUpdate.setUpdateMap(mapUpdate);
                        msgUpdate.setToMemberSet(service.getOwnershipOtherMemberSet(null));
                        service.post(msgUpdate);
                        this.processUpdate(mapUpdate);
                    }
                    long cRepeatMillis = service.getDistributionRepeatMillis();
                    ldtNextDist = ldtNow + (service.getServiceState() == Service.SERVICE_STOPPING ? cRepeatMillis / (long)service.getDistributionAggressiveness() : (cAnalysisMillis == -1L ? cRepeatMillis : cAnalysisMillis));
                    this.setAnalysisNextMillis(ldtNextDist);
                }
                catch (Throwable t) {
                    Component._trace(String.valueOf("Unexpected exception occurred while calculating the ") + "partition assignment: " + Base.printStackTrace(t), 1);
                }
                Object var10_13 = null;
                manager.reset();
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                manager.reset();
                throw throwable;
            }
        }
        if (!service.isDistributionAllowed() ? false : this.processPendingChanges() ^ true) {
            ldtNextDist = Math.min(ldtNextDist, ldtNow + 100L);
        }
        service.setDistributionNextMillis(ldtNextDist);
    }

    protected void endangerPartitions(PartitionSet partsEndanger, int iStore) {
        int[][] aaiOwners = this.getPartitionAssignments();
        int nMemberThis = this.getThisMember().getId();
        PartitionedService service = this.getService();
        PartitionedService$TransferControl ctrlTransfer = service.getTransferControl();
        int iPart = partsEndanger.next(0);
        while (iPart >= 0) {
            if (aaiOwners[iPart][0] == nMemberThis) {
                int nBackupOwner = aaiOwners[iPart][iStore];
                Member memberBackup = service.getServiceMemberSet().getMember(nBackupOwner);
                if (memberBackup != null) {
                    aaiOwners[iPart][iStore] = 0;
                    service.getPartitionControl(iPart).preventTransfer();
                    ctrlTransfer.sendBackupRelease(iPart, iStore, nMemberThis, 0, memberBackup);
                }
            }
            iPart = partsEndanger.next(iPart + 1);
        }
    }

    public long getAnalysisNextMillis() {
        return this.__m_AnalysisNextMillis;
    }

    public PartitionedService$CentralDistribution$DistributionManager getDistributionManager() {
        return this.__m_DistributionManager;
    }

    public Map[] getPendingChanges() {
        return this.__m_PendingChanges;
    }

    public Map getPendingChanges(int iStore) {
        return this.getPendingChanges()[iStore];
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/PartitionedService$CentralDistribution".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PartitionedService$CentralDistribution();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    public boolean isCoordinator() {
        PartitionedService service = this.getService();
        return service.getOwnershipSenior(false) == service.getThisMember();
    }

    public void onDistributionCompleted(Member member, boolean fSuccess) {
        this.setDistributionInProgress(false);
        PartitionedService service = this.getService();
        int nRetryMillis = service.getDistributionRepeatMillis() / service.getDistributionAggressiveness();
        if (fSuccess ^ true) {
            service.getTransferControl().onReceiveRollback(member);
        }
        Component._assert(service.isTransferInProgress() ^ true);
        service.setDistributionNextMillis(Base.getSafeTimeMillis() + (long)nRetryMillis);
    }

    public void onDistributionPlanUpdate(PartitionedService$CentralDistribution$DistributionPlanUpdate msgUpdate) {
        if (this.getService().isDistributionAllowed()) {
            this.processUpdate(msgUpdate.getUpdateMap());
        }
    }

    public void onDistributionRequest(RequestMessage msgRequest) {
        PartitionedService$DistributionRequest msg = (PartitionedService$DistributionRequest)msgRequest;
        PartitionedService service = this.getService();
        if (service.checkDeferredDistribution() ^ true) {
            int cSent;
            PartitionSet parts = msg.getPartitions();
            int cRequest = msg.getPartitionCount();
            Member memberFrom = msg.getFromMember();
            parts.retain(service.collectOwnedPartitions(true));
            cRequest = Math.min(cRequest, parts.cardinality());
            if (cRequest > 0 && (cSent = service.transferPrimary(memberFrom, msg, parts, cRequest)) > 0) {
                Component._trace(String.valueOf("Transferring primary ") + parts + " to member " + memberFrom.getId() + " requesting " + cRequest, 5);
                return;
            }
        }
        Grid$Response msgResponse = (Grid$Response)service.instantiateMessage("Response");
        msgResponse.respondTo(msg);
        service.post(msgResponse);
    }

    public void onInit() {
        super.onInit();
        PartitionedService service = (PartitionedService)this.get_Module();
        int cPartitions = service.getPartitionCount();
        int cBackups = service.getBackupCount();
        service.registerMessageType("DistributionPlanUpdate", PartitionedService$CentralDistribution$DistributionPlanUpdate.get_CLASS());
        Map[] aMapPending = new Map[cBackups + 1];
        int iStore = 0;
        while (iStore <= cBackups) {
            aMapPending[iStore] = new HashMap();
            ++iStore;
        }
        this.setPendingChanges(aMapPending);
        PartitionedService$CentralDistribution$DistributionManager mgr = (PartitionedService$CentralDistribution$DistributionManager)this._findChild("DistributionManager");
        service.getPartitionAssignmentStrategy().init(mgr);
        this.setDistributionManager(mgr);
    }

    public void onMembershipChanged(int iReason) {
        this.setAnalysisNextMillis(0L);
        this.getService().setDistributionNextMillis(0L);
        int cBackups = this.getBackupCount();
        int iStore = 0;
        while (iStore <= cBackups) {
            this.getPendingChanges(iStore).clear();
            ++iStore;
        }
    }

    protected boolean processPendingChanges() {
        PartitionedService service = this.getService();
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        int[][] aaiOwners = this.getPartitionAssignments();
        int nMemberThis = this.getThisMember().getId();
        ServiceMemberSet setMembers = service.getServiceMemberSet();
        int iStore = 0;
        while (iStore <= cBackups) {
            int cPending;
            boolean fPrimary = iStore == 0;
            Map mapPending = this.getPendingChanges(iStore);
            PartitionSet partsEndanger = (PartitionSet)mapPending.remove(Base.makeInteger(0));
            if (partsEndanger != null) {
                Component._assert(iStore > 0);
                this.endangerPartitions(partsEndanger, iStore);
            }
            if (!((cPending = mapPending.size()) == 0)) {
                Object[] aNMember = mapPending.keySet().toArray(new Integer[cPending]);
                Base.randomize(aNMember);
                int i = 0;
                while (i < cPending) {
                    Object NMember = aNMember[i];
                    int nMember = (Integer)NMember;
                    PartitionSet parts = (PartitionSet)mapPending.get(NMember);
                    Member member = ((MemberSet)setMembers).getMember(nMember);
                    if (member == null) {
                        mapPending.remove(NMember);
                    } else {
                        int iPart = parts.next(0);
                        while (iPart >= 0) {
                            int[] aiOwners = aaiOwners[iPart];
                            int nOwnerActual = aiOwners[0];
                            if (fPrimary) {
                                if (nOwnerActual != nMember) {
                                    parts.remove(iPart);
                                }
                            } else {
                                int iStoreCur = service.getOwnedIndex(iPart, nMember);
                                if (nOwnerActual != nMemberThis) {
                                    parts.remove(iPart);
                                } else if (iStoreCur != -1) {
                                    service.modifyBackupIndex(member, iPart, iStore);
                                    parts.remove(iPart);
                                }
                            }
                            iPart = parts.next(iPart + 1);
                        }
                        if (parts.isEmpty()) {
                            mapPending.remove(NMember);
                        } else {
                            if (fPrimary) {
                                PartitionedService$DistributionRequest msg = (PartitionedService$DistributionRequest)service.instantiateMessage("DistributionRequest");
                                msg.addToMember(member);
                                msg.setSourceMember(member);
                                msg.setPartitionCount(parts.cardinality());
                                msg.setPartitions(parts);
                                Component._trace(String.valueOf("Asking member ") + member.getId() + " for primary ownership of " + parts, 4);
                                this.setDistributionInProgress(true);
                                service.post(msg);
                            } else {
                                parts = new PartitionSet(parts);
                                service.transferBackup(member, parts, iStore, parts.cardinality());
                            }
                            return false;
                        }
                    }
                    ++i;
                }
            }
            ++iStore;
        }
        return true;
    }

    protected void processUpdate(Map mapUpdate) {
        int nMemberThis = this.getThisMember().getId();
        int cPartitions = this.getPartitionCount();
        int cBackups = this.getBackupCount();
        int[][] aaiOwners = this.getPartitionAssignments();
        int iStore = 0;
        while (iStore <= cBackups) {
            this.getPendingChanges(iStore).clear();
            ++iStore;
        }
        Iterator iter = mapUpdate.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Ownership owners = (Ownership)entry.getKey();
            PartitionSet parts = (PartitionSet)entry.getValue();
            int nOwner = owners.getPrimaryOwner();
            if (!(nOwner == nMemberThis)) continue;
            int iPart = parts.next(0);
            while (iPart >= 0) {
                int[] aiOwners = aaiOwners[iPart];
                boolean fPrimaryXfer = false;
                int iStore2 = 0;
                while (iStore2 <= cBackups) {
                    int nOwnerPlan = owners.getOwner(iStore2);
                    int nOwnerActual = aiOwners[iStore2];
                    if (!(iStore2 == 0) ? false : nOwnerActual == 0) break;
                    if (nOwnerPlan != nOwnerActual ? true : fPrimaryXfer) {
                        int nMemberTarget = iStore2 == 0 ? nOwnerActual : nOwnerPlan;
                        Integer IMemberTarget = Base.makeInteger(nMemberTarget);
                        Map mapPending = this.getPendingChanges(iStore2);
                        PartitionSet partsPending = (PartitionSet)mapPending.get(IMemberTarget);
                        if (partsPending == null) {
                            partsPending = new PartitionSet(cPartitions);
                            mapPending.put(IMemberTarget, partsPending);
                        }
                        partsPending.add(iPart);
                        fPrimaryXfer = fPrimaryXfer ? true : iStore2 == 0;
                    }
                    ++iStore2;
                }
                iPart = parts.next(iPart + 1);
            }
        }
        this.getService().setDistributionNextMillis(0L);
    }

    public String reportDistributionState() {
        StringBuilder sb = new StringBuilder();
        if (this.isCoordinator()) {
            sb.append(this.getService().getPartitionAssignmentStrategy().getDescription()).append('\n');
        }
        ServiceMemberSet setMembers = this.getService().getServiceMemberSet();
        int cBackups = this.getBackupCount();
        int cChanges = 0;
        int iStore = 0;
        while (iStore <= cBackups) {
            Map mapPending = this.getPendingChanges(iStore);
            int cPending = mapPending.size();
            if (!(cPending == 0)) {
                if (cChanges == 0) {
                    sb.append("\nPending distribution changes:\n").append("-----------------------------\n");
                }
                cChanges += cPending;
                Object[] aNMember = mapPending.keySet().toArray(new Integer[cPending]);
                Arrays.sort(aNMember);
                int i = 0;
                while (i < cPending) {
                    Object NMember = aNMember[i];
                    int nMember = (Integer)NMember;
                    PartitionSet parts = (PartitionSet)mapPending.get(NMember);
                    Member member = ((MemberSet)setMembers).getMember(nMember);
                    sb.append(iStore == 0 ? "Primary" : "Backup").append(" transfer of ").append(parts).append(' ').append(iStore == 0 ? "from" : "to").append(" member ").append(nMember).append('\n');
                    ++i;
                }
            }
            ++iStore;
        }
        return sb.toString();
    }

    protected void setAnalysisNextMillis(long ldtNextAnalysis) {
        this.__m_AnalysisNextMillis = ldtNextAnalysis;
    }

    protected void setDistributionManager(PartitionedService$CentralDistribution$DistributionManager manager) {
        this.__m_DistributionManager = manager;
    }

    public void setPendingChanges(int iStore, Map mapPending) {
        this.getPendingChanges()[iStore] = mapPending;
    }

    public void setPendingChanges(Map[] aMapPending) {
        this.__m_PendingChanges = aMapPending;
    }
}

