/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Cluster;
import com.tangosol.coherence.component.net.extend.protocol.CacheServiceProtocol;
import com.tangosol.coherence.component.net.extend.protocol.InvocationServiceProtocol;
import com.tangosol.coherence.component.net.extend.protocol.NamedCacheProtocol;
import com.tangosol.coherence.component.net.extend.proxy.serviceProxy.CacheServiceProxy;
import com.tangosol.coherence.component.net.extend.proxy.serviceProxy.InvocationServiceProxy;
import com.tangosol.coherence.component.util.DaemonPool;
import com.tangosol.coherence.component.util.SafeCluster;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Acknowledgement;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigSync;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$DispatchNotification;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Guard;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberConfigUpdate;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcome;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$MemberWelcomeRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMemberLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyMessageReceipt;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyPollClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyResponse;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceAnnounced;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceJoining;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyServiceLeaving;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyShutdown;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$NotifyStartup;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$PollArray;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ProtocolContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ReceiveQueue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$Response;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$ServiceConfig;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid$WrapperGuardable;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$NotifyConnectionClosed;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$NotifyConnectionOpened;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$NotifyServiceJoined;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$NotifyServiceLeft;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$RedirectRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$ServiceLoad;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.ProxyService$ServiceLoadListener;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.acceptor.TcpAcceptor$TcpConnection;
import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.internal.net.cluster.LegacyXmlConfigurableQuorumPolicy;
import com.tangosol.net.Member;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ProxyService;
import com.tangosol.net.RequestPolicyException;
import com.tangosol.net.management.Registry;
import com.tangosol.net.messaging.Connection;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.net.messaging.ConnectionEvent;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.net.messaging.ConnectionFilter;
import com.tangosol.net.messaging.ConnectionListener;
import com.tangosol.net.proxy.DefaultProxyServiceLoadBalancer;
import com.tangosol.net.proxy.ProxyServiceLoad;
import com.tangosol.net.proxy.ProxyServiceLoadBalancer;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.LiteMap;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.SafeHashMap;
import com.tangosol.util.SynchronousListener;
import com.tangosol.util.WrapperException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class ProxyService
extends Grid
implements com.tangosol.net.ProxyService,
ConnectionFilter,
ConnectionListener,
SynchronousListener {
    private ConnectionAcceptor __m_Acceptor;
    private CacheServiceProxy __m_CacheServiceProxy;
    private InvocationServiceProxy __m_InvocationServiceProxy;
    private ProxyServiceLoadBalancer __m_LoadBalancer;
    private ProxyService$ServiceLoad __m_ServiceLoad;
    private Map __m_ServiceLoadMap;
    private long __m_ServiceLoadTimeMillis;
    private static ListMap __mapChildren;

    static {
        ProxyService.__initStatic();
    }

    public ProxyService() {
        this(null, null, true);
    }

    public ProxyService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setMessageClassMap(new HashMap());
            this.setSerializerMap(new WeakHashMap());
            this.setServiceLoadMap(new SafeHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Grid$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Grid$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Grid$Guard("Guard", this, true), "Guard");
        this._addChild(new Grid$MemberConfigListener("MemberConfigListener", this, true), "MemberConfigListener");
        this._addChild(new Grid$PollArray("PollArray", this, true), "PollArray");
        this._addChild(new Grid$ServiceConfig("ServiceConfig", this, true), "ServiceConfig");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Acknowledgement", Grid$Acknowledgement.get_CLASS());
        Class clazz2 = __mapChildren.put("ConfigRequest", Grid$ConfigRequest.get_CLASS());
        Class clazz3 = __mapChildren.put("ConfigResponse", Grid$ConfigResponse.get_CLASS());
        Class clazz4 = __mapChildren.put("ConfigSync", Grid$ConfigSync.get_CLASS());
        Class clazz5 = __mapChildren.put("ConfigUpdate", Grid$ConfigUpdate.get_CLASS());
        Class clazz6 = __mapChildren.put("DispatchEvent", Grid$DispatchEvent.get_CLASS());
        Class clazz7 = __mapChildren.put("DispatchNotification", Grid$DispatchNotification.get_CLASS());
        Class clazz8 = __mapChildren.put("MemberConfigUpdate", Grid$MemberConfigUpdate.get_CLASS());
        Class clazz9 = __mapChildren.put("MemberWelcome", Grid$MemberWelcome.get_CLASS());
        Class clazz10 = __mapChildren.put("MemberWelcomeRequest", Grid$MemberWelcomeRequest.get_CLASS());
        Class clazz11 = __mapChildren.put("NotifyConnectionClosed", ProxyService$NotifyConnectionClosed.get_CLASS());
        Class clazz12 = __mapChildren.put("NotifyConnectionOpened", ProxyService$NotifyConnectionOpened.get_CLASS());
        Class clazz13 = __mapChildren.put("NotifyMemberJoined", Grid$NotifyMemberJoined.get_CLASS());
        Class clazz14 = __mapChildren.put("NotifyMemberLeaving", Grid$NotifyMemberLeaving.get_CLASS());
        Class clazz15 = __mapChildren.put("NotifyMemberLeft", Grid$NotifyMemberLeft.get_CLASS());
        Class clazz16 = __mapChildren.put("NotifyMessageReceipt", Grid$NotifyMessageReceipt.get_CLASS());
        Class clazz17 = __mapChildren.put("NotifyPollClosed", Grid$NotifyPollClosed.get_CLASS());
        Class clazz18 = __mapChildren.put("NotifyResponse", Grid$NotifyResponse.get_CLASS());
        Class clazz19 = __mapChildren.put("NotifyServiceAnnounced", Grid$NotifyServiceAnnounced.get_CLASS());
        Class clazz20 = __mapChildren.put("NotifyServiceJoined", ProxyService$NotifyServiceJoined.get_CLASS());
        Class clazz21 = __mapChildren.put("NotifyServiceJoining", Grid$NotifyServiceJoining.get_CLASS());
        Class clazz22 = __mapChildren.put("NotifyServiceLeaving", Grid$NotifyServiceLeaving.get_CLASS());
        Class clazz23 = __mapChildren.put("NotifyServiceLeft", ProxyService$NotifyServiceLeft.get_CLASS());
        Class clazz24 = __mapChildren.put("NotifyShutdown", Grid$NotifyShutdown.get_CLASS());
        Class clazz25 = __mapChildren.put("NotifyStartup", Grid$NotifyStartup.get_CLASS());
        Class clazz26 = __mapChildren.put("ProtocolContext", Grid$ProtocolContext.get_CLASS());
        Class clazz27 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
        Class clazz28 = __mapChildren.put("ReceiveQueue", Grid$ReceiveQueue.get_CLASS());
        Class clazz29 = __mapChildren.put("RedirectRequest", ProxyService$RedirectRequest.get_CLASS());
        Class clazz30 = __mapChildren.put("Response", Grid$Response.get_CLASS());
        Class clazz31 = __mapChildren.put("ServiceLoad", ProxyService$ServiceLoad.get_CLASS());
        Class clazz32 = __mapChildren.put("ServiceLoadListener", ProxyService$ServiceLoadListener.get_CLASS());
        Class clazz33 = __mapChildren.put("WrapperGuardable", Grid$WrapperGuardable.get_CLASS());
    }

    public void checkConnection(Connection connection) throws ConnectionException {
        if (this.getActionPolicy().isAllowed(this, ProxyService.ProxyAction.CONNECT) ^ true) {
            throw new ConnectionException("connection rejected", new RequestPolicyException("client connections are disallowed by the action policy"));
        }
        ProxyService$RedirectRequest request = (ProxyService$RedirectRequest)this.instantiateMessage("RedirectRequest");
        request.setConnection(connection);
        request.addToMember(this.getThisMember());
        Object oResult = this.poll(request);
        if (!(oResult instanceof Boolean) ? false : (Boolean)oResult) {
            throw new ConnectionException("connection redirected");
        }
    }

    public synchronized void configure(XmlElement xml) {
        Acceptor acceptorImpl;
        OperationalContext ctx;
        Component._assert(xml != null);
        super.configure(xml);
        this.setCacheServiceProxy(new CacheServiceProxy());
        this.setInvocationServiceProxy(new InvocationServiceProxy());
        this.getCacheServiceProxy().setConfig(xml.getSafeElement("proxy-config/cache-service-proxy"));
        this.getInvocationServiceProxy().setConfig(xml.getSafeElement("proxy-config/invocation-service-proxy"));
        XmlElement xmlAcceptor = Acceptor.findAcceptorConfig(xml);
        XmlElement xmlHandler = XmlHelper.ensureElement(xmlAcceptor, "incoming-message-handler");
        XmlElement xmlSub = XmlHelper.ensureElement(xmlHandler, "thread-count");
        if (xmlSub.getValue() == null) {
            xmlSub.setInt(xml.getSafeElement("thread-count").getInt());
        }
        if ((xmlSub = XmlHelper.ensureElement(xmlHandler, "task-hung-threshold")).getValue() == null) {
            xmlSub.setString(xml.getSafeElement("task-hung-threshold").getString());
        }
        if ((xmlSub = XmlHelper.ensureElement(xmlHandler, "task-timeout")).getValue() == null) {
            xmlSub.setString(xml.getSafeElement("task-timeout").getString());
        }
        if ((xmlSub = XmlHelper.ensureElement(xmlHandler, "request-timeout")).getValue() == null) {
            xmlSub.setString(xml.getSafeElement("request-timeout").getString());
        }
        if ((ctx = this.getOperationalContext()) == null) {
            throw new IllegalStateException("missing required OperationalContext");
        }
        ConnectionAcceptor acceptor = Acceptor.createAcceptor(xmlAcceptor, ctx);
        if (acceptor instanceof Acceptor) {
            acceptorImpl = (Acceptor)acceptor;
            acceptorImpl.setServiceName(String.valueOf(this.getThreadName()) + ':' + acceptorImpl.getServiceName());
            acceptorImpl.setParentService(this);
            acceptorImpl.setDefaultGuardTimeout(this.getDefaultGuardTimeout());
        }
        acceptor.registerProtocol(CacheServiceProtocol.getInstance());
        acceptor.registerProtocol(InvocationServiceProtocol.getInstance());
        acceptor.registerProtocol(NamedCacheProtocol.getInstance());
        if (this.getCacheServiceProxy().isEnabled()) {
            acceptor.registerReceiver(this.getCacheServiceProxy());
        }
        if (this.getInvocationServiceProxy().isEnabled()) {
            acceptor.registerReceiver(this.getInvocationServiceProxy());
        }
        acceptor.setContextClassLoader(this.getContextClassLoader());
        acceptor.setConnectionFilter(this);
        if (acceptor instanceof Acceptor) {
            acceptorImpl = (Acceptor)acceptor;
            this.getCacheServiceProxy().setSerializer(acceptorImpl.ensureSerializer());
            this.getInvocationServiceProxy().setSerializer(acceptorImpl.ensureSerializer());
        } else {
            this.getCacheServiceProxy().setSerializer(this.ensureSerializer());
            this.getInvocationServiceProxy().setSerializer(this.ensureSerializer());
        }
        ProxyServiceLoadBalancer balancer = null;
        XmlElement xmlBalancer = xml.getSafeElement("load-balancer");
        XmlElement xmlInstance = xmlBalancer.getElement("instance");
        if (xmlInstance == null) {
            String sName;
            String string = sName = xmlBalancer.isEmpty() ? "proxy" : xmlBalancer.getString();
            if (sName.equals("proxy")) {
                balancer = new DefaultProxyServiceLoadBalancer();
            } else if (sName.equals("client") ^ true) {
                throw new IllegalArgumentException(String.valueOf("illegal load balancer:\n") + xmlBalancer);
            }
        } else {
            balancer = (ProxyServiceLoadBalancer)XmlHelper.createInstance(xmlInstance, this.getContextClassLoader(), null);
        }
        if (balancer != null) {
            this.setLoadBalancer(balancer);
            try {
                balancer.init(this);
            }
            catch (RuntimeException e) {
                Base.ensureRuntimeException(e, "error initializing load balancer");
            }
        }
        XmlElement xmlPolicy = xml.getSafeElement("proxy-quorum-policy-scheme");
        this.setActionPolicy(new LegacyXmlConfigurableQuorumPolicy().createPolicy(xmlPolicy, this.getContextClassLoader()));
        this.setAcceptor(acceptor);
    }

    public void connectionClosed(ConnectionEvent evt) {
        ProxyService$NotifyConnectionClosed msg = (ProxyService$NotifyConnectionClosed)this.instantiateMessage("NotifyConnectionClosed");
        msg.setConnection(evt.getConnection());
        msg.addToMember(this.getThisMember());
        this.send(msg);
    }

    public void connectionError(ConnectionEvent evt) {
        this.connectionClosed(evt);
    }

    public void connectionOpened(ConnectionEvent evt) {
        ProxyService$NotifyConnectionOpened msg = (ProxyService$NotifyConnectionOpened)this.instantiateMessage("NotifyConnectionOpened");
        msg.setConnection(evt.getConnection());
        msg.addToMember(this.getThisMember());
        this.send(msg);
    }

    public String formatStats() {
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (acceptor instanceof Acceptor) {
            return ((Acceptor)acceptor).formatStats();
        }
        return super.formatStats();
    }

    public ConnectionAcceptor getAcceptor() {
        return this.__m_Acceptor;
    }

    public CacheServiceProxy getCacheServiceProxy() {
        return this.__m_CacheServiceProxy;
    }

    public ClusterDependencies getClusterDependencies() {
        com.tangosol.net.Cluster oCluster = this.getCluster();
        if (oCluster instanceof SafeCluster) {
            oCluster = ((SafeCluster)oCluster).ensureRunningCluster();
        }
        if (oCluster instanceof Cluster) {
            return ((Cluster)oCluster).getDependencies();
        }
        throw new IllegalStateException();
    }

    public InvocationServiceProxy getInvocationServiceProxy() {
        return this.__m_InvocationServiceProxy;
    }

    protected String getListenAddress(Member member) {
        ObservableMap map = this.getServiceMemberSet().getMemberConfigMap(member.getId());
        return (String)map.get("listen-address");
    }

    protected Integer getListenPort(Member member) {
        ObservableMap map = this.getServiceMemberSet().getMemberConfigMap(member.getId());
        return (Integer)map.get("listen-port");
    }

    public ProxyServiceLoadBalancer getLoadBalancer() {
        return this.__m_LoadBalancer;
    }

    public ProxyService$ServiceLoad getServiceLoad() {
        ProxyService$ServiceLoad load = this.__m_ServiceLoad;
        if (load == null) {
            load = new ProxyService$ServiceLoad();
            this.setServiceLoad(load);
        }
        return load;
    }

    public Map getServiceLoadMap() {
        return this.__m_ServiceLoadMap;
    }

    public long getServiceLoadTimeMillis() {
        return this.__m_ServiceLoadTimeMillis;
    }

    public String getServiceType() {
        return "Proxy";
    }

    public String getServiceVersion() {
        return "3.7";
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/ProxyService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ProxyService();
    }

    private final Component get_Module() {
        return this;
    }

    protected XmlElement initServiceConfig() {
        XmlElement xmlConfig = super.initServiceConfig();
        xmlConfig.getElementList().add(this.getServiceConfig().getSafeElement("proxy-quorum-policy-scheme").clone());
        return xmlConfig;
    }

    public boolean isRunning() {
        ConnectionAcceptor acceptor;
        if (super.isRunning() && (acceptor = this.getAcceptor()) != null) {
            if (acceptor.isRunning()) {
                return true;
            }
            this.stop();
        }
        return false;
    }

    protected void onNotify() {
        super.onNotify();
        long UPDATE_PERIOD = 10000L;
        if (this.getServiceLoadTimeMillis() + UPDATE_PERIOD <= Base.getLastSafeTimeMillis()) {
            ProxyService$ServiceLoad load = this.getServiceLoad();
            ConnectionAcceptor acceptor = this.getAcceptor();
            if (acceptor instanceof Acceptor) {
                Acceptor acceptorImpl = (Acceptor)acceptor;
                load.setConnectionPendingCount(acceptorImpl.getConnectionPendingSet().size());
                DaemonPool pool = acceptorImpl.getDaemonPool();
                if (pool.isStarted()) {
                    load.setDaemonActiveCount(pool.getActiveDaemonCount());
                }
                load.setMessageBacklogIncoming(pool.getQueue().size());
                if (acceptor instanceof TcpAcceptor) {
                    int cBacklog = 0;
                    try {
                        Iterator iter = acceptorImpl.getConnectionSet().iterator();
                        while (iter.hasNext()) {
                            TcpAcceptor$TcpConnection conn = (TcpAcceptor$TcpConnection)iter.next();
                            if (!(conn != null)) continue;
                            cBacklog += conn.getOutgoingQueue().size();
                        }
                    }
                    catch (ConcurrentModificationException e) {
                        // empty catch block
                    }
                    load.setMessageBacklogOutgoing(cBacklog);
                }
            }
            this.updateServiceLoad();
        }
    }

    public void onNotifyConnectionClosed(ProxyService$NotifyConnectionClosed msg) {
        Registry registry;
        Connection connection = msg.getConnection();
        if (connection instanceof TcpAcceptor$TcpConnection && (registry = this.getCluster().getManagement()) != null) {
            String sName = String.valueOf(registry.ensureGlobalName(String.valueOf(Registry.CONNECTION_TYPE) + ",name=" + this.getServiceName())) + ",UUID=" + connection.getId();
            registry.unregister(sName);
        }
        ProxyService$ServiceLoad load = this.getServiceLoad();
        load.updateConnectionCount(-1);
        this.updateServiceLoad();
        this.updateLoadBalancer(this.getThisMember(), load);
    }

    public void onNotifyConnectionOpened(ProxyService$NotifyConnectionOpened msg) {
        Registry registry;
        Connection connection = msg.getConnection();
        if (connection instanceof TcpAcceptor$TcpConnection && (registry = this.getCluster().getManagement()) != null) {
            String sName = String.valueOf(registry.ensureGlobalName(String.valueOf(Registry.CONNECTION_TYPE) + ",name=" + this.getServiceName())) + ",UUID=" + connection.getId();
            registry.register(sName, connection);
        }
        ProxyService$ServiceLoad load = this.getServiceLoad();
        load.updateConnectionCount(1);
        this.updateServiceLoad();
        this.updateLoadBalancer(this.getThisMember(), load);
    }

    public void onNotifyServiceJoined(com.tangosol.coherence.component.net.Member member) {
        ObservableMap map = this.getServiceMemberSet().getMemberConfigMap(member.getId());
        Map mapLoad = (Map)map.get("service-load");
        if (mapLoad != null) {
            ProxyService$ServiceLoadListener listener = (ProxyService$ServiceLoadListener)this._newChild("ServiceLoadListener");
            listener.setMember(member);
            ProxyService$ServiceLoad load = new ProxyService$ServiceLoad();
            load.fromMap(mapLoad);
            load.setListener(listener);
            this.getServiceLoadMap().put(member, load);
            map.addMapListener(listener);
            this.updateLoadBalancer(member, load);
        }
    }

    public void onNotifyServiceLeft(com.tangosol.coherence.component.net.Member member) {
        ProxyService$ServiceLoad load = (ProxyService$ServiceLoad)this.getServiceLoadMap().remove(member);
        if (load != null) {
            ProxyService$ServiceLoadListener listener = load.getListener();
            if (listener != null) {
                this.getServiceMemberSet().getMemberConfigMap(member.getId()).removeMapListener(listener);
            }
            this.updateLoadBalancer(member, null);
        }
    }

    public void onRedirectRequest(ProxyService$RedirectRequest request) {
        boolean fRedirect = false;
        Connection connection = request.getConnection();
        if (connection instanceof TcpAcceptor$TcpConnection) {
            TcpAcceptor$TcpConnection connectionImpl = (TcpAcceptor$TcpConnection)connection;
            ProxyServiceLoadBalancer balancer = this.getLoadBalancer();
            List<Member> list = ((balancer == null ? true : connectionImpl.isRedirect()) ? true : connectionImpl.isRedirectSupported() ^ true) ? null : balancer.getMemberList(connectionImpl.getMember());
            if (!(list != null) ? false : list.isEmpty() ^ true) {
                Member memberFirst = list.get(0);
                if (!Base.equals(this.getThisMember(), memberFirst)) {
                    ProxyService$ServiceLoad load = (ProxyService$ServiceLoad)this.getServiceLoadMap().get(memberFirst);
                    if (load != null) {
                        load.updateConnectionPendingCount(1);
                        this.updateLoadBalancer(memberFirst, load);
                    }
                    ArrayList<Object[]> listAddr = new ArrayList<Object[]>(list.size());
                    Iterator iter = list.iterator();
                    while (iter.hasNext()) {
                        Member member = (Member)iter.next();
                        String sAddr = this.getListenAddress(member);
                        Integer IPort = this.getListenPort(member);
                        if (!(!(sAddr != null) ? false : IPort != null)) continue;
                        listAddr.add(new Object[]{sAddr, IPort});
                    }
                    if (listAddr.isEmpty() ^ true) {
                        connectionImpl.setRedirect(true);
                        connectionImpl.setRedirectList(listAddr);
                        fRedirect = true;
                    }
                }
            }
        }
        Grid$Response response = (Grid$Response)this.instantiateMessage("Response");
        request.ensureRequestPoll().setResult(fRedirect);
        response.respondTo(request);
        this.send(response);
    }

    public void onServiceStarted() {
        com.tangosol.coherence.component.net.Member memberThis = this.getThisMember();
        Iterator iter = this.getServiceMemberSet().iterator();
        while (iter.hasNext()) {
            com.tangosol.coherence.component.net.Member member = (com.tangosol.coherence.component.net.Member)iter.next();
            if (!(Base.equals(member, memberThis) ^ true)) continue;
            this.onNotifyServiceJoined(member);
        }
        super.onServiceStarted();
    }

    protected void onServiceStarting() {
        super.onServiceStarting();
        ConnectionAcceptor acceptor = this.getAcceptor();
        ProxyService$ServiceLoad load = this.getServiceLoad();
        if (acceptor instanceof Acceptor) {
            Acceptor acceptorImpl = (Acceptor)acceptor;
            load.setConnectionLimit(acceptorImpl.getConnectionLimit());
            load.setDaemonCount(acceptorImpl.getDaemonPool().getDaemonCount());
        }
        this.updateServiceLoad();
        this.updateLoadBalancer(this.getThisMember(), load);
        if (acceptor instanceof TcpAcceptor) {
            ((TcpAcceptor)acceptor).addConnectionListener(this);
        }
        if (acceptor instanceof Acceptor) {
            this.guard(((Acceptor)acceptor).getGuardable());
        }
        acceptor.start();
        if (acceptor instanceof TcpAcceptor) {
            Registry registry = this.getCluster().getManagement();
            if (registry != null) {
                String sName = registry.ensureGlobalName(String.valueOf(Registry.CONNECTION_MANAGER_TYPE) + ",name=" + this.getServiceName());
                registry.register(sName, acceptor);
            }
            InetSocketAddress addr = ((TcpAcceptor)acceptor).getLocalAddress();
            LiteMap map = new LiteMap();
            map.put("listen-address", addr.getAddress().getHostAddress());
            map.put("listen-port", addr.getPort());
            this.getThisMemberConfigMap().putAll(map);
        }
    }

    protected void onServiceStopped() {
        Registry registry;
        super.onServiceStopped();
        ConnectionAcceptor acceptor = this.getAcceptor();
        acceptor.stop();
        this.updateLoadBalancer(this.getThisMember(), null);
        if (acceptor instanceof TcpAcceptor && (registry = this.getCluster().getManagement()) != null) {
            String sName = registry.ensureGlobalName(String.valueOf(Registry.CONNECTION_MANAGER_TYPE) + ",name=" + this.getServiceName());
            registry.unregister(sName);
        }
    }

    protected void onServiceStopping() {
        super.onServiceStopping();
        this.getAcceptor().shutdown();
    }

    public void resetStats() {
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (acceptor instanceof Acceptor) {
            ((Acceptor)acceptor).resetStats();
        }
        super.resetStats();
    }

    protected void setAcceptor(ConnectionAcceptor acceptor) {
        Component._assert(this.getAcceptor() == null);
        this.__m_Acceptor = acceptor;
    }

    protected void setCacheServiceProxy(CacheServiceProxy proxy) {
        Component._assert(this.getCacheServiceProxy() == null);
        this.__m_CacheServiceProxy = proxy;
    }

    public void setContextClassLoader(ClassLoader loader) {
        super.setContextClassLoader(loader);
        ConnectionAcceptor acceptor = this.getAcceptor();
        if (acceptor != null) {
            acceptor.setContextClassLoader(loader);
        }
    }

    protected void setInvocationServiceProxy(InvocationServiceProxy proxy) {
        Component._assert(this.getInvocationServiceProxy() == null);
        this.__m_InvocationServiceProxy = proxy;
    }

    protected void setLoadBalancer(ProxyServiceLoadBalancer balancer) {
        Component._assert(balancer != null);
        this.__m_LoadBalancer = balancer;
    }

    protected void setServiceLoad(ProxyService$ServiceLoad load) {
        this.__m_ServiceLoad = load;
    }

    protected void setServiceLoadMap(Map map) {
        Component._assert(map != null);
        this.__m_ServiceLoadMap = map;
    }

    protected void setServiceLoadTimeMillis(long c) {
        this.__m_ServiceLoadTimeMillis = c;
    }

    public void updateLoadBalancer(Member member, ProxyServiceLoad load) {
        ProxyServiceLoadBalancer balancer = this.getLoadBalancer();
        if (balancer != null) {
            balancer.update(member, load);
        }
    }

    protected void updateServiceLoad() {
        this.getThisMemberConfigMap().put("service-load", this.getServiceLoad().toMap());
        this.setServiceLoadTimeMillis(Base.getSafeTimeMillis());
    }

    protected boolean validateServiceConfig(XmlElement xmlConfig) {
        XmlElement xmlActionPolicy = this.getServiceConfig().getSafeElement("proxy-quorum-policy-scheme");
        return !super.validateServiceConfig(xmlConfig) ? false : this.verifyFeature("proxy-quorum-policy-scheme", xmlActionPolicy, xmlConfig.getSafeElement("proxy-quorum-policy-scheme"));
    }
}

