/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Lease;
import com.tangosol.coherence.component.net.Message;
import com.tangosol.coherence.component.net.message.requestMessage.distributedCacheKeyRequest.ExtendedKeyRequest;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Grid;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$LockRequest$Poll;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.util.Map;

public class PartitionedCache$LockRequest
extends ExtendedKeyRequest {
    private transient long __m_LeaseExpiration;
    private int __m_LeaseHolderId;
    private long __m_LeaseMillis;
    private long __m_LeaseThreadId;
    private long __m_LeaseWaitMillis;
    private transient long __m_LeaseWaitTimeout;
    private static ListMap __mapChildren;

    static {
        PartitionedCache$LockRequest.__initStatic();
    }

    public PartitionedCache$LockRequest() {
        this(null, null, true);
    }

    public PartitionedCache$LockRequest(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBufferUsageCounter(1);
            this.setMessageType(67);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Poll", PartitionedCache$LockRequest$Poll.get_CLASS());
    }

    public Message cloneMessage() {
        PartitionedCache$LockRequest msg = (PartitionedCache$LockRequest)super.cloneMessage();
        msg.fromLease(this.toLease());
        return msg;
    }

    public void fromLease(Lease lease) {
        this.setKey((Binary)lease.getResourceKey());
        this.setLeaseHolderId(lease.getHolderId());
        this.setLeaseThreadId(lease.getHolderThreadId());
        long ldtExpiry = lease.getExpirationTime();
        if (ldtExpiry > 0L) {
            this.setLeaseMillis(Math.max(0L, ldtExpiry - ((PartitionedCache)this.get_Module()).getClusterTime()));
        }
    }

    public String getDescription() {
        return String.valueOf(super.getDescription()) + "\nWaitTimeout=" + this.getLeaseWaitTimeout() + ", LeaseExpiration=" + this.getLeaseExpiration();
    }

    public long getLeaseExpiration() {
        long ldtExpiry = this.__m_LeaseExpiration;
        if (ldtExpiry == 0L) {
            PartitionedCache service = (PartitionedCache)this.getService();
            ldtExpiry = service.adjustWaitTime(this.getLeaseMillis() - 1L, Grid.TIME_CLUSTER);
            this.setLeaseExpiration(ldtExpiry);
        }
        return ldtExpiry;
    }

    public int getLeaseHolderId() {
        return this.__m_LeaseHolderId;
    }

    public long getLeaseMillis() {
        return this.__m_LeaseMillis;
    }

    public long getLeaseThreadId() {
        return this.__m_LeaseThreadId;
    }

    public long getLeaseWaitMillis() {
        return this.__m_LeaseWaitMillis;
    }

    public long getLeaseWaitTimeout() {
        long ldtTimeout = this.__m_LeaseWaitTimeout;
        if (ldtTimeout == 0L) {
            PartitionedCache service = (PartitionedCache)this.getService();
            ldtTimeout = service.adjustWaitTime(this.getLeaseWaitMillis(), Grid.TIME_CLUSTER);
            this.setLeaseWaitTimeout(ldtTimeout);
        }
        return ldtTimeout;
    }

    public long getRequestTimeoutMillis() {
        long cWait = this.getLeaseWaitMillis();
        if (cWait < (long)0) {
            return cWait;
        }
        long cDefault = this.getService().getRequestTimeout();
        if (cDefault <= (long)0) {
            return cDefault;
        }
        if (cWait < cDefault) {
            return cDefault;
        }
        return Math.min(cWait, Long.MAX_VALUE - cDefault) + cDefault;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$LockRequest".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PartitionedCache$LockRequest();
    }

    private final Component get_Module() {
        return ((Component)this).get_Parent();
    }

    public void read(ReadBuffer.BufferInput input) throws IOException {
        super.read(input);
        this.setLeaseHolderId(input.readUnsignedShort());
        this.setLeaseThreadId(ExternalizableHelper.readLong(input));
        this.setLeaseMillis(ExternalizableHelper.readLong(input));
        this.setLeaseWaitMillis(ExternalizableHelper.readLong(input));
    }

    public void run() {
        ((PartitionedCache)this.getService()).onLockRequest(this);
    }

    protected void setLeaseExpiration(long ltExpiration) {
        this.__m_LeaseExpiration = ltExpiration;
    }

    public void setLeaseHolderId(int nHolderId) {
        this.__m_LeaseHolderId = nHolderId;
    }

    public void setLeaseMillis(long cMillis) {
        this.__m_LeaseMillis = cMillis;
        this.setLeaseExpiration(0L);
    }

    public void setLeaseThreadId(long lThreadId) {
        this.__m_LeaseThreadId = lThreadId;
    }

    public void setLeaseWaitMillis(long cMillis) {
        this.__m_LeaseWaitMillis = cMillis;
        this.setLeaseWaitTimeout(0L);
    }

    protected void setLeaseWaitTimeout(long ldtTimeout) {
        this.__m_LeaseWaitTimeout = ldtTimeout;
    }

    public Lease toLease() {
        Lease lease = Lease.instantiate(0, this.getKey(), this.getService());
        lease.setHolderId(this.getLeaseHolderId());
        lease.setHolderThreadId(this.getLeaseThreadId());
        lease.setExpirationTime(this.getLeaseExpiration());
        return lease;
    }

    public void write(WriteBuffer.BufferOutput output) throws IOException {
        super.write(output);
        output.writeShort(this.getLeaseHolderId());
        ExternalizableHelper.writeLong(output, this.getLeaseThreadId());
        ExternalizableHelper.writeLong(output, this.getLeaseMillis());
        ExternalizableHelper.writeLong(output, this.getLeaseWaitMillis());
    }
}

