/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.Util;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$BackingMapContext;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$BinaryMap;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$Storage;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.grid.partitionedService.PartitionedCache$ViewMap$ProxyListener;
import com.tangosol.io.ClassLoaderAware;
import com.tangosol.license.LicenseException;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.RequestTimeoutException;
import com.tangosol.net.partition.KeyPartitioningStrategy;
import com.tangosol.net.partition.PartitionSet;
import com.tangosol.util.Base;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.ImmutableArrayList;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.ListMap;
import com.tangosol.util.MapListener;
import com.tangosol.util.MapListenerSupport;
import com.tangosol.util.MapTriggerListener;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.WrapperException;
import com.tangosol.util.comparator.EntryComparator;
import com.tangosol.util.comparator.SafeComparator;
import com.tangosol.util.filter.InKeySetFilter;
import com.tangosol.util.filter.KeyAssociatedFilter;
import com.tangosol.util.filter.LimitFilter;
import com.tangosol.util.filter.PartitionedFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PartitionedCache$ViewMap
extends Util
implements ClassLoaderAware,
NamedCache {
    private boolean __m_Active;
    private PartitionedCache$BinaryMap __m_BinaryMap;
    private String __m_CacheName;
    private ClassLoader __m_ClassLoader;
    private transient ConverterCollections.ConverterNamedCache __m_ConverterMap;
    private transient Converter __m_FromBinaryConverter;
    private transient Converter __m_KeyToBinaryConverter;
    private boolean __m_PassThrough;
    private transient Converter __m_ValueToBinaryConverter;
    private static ListMap __mapChildren;
    private static transient long __s_LicenseMsgTimestamp;

    static {
        PartitionedCache$ViewMap.__initStatic();
    }

    public PartitionedCache$ViewMap() {
        this(null, null, true);
    }

    public PartitionedCache$ViewMap(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setActive(true);
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("ProxyListener", PartitionedCache$ViewMap$ProxyListener.get_CLASS());
    }

    public void addIndex(ValueExtractor extractor, boolean fOrdered, Comparator comparator) {
        this.ensureBinaryMap().addIndex(extractor, fOrdered, comparator);
    }

    public void addMapListener(MapListener listener) {
        this.addMapListener(listener, null, false);
    }

    public void addMapListener(MapListener listener, Filter filter, boolean fLite) {
        this.ensureBinaryMap().addMapListener(this.instantiateProxyListener(listener), filter, fLite);
    }

    public void addMapListener(MapListener listener, Object oKey, boolean fLite) {
        this.ensureBinaryMap().addMapListener(this.instantiateProxyListener(listener), this.getKeyToBinaryConverter().convert(oKey), fLite);
    }

    public Object aggregate(Filter filter, InvocableMap.EntryAggregator agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        PartitionSet partitions = null;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            partitions = this.makePartitionSet(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        } else if (filter instanceof PartitionedFilter) {
            PartitionedFilter filterPart = (PartitionedFilter)filter;
            partitions = new PartitionSet(filterPart.getPartitionSet());
            filter = filterPart.getFilter();
        }
        if (filter instanceof LimitFilter) {
            throw new UnsupportedOperationException("LimitFilter cannot be used with aggregate");
        }
        this.prepareParallelQuery(filter);
        if (agent instanceof InvocableMap.ParallelAwareAggregator) {
            InvocableMap.ParallelAwareAggregator aggregator = (InvocableMap.ParallelAwareAggregator)agent;
            PartitionedCache$BinaryMap mapBinary = this.ensureBinaryMap();
            try {
                List listBinParts;
                List list = listBinParts = partitions == null ? (List)mapBinary.aggregate(filter, aggregator.getParallelAggregator()) : (List)mapBinary.aggregate(filter, aggregator.getParallelAggregator(), partitions);
                if (this.isPassThrough()) {
                    PartitionedCache$BackingMapContext context = this.getService().getBackingMapContext();
                    Converter convValDown = context.getValueToInternalConverter();
                    Converter convValUp = context.getValueFromInternalConverter();
                    return convValDown.convert(aggregator.aggregateResults(ConverterCollections.getCollection(listBinParts, convValUp, convValDown)));
                }
                return aggregator.aggregateResults(ConverterCollections.getCollection(listBinParts, this.getFromBinaryConverter(), this.getValueToBinaryConverter()));
            }
            catch (LicenseException e) {
                PartitionedCache$ViewMap.reportMissingLicense("Aggregation", e);
                return agent.aggregate(InvocableMapHelper.makeEntrySet(this.localEntrySet(filter)));
            }
            catch (RequestTimeoutException e) {
                throw this.processAggregateTimeout(e, aggregator);
            }
        }
        return agent.aggregate(InvocableMapHelper.makeEntrySet(this.entrySet(filter)));
    }

    public Object aggregate(Collection colKeys, InvocableMap.EntryAggregator agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        if (agent instanceof InvocableMap.ParallelAwareAggregator) {
            InvocableMap.ParallelAwareAggregator aggregator = (InvocableMap.ParallelAwareAggregator)agent;
            Converter convKeyDown = this.getKeyToBinaryConverter();
            Converter convValDown = this.getValueToBinaryConverter();
            Converter convUp = this.getFromBinaryConverter();
            try {
                ConverterCollections.ConverterCollection colBinKeys = colKeys instanceof Set ? ConverterCollections.getSet((Set)colKeys, convKeyDown, convUp) : ConverterCollections.getCollection(colKeys, convKeyDown, convUp);
                List listBinParts = (List)this.ensureBinaryMap().aggregate(colBinKeys, aggregator.getParallelAggregator());
                if (this.isPassThrough()) {
                    PartitionedCache$BackingMapContext context = this.getService().getBackingMapContext();
                    convValDown = context.getValueToInternalConverter();
                    convUp = context.getValueFromInternalConverter();
                    return convValDown.convert(aggregator.aggregateResults(ConverterCollections.getCollection(listBinParts, convUp, convValDown)));
                }
                return aggregator.aggregateResults(ConverterCollections.getCollection(listBinParts, convUp, convValDown));
            }
            catch (LicenseException e) {
                PartitionedCache$ViewMap.reportMissingLicense("Aggregation", e);
            }
            catch (RequestTimeoutException e) {
                throw this.processAggregateTimeout(e, aggregator);
            }
        }
        return agent.aggregate(InvocableMapHelper.makeEntrySet(this.getAll(colKeys), colKeys, true));
    }

    public void clear() {
        this.ensureBinaryMap().clear();
    }

    public boolean containsKey(Object oKey) {
        return this.ensureConverterMap().containsKey(oKey);
    }

    public boolean containsValue(Object oValue) {
        return this.ensureConverterMap().containsValue(oValue);
    }

    public void destroy() {
        this.getCacheService().destroyCache(this);
    }

    protected PartitionedCache$BinaryMap ensureBinaryMap() {
        PartitionedCache$BinaryMap map = this.getBinaryMap();
        if (map == null) {
            this.onInvalidAccess();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ConverterCollections.ConverterNamedCache ensureConverterMap() {
        ConverterCollections.ConverterNamedCache map = this.getConverterMap();
        if (map == null) {
            PartitionedCache$ViewMap partitionedCache$ViewMap = this;
            synchronized (partitionedCache$ViewMap) {
                map = this.getConverterMap();
                if (map == null) {
                    map = ConverterCollections.getNamedCache(this.ensureBinaryMap(), this.getFromBinaryConverter(), this.getKeyToBinaryConverter(), this.getFromBinaryConverter(), this.getValueToBinaryConverter());
                    this.setConverterMap(map);
                }
            }
        }
        return map;
    }

    public Set entrySet() {
        return this.ensureConverterMap().entrySet();
    }

    public Set entrySet(Filter filter) {
        if (filter == null) {
            return this.entrySet();
        }
        PartitionSet partitions = null;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            partitions = this.makePartitionSet(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        } else if (filter instanceof PartitionedFilter) {
            PartitionedFilter filterPart = (PartitionedFilter)filter;
            partitions = new PartitionSet(filterPart.getPartitionSet());
            filter = filterPart.getFilter();
        }
        if (filter instanceof LimitFilter) {
            LimitFilter filterLimit = (LimitFilter)filter;
            filterLimit.setComparator(null);
            filterLimit.setTopAnchor(null);
            filterLimit.setBottomAnchor(null);
        }
        this.prepareParallelQuery(filter);
        try {
            if (partitions == null) {
                return this.ensureConverterMap().entrySet(filter);
            }
            Converter convUp = this.getFromBinaryConverter();
            return ConverterCollections.getEntrySet(this.ensureBinaryMap().entrySet(filter, partitions), convUp, this.getKeyToBinaryConverter(), convUp, this.getValueToBinaryConverter());
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Query", e);
            return this.localEntrySet(filter);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, PartitionedCache$BinaryMap.RESPONSE_SET);
        }
    }

    public Set entrySet(Filter filter, Comparator comparator) {
        Set setEntries;
        PartitionSet partitions = null;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            partitions = this.makePartitionSet(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        } else if (filter instanceof PartitionedFilter) {
            PartitionedFilter filterPart = (PartitionedFilter)filter;
            partitions = new PartitionSet(filterPart.getPartitionSet());
            filter = filterPart.getFilter();
        }
        LimitFilter filterLimit = null;
        int cPageSize = 0;
        int cSkip = 0;
        if (filter instanceof LimitFilter) {
            filterLimit = (LimitFilter)filter;
            if (comparator == null) {
                comparator = SafeComparator.INSTANCE;
            }
            filterLimit.setComparator(comparator);
            cPageSize = filterLimit.getPageSize();
            int nPage = filterLimit.getPage();
            if (nPage == 0) {
                filterLimit.setTopAnchor(null);
                filterLimit.setBottomAnchor(null);
            } else {
                Object oAnchorTop = filterLimit.getTopAnchor();
                Object oAnchorBottom = filterLimit.getBottomAnchor();
                if (!(oAnchorTop == null) ? false : oAnchorBottom == null) {
                    cSkip = cPageSize * nPage;
                    LimitFilter filterTemp = (LimitFilter)filterLimit.clone();
                    filterTemp.setPage(0);
                    filterTemp.setPageSize(cSkip + cPageSize);
                    filter = filterTemp;
                }
            }
        }
        this.prepareParallelQuery(filter);
        try {
            if (partitions == null) {
                setEntries = this.ensureConverterMap().entrySet(filter, comparator);
            } else {
                Converter convUp = this.getFromBinaryConverter();
                setEntries = ConverterCollections.getEntrySet(this.ensureBinaryMap().entrySet(filter, comparator, partitions), convUp, this.getKeyToBinaryConverter(), convUp, this.getValueToBinaryConverter());
            }
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Query", e);
            return this.localEntrySet(filter, comparator);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, PartitionedCache$BinaryMap.RESPONSE_VOID);
        }
        Object[] aEntry = setEntries.toArray();
        comparator = new EntryComparator(comparator);
        Arrays.sort(aEntry, comparator);
        if (filterLimit != null) {
            int cEntries;
            if (cSkip > 0) {
                cEntries = Math.min(Math.max(0, aEntry.length - cSkip), cPageSize);
                if (cEntries > 0) {
                    Object[] ao = new Object[cEntries];
                    System.arraycopy(aEntry, cSkip, ao, 0, cEntries);
                    aEntry = ao;
                } else {
                    aEntry = new Object[]{};
                }
            } else {
                filterLimit.setComparator(comparator);
                aEntry = filterLimit.extractPage(aEntry);
                cEntries = aEntry.length;
            }
            if (cEntries > 0) {
                filterLimit.setTopAnchor(((Map.Entry)aEntry[0]).getValue());
                filterLimit.setBottomAnchor(((Map.Entry)aEntry[cEntries - 1]).getValue());
            }
        }
        return new ImmutableArrayList(aEntry);
    }

    public Object get(Object oKey) {
        return this.ensureConverterMap().get(oKey);
    }

    public Map getAll(Collection colKeys) {
        try {
            return this.ensureConverterMap().getAll(colKeys);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, PartitionedCache$BinaryMap.RESPONSE_MAP);
        }
    }

    public PartitionedCache$BinaryMap getBinaryMap() {
        return this.__m_BinaryMap;
    }

    public String getCacheName() {
        return this.__m_CacheName;
    }

    public CacheService getCacheService() {
        return (PartitionedCache)this.get_Module();
    }

    public ClassLoader getClassLoader() {
        return this.__m_ClassLoader;
    }

    public ClassLoader getContextClassLoader() {
        return this.getClassLoader();
    }

    protected ConverterCollections.ConverterNamedCache getConverterMap() {
        return this.__m_ConverterMap;
    }

    public Converter getFromBinaryConverter() {
        return this.__m_FromBinaryConverter;
    }

    public Converter getKeyToBinaryConverter() {
        return this.__m_KeyToBinaryConverter;
    }

    public static long getLicenseMsgTimestamp() {
        return __s_LicenseMsgTimestamp;
    }

    public PartitionedCache getService() {
        return (PartitionedCache)this.get_Module();
    }

    public Converter getValueToBinaryConverter() {
        return this.__m_ValueToBinaryConverter;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/grid/partitionedService/PartitionedCache$ViewMap".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new PartitionedCache$ViewMap();
    }

    private final Component get_Module() {
        return this.get_Parent();
    }

    protected MapListener instantiateProxyListener(MapListener listener) {
        if (listener instanceof MapTriggerListener) {
            return listener;
        }
        PartitionedCache$ViewMap$ProxyListener listenerProxy = (PartitionedCache$ViewMap$ProxyListener)this._newChild("ProxyListener");
        listenerProxy.setListener(listener);
        return listener instanceof MapListenerSupport.SynchronousListener ? new MapListenerSupport.WrapperSynchronousListener(listenerProxy) : (MapListener)listenerProxy;
    }

    public synchronized void invalidate() {
        if (this.isActive()) {
            this.setActive(false);
            this.setBinaryMap(null);
            this.setConverterMap(null);
            this.setClassLoader(null);
            this.setFromBinaryConverter(null);
            this.setKeyToBinaryConverter(null);
            this.setValueToBinaryConverter(null);
        }
    }

    public Object invoke(Object oKey, InvocableMap.EntryProcessor agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        try {
            return this.ensureConverterMap().invoke(oKey, agent);
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Invocation", e);
            return InvocableMapHelper.invokeLocked(this, InvocableMapHelper.makeEntry(this, oKey), agent);
        }
    }

    public Map invokeAll(Filter filter, InvocableMap.EntryProcessor agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        PartitionSet partitions = null;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            partitions = this.makePartitionSet(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        } else if (filter instanceof PartitionedFilter) {
            PartitionedFilter filterPart = (PartitionedFilter)filter;
            partitions = new PartitionSet(filterPart.getPartitionSet());
            filter = filterPart.getFilter();
        }
        if (filter instanceof LimitFilter) {
            throw new UnsupportedOperationException("LimitFilter cannot be used with invokeAll");
        }
        this.prepareParallelQuery(filter);
        try {
            if (partitions == null) {
                return this.ensureConverterMap().invokeAll(filter, agent);
            }
            Converter convUp = this.getFromBinaryConverter();
            return ConverterCollections.getMap(this.ensureBinaryMap().invokeAll(filter, agent, partitions), convUp, this.getKeyToBinaryConverter(), convUp, NullImplementation.getConverter());
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Invocation", e);
            return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.makeEntrySet(this, this.localKeySet(filter), false), agent);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, PartitionedCache$BinaryMap.RESPONSE_MAP);
        }
    }

    public Map invokeAll(Collection colKeys, InvocableMap.EntryProcessor agent) {
        if (agent == null) {
            throw new IllegalArgumentException("Processor must be specified");
        }
        try {
            return this.ensureConverterMap().invokeAll(colKeys, agent);
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Invocation", e);
            return InvocableMapHelper.invokeAllLocked(this, InvocableMapHelper.makeEntrySet(this, colKeys, false), agent);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, PartitionedCache$BinaryMap.RESPONSE_MAP);
        }
    }

    public boolean isActive() {
        return this.__m_Active;
    }

    public boolean isEmpty() {
        return this.ensureConverterMap().isEmpty();
    }

    public boolean isPassThrough() {
        return this.__m_PassThrough;
    }

    public Set keySet() {
        return this.ensureConverterMap().keySet();
    }

    public Set keySet(Filter filter) {
        if (filter == null) {
            return this.keySet();
        }
        PartitionSet partitions = null;
        if (filter instanceof KeyAssociatedFilter) {
            KeyAssociatedFilter filterAssoc = (KeyAssociatedFilter)filter;
            partitions = this.makePartitionSet(filterAssoc.getHostKey());
            filter = filterAssoc.getFilter();
        }
        if (filter instanceof LimitFilter) {
            LimitFilter filterLimit = (LimitFilter)filter;
            filterLimit.setComparator(null);
            filterLimit.setTopAnchor(null);
            filterLimit.setBottomAnchor(null);
        } else if (filter instanceof PartitionedFilter) {
            PartitionedFilter filterPart = (PartitionedFilter)filter;
            partitions = new PartitionSet(filterPart.getPartitionSet());
            filter = filterPart.getFilter();
        }
        this.prepareParallelQuery(filter);
        try {
            return partitions == null ? this.ensureConverterMap().keySet(filter) : ConverterCollections.getSet(this.ensureBinaryMap().keySet(filter, partitions), this.getFromBinaryConverter(), this.getKeyToBinaryConverter());
        }
        catch (LicenseException e) {
            PartitionedCache$ViewMap.reportMissingLicense("Query", e);
            return this.localKeySet(filter);
        }
        catch (RequestTimeoutException e) {
            throw this.processRequestTimeout(e, PartitionedCache$BinaryMap.RESPONSE_SET);
        }
    }

    protected Set localEntrySet(Filter filter) {
        return InvocableMapHelper.query(this, filter, true, false, null);
    }

    protected Set localEntrySet(Filter filter, Comparator comparator) {
        return InvocableMapHelper.query(this, filter, true, true, comparator);
    }

    protected Set localKeySet(Filter filter) {
        return InvocableMapHelper.query(this, filter, false, false, null);
    }

    public boolean lock(Object oKey) {
        return this.ensureConverterMap().lock(oKey);
    }

    public boolean lock(Object oKey, long lMillis) {
        return this.ensureConverterMap().lock(oKey, lMillis);
    }

    protected PartitionSet makePartitionSet(Object oKey) {
        return this.getService().getKeyPartitioningStrategy().getAssociatedPartitions(oKey);
    }

    protected void onInvalidAccess() {
        throw new IllegalStateException(String.valueOf("The distributed cache reference \"") + this.getCacheName() + "\" has been invalidated; no further operations are allowed.");
    }

    protected void prepareParallelQuery(Filter filter) {
        Filter filterTest;
        Filter filter2 = filterTest = filter instanceof LimitFilter ? ((LimitFilter)filter).getFilter() : filter;
        if (filterTest instanceof InKeySetFilter) {
            ((InKeySetFilter)filterTest).ensureConverted(this.getService().getBackingMapContext().getKeyToInternalConverter());
        }
    }

    protected RequestTimeoutException processAggregateTimeout(RequestTimeoutException eTimeout, InvocableMap.ParallelAwareAggregator aggregator) {
        Object oResult = eTimeout.getPartialResult();
        if (oResult != null) {
            try {
                oResult = aggregator.aggregateResults(ConverterCollections.getCollection((List)oResult, this.getFromBinaryConverter(), NullImplementation.getConverter()));
            }
            catch (Throwable e) {
                oResult = null;
            }
        }
        eTimeout.setPartialResult(oResult);
        return eTimeout;
    }

    protected RequestTimeoutException processRequestTimeout(RequestTimeoutException eTimeout, int nResponseType) {
        Object oResult = eTimeout.getPartialResult();
        if (oResult != null) {
            try {
                Converter convKeyDown = this.getKeyToBinaryConverter();
                Converter convUp = this.getFromBinaryConverter();
                Converter convNotUsed = NullImplementation.getConverter();
                switch (nResponseType) {
                    case 2: {
                        oResult = ConverterCollections.getSet((Set)oResult, convUp, convNotUsed);
                        break;
                    }
                    case 3: {
                        oResult = ConverterCollections.getMap((Map)oResult, convUp, convKeyDown, convUp, convNotUsed);
                        break;
                    }
                    default: {
                        oResult = null;
                        break;
                    }
                }
            }
            catch (Throwable e) {
                oResult = null;
            }
        }
        eTimeout.setPartialResult(oResult);
        return eTimeout;
    }

    public Object put(Object oKey, Object oValue) {
        return this.ensureConverterMap().put(oKey, oValue);
    }

    public Object put(Object oKey, Object oValue, long cMillis) {
        return this.ensureConverterMap().put(oKey, oValue, cMillis);
    }

    public void putAll(Map map) {
        this.ensureConverterMap().putAll(map);
    }

    public void release() {
        this.getCacheService().releaseCache(this);
    }

    public Object remove(Object oKey) {
        return this.ensureConverterMap().remove(oKey);
    }

    public void removeIndex(ValueExtractor extractor) {
        this.ensureBinaryMap().removeIndex(extractor);
    }

    public void removeMapListener(MapListener listener) {
        this.removeMapListener(listener, null);
    }

    public void removeMapListener(MapListener listener, Filter filter) {
        this.ensureBinaryMap().removeMapListener(this.instantiateProxyListener(listener), filter);
    }

    public void removeMapListener(MapListener listener, Object oKey) {
        this.ensureBinaryMap().removeMapListener(this.instantiateProxyListener(listener), this.getKeyToBinaryConverter().convert(oKey));
    }

    public String reportKey(Object oKey) {
        PartitionedCache service = this.getService();
        return service.reportPartitionOwnership(service.getKeyPartitioningStrategy().getKeyPartition(oKey));
    }

    public String reportKeyDistribution(boolean fVerbose) {
        PartitionedCache service = this.getService();
        KeyPartitioningStrategy strategy = service.getKeyPartitioningStrategy();
        int cPartitions = service.getPartitionCount();
        int[] ac = new int[cPartitions];
        Iterator iter = this.keySet().iterator();
        while (iter.hasNext()) {
            int n = strategy.getKeyPartition(iter.next());
            ac[n] = ac[n] + 1;
        }
        StringBuffer sb = new StringBuffer("\n");
        double dAverage = (double)this.size() / (double)cPartitions;
        double dStdDev = 0.0;
        int cMax = 0;
        int cMin = Integer.MAX_VALUE;
        int iPartition = 0;
        while (iPartition < cPartitions) {
            int c = ac[iPartition];
            cMax = Math.max(cMax, c);
            cMin = Math.min(cMin, c);
            if (!fVerbose ? false : c > 0) {
                sb.append('\n').append(iPartition).append(": ").append(c);
            }
            double dDiff = dAverage - (double)c;
            dStdDev += dDiff * dDiff;
            ++iPartition;
        }
        return String.valueOf("max=") + cMax + "; min=" + cMin + "; average=" + (float)dAverage + "; std dev=" + Math.sqrt((float)(dStdDev / (double)cPartitions)) + sb;
    }

    private static void reportMissingLicense(String sFeature, LicenseException e) {
        long ldtMsg = PartitionedCache$ViewMap.getLicenseMsgTimestamp();
        if (ldtMsg == 0L) {
            PartitionedCache$ViewMap.setLicenseMsgTimestamp(Base.getSafeTimeMillis());
            String sMsg = String.valueOf("Parallel ") + sFeature + " is a feature of Coherence Enterprise Edition and Coherence Grid Edition," + " and is not available in this Coherence Edition; selecting the default single-threaded Local " + sFeature + " implementation instead. The single-threaded Local " + sFeature + " implementation uses significantly more resources (CPU, memory and network) than the Parallel " + sFeature + " implementation" + (sFeature.equals("Query") ? ", and should not be used for large queries" : "") + ".";
            Component._trace(sMsg, 2);
        }
    }

    public String reportStorage(boolean fPrimary) {
        PartitionedCache service = this.getService();
        PartitionedCache$BinaryMap mapBinary = (PartitionedCache$BinaryMap)service.getReferencesBinaryMap().get(this.getCacheName());
        long lCacheId = mapBinary.getCacheId();
        PartitionedCache$Storage storage = service.getStorage(lCacheId);
        Map map = fPrimary ? storage.getBackingMap() : storage.getBackupMap();
        StringBuffer sb = new StringBuffer();
        sb.append("CacheId=").append(lCacheId).append(", Size=").append(map.size());
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Binary binKey = (Binary)entry.getKey();
            Binary binValue = (Binary)entry.getValue();
            sb.append('\n').append(this.getFromBinaryConverter().convert(binKey)).append(" = ").append(this.getFromBinaryConverter().convert(binValue));
            if (!(fPrimary ? service.isPrimaryOwner(binKey) ^ true : service.isBackupOwner(binKey) ^ true)) continue;
            int iPartition = service.getKeyPartition(binKey);
            int[] aiOwner = service.getPartitionAssignments()[iPartition];
            int nOwner = fPrimary ? aiOwner[0] : aiOwner[1];
            sb.append(" ! owner=").append(nOwner);
        }
        return sb.toString();
    }

    protected void setActive(boolean fActive) {
        this.__m_Active = fActive;
    }

    public void setBinaryMap(PartitionedCache$BinaryMap map) {
        if (this.isActive()) {
            Component._assert(!(this.getBinaryMap() == null) ? false : map != null);
            this.setCacheName(map.getCacheName());
        } else {
            Component._assert(map == null);
        }
        this.__m_BinaryMap = map;
    }

    protected void setCacheName(String sName) {
        this.__m_CacheName = sName;
    }

    public void setClassLoader(ClassLoader loader) {
        if (this.isActive()) {
            Component._assert(!(this.getClassLoader() == null) ? false : loader != null);
            PartitionedCache service = this.getService();
            if (loader == NullImplementation.getClassLoader()) {
                this.setKeyToBinaryConverter(service.instantiateKeyToBinaryConverter(true));
                this.setValueToBinaryConverter(NullImplementation.getConverter());
                this.setFromBinaryConverter(ExternalizableHelper.CONVERTER_STRIP_INTDECO);
                this.setPassThrough(true);
            } else {
                this.setKeyToBinaryConverter(service.getBackingMapContext().getKeyToBinaryConverter());
                this.setValueToBinaryConverter(service.instantiateValueToBinaryConverter(loader));
                this.setFromBinaryConverter(service.instantiateFromBinaryConverter(loader));
            }
        } else {
            Component._assert(loader == null);
        }
        this.__m_ClassLoader = loader;
    }

    public void setContextClassLoader(ClassLoader loader) {
        throw new UnsupportedOperationException();
    }

    protected void setConverterMap(ConverterCollections.ConverterNamedCache map) {
        if (this.isActive()) {
            Component._assert(!(this.getConverterMap() == null) ? false : map != null);
        } else {
            Component._assert(map == null);
        }
        this.__m_ConverterMap = map;
    }

    protected void setFromBinaryConverter(Converter conv) {
        this.__m_FromBinaryConverter = conv;
    }

    protected void setKeyToBinaryConverter(Converter conv) {
        this.__m_KeyToBinaryConverter = conv;
    }

    private static void setLicenseMsgTimestamp(long ldt) {
        __s_LicenseMsgTimestamp = ldt;
    }

    protected void setPassThrough(boolean fPass) {
        this.__m_PassThrough = fPass;
    }

    protected void setValueToBinaryConverter(Converter conv) {
        this.__m_ValueToBinaryConverter = conv;
    }

    public int size() {
        return this.ensureConverterMap().size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append("{Name=").append(this.getCacheName()).append(", ClassLoader=").append(this.getClassLoader()).append(", ServiceName=").append(this.getService().getServiceName()).append('}');
        return sb.toString();
    }

    public boolean unlock(Object oKey) {
        return this.ensureConverterMap().unlock(oKey);
    }

    public Collection values() {
        return this.ensureConverterMap().values();
    }
}

