/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Acceptor$MessageFactory;
import com.tangosol.license.CoherenceCachingEdition;
import com.tangosol.net.Guardable;
import com.tangosol.net.Guardian;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.messaging.ConnectionAcceptor;
import com.tangosol.net.messaging.ConnectionFilter;
import com.tangosol.net.messaging.Protocol;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ListMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class Acceptor
extends Peer
implements ConnectionAcceptor {
    private volatile boolean __m_AcceptingConnections;
    private ConnectionFilter __m_ConnectionFilter;
    private int __m_ConnectionLimit;
    private Set __m_ConnectionPendingSet;
    private Set __m_ConnectionSet;
    private static ListMap __mapChildren;

    static {
        Acceptor._initStatic();
    }

    public Acceptor(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("MessageFactory", Acceptor$MessageFactory.get_CLASS());
        Class clazz3 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    private static void _initStatic$Default() {
        Acceptor.__initStatic();
    }

    protected static void _initStatic() {
        Acceptor._initStatic$Default();
        try {
            new CoherenceCachingEdition();
        }
        catch (RuntimeException e) {
            Peer.setLicenseError(e.getMessage());
        }
    }

    protected void checkPingTimeouts() {
        Iterator iter = this.getConnectionSet().iterator();
        while (iter.hasNext()) {
            Connection connection = (Connection)iter.next();
            this.checkPingTimeout(connection);
        }
    }

    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
        if (xml == null) {
            return;
        }
        this.setConnectionLimit(xml.getSafeElement("connection-limit").getInt(this.getConnectionLimit()));
    }

    public static ConnectionAcceptor createAcceptor(XmlElement xml, OperationalContext ctx) {
        ConnectionAcceptor acceptor;
        if (xml.getElement("http-acceptor") != null) {
            acceptor = (ConnectionAcceptor)((Object)Component._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Acceptor.HttpAcceptor"));
        } else if (xml.getElement("jms-acceptor") != null) {
            acceptor = (ConnectionAcceptor)((Object)Component._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Acceptor.JmsAcceptor"));
        } else if (xml.getElement("tcp-acceptor") != null) {
            acceptor = (ConnectionAcceptor)((Object)Component._newInstance("Component.Util.Daemon.QueueProcessor.Service.Peer.Acceptor.TcpAcceptor"));
        } else {
            throw new IllegalArgumentException(String.valueOf("unsupported \"acceptor-config\":\n") + xml);
        }
        acceptor.setOperationalContext(ctx);
        acceptor.configure(xml);
        return acceptor;
    }

    public static XmlElement findAcceptorConfig(XmlElement xml) {
        XmlElement xmlConfig = xml.getName().equals("acceptor-config") ? xml : xml.getSafeElement("acceptor-config");
        if ((xmlConfig.getElement("http-acceptor") != null ? true : xmlConfig.getElement("jms-acceptor") != null) ? true : xmlConfig.getElement("tcp-acceptor") != null) {
            return (XmlElement)xmlConfig.clone();
        }
        throw new IllegalArgumentException(String.valueOf("the \"acceptor-config\" element is either") + " missing, empty, or does not contain a valid transport-specific" + " child element:\n" + xml);
    }

    public String formatStats() {
        return String.valueOf("Connections=") + this.getConnectionSet().size() + ", " + super.formatStats();
    }

    public ConnectionFilter getConnectionFilter() {
        return this.__m_ConnectionFilter;
    }

    public int getConnectionLimit() {
        return this.__m_ConnectionLimit;
    }

    public Set getConnectionPendingSet() {
        return this.__m_ConnectionPendingSet;
    }

    public Set getConnectionSet() {
        return this.__m_ConnectionSet;
    }

    public Collection getConnections() {
        return Collections.unmodifiableSet(this.getConnectionSet());
    }

    public String getDescription() {
        int cLimit = this.getConnectionLimit();
        if (cLimit > 0) {
            return String.valueOf(super.getDescription()) + ", ConnectionLimit=" + cLimit;
        }
        return super.getDescription();
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/Acceptor".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public Guardian.GuardContext guard(Guardable guardable) {
        Guardian guardian = (Guardian)((Object)this.getParentService());
        return guardian != null ? guardian.guard(guardable) : super.guard(guardable);
    }

    public Guardian.GuardContext guard(Guardable guardable, long cMillis, float flPctRecover) {
        Guardian guardian = (Guardian)((Object)this.getParentService());
        return guardian != null ? guardian.guard(guardable, cMillis, flPctRecover) : super.guard(guardable, cMillis, flPctRecover);
    }

    public boolean isAcceptingConnections() {
        int cLimit = this.getConnectionLimit();
        if (!(cLimit > 0) ? false : this.getConnectionSet().size() >= cLimit) {
            return false;
        }
        return this.__m_AcceptingConnections;
    }

    public void negotiateProtocols(Connection connection, Map mapRequired) {
        Integer IVersion;
        String sProtocol;
        Map.Entry entry;
        Component._assert(connection != null);
        Component._assert(mapRequired != null);
        HashMap<String, Protocol.MessageFactory> mapFactory = connection.getMessageFactoryMap();
        Component._assert(mapFactory != null);
        Iterator iter = mapRequired.entrySet().iterator();
        while (iter.hasNext()) {
            entry = (Map.Entry)iter.next();
            sProtocol = (String)entry.getKey();
            IVersion = (Integer)entry.getValue();
            Protocol.MessageFactory factory = (Protocol.MessageFactory)mapFactory.get(sProtocol);
            if (!(factory == null ? true : factory.getVersion() != IVersion.intValue())) continue;
            mapFactory = null;
            break;
        }
        if (mapFactory == null) {
            mapFactory = new HashMap<String, Protocol.MessageFactory>();
            iter = mapRequired.entrySet().iterator();
            while (iter.hasNext()) {
                entry = (Map.Entry)iter.next();
                sProtocol = (String)entry.getKey();
                IVersion = (Integer)entry.getValue();
                Protocol protocol = this.getProtocol(sProtocol);
                if (protocol == null) {
                    throw new RuntimeException(String.valueOf("unsupported protocol: ") + sProtocol);
                }
                mapFactory.put(sProtocol, protocol.getMessageFactory(IVersion));
            }
            connection.setMessageFactoryMap(mapFactory);
        }
    }

    public void onConnectionClosed(Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (!(this.getConnectionPendingSet().remove(connection) ^ true) ? false : this.getConnectionSet().remove(connection)) {
            super.onConnectionClosed(connection);
        }
    }

    public void onConnectionError(Connection connection, Throwable e) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (!(this.getConnectionPendingSet().remove(connection) ^ true) ? false : this.getConnectionSet().remove(connection)) {
            super.onConnectionError(connection, e);
        }
    }

    public void onConnectionOpened(Connection connection) {
        if (this.get_Connection() == connection) {
            return;
        }
        if (!this.getConnectionPendingSet().remove(connection) ? false : this.getConnectionSet().add(connection)) {
            super.onConnectionOpened(connection);
        }
    }

    public void onServiceStarted() {
        super.onServiceStarted();
        this.setAcceptingConnections(true);
    }

    protected void onServiceStopped() {
        Connection connection;
        this.setAcceptingConnections(false);
        Iterator<Object> iter = this.getConnectionPendingSet().iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            iter.remove();
            connection.closeInternal(true, null, 0L);
        }
        iter = new HashSet(this.getConnectionSet()).iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            connection.closeInternal(true, null, 0L);
        }
        iter = this.getConnectionSet().iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            iter.remove();
            connection.closeInternal(true, null, 100L);
            if (!connection.isOpen()) continue;
            this.getDaemonPool().stop();
            connection.closeInternal(true, null, 1000L);
            if (!connection.isOpen()) continue;
            Component._trace(String.valueOf("Unable to close \"") + connection + "\"; this Connection will be abandoned", 1);
        }
        super.onServiceStopped();
    }

    protected void onServiceStopping() {
        Connection connection;
        this.setAcceptingConnections(false);
        Iterator iter = this.getConnectionPendingSet().iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            iter.remove();
            connection.closeInternal(true, null, 0L);
        }
        iter = this.getConnectionSet().iterator();
        while (iter.hasNext()) {
            connection = (Connection)iter.next();
            iter.remove();
            connection.closeInternal(true, null, 0L);
        }
        super.onServiceStopping();
    }

    protected void ping() {
        Iterator iter = this.getConnectionSet().iterator();
        while (iter.hasNext()) {
            Connection connection = (Connection)iter.next();
            connection.ping();
        }
    }

    protected void setAcceptingConnections(boolean fAccepting) {
        this.__m_AcceptingConnections = fAccepting;
    }

    public void setConnectionFilter(ConnectionFilter filter) {
        this.__m_ConnectionFilter = filter;
    }

    protected void setConnectionLimit(int cLimit) {
        this.__m_ConnectionLimit = cLimit;
    }

    protected void setConnectionPendingSet(Set set) {
        this.__m_ConnectionPendingSet = set;
    }

    protected void setConnectionSet(Set set) {
        this.__m_ConnectionSet = set;
    }
}

