/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.util.JmsUtil;
import com.tangosol.coherence.component.net.extend.util.JndiUtil;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$Protocol;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator$MessageFactory;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.JmsInitiator$JmsConnection;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.jms.DeliveryMode;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.NamingException;

public class JmsInitiator
extends Initiator
implements ExceptionListener {
    private int __m_MessageDeliveryMode;
    private long __m_MessageExpiration;
    private int __m_MessagePriority;
    private QueueConnection __m_QueueConnection;
    private String __m_QueueConnectionFactoryName;
    private Queue __m_QueueDiscovery;
    private String __m_QueueName;
    private QueueSender __m_QueueSender;
    private QueueSession __m_QueueSession;
    private static ListMap __mapChildren;
    private static /* synthetic */ Class __sf0;
    private static /* synthetic */ Class __sf1;

    static {
        JmsInitiator.__initStatic();
    }

    public JmsInitiator() {
        this(null, null, true);
    }

    public JmsInitiator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Peer$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Peer$Protocol("Protocol", this, true), "Protocol");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("JmsConnection", JmsInitiator$JmsConnection.get_CLASS());
        Class clazz3 = __mapChildren.put("MessageFactory", Initiator$MessageFactory.get_CLASS());
        Class clazz4 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
    }

    private static /* synthetic */ Class __sm0() {
        Class<?> clazz = __sf0;
        if (clazz == null) {
            try {
                clazz = __sf0 = Class.forName("javax.jms.Queue");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    private static /* synthetic */ Class __sm1() {
        Class<?> clazz = __sf1;
        if (clazz == null) {
            try {
                clazz = __sf1 = Class.forName("javax.jms.QueueConnectionFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
        if (xml == null) {
            return;
        }
        XmlElement xmlCat = xml.getSafeElement("jms-initiator");
        this.setQueueConnectionFactoryName(Service.ensureStringValue(xmlCat, "queue-connection-factory-name", this.getQueueConnectionFactoryName()));
        this.setQueueName(Service.ensureStringValue(xmlCat, "queue-name", this.getQueueName()));
        XmlElement xmlVal = xmlCat.getSafeElement("message-delivery-mode");
        if (xmlVal.getString("NON_PERSISTENT").equalsIgnoreCase("PERSISTENT")) {
            this.setMessageDeliveryMode(DeliveryMode.PERSISTENT);
        } else {
            this.setMessageDeliveryMode(DeliveryMode.NON_PERSISTENT);
        }
        this.setMessageExpiration(Service.parseTime(xmlCat, "message-expiration", Message.DEFAULT_TIME_TO_LIVE));
        this.setMessagePriority(xmlCat.getSafeElement("message-priority").getInt(Message.DEFAULT_PRIORITY));
        this.setConnectTimeout(Service.parseTime(xmlCat, "connect-timeout", this.getConnectTimeout()));
    }

    public String getDescription() {
        String sMode;
        switch (this.getMessageDeliveryMode()) {
            case 2: {
                sMode = "PERSISTENT";
                break;
            }
            case 1: {
                sMode = "NON_PERSISTENT";
                break;
            }
            default: {
                sMode = "UNKNOWN";
            }
        }
        return String.valueOf(super.getDescription()) + ", QueueConnectionFactoryName=" + this.getQueueConnectionFactoryName() + ", QueueName=" + this.getQueueName() + ", MessageExpiration=" + this.getMessageExpiration() + ", MessagePriority=" + this.getMessageDeliveryMode() + ", MessageDeliveryMode=" + sMode;
    }

    public int getMessageDeliveryMode() {
        return this.__m_MessageDeliveryMode;
    }

    public long getMessageExpiration() {
        return this.__m_MessageExpiration;
    }

    public int getMessagePriority() {
        return this.__m_MessagePriority;
    }

    public QueueConnection getQueueConnection() {
        return this.__m_QueueConnection;
    }

    public String getQueueConnectionFactoryName() {
        return this.__m_QueueConnectionFactoryName;
    }

    public Queue getQueueDiscovery() {
        return this.__m_QueueDiscovery;
    }

    public String getQueueName() {
        return this.__m_QueueName;
    }

    public QueueSender getQueueSender() {
        return this.__m_QueueSender;
    }

    public QueueSession getQueueSession() {
        return this.__m_QueueSession;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/initiator/JmsInitiator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new JmsInitiator();
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection() {
        JmsInitiator$JmsConnection connection = (JmsInitiator$JmsConnection)this._newChild("JmsConnection");
        connection.setConnectionManager(this);
        return connection;
    }

    public void onException(JMSException e) {
        Component._trace(e, String.valueOf("Stopping ") + this.getServiceName() + " due to a fatal JMS exception.");
        this.stop();
    }

    protected void onServiceStarting() {
        QueueSession session;
        QueueConnection connection;
        QueueConnectionFactory factory;
        Queue queue;
        super.onServiceStarting();
        try {
            queue = (Queue)JndiUtil.lookup(this.getQueueName(), JmsInitiator.__sm0());
            this.setQueueDiscovery(queue);
        }
        catch (NamingException e) {
            throw Base.ensureRuntimeException(e, String.valueOf("error retrieving a Queue from JNDI") + " using the name \"" + this.getQueueName() + "\"");
        }
        try {
            factory = (QueueConnectionFactory)JndiUtil.lookup(this.getQueueConnectionFactoryName(), JmsInitiator.__sm1());
        }
        catch (NamingException e) {
            throw Base.ensureRuntimeException(e, String.valueOf("error retrieving a ") + " QueueConnectionFactory from JNDI using the name \"" + this.getQueueConnectionFactoryName() + "\"");
        }
        try {
            connection = factory.createQueueConnection();
            this.setQueueConnection(connection);
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error creating a QueueConnection");
        }
        try {
            session = connection.createQueueSession(false, Session.AUTO_ACKNOWLEDGE);
            this.setQueueSession(session);
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error creating a QueueSession");
        }
        try {
            this.setQueueSender(session.createSender(queue));
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error creating a QueueSender");
        }
        try {
            connection.setExceptionListener((ExceptionListener)this);
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error registering an ExceptionListener");
        }
        try {
            connection.start();
        }
        catch (JMSException e) {
            throw Base.ensureRuntimeException(e, "error starting a QueueConnection");
        }
    }

    protected void onServiceStopped() {
        super.onServiceStopped();
        JmsUtil.close((MessageProducer)this.getQueueSender());
        JmsUtil.close((Session)this.getQueueSession());
        JmsUtil.close((javax.jms.Connection)this.getQueueConnection());
    }

    protected void setMessageDeliveryMode(int nMode) {
        this.__m_MessageDeliveryMode = nMode;
    }

    protected void setMessageExpiration(long cMillis) {
        this.__m_MessageExpiration = cMillis;
    }

    protected void setMessagePriority(int nPriority) {
        this.__m_MessagePriority = nPriority;
    }

    protected void setQueueConnection(QueueConnection connection) {
        this.__m_QueueConnection = connection;
    }

    protected void setQueueConnectionFactoryName(String sName) {
        this.__m_QueueConnectionFactoryName = sName;
    }

    protected void setQueueDiscovery(Queue queue) {
        this.__m_QueueDiscovery = queue;
    }

    protected void setQueueName(String sName) {
        this.__m_QueueName = sName;
    }

    protected void setQueueSender(QueueSender sender) {
        this.__m_QueueSender = sender;
    }

    protected void setQueueSession(QueueSession session) {
        this.__m_QueueSession = session;
    }
}

