/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.extend.Connection;
import com.tangosol.coherence.component.net.extend.util.TcpUtil;
import com.tangosol.coherence.component.util.Daemon$Guard;
import com.tangosol.coherence.component.util.daemon.QueueProcessor$Queue;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service;
import com.tangosol.coherence.component.util.daemon.queueProcessor.Service$EventDispatcher;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DaemonPool;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$DispatchEvent;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.Peer$Protocol;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.Initiator;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.TcpInitiator$MessageFactory;
import com.tangosol.coherence.component.util.daemon.queueProcessor.service.peer.initiator.TcpInitiator$TcpConnection;
import com.tangosol.net.AddressProvider;
import com.tangosol.net.ConfigurableAddressProvider;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.SocketOptions;
import com.tangosol.net.SocketProvider;
import com.tangosol.net.SocketProviderFactory;
import com.tangosol.net.messaging.ConnectionException;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import com.tangosol.util.WrapperException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;

public class TcpInitiator
extends Initiator {
    private InetSocketAddress __m_LocalAddress;
    private AddressProvider __m_RemoteAddressProvider;
    private transient SocketOptions __m_SocketOptions;
    private SocketProvider __m_SocketProvider;
    private SocketProviderFactory __m_SocketProviderFactory;
    private static ListMap __mapChildren;

    static {
        TcpInitiator.__initStatic();
    }

    public TcpInitiator() {
        this(null, null, true);
    }

    public TcpInitiator(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setDaemonState(0);
            this.setDefaultGuardRecovery(0.9f);
            this.setDefaultGuardTimeout(60000L);
            this.setProtocolMap(new HashMap());
            this.setReceiverMap(new HashMap());
            this.setRequestTimeout(30000L);
            this.setSerializerMap(new WeakHashMap());
            this.setSocketOptions(new SocketOptions());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new Peer$DaemonPool("DaemonPool", this, true), "DaemonPool");
        this._addChild(new Service$EventDispatcher("EventDispatcher", this, true), "EventDispatcher");
        this._addChild(new Daemon$Guard("Guard", this, true), "Guard");
        this._addChild(new Peer$Protocol("Protocol", this, true), "Protocol");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("DispatchEvent", Peer$DispatchEvent.get_CLASS());
        Class clazz2 = __mapChildren.put("MessageFactory", TcpInitiator$MessageFactory.get_CLASS());
        Class clazz3 = __mapChildren.put("Queue", QueueProcessor$Queue.get_CLASS());
        Class clazz4 = __mapChildren.put("TcpConnection", TcpInitiator$TcpConnection.get_CLASS());
    }

    public synchronized void configure(XmlElement xml) {
        super.configure(xml);
        if (xml == null) {
            return;
        }
        XmlElement xmlCat = xml.getSafeElement("tcp-initiator");
        try {
            this.setSocketProvider(this.getSocketProviderFactory().ensureProvider(xmlCat.getSafeElement("socket-provider")));
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e, "error configuring socket provider");
        }
        XmlElement xmlSub = xmlCat.getSafeElement("local-address");
        this.setLocalAddress(TcpInitiator.parseLocalSocketAddress(xmlSub));
        this.setRemoteAddressProvider(ConfigurableAddressProvider.createAddressProvider(xmlCat.getSafeElement("remote-addresses"), this.getContextClassLoader()));
        this.setConnectTimeout(Service.parseTime(xmlCat, "connect-timeout", this.getConnectTimeout()));
        this.getSocketOptions().setConfig(xmlCat);
    }

    protected void configureSocket(Socket socket) {
        try {
            this.getSocketOptions().apply(socket);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "error configuring Socket");
        }
        InetSocketAddress addr = this.getLocalAddress();
        if (addr != null) {
            Component._trace(String.valueOf("Binding Socket to ") + TcpUtil.toString(addr), 6);
            try {
                socket.bind(addr);
            }
            catch (Exception e) {
                throw Base.ensureRuntimeException(e, String.valueOf("error binding Socket to ") + TcpUtil.toString(addr));
            }
            if (socket.isBound() ^ true) {
                throw new RuntimeException(String.valueOf("could not bind Socket to ") + TcpUtil.toString(addr));
            }
        }
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer(super.getDescription());
        sb.append(", SocketProvider=").append(this.getSocketProvider());
        InetSocketAddress addr = this.getLocalAddress();
        if (addr != null) {
            sb.append(", LocalAddress=").append(TcpUtil.toString(addr));
        }
        sb.append(", RemoteAddresses=").append(this.getRemoteAddressProvider());
        SocketOptions options = this.getSocketOptions();
        if (options != null) {
            sb.append(", ").append(options);
        }
        return sb.toString();
    }

    public InetSocketAddress getLocalAddress() {
        return this.__m_LocalAddress;
    }

    public AddressProvider getRemoteAddressProvider() {
        return this.__m_RemoteAddressProvider;
    }

    public SocketOptions getSocketOptions() {
        return this.__m_SocketOptions;
    }

    public SocketProvider getSocketProvider() {
        return this.__m_SocketProvider;
    }

    public SocketProviderFactory getSocketProviderFactory() {
        SocketProviderFactory factory = this.__m_SocketProviderFactory;
        if (factory == null) {
            OperationalContext ctx = this.getOperationalContext();
            factory = ctx == null ? new SocketProviderFactory() : ctx.getSocketProviderFactory();
            this.setSocketProviderFactory(factory);
        }
        return factory;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/daemon/queueProcessor/service/peer/initiator/TcpInitiator".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new TcpInitiator();
    }

    private final Component get_Module() {
        return this;
    }

    protected Connection instantiateConnection() {
        TcpInitiator$TcpConnection connection = (TcpInitiator$TcpConnection)this._newChild("TcpConnection");
        connection.setConnectionManager(this);
        return connection;
    }

    public Socket instantiateSocket() {
        Socket socket;
        try {
            socket = this.getSocketProvider().openSocket();
        }
        catch (IOException e) {
            throw Base.ensureRuntimeException(e, "error creating Socket");
        }
        this.configureSocket(socket);
        return socket;
    }

    public void onInit() {
        super.onInit();
        try {
            SocketOptions options = this.getSocketOptions();
            options.setOption(java.net.SocketOptions.SO_KEEPALIVE, Boolean.TRUE);
            options.setOption(java.net.SocketOptions.TCP_NODELAY, Boolean.TRUE);
            options.setOption(java.net.SocketOptions.SO_LINGER, 0);
        }
        catch (SocketException e) {
            throw Base.ensureRuntimeException(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Connection openConnection() {
        block10: {
            provider = this.getRemoteAddressProvider();
            Component._assert(provider != null);
            cMillis = (int)this.getConnectTimeout();
            cMillis = cMillis <= 0 != false ? 0 : cMillis;
            listAddr = new LinkedList<String>();
            iterRedirect = null;
            while (true) {
                block11: {
                    connection = (TcpInitiator$TcpConnection)this.instantiateConnection();
                    if (iterRedirect == null != false ? true : iterRedirect.hasNext() ^ true) {
                        addr = provider.getNextAddress();
                        iterRedirect = null;
                    } else {
                        addr = (InetSocketAddress)iterRedirect.next();
                        connection.setRedirect(true);
                    }
                    if (addr == null) break block10;
                    sAddr = TcpUtil.toString(addr);
                    listAddr.add(sAddr);
                    socket = this.instantiateSocket();
                    try {
                        if (iterRedirect == null) {
                            Component._trace(String.valueOf("Connecting Socket to ") + sAddr, 5);
                        } else {
                            Component._trace(String.valueOf("Redirecting Socket to ") + sAddr, 5);
                        }
                        socket.connect(addr, cMillis);
                        Component._trace(String.valueOf("Connected Socket to ") + sAddr, 3);
                        connection.setSocket(socket);
                    }
                    catch (Exception e) {
                        Component._trace(String.valueOf("Error connecting Socket to ") + sAddr + ": " + e, 3);
                        TcpUtil.close(socket);
                        if (!(iterRedirect == null != false ? true : iterRedirect.hasNext() ^ true)) continue;
                        provider.reject(e);
                        continue;
                    }
                    try {
                        connection.open();
                        break;
                    }
                    catch (Exception e) {
                        if (!(iterRedirect == null == false ? false : connection.isRedirect())) break block11;
                        list = connection.getRedirectList();
                        listRedirect = new ArrayList<InetSocketAddress>(list.size());
                        iter = list.iterator();
                        ** while (iter.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        ao = (Object[])iter.next();
                        s = (String)ao[0];
                        n = (Integer)ao[1];
                        listRedirect.add(new InetSocketAddress(s, n));
                        continue;
                    }
lbl51:
                    // 1 sources

                    iterRedirect = listRedirect.iterator();
                    continue;
                }
                Component._trace(String.valueOf("Error establishing a connection with ") + sAddr + ": " + e, 3);
                if (!(iterRedirect == null != false ? true : iterRedirect.hasNext() ^ true)) continue;
                provider.reject(e);
            }
            provider.accept();
            return connection;
        }
        throw new ConnectionException(String.valueOf("could not establish a connection to one of the ") + "following addresses: " + listAddr + "; make sure the " + "\"remote-addresses\" configuration element contains an address and " + "port of a running TcpAcceptor");
    }

    protected static InetSocketAddress parseLocalSocketAddress(XmlElement xml) {
        XmlElement xmlAddr = xml.getElement("address");
        XmlElement xmlPort = xml.getElement("port");
        if (!(xmlAddr == null) ? false : xmlPort == null) {
            return null;
        }
        String sAddr = xmlAddr == null ? "localhost" : xmlAddr.getString();
        int nPort = xmlPort == null ? 0 : xmlPort.getInt();
        InetAddress addr = null;
        try {
            addr = InetAddressHelper.getLocalAddress(sAddr);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, String.valueOf("the \"") + xml.getName() + "\" configuration element contains an invalid \"address\" element");
        }
        try {
            return new InetSocketAddress(addr, nPort);
        }
        catch (RuntimeException e) {
            throw Base.ensureRuntimeException(e, String.valueOf("the \"") + xml.getName() + "\" configuration element contains an invalid \"port\" element");
        }
    }

    protected void setLocalAddress(InetSocketAddress addr) {
        this.__m_LocalAddress = addr;
    }

    protected void setRemoteAddressProvider(AddressProvider provider) {
        this.__m_RemoteAddressProvider = provider;
    }

    protected void setSocketOptions(SocketOptions options) {
        Component._assert(options != null);
        Component._assert(this.getSocketOptions() == null);
        this.__m_SocketOptions = options;
    }

    public void setSocketProvider(SocketProvider pSocketProvider) {
        this.__m_SocketProvider = pSocketProvider;
    }

    public void setSocketProviderFactory(SocketProviderFactory factory) {
        this.__m_SocketProviderFactory = factory;
    }
}

