/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.Queue$Iterator;
import com.tangosol.util.ListMap;
import com.tangosol.util.RecyclingLinkedList;
import com.tangosol.util.WrapperException;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class ConcurrentQueue
extends Queue {
    public static final int FLUSH_AUTO = 1;
    public static final int FLUSH_EXPLICIT = 2;
    public static final int FLUSH_PENDING = 0;
    private transient AtomicInteger __m_AtomicFlushState;
    private transient int __m_BatchSize;
    private AtomicInteger __m_ElementCounter;
    private Object __m_Notifier;
    private long __m_StatsEmptied;
    private long __m_StatsFlushed;
    private static ListMap __mapChildren;

    static {
        ConcurrentQueue.__initStatic();
    }

    public ConcurrentQueue() {
        this(null, null, true);
    }

    public ConcurrentQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setBatchSize(1);
            this.setElementList(new RecyclingLinkedList());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Iterator", Queue$Iterator.get_CLASS());
    }

    public boolean add(Object oElement) {
        if (oElement == null) {
            throw new IllegalArgumentException("The ConcurrentQueue does not support null values.");
        }
        this.getElementList().add(oElement);
        this.onAddElement();
        return true;
    }

    public boolean addHead(Object oElement) {
        if (oElement == null) {
            throw new IllegalArgumentException("The ConcurrentQueue does not support null values.");
        }
        this.getElementList().add(0, oElement);
        this.onAddElement();
        return true;
    }

    protected void checkFlush(int cElements) {
        if (this.getNotifier() != null) {
            int nFlushState;
            if (cElements == 1) {
                nFlushState = FLUSH_PENDING;
                this.updateFlushState(nFlushState);
            } else {
                nFlushState = this.getFlushState();
            }
            switch (nFlushState) {
                case 0: {
                    if (!(cElements % this.getBatchSize() == 0)) break;
                    this.flush(true);
                    break;
                }
                case 2: {
                    this.updateFlushStateConditionally(FLUSH_EXPLICIT, FLUSH_AUTO);
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    public void flush() {
        this.flush(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flush(boolean fAuto) {
        Object oNotifier;
        if (this.updateFlushState(fAuto ? FLUSH_AUTO : FLUSH_EXPLICIT) == FLUSH_PENDING && (oNotifier = this.getNotifier()) != null) {
            Object object = oNotifier;
            synchronized (object) {
                this.setStatsFlushed(this.getStatsFlushed() + 1L);
                oNotifier.notifyAll();
            }
        }
    }

    protected AtomicInteger getAtomicFlushState() {
        return this.__m_AtomicFlushState;
    }

    public int getBatchSize() {
        return this.__m_BatchSize;
    }

    public AtomicInteger getElementCounter() {
        return this.__m_ElementCounter;
    }

    public int getFlushState() {
        return this.getAtomicFlushState().get();
    }

    public Object getNotifier() {
        return this.__m_Notifier;
    }

    public long getStatsEmptied() {
        return this.__m_StatsEmptied;
    }

    public long getStatsFlushed() {
        return this.__m_StatsFlushed;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/queue/ConcurrentQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    public static Component get_Instance() {
        return new ConcurrentQueue();
    }

    private final Component get_Module() {
        return this;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isFlushPending() {
        return this.getFlushState() == FLUSH_PENDING;
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException();
    }

    protected void onAddElement() {
        this.checkFlush(this.getElementCounter().incrementAndGet());
    }

    protected void onEmpty() {
        this.setStatsEmptied(this.getStatsEmptied() + 1L);
    }

    public void onInit() {
        this.setElementCounter(new AtomicInteger());
        this.setAtomicFlushState(new AtomicInteger(FLUSH_PENDING));
        this.setNotifier(this);
        super.onInit();
    }

    public Object peekNoWait() {
        try {
            return this.isEmpty() ? null : this.getElementList().get(0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Object remove(long cMillis) {
        Object o = this.removeNoWait();
        while (o == null) {
            long cWait = Math.min(1000L, cMillis);
            this.waitForEntry(cWait);
            o = this.removeNoWait();
            if (cMillis > (long)0 && (cMillis -= cWait) <= (long)0) break;
        }
        return o;
    }

    /*
     * WARNING - void declaration
     */
    public Object removeNoWait() {
        AtomicInteger counter = this.getElementCounter();
        if (counter.get() == 0) {
            return null;
        }
        try {
            void e;
            Object oEntry = this.getElementList().remove(0);
            if (counter.decrementAndGet() == 0) {
                this.onEmpty();
            }
            return e;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    protected void setAtomicFlushState(AtomicInteger atomicState) {
        Component._assert(this.getAtomicFlushState() == null);
        this.__m_AtomicFlushState = atomicState;
    }

    public void setBatchSize(int cBatch) {
        if (cBatch > 0) {
            this.__m_BatchSize = cBatch;
        }
    }

    protected void setElementCounter(AtomicInteger counter) {
        this.__m_ElementCounter = counter;
    }

    public void setNotifier(Object oNotifier) {
        this.__m_Notifier = oNotifier;
    }

    protected void setStatsEmptied(long cEmptied) {
        this.__m_StatsEmptied = cEmptied;
    }

    protected void setStatsFlushed(long cFlush) {
        this.__m_StatsFlushed = cFlush;
    }

    public int size() {
        return this.getElementCounter().get();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.get_Name()).append(" size=").append(this.size()).append(", emptied=").append(this.getStatsEmptied()).append(", flushed=").append(this.getStatsFlushed()).append(", first=").append(this.peekNoWait());
        return sb.toString();
    }

    protected int updateFlushState(int nState) {
        return this.getAtomicFlushState().getAndSet(nState);
    }

    protected boolean updateFlushStateConditionally(int nStateAssumed, int nStateNew) {
        return this.getAtomicFlushState().compareAndSet(nStateAssumed, nStateNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForEntry(long cMillis) {
        if (this.isEmpty()) {
            try {
                Object oNotifier = this.getNotifier();
                if (oNotifier == null) {
                    throw new UnsupportedOperationException("blocking remove without a notifier");
                }
                Object object = oNotifier;
                synchronized (object) {
                    if (this.isEmpty()) {
                        oNotifier.wait(cMillis);
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new WrapperException(e);
            }
        }
    }
}

