/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue.concurrentQueue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue$Iterator;
import com.tangosol.coherence.component.util.queue.ConcurrentQueue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.MultiQueue$WindowedArray;
import com.tangosol.util.Base;
import com.tangosol.util.ListMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public abstract class MultiQueue
extends ConcurrentQueue {
    private AtomicLong __m_NextRemoveableIndex;
    private MultiQueue$WindowedArray __m_WindowedArray;
    private static ListMap __mapChildren;

    static {
        MultiQueue.__initStatic();
    }

    public MultiQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Iterator", Queue$Iterator.get_CLASS());
    }

    public boolean add(Object oElement) {
        if (oElement == null) {
            throw new IllegalArgumentException("The MultiQueue does not support null values.");
        }
        this.getWindowedArray().add(oElement);
        this.onAddElement();
        return true;
    }

    public boolean addHead(Object oElement) {
        throw new UnsupportedOperationException();
    }

    protected void checkFlush(int cElements) {
        if (cElements == 0) {
            this.onEmpty();
        } else {
            super.checkFlush(cElements);
        }
    }

    public AtomicLong getNextRemoveableIndex() {
        return this.__m_NextRemoveableIndex;
    }

    protected MultiQueue$WindowedArray getWindowedArray() {
        return this.__m_WindowedArray;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/queue/concurrentQueue/MultiQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    public void onInit() {
        super.onInit();
        MultiQueue$WindowedArray wa = (MultiQueue$WindowedArray)this._findChild("WindowedArray");
        this.setWindowedArray(wa);
        this.setNextRemoveableIndex(new AtomicLong(wa.getFirstIndex()));
    }

    public Object peekNoWait() {
        AtomicLong atomicNext;
        long lNext;
        MultiQueue$WindowedArray wa = this.getWindowedArray();
        Object oPeek = wa.optimisticGet(lNext = (atomicNext = this.getNextRemoveableIndex()).get());
        return (!(oPeek == null) ? false : lNext <= wa.getLastIndex()) ? wa.get(atomicNext.get()) : oPeek;
    }

    public Object remove(long cMillis) {
        return this.getNotifier() == null ? this.removeMulti(cMillis) : super.remove(cMillis);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object removeMulti(long cMillis) {
        MultiQueue$WindowedArray wa = this.getWindowedArray();
        while (true) {
            Object var11_9;
            boolean fRollback;
            long lNext;
            block9: {
                Object object;
                lNext = this.getNextRemoveableIndex().getAndIncrement();
                fRollback = true;
                long cWait = (!((long)0 < cMillis) ? false : cMillis < 1000L) ? cMillis : 1000L;
                try {
                    try {
                        Object oRemoved = wa.safeRemove(lNext, cWait);
                        if (oRemoved == null) {
                            fRollback = wa.isRemoved(lNext) ^ true;
                            if (cMillis != (long)0 && (cMillis -= cWait) <= (long)0) {
                                Object var10_10 = null;
                                var11_9 = null;
                                if (!fRollback) return var10_10;
                                this.rollbackNextIndex(lNext);
                                return var10_10;
                            }
                            break block9;
                        }
                        fRollback = false;
                        if (this.getElementCounter().decrementAndGet() == 0) {
                            this.onEmpty();
                        }
                        object = oRemoved;
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw Base.ensureRuntimeException(e);
                    }
                }
                catch (Throwable throwable) {
                    var11_9 = null;
                    if (fRollback) {
                        this.rollbackNextIndex(lNext);
                    }
                    throw throwable;
                }
                var11_9 = null;
                if (!fRollback) return object;
                this.rollbackNextIndex(lNext);
                return object;
            }
            var11_9 = null;
            if (!fRollback) continue;
            this.rollbackNextIndex(lNext);
        }
    }

    public Object removeNoWait() {
        return this.getNotifier() == null ? this.removeNoWaitMulti() : this.removeNoWaitSingle();
    }

    protected Object removeNoWaitMulti() {
        MultiQueue$WindowedArray wa = this.getWindowedArray();
        AtomicLong atomicNext = this.getNextRemoveableIndex();
        Object oRemoved = null;
        boolean fRollback = true;
        do {
            Object var8_6;
            long lNext = atomicNext.getAndIncrement();
            try {
                try {
                    oRemoved = wa.safeRemove(lNext);
                    if (oRemoved == null) {
                        if (lNext <= wa.getLastIndex()) {
                            oRemoved = wa.safeRemove(lNext, -1L);
                        } else {
                            Object var7_7 = null;
                            var8_6 = null;
                            if (fRollback) {
                                this.rollbackNextIndex(lNext);
                            }
                            return var7_7;
                        }
                    }
                    fRollback = false;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw Base.ensureRuntimeException(e);
                }
            }
            catch (Throwable throwable) {
                var8_6 = null;
                if (fRollback) {
                    this.rollbackNextIndex(lNext);
                }
                throw throwable;
            }
            var8_6 = null;
            if (!fRollback) continue;
            this.rollbackNextIndex(lNext);
        } while (oRemoved == null);
        if (this.getElementCounter().decrementAndGet() == 0) {
            this.onEmpty();
        }
        return oRemoved;
    }

    protected Object removeNoWaitSingle() {
        MultiQueue$WindowedArray wa = this.getWindowedArray();
        AtomicLong atomicNext = this.getNextRemoveableIndex();
        Object oRemoved = wa.safeRemove(atomicNext.get());
        try {
            while (oRemoved == null) {
                long lFirst = atomicNext.get();
                if (lFirst > wa.getLastIndex()) {
                    return null;
                }
                oRemoved = wa.safeRemove(lFirst, -1L);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e);
        }
        atomicNext.incrementAndGet();
        if (this.getElementCounter().decrementAndGet() == 0) {
            this.onEmpty();
        }
        return oRemoved;
    }

    protected void rollbackNextIndex(long iVirtual) {
        long lCur;
        AtomicLong atomicNext = this.getNextRemoveableIndex();
        while (!((lCur = atomicNext.get()) <= iVirtual ? true : atomicNext.compareAndSet(lCur, iVirtual))) {
        }
    }

    public void setNextRemoveableIndex(AtomicLong pNextRemoveableIndex) {
        this.__m_NextRemoveableIndex = pNextRemoveableIndex;
    }

    protected void setWindowedArray(MultiQueue$WindowedArray waElements) {
        this.__m_WindowedArray = waElements;
    }

    public int size() {
        return Math.max(0, super.size());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(", next=").append(this.getNextRemoveableIndex().get()).append(", storage array={").append(this.getWindowedArray()).append('}');
        return sb.toString();
    }

    public void waitForEntry(long cMillis) {
        try {
            this.getWindowedArray().get(this.getNextRemoveableIndex().get(), cMillis == 0L ? -1L : cMillis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw Base.ensureRuntimeException(e);
        }
    }
}

