/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.queue.concurrentQueue.balancedQueue;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.util.Queue;
import com.tangosol.coherence.component.util.Queue$Iterator;
import com.tangosol.coherence.component.util.queue.concurrentQueue.BalancedQueue;
import com.tangosol.coherence.component.util.queue.concurrentQueue.balancedQueue.BundlingQueue$TargetQueue;
import com.tangosol.util.ListMap;
import com.tangosol.util.stats.MovingAverage;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BundlingQueue
extends BalancedQueue {
    private transient MovingAverage __m_BundleAverage;
    private transient double __m_BundlingAggression;
    private transient boolean __m_BundlingEnabled;
    private transient long __m_DeferralThresholdNanos;
    private transient long __m_DeferralThresholdReads;
    private transient long __m_ReadAttemptCount;
    private transient long __m_StatsBundled;
    private static ListMap __mapChildren;

    static {
        BundlingQueue.__initStatic();
    }

    public BundlingQueue(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    private static void __initStatic() {
        __mapChildren = new ListMap();
        Class clazz = __mapChildren.put("Iterator", Queue$Iterator.get_CLASS());
        Class clazz2 = __mapChildren.put("TargetQueue", BundlingQueue$TargetQueue.get_CLASS());
    }

    public AtomicInteger getAtomicFlushState() {
        return super.getAtomicFlushState();
    }

    public MovingAverage getBundleAverage() {
        return this.__m_BundleAverage;
    }

    public double getBundlingAggression() {
        return this.__m_BundlingAggression;
    }

    public long getDeferralThresholdNanos() {
        return this.__m_DeferralThresholdNanos;
    }

    public long getDeferralThresholdReads() {
        return this.__m_DeferralThresholdReads;
    }

    public long getReadAttemptCount() {
        return this.__m_ReadAttemptCount;
    }

    public long getStatsBundled() {
        return this.__m_StatsBundled;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/queue/concurrentQueue/balancedQueue/BundlingQueue".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    protected Map get_ChildClasses() {
        return __mapChildren;
    }

    private final Component get_Module() {
        return this;
    }

    protected Queue instantiateTargetQueue() {
        return this.isBundlingEnabled() ? (BundlingQueue$TargetQueue)this._newChild("TargetQueue") : super.instantiateTargetQueue();
    }

    public boolean isBundlingEnabled() {
        return this.__m_BundlingEnabled;
    }

    public void onEmptyTarget(Object oTarget, Queue queueTarget) {
        if (queueTarget.isEmpty()) {
            super.onEmptyTarget(oTarget, queueTarget);
        }
    }

    public void onInit() {
        this.setBundleAverage(new MovingAverage(1000, 10));
        super.onInit();
    }

    public void resetStats() {
        this.setStatsBundled(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void safeRemoveTargetQueue(Object oTarget) {
        boolean fRemoved = false;
        Object object = this.getLock(oTarget);
        synchronized (object) {
            Map mapTarget = this.getTargetMap();
            Queue queueTarget = (Queue)mapTarget.get(oTarget);
            if (queueTarget instanceof BundlingQueue$TargetQueue) {
                Object object2 = ((BundlingQueue$TargetQueue)queueTarget).getHeadLock();
                synchronized (object2) {
                    if (queueTarget.isEmpty()) {
                        mapTarget.remove(oTarget);
                        fRemoved = true;
                    }
                }
            } else if (!(queueTarget != null) ? false : queueTarget.isEmpty()) {
                mapTarget.remove(oTarget);
                fRemoved = true;
            }
        }
        if (fRemoved) {
            this.refreshEntries();
        }
    }

    protected void setBundleAverage(MovingAverage average) {
        this.__m_BundleAverage = average;
    }

    public void setBundlingAggression(double dAggression) {
        this.__m_BundlingAggression = Math.max(0.0, dAggression);
    }

    public void setBundlingEnabled(boolean fEnabled) {
        this.__m_BundlingEnabled = fEnabled;
    }

    public void setDeferralThresholdNanos(long cNanos) {
        this.__m_DeferralThresholdNanos = cNanos;
    }

    public void setDeferralThresholdReads(long cReads) {
        this.__m_DeferralThresholdReads = cReads;
    }

    public void setReadAttemptCount(long cAttempts) {
        this.__m_ReadAttemptCount = cAttempts;
    }

    public void setStatsBundled(long cBundled) {
        this.__m_StatsBundled = cBundled;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(", bundled=").append(this.getStatsBundled()).append(", average/bundle=").append(this.getBundleAverage().getDoubleAverage()).append(", stddev=").append(this.getBundleAverage().getStandardDeviation());
        return sb.toString();
    }
}

