/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.component.util.safeService;

import com.tangosol.coherence.Component;
import com.tangosol.coherence.component.net.Security;
import com.tangosol.coherence.component.util.SafeNamedCache;
import com.tangosol.coherence.component.util.SafeService;
import com.tangosol.coherence.component.util.SafeService$ServiceAction;
import com.tangosol.net.BackingMapManager;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.internal.ScopedReferenceStore;
import com.tangosol.net.security.SecurityHelper;
import com.tangosol.util.Service;
import com.tangosol.util.WrapperException;
import java.util.Enumeration;

public class SafeCacheService
extends SafeService
implements CacheService {
    private transient BackingMapManager __m_BackingMapManager;
    private ScopedReferenceStore __m_ScopedStore;

    public SafeCacheService() {
        this(null, null, true);
    }

    public SafeCacheService(String sName, Component compParent, boolean fInit) {
        super(sName, compParent, false);
        if (fInit) {
            this.__init();
        }
    }

    public void __init() {
        this.__initPrivate();
        try {
            this.setSafeServiceState(0);
            this.setScopedStore(new ScopedReferenceStore());
        }
        catch (Exception e) {
            throw new WrapperException(e);
        }
        this._addChild(new SafeService$ServiceAction("ServiceAction", this, true), "ServiceAction");
        this.set_Constructed(true);
    }

    protected void __initPrivate() {
        super.__initPrivate();
    }

    protected void cleanup() {
        super.cleanup();
        ScopedReferenceStore store = this.getScopedStore();
        store.lockAll();
        try {
            store.clear();
        }
        finally {
            Object var3_2 = null;
            store.unlockAll();
        }
    }

    public void destroyCache(NamedCache cache) {
        block3: {
            Security.checkPermission(this.getSafeCluster().getCluster(), this.getServiceName(), cache.getCacheName(), "destroy");
            SafeNamedCache cacheSafe = (SafeNamedCache)cache;
            this.removeCacheReference(cacheSafe);
            CacheService service = this.getCacheService();
            try {
                NamedCache cacheWrapped = cacheSafe.getNamedCache();
                if (cacheWrapped == null) {
                    throw new IllegalStateException("Cache is already released");
                }
                service.destroyCache(cacheWrapped);
            }
            catch (RuntimeException e) {
                if (!(!(service != null) ? false : service.isRunning())) break block3;
                throw e;
            }
        }
    }

    private NamedCache ensureCache$Router(String sName, ClassLoader loader) {
        return this.getRunningCacheService().ensureCache(sName, loader);
    }

    public NamedCache ensureCache(String sName, ClassLoader loader) {
        this.checkClientThread("ensureCache");
        if (sName == null ? true : sName.length() == 0) {
            sName = "Default";
        }
        if (loader == null) {
            loader = this.getContextClassLoader();
        }
        Security.checkPermission(this.getSafeCluster().getCluster(), this.getServiceName(), sName, "join");
        ScopedReferenceStore store = this.getScopedStore();
        SafeNamedCache cacheSafe = (SafeNamedCache)store.getCache(sName, loader);
        if (cacheSafe == null) {
            block5: {
                store.lock(sName);
                try {
                    cacheSafe = (SafeNamedCache)store.getCache(sName, loader);
                    if (!(cacheSafe == null)) break block5;
                    NamedCache cache = this.ensureCache$Router(sName, loader);
                    cacheSafe = new SafeNamedCache();
                    cacheSafe.setSubject(SecurityHelper.getCurrentSubject());
                    cacheSafe.setSafeCacheService(this);
                    cacheSafe.setCacheName(sName);
                    cacheSafe.setClassLoader(loader);
                    cacheSafe.setNamedCache(cache);
                    store.putCache(cacheSafe, loader);
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    store.unlock(sName);
                    throw throwable;
                }
            }
            Object var6_7 = null;
            store.unlock(sName);
        }
        return cacheSafe;
    }

    public CacheService ensureRunningCacheService(boolean fDrain) {
        return (CacheService)this.ensureRunningService(fDrain);
    }

    public BackingMapManager getBackingMapManager() {
        return this.__m_BackingMapManager;
    }

    public Enumeration getCacheNames() {
        return this.getRunningCacheService().getCacheNames();
    }

    public CacheService getCacheService() {
        return (CacheService)this.getService();
    }

    protected CacheService getRunningCacheService() {
        return this.ensureRunningCacheService(true);
    }

    protected ScopedReferenceStore getScopedStore() {
        return this.__m_ScopedStore;
    }

    public static Class get_CLASS() {
        Class<?> clz;
        try {
            clz = Class.forName("com/tangosol/coherence/component/util/safeService/SafeCacheService".replace('/', '.'));
        }
        catch (ClassNotFoundException e) {
            throw new NoClassDefFoundError(e.getMessage());
        }
        return clz;
    }

    public static Component get_Instance() {
        return new SafeCacheService();
    }

    private final Component get_Module() {
        return this;
    }

    public void releaseCache(NamedCache cache) {
        block3: {
            SafeNamedCache cacheSafe = (SafeNamedCache)cache;
            this.removeCacheReference(cacheSafe);
            CacheService service = this.getCacheService();
            try {
                NamedCache cacheWrapped = cacheSafe.getNamedCache();
                if (cacheWrapped != null) {
                    service.releaseCache(cacheWrapped);
                }
            }
            catch (RuntimeException e) {
                if (!(!(service != null) ? false : service.isRunning())) break block3;
                throw e;
            }
        }
    }

    protected void removeCacheReference(SafeNamedCache cacheSafe) {
        cacheSafe.setReleased(true);
        String sName = cacheSafe.getCacheName();
        ScopedReferenceStore store = this.getScopedStore();
        store.lock(sName);
        try {
            store.releaseCache(cacheSafe);
        }
        finally {
            Object var5_4 = null;
            store.unlock(sName);
        }
    }

    public void setBackingMapManager(BackingMapManager manager) {
        this.__m_BackingMapManager = manager;
    }

    protected void setScopedStore(ScopedReferenceStore scopedStore) {
        this.__m_ScopedStore = scopedStore;
    }

    protected void startService(Service service) {
        ((CacheService)service).setBackingMapManager(this.getBackingMapManager());
        super.startService(service);
    }
}

