/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.tangosol.coherence.dslquery.CoherenceQueryLanguage;
import com.tangosol.coherence.dslquery.FilterBuilder;
import com.tangosol.coherence.dslquery.SQLOPParser;
import com.tangosol.coherence.dslquery.SelectListMaker;
import com.tangosol.coherence.dslquery.UpdateSetListMaker;
import com.tangosol.coherence.dsltools.precedence.TokenTable;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.coherence.dsltools.termtrees.Terms;
import com.tangosol.io.Serializer;
import com.tangosol.io.WrapperBufferInput;
import com.tangosol.io.WrapperBufferOutput;
import com.tangosol.io.pof.PofBufferReader;
import com.tangosol.io.pof.PofBufferWriter;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofInputStream;
import com.tangosol.io.pof.PofOutputStream;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.Cluster;
import com.tangosol.net.DistributedCacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.CompositeAggregator;
import com.tangosol.util.aggregator.GroupAggregator;
import com.tangosol.util.aggregator.QueryRecorder;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.processor.ConditionalRemove;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class CoherenceQuery {
    public static final int FUNCTION_SELECT_STAR = 0;
    public static final int FUNCTION_SELECT_DISTINCT = 1;
    public static final int FUNCTION_SELECT_PROJECTION = 2;
    public static final int FUNCTION_SELECT_AGGREGATION = 3;
    public static final int FUNCTION_UPDATE = 4;
    public static final int FUNCTION_DELETE = 5;
    public static final int FUNCTION_CREATE_INDEX = 6;
    public static final int FUNCTION_DROP_INDEX = 7;
    public static final int FUNCTION_DROP_CACHE = 8;
    public static final int FUNCTION_INSERT = 9;
    public static final int FUNCTION_CREATE_CACHE = 10;
    public static final int FUNCTION_BACKUP_CACHE = 11;
    public static final int FUNCTION_RESTORE_CACHE = 12;
    public static final int FUNCTION_SOURCE_FILE = 13;
    private boolean m_fValidateCache = false;
    private Object[] m_env = new Object[0];
    private Map m_bindingEnv = new HashMap();
    private NodeTerm m_where;
    private Term m_fields;
    private String m_table;
    private String m_alias;
    private String m_file;
    private Term m_groupBy;
    private Term m_setList;
    private Term m_extractor;
    private boolean m_isDistinct;
    private Filter m_filter;
    private InvocableMap.EntryAggregator m_aggregator;
    private InvocableMap.EntryProcessor m_entryProcessor;
    private ValueExtractor m_valueExtractor;
    private Object m_insertKey;
    private Object m_insertValue;
    private String m_error = null;
    private int m_execution = -1;
    private boolean m_fExtendedLanguage = false;

    public CoherenceQuery() {
        this(false);
    }

    public CoherenceQuery(boolean fValidateCache) {
        this.m_fValidateCache = fValidateCache;
    }

    public boolean build(NodeTerm node) {
        return this.build(node, new Object[0]);
    }

    public boolean build(NodeTerm node, Object[] env) {
        return this.build(node, env, new HashMap());
    }

    public boolean build(NodeTerm node, Map map) {
        return this.build(node, new Object[0], map);
    }

    public boolean build(NodeTerm sn, Object[] env, Map map) {
        this.m_env = env;
        this.m_bindingEnv = map;
        this.m_filter = null;
        this.m_where = null;
        this.m_extractor = null;
        if (sn.getFunctor().equals("sqlSelectNode")) {
            this.m_table = this.getTable(sn);
            this.m_alias = this.getAlias(sn);
            this.m_where = this.getWhere(sn);
            if (this.m_where != null) {
                FilterBuilder fm = new FilterBuilder();
                fm.setAlias(this.m_alias);
                this.m_filter = fm.makeFilter(this.m_where, env, map);
            } else {
                this.m_filter = new AlwaysFilter();
            }
            this.m_fields = this.getFields(sn);
            this.m_groupBy = this.getGroupBy(sn);
            this.m_isDistinct = this.getIsDestinct(sn);
            if (this.m_groupBy != null) {
                if (this.m_fields == null) {
                    this.m_error = "must have fields for group by to make sense";
                    return false;
                }
                if (!this.headsMatch((NodeTerm)this.m_fields, (NodeTerm)this.m_groupBy)) {
                    this.m_error = "group by fields must match head of select list";
                    return false;
                }
            }
            if (this.m_fields.termEqual(Terms.newTerm("fieldList", AtomicTerm.createString("*"))) || this.m_alias != null && this.m_fields.termEqual(Terms.newTerm("fieldList", AtomicTerm.createString(this.m_alias)))) {
                this.m_execution = 0;
                return true;
            }
            SelectListMaker transformer = new SelectListMaker(env);
            transformer.setAlias(this.m_alias);
            transformer.makeSelects((NodeTerm)this.m_fields);
            if (!transformer.hasCalls()) {
                if (this.m_isDistinct) {
                    this.m_aggregator = transformer.getDistinctValues();
                    this.m_execution = 1;
                    return true;
                }
                this.m_aggregator = transformer.getResultsAsReduction();
                this.m_execution = 2;
                return true;
            }
            this.m_aggregator = transformer.getResultsAsEntryAggregator();
            this.m_execution = 3;
            return true;
        }
        if (sn.getFunctor().equals("sqlExplainNode")) {
            return this.buildForQueryRecorder(sn, env, map, QueryRecorder.RecordType.EXPLAIN);
        }
        if (sn.getFunctor().equals("sqlTraceNode")) {
            return this.buildForQueryRecorder(sn, env, map, QueryRecorder.RecordType.TRACE);
        }
        if (sn.getFunctor().equals("sqlUpdateNode")) {
            this.m_table = this.getTable(sn);
            this.m_alias = this.getAlias(sn);
            this.m_where = this.getWhere(sn);
            if (this.m_where != null) {
                FilterBuilder fm = new FilterBuilder();
                fm.setAlias(this.m_alias);
                this.m_filter = fm.makeFilter(this.m_where, env);
            } else {
                this.m_filter = new AlwaysFilter();
            }
            this.m_setList = this.getSetList(sn);
            UpdateSetListMaker transformer = new UpdateSetListMaker(env);
            transformer.setExtendedLanguage(this.m_fExtendedLanguage);
            transformer.setAlias(this.m_alias);
            try {
                this.m_entryProcessor = transformer.makeSetList((NodeTerm)this.m_setList);
            }
            catch (Exception ex) {
                this.m_error = ex.getMessage();
                return false;
            }
            this.m_execution = 4;
            return true;
        }
        if (sn.getFunctor().equals("sqlDeleteNode")) {
            this.m_table = this.getTable(sn);
            this.m_alias = this.getAlias(sn);
            this.m_where = this.getWhere(sn);
            if (this.m_where != null) {
                FilterBuilder fm = new FilterBuilder();
                fm.setAlias(this.m_alias);
                this.m_filter = fm.makeFilter(this.m_where, env);
            } else {
                this.m_filter = new AlwaysFilter();
            }
            this.m_entryProcessor = new ConditionalRemove(AlwaysFilter.INSTANCE);
            this.m_execution = 5;
            return true;
        }
        if (sn.getFunctor().equals("sqlCreateIndexNode")) {
            this.m_table = this.getTable(sn);
            this.m_extractor = this.getExtractor(sn);
            if (this.m_extractor != null) {
                SelectListMaker transformer = new SelectListMaker(env);
                transformer.makeSelects((NodeTerm)this.m_extractor);
                this.m_valueExtractor = transformer.getResultsAsValueExtractor();
                this.m_execution = 6;
                return true;
            }
            this.m_error = "ValueExtractor(s) needed for create index";
            return false;
        }
        if (sn.getFunctor().equals("sqlDropIndexNode")) {
            this.m_table = this.getTable(sn);
            this.m_extractor = this.getExtractor(sn);
            if (this.m_extractor != null) {
                SelectListMaker transformer = new SelectListMaker(env);
                transformer.makeSelects((NodeTerm)this.m_extractor);
                this.m_valueExtractor = transformer.getResultsAsValueExtractor();
                this.m_execution = 7;
                return true;
            }
            this.m_error = "ValueExtractor(s) needed for droping index";
            return false;
        }
        if (sn.getFunctor().equals("sqlDropCacheNode")) {
            this.m_table = this.getTable(sn);
            if (this.m_table != null) {
                this.m_execution = 8;
                return true;
            }
            this.m_error = "Cache name needed for droping cache";
            return false;
        }
        if (sn.getFunctor().equals("sqlInsertNode")) {
            this.m_table = this.getTable(sn);
            this.m_alias = this.getAlias(sn);
            Term key = this.getInsertKey(sn);
            Term value = this.getInsertValue(sn);
            if (this.m_table != null) {
                if (value == null) {
                    value = Terms.newTerm("literal", AtomicTerm.createNull());
                }
                UpdateSetListMaker transformer = new UpdateSetListMaker(env);
                transformer.setExtendedLanguage(this.m_fExtendedLanguage);
                try {
                    this.m_insertValue = transformer.makeObject((NodeTerm)value);
                }
                catch (Exception ex) {
                    this.m_error = "Error creating object: " + ex.getMessage();
                    return false;
                }
                if (key == null) {
                    try {
                        this.m_insertKey = ClassHelper.invoke(this.m_insertValue, "getKey", new Object[0]);
                    }
                    catch (NoSuchMethodException e) {
                        this.m_error = this.m_insertValue != null ? "No key specified and Missing or inaccessible method: " + this.m_insertValue.getClass().getName() + ".getKey()!" : "No key specified!";
                        return false;
                    }
                    catch (Exception ex) {
                        this.m_error = ex.getMessage();
                        return false;
                    }
                }
                try {
                    this.m_insertKey = transformer.makeObjectForKey((NodeTerm)key, this.m_insertValue);
                }
                catch (Exception ex) {
                    this.m_error = ex.getMessage();
                    return false;
                }
                this.m_execution = 9;
                return true;
            }
            this.m_error = "Malformed insert statment!";
            return false;
        }
        if (sn.getFunctor().equals("sqlCreateCacheNode")) {
            this.m_table = this.getTable(sn);
            if (this.m_table != null) {
                this.m_execution = 10;
                return true;
            }
            this.m_error = "Cache name needed for creating cache";
            return false;
        }
        if (sn.getFunctor().equals("sqlBackupCacheNode")) {
            this.m_table = this.getTable(sn);
            if (this.m_table == null) {
                this.m_error = "Cache name needed for backing up cache";
                return false;
            }
            this.m_file = this.getFile(sn);
            if (this.m_file != null) {
                this.m_execution = 11;
                return true;
            }
            this.m_error = "File name needed for backing up cache";
            return false;
        }
        if (sn.getFunctor().equals("sqlRestoreCacheNode")) {
            this.m_table = this.getTable(sn);
            if (this.m_table == null) {
                this.m_error = "Cache name needed for restoring  cache";
                return false;
            }
            this.m_file = this.getFile(sn);
            if (this.m_file != null) {
                this.m_execution = 12;
                return true;
            }
            this.m_error = "File name needed for restoring cache";
            return false;
        }
        if (sn.getFunctor().equals("sqlSourceNode")) {
            this.m_file = this.getFile(sn);
            if (this.m_file != null) {
                this.m_execution = 13;
                return true;
            }
            this.m_error = "File name needed for sourcing";
            return false;
        }
        this.m_error = "unknown translation tree";
        return false;
    }

    public Object execute() {
        return this.execute(null, false);
    }

    public Object execute(PrintWriter out, boolean trace) {
        this.m_error = null;
        RandomAccessFile f = null;
        switch (this.m_execution) {
            case 0: {
                ClassLoader cl = Base.getContextClassLoader();
                return CacheFactory.getCache(this.m_table).entrySet(this.m_filter);
            }
            case 1: {
                return CacheFactory.getCache(this.m_table).aggregate(this.m_filter, this.m_aggregator);
            }
            case 2: {
                return CacheFactory.getCache(this.m_table).aggregate(this.m_filter, this.m_aggregator);
            }
            case 3: {
                return CacheFactory.getCache(this.m_table).aggregate(this.m_filter, this.m_aggregator);
            }
            case 4: {
                return CacheFactory.getCache(this.m_table).invokeAll(this.m_filter, this.m_entryProcessor);
            }
            case 5: {
                Map m = CacheFactory.getCache(this.m_table).invokeAll(this.m_filter, this.m_entryProcessor);
                return m.entrySet();
            }
            case 6: {
                CacheFactory.getCache(this.m_table).addIndex(this.m_valueExtractor, true, null);
                return null;
            }
            case 7: {
                CacheFactory.getCache(this.m_table).removeIndex(this.m_valueExtractor);
                return null;
            }
            case 8: {
                CacheFactory.getCache(this.m_table).destroy();
                return null;
            }
            case 9: {
                return CacheFactory.getCache(this.m_table).put(this.m_insertKey, this.m_insertValue);
            }
            case 10: {
                CacheFactory.getCache(this.m_table);
                return null;
            }
            case 11: {
                try {
                    DataOutput outstream = f = new RandomAccessFile(new File(this.m_file), "rw");
                    NamedCache ch = CacheFactory.getCache(this.m_table);
                    CacheService serv = ch.getCacheService();
                    Serializer ser = serv.getSerializer();
                    if (ser instanceof PofContext) {
                        outstream = new PofOutputStream(new PofBufferWriter(new WrapperBufferOutput(outstream), (PofContext)ser));
                    }
                    ExternalizableHelper.writeMap(outstream, ch);
                }
                catch (IOException e) {
                    this.m_error = "IOException";
                    System.err.println("\n" + e);
                    throw new RuntimeException("Error in BACKUP", e);
                }
                finally {
                    if (f != null) {
                        try {
                            f.close();
                        }
                        catch (IOException e) {
                            this.m_error = "IOException";
                            System.err.println("\n" + e);
                        }
                    }
                }
                return null;
            }
            case 12: {
                try {
                    Closeable instream = f = new RandomAccessFile(new File(this.m_file), "rw");
                    NamedCache ch = CacheFactory.getCache(this.m_table);
                    CacheService serv = ch.getCacheService();
                    Serializer ser = serv.getSerializer();
                    if (ser instanceof PofContext) {
                        instream = new PofInputStream(new PofBufferReader(new WrapperBufferInput((DataInput)((Object)instream)), (PofContext)ser));
                    }
                    ExternalizableHelper.readMap(instream, ch, null);
                }
                catch (IOException e) {
                    this.m_error = "IOException";
                    System.err.println("\n" + e);
                    throw new RuntimeException("Error in RESTORE", e);
                }
                finally {
                    if (f != null) {
                        try {
                            f.close();
                        }
                        catch (IOException e) {
                            this.m_error = "IOException";
                            System.err.println("\n" + e);
                        }
                    }
                }
                return null;
            }
            case 13: {
                return this.source(this.m_file, out, trace);
            }
        }
        return null;
    }

    public boolean sanityCheck() {
        switch (this.m_execution) {
            case 0: {
                return this.testCacheName(this.m_table);
            }
            case 1: {
                return this.testCacheName(this.m_table);
            }
            case 2: {
                return this.testCacheName(this.m_table);
            }
            case 3: {
                return this.testCacheName(this.m_table);
            }
            case 4: {
                return this.testCacheName(this.m_table);
            }
            case 5: {
                return this.testCacheName(this.m_table);
            }
            case 6: {
                return this.testCacheName(this.m_table);
            }
            case 7: {
                return this.testCacheName(this.m_table);
            }
            case 8: {
                return this.testCacheName(this.m_table);
            }
            case 9: {
                return this.testCacheName(this.m_table);
            }
            case 10: {
                return true;
            }
            case 11: {
                return this.testCacheName(this.m_table);
            }
            case 12: {
                return this.testCacheName(this.m_table);
            }
            case 13: {
                return true;
            }
        }
        this.m_error = "unknown execution state!";
        return false;
    }

    public void showPlan(PrintWriter out) {
        if (out == null) {
            return;
        }
        switch (this.m_execution) {
            case 0: {
                out.println("CacheFactory.getCache(\"" + this.m_table + "\").entrySet(" + this.m_filter + ")");
                break;
            }
            case 1: {
                out.println("CacheFactory.getCache(\"" + this.m_table + "\").aggregate(" + this.m_filter + ", " + this.m_aggregator + ")");
                break;
            }
            case 2: {
                out.println("CacheFactory.getCache(\"" + this.m_table + "\").aggregate(" + this.m_filter + ", " + this.m_aggregator + ")");
                break;
            }
            case 3: {
                String cn = "";
                if (this.m_aggregator instanceof GroupAggregator) {
                    cn = "GroupAggregator.";
                } else if (this.m_aggregator instanceof CompositeAggregator) {
                    cn = "CompositeAggregator.";
                }
                out.println("CacheFactory.getCache(\"" + this.m_table + "\").aggregate(" + this.m_filter + ", " + cn + this.m_aggregator + ")");
                break;
            }
            case 4: {
                out.println("CacheFactory.getCache(\"" + this.m_table + "\").invokeAll(" + this.m_filter + ",\n" + this.m_entryProcessor + ")");
                break;
            }
            case 5: {
                out.println("CacheFactory.getCache(\"" + this.m_table + "\").invokeAll(" + this.m_filter + ", " + this.m_entryProcessor + ")");
                break;
            }
            case 6: {
                out.println("CacheFactory.getCache(\"" + this.m_table + "\").addIndex(" + this.m_valueExtractor + ", " + "true, null)");
                break;
            }
            case 7: {
                out.println("CacheFactory.getCache(\"" + this.m_table + "\").removeIndex(" + this.m_valueExtractor + ")");
                break;
            }
            case 8: {
                out.println("CacheFactory.getCache(\"" + this.m_table + "\").destroy()");
                break;
            }
            case 9: {
                out.println("CacheFactory.getCache(\"" + this.m_table + "\").put(" + this.m_insertKey + ", " + this.m_insertValue + ")");
                break;
            }
            case 10: {
                out.println("CacheFactory.getCache(\"" + this.m_table + "\")");
                break;
            }
            case 11: {
                out.println("ExternalizableHelpwer.writeMap(new RandomAccessFile(new File(\"" + this.m_file + "\"),\"rw\")," + "CacheFactory.getCache(\"" + this.m_table + "\"))");
                break;
            }
            case 12: {
                out.println("ExternalizableHelpwer.readMap(new RandomAccessFile(new File(\"" + this.m_file + "\"),\"rw\")," + "CacheFactory.getCache(\"" + this.m_table + "\"),null)");
                break;
            }
            case 13: {
                out.println("source(\"" + this.m_file + "\")");
                break;
            }
        }
    }

    public String getErrorString() {
        return this.m_error;
    }

    public int getFunction() {
        return this.m_execution;
    }

    protected String atomicStringValueOf(Term t) {
        if (t == null) {
            return null;
        }
        if (t.isAtom()) {
            return ((AtomicTerm)t).getValue();
        }
        return null;
    }

    protected String getTable(NodeTerm sn) {
        return this.atomicStringValueOf(sn.findAttribute("from"));
    }

    protected String getAlias(NodeTerm sn) {
        return this.atomicStringValueOf(sn.findAttribute("alias"));
    }

    protected String getFile(NodeTerm sn) {
        return this.atomicStringValueOf(sn.findAttribute("file"));
    }

    protected boolean getIsDestinct(NodeTerm sn) {
        String dist = this.atomicStringValueOf(sn.findAttribute("isDistinct"));
        return dist != null && dist.equals("true");
    }

    protected NodeTerm getWhere(NodeTerm sn) {
        Term t = sn.findChild("whereClause");
        if (t == null) {
            return null;
        }
        if (t.length() == 1) {
            return (NodeTerm)t.termAt(1);
        }
        return null;
    }

    protected Term getFields(NodeTerm sn) {
        return sn.findChild("fieldList");
    }

    protected Term getInsertKey(NodeTerm sn) {
        return sn.findAttribute("key");
    }

    protected Term getInsertValue(NodeTerm sn) {
        return sn.findAttribute("value");
    }

    protected Term getGroupBy(NodeTerm sn) {
        Term t = sn.findChild("groupBy");
        if (t == null) {
            return null;
        }
        if (t.length() == 0) {
            return null;
        }
        return t;
    }

    protected Term getSetList(NodeTerm sn) {
        return sn.findChild("setList");
    }

    protected Term getExtractor(NodeTerm sn) {
        return sn.findChild("extractor");
    }

    protected boolean headsMatch(NodeTerm fieldList, NodeTerm groupByList) {
        return groupByList.headChildrenTermEqual(fieldList);
    }

    public void setExtendedLanguage(boolean fExtendedLanguage) {
        this.m_fExtendedLanguage = fExtendedLanguage;
    }

    protected boolean testCacheName(String name) {
        if (!this.m_fValidateCache) {
            return true;
        }
        Cluster cl = CacheFactory.ensureCluster();
        Enumeration e = cl.getServiceNames();
        while (e.hasMoreElements()) {
            String serviceName = (String)e.nextElement();
            Service serv = cl.getService(serviceName);
            if (!(serv instanceof DistributedCacheService)) continue;
            DistributedCacheService dcs = (DistributedCacheService)serv;
            Enumeration e2 = dcs.getCacheNames();
            while (e2.hasMoreElements()) {
                String cacheName = (String)e2.nextElement();
                if (!cacheName.equals(name)) continue;
                return true;
            }
        }
        this.m_error = "cache " + name + " does not exist!";
        return false;
    }

    protected void traceout(String line, PrintWriter out, boolean trace) {
        if (trace && out != null) {
            out.println(line);
        }
    }

    protected Object source(String fn, PrintWriter out, boolean trace) {
        BufferedReader r;
        Object results = null;
        if (fn == null || fn.length() == 0) {
            return null;
        }
        try {
            r = new BufferedReader(new FileReader(fn));
        }
        catch (FileNotFoundException e) {
            this.m_error = "file not found " + fn;
            this.traceout(this.m_error, out, trace);
            return null;
        }
        TokenTable toks = this.m_fExtendedLanguage ? CoherenceQueryLanguage.getSqlTokenTable(true) : CoherenceQueryLanguage.sqlTokenTable();
        SQLOPParser p = new SQLOPParser(r, toks);
        do {
            Term pn = p.parse();
            this.traceout("\nParsed: " + pn, out, trace);
            CoherenceQuery query = new CoherenceQuery(false);
            query.setExtendedLanguage(this.m_fExtendedLanguage);
            if (query.build((NodeTerm)pn)) {
                if (trace) {
                    query.showPlan(out);
                }
                results = query.execute(out, trace);
            } else {
                this.m_error = "Error: " + query.getErrorString();
                this.traceout(this.m_error, out, trace);
            }
            p.getScanner().advanceWhenMatching(";");
        } while (!p.getScanner().isEnd());
        return results;
    }

    protected boolean buildForQueryRecorder(NodeTerm sn, Object[] env, Map map, QueryRecorder.RecordType type) {
        NodeTerm nodeStmt = (NodeTerm)sn.findChild("sqlSelectNode");
        if (nodeStmt == null) {
            nodeStmt = (NodeTerm)sn.findChild("sqlUpdateNode");
        }
        if (nodeStmt == null) {
            nodeStmt = (NodeTerm)sn.findChild("sqlDeleteNode");
        }
        this.m_table = this.getTable(nodeStmt);
        this.m_alias = this.getAlias(nodeStmt);
        this.m_where = this.getWhere(nodeStmt);
        if (this.m_where != null) {
            FilterBuilder fm = new FilterBuilder();
            fm.setAlias(this.m_alias);
            this.m_filter = fm.makeFilter(this.m_where, env, map);
        } else {
            this.m_filter = new AlwaysFilter();
        }
        this.m_fields = this.getFields(nodeStmt);
        this.m_groupBy = this.getGroupBy(nodeStmt);
        this.m_isDistinct = this.getIsDestinct(nodeStmt);
        this.m_aggregator = new QueryRecorder(type);
        this.m_execution = 3;
        return true;
    }
}

