/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.tangosol.coherence.dslquery.SQLDeleteOPToken;
import com.tangosol.coherence.dslquery.SQLOPToken;
import com.tangosol.coherence.dslquery.SQLSelectOPToken;
import com.tangosol.coherence.dslquery.SQLUpdateOPToken;
import com.tangosol.coherence.dsltools.precedence.OPParser;
import com.tangosol.coherence.dsltools.precedence.OPScanner;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;

public class SQLExplainOPToken
extends SQLOPToken {
    private static final SQLSelectOPToken SQL_SELECT_OP_TOKEN = new SQLSelectOPToken("select", "identifier");
    private static final SQLUpdateOPToken SQL_UPDATE_OP_TOKEN = new SQLUpdateOPToken("update", "identifier");
    private static final SQLDeleteOPToken SQL_DELETE_OP_TOKEN = new SQLDeleteOPToken("delete", "identifier");

    public SQLExplainOPToken(String id, String sNudASTName) {
        super(id, sNudASTName);
    }

    @Override
    public Term nud(OPParser p) {
        char cCurrent;
        OPScanner s = p.getScanner();
        String sCurrent = s.getCurrentAsString();
        if (sCurrent == null) {
            return super.nud(p);
        }
        if (sCurrent.length() == 1 && ((cCurrent = sCurrent.charAt(0)) == '.' || cCurrent == ',' || cCurrent == '(' || cCurrent == ';')) {
            return super.nud(p);
        }
        Term stmt = null;
        this.advanceToStmt(s);
        if (s.advanceWhenMatching("select")) {
            SQLSelectOPToken token = SQL_SELECT_OP_TOKEN;
            stmt = token.nud(p);
        } else if (s.advanceWhenMatching("update")) {
            SQLUpdateOPToken token = SQL_UPDATE_OP_TOKEN;
            stmt = token.nud(p);
        } else if (s.advanceWhenMatching("delete")) {
            SQLDeleteOPToken token = SQL_DELETE_OP_TOKEN;
            stmt = token.nud(p);
        }
        return new NodeTerm(this.getFunctor(), new Term[]{stmt});
    }

    protected void advanceToStmt(OPScanner s) {
        s.advance("plan");
        s.advance("for");
    }

    protected String getFunctor() {
        return "sqlExplainNode";
    }
}

