/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.tangosol.coherence.dslquery.AbstractCoherenceQueryWalker;
import com.tangosol.coherence.dslquery.PropertyBuilder;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.CompositeAggregator;
import com.tangosol.util.aggregator.Count;
import com.tangosol.util.aggregator.DistinctValues;
import com.tangosol.util.aggregator.DoubleAverage;
import com.tangosol.util.aggregator.DoubleMax;
import com.tangosol.util.aggregator.DoubleMin;
import com.tangosol.util.aggregator.DoubleSum;
import com.tangosol.util.aggregator.GroupAggregator;
import com.tangosol.util.aggregator.LongMax;
import com.tangosol.util.aggregator.LongMin;
import com.tangosol.util.aggregator.LongSum;
import com.tangosol.util.aggregator.ReducerAggregator;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.MultiExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.processor.CompositeProcessor;
import com.tangosol.util.processor.ExtractorProcessor;
import java.util.HashMap;
import java.util.Map;

public class SelectListMaker
extends AbstractCoherenceQueryWalker {
    protected NodeTerm m_target;
    protected Object m_out;
    protected AtomicTerm m_atom;
    protected int m_callCount = 0;
    protected PropertyBuilder m_pb = new PropertyBuilder();
    protected Object[] m_results;
    protected Object[] m_bindings;
    protected Map m_bindingEnv;

    public SelectListMaker() {
        this(new Object[0], new HashMap());
    }

    public SelectListMaker(Object[] env) {
        this(env, new HashMap());
    }

    public SelectListMaker(Object[] env, Map map) {
        this.m_bindings = env;
        this.m_bindingEnv = map;
    }

    public SelectListMaker(NodeTerm node) {
        this(node, new Object[0]);
    }

    public SelectListMaker(NodeTerm node, Object[] env) {
        this.m_target = node;
        this.m_bindings = env;
    }

    public boolean hasCalls() {
        return this.m_callCount > 0;
    }

    public boolean isAggregation() {
        return this.m_callCount == this.m_results.length;
    }

    public Object[] getResults() {
        return this.m_results;
    }

    public ValueExtractor getResultsAsValueExtractor() {
        if (this.hasCalls()) {
            return null;
        }
        if (this.m_results.length == 1) {
            return (ValueExtractor)this.m_results[0];
        }
        ValueExtractor[] extractors = new ValueExtractor[this.m_results.length];
        for (int i = 0; i < this.m_results.length; ++i) {
            extractors[i] = (ValueExtractor)this.m_results[i];
        }
        return new MultiExtractor(extractors);
    }

    public DistinctValues getDistinctValues() {
        if (this.hasCalls()) {
            return null;
        }
        return new DistinctValues(this.getResultsAsValueExtractor());
    }

    public InvocableMap.EntryProcessor getResultsAsEntryProcessor() {
        if (this.hasCalls()) {
            return null;
        }
        if (this.m_results.length == 1) {
            return new ExtractorProcessor((ValueExtractor)this.m_results[0]);
        }
        InvocableMap.EntryProcessor[] processors = new InvocableMap.EntryProcessor[this.m_results.length];
        for (int i = 0; i < this.m_results.length; ++i) {
            processors[i] = new ExtractorProcessor((ValueExtractor)this.m_results[i]);
        }
        return new CompositeProcessor(processors);
    }

    public InvocableMap.EntryAggregator getResultsAsReduction() {
        int identifierCount = this.m_results.length;
        if (this.hasCalls()) {
            return null;
        }
        if (identifierCount == 1) {
            return new ReducerAggregator((ValueExtractor)this.m_results[0]);
        }
        ValueExtractor[] extractors = new ValueExtractor[identifierCount];
        for (int i = 0; i < identifierCount; ++i) {
            extractors[i] = (ValueExtractor)this.m_results[i];
        }
        return new ReducerAggregator(new MultiExtractor(extractors));
    }

    public InvocableMap.EntryAggregator getResultsAsEntryAggregator() {
        InvocableMap.EntryAggregator aggregator;
        int identifierCount = this.m_results.length - this.m_callCount;
        if (!this.hasCalls()) {
            return null;
        }
        if (this.m_results.length == 1) {
            return (InvocableMap.EntryAggregator)this.m_results[0];
        }
        if (this.m_results.length == this.m_callCount) {
            InvocableMap.EntryAggregator[] aggregators = new InvocableMap.EntryAggregator[this.m_results.length];
            for (int i = 0; i < this.m_results.length; ++i) {
                aggregators[i] = (InvocableMap.EntryAggregator)this.m_results[i];
            }
            return CompositeAggregator.createInstance(aggregators);
        }
        ValueExtractor[] extractors = new ValueExtractor[identifierCount];
        for (int i = 0; i < identifierCount; ++i) {
            extractors[i] = (ValueExtractor)this.m_results[i];
        }
        if (this.m_callCount == 1) {
            aggregator = (InvocableMap.EntryAggregator)this.m_results[identifierCount];
        } else {
            InvocableMap.EntryAggregator[] aggregators = new InvocableMap.EntryAggregator[this.m_callCount];
            for (int i = 0; i < this.m_callCount; ++i) {
                aggregators[i] = (InvocableMap.EntryAggregator)this.m_results[identifierCount + i];
            }
            aggregator = CompositeAggregator.createInstance(aggregators);
        }
        if (identifierCount == 1) {
            return GroupAggregator.createInstance(extractors[0], aggregator);
        }
        return GroupAggregator.createInstance(new MultiExtractor(extractors), aggregator);
    }

    public Object[] makeSelects() {
        this.m_out = null;
        this.m_results = new Object[this.m_target.length()];
        int count = this.m_target.length();
        for (int i = 1; i <= count; ++i) {
            this.m_target.termAt(i).accept(this);
            this.m_results[i - 1] = this.m_out;
        }
        return this.m_results;
    }

    public Object[] makeSelects(NodeTerm node) {
        this.m_target = node;
        return this.makeSelects();
    }

    @Override
    public void acceptAtom(String functor, AtomicTerm atom) {
        this.m_out = atom.getObject();
        this.m_atom = atom;
    }

    @Override
    protected void acceptLiteral(AtomicTerm l) {
        this.m_out = l.getObject();
        this.m_atom = l;
    }

    @Override
    protected void acceptIdentifier(String s) {
        this.m_out = s.equalsIgnoreCase("null") ? null : (s.equalsIgnoreCase("true") ? Boolean.TRUE : (s.equalsIgnoreCase("false") ? Boolean.FALSE : new ReflectionExtractor(this.m_pb.extractorStringFor(s))));
    }

    @Override
    protected void acceptNumericBinding(int i) {
        this.m_out = this.m_bindings[i - 1];
    }

    @Override
    protected void acceptKeyedBinding(String key) {
        this.m_out = this.m_bindingEnv.get(key);
    }

    @Override
    protected void acceptCall(String function, NodeTerm args) {
        int count = args.length();
        Object[] oList = new Object[count];
        for (int i = 1; i <= count; ++i) {
            args.termAt(i).accept(this);
            oList[i - 1] = this.m_out;
        }
        ValueExtractor ve = null;
        if (oList.length > 0 && oList[0] instanceof ValueExtractor) {
            ve = (ValueExtractor)oList[0];
        }
        if (function.equalsIgnoreCase("max")) {
            ++this.m_callCount;
            this.m_out = new DoubleMax(ve);
        } else if (function.equalsIgnoreCase("min")) {
            ++this.m_callCount;
            this.m_out = new DoubleMin(ve);
        } else if (function.equalsIgnoreCase("sum")) {
            ++this.m_callCount;
            this.m_out = new DoubleSum(ve);
        } else if (function.equalsIgnoreCase("avg")) {
            ++this.m_callCount;
            this.m_out = new DoubleAverage(ve);
        } else if (function.equalsIgnoreCase("long_max")) {
            ++this.m_callCount;
            this.m_out = new LongMax(ve);
        } else if (function.equalsIgnoreCase("long_min")) {
            ++this.m_callCount;
            this.m_out = new LongMin(ve);
        } else if (function.equalsIgnoreCase("long_sum")) {
            ++this.m_callCount;
            this.m_out = new LongSum(ve);
        } else if (function.equalsIgnoreCase("count")) {
            ++this.m_callCount;
            this.m_out = new Count();
        } else if (function.equalsIgnoreCase("value")) {
            this.m_out = IdentityExtractor.INSTANCE;
        } else if (function.equalsIgnoreCase("key")) {
            if (ve instanceof ChainedExtractor) {
                ChainedExtractor ce = (ChainedExtractor)ve;
                ValueExtractor[] ave = ce.getExtractors();
                String m = ((ReflectionExtractor)ave[0]).getMethodName();
                Object[] p = ((ReflectionExtractor)ave[0]).getParameters();
                ave[0] = new ReflectionExtractor(m, p);
            } else if (ve instanceof ReflectionExtractor) {
                ReflectionExtractor re = (ReflectionExtractor)ve;
                ve = new ReflectionExtractor(re.getMethodName(), re.getParameters());
            }
            this.m_out = new KeyExtractor(ve);
        } else {
            this.m_out = new ReflectionExtractor(function, oList);
        }
    }

    @Override
    protected void acceptPath(NodeTerm list) {
        int count = list.length();
        ValueExtractor[] veList = new ValueExtractor[count];
        for (int i = 1; i <= count; ++i) {
            list.termAt(i).accept(this);
            veList[i - 1] = (ValueExtractor)this.m_out;
        }
        this.m_out = new ChainedExtractor(veList);
    }
}

