/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.dslquery;

import com.tangosol.coherence.dslquery.AbstractCoherenceQueryWalker;
import com.tangosol.coherence.dslquery.PropertyBuilder;
import com.tangosol.coherence.dsltools.termtrees.AtomicTerm;
import com.tangosol.coherence.dsltools.termtrees.NodeTerm;
import com.tangosol.coherence.dsltools.termtrees.Term;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.ValueUpdater;
import com.tangosol.util.extractor.ChainedExtractor;
import com.tangosol.util.extractor.CompositeUpdater;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import com.tangosol.util.extractor.ReflectionExtractor;
import com.tangosol.util.extractor.ReflectionUpdater;
import com.tangosol.util.processor.CompositeProcessor;
import com.tangosol.util.processor.NumberIncrementor;
import com.tangosol.util.processor.NumberMultiplier;
import com.tangosol.util.processor.UpdaterProcessor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class UpdateSetListMaker
extends AbstractCoherenceQueryWalker {
    protected NodeTerm m_target;
    protected Object m_out;
    protected AtomicTerm m_atom;
    protected Object[] m_results;
    protected Object[] m_bindings;
    protected Map m_bindingEnv;
    protected PropertyBuilder m_pb = new PropertyBuilder();
    protected boolean m_fRValueExpected = false;
    protected boolean m_fExtendedLanguage = false;

    public UpdateSetListMaker() {
        this(new Object[0]);
    }

    public UpdateSetListMaker(Object[] env) {
        this(env, new HashMap());
    }

    public UpdateSetListMaker(Object[] env, Map map) {
        this.m_bindings = env;
        this.m_bindingEnv = map;
    }

    public UpdateSetListMaker(NodeTerm node) {
        this(node, new Object[0]);
    }

    public UpdateSetListMaker(NodeTerm node, Object[] env) {
        this.m_bindings = env;
        this.m_target = node;
        this.m_results = new Object[this.m_target.length()];
    }

    public Object[] getResults() {
        return this.m_results;
    }

    public InvocableMap.EntryProcessor getResultAsEntryProcessor() {
        if (this.m_results.length == 1) {
            return (InvocableMap.EntryProcessor)this.m_results[0];
        }
        InvocableMap.EntryProcessor[] res = new InvocableMap.EntryProcessor[this.m_results.length];
        for (int i = 0; i < this.m_results.length; ++i) {
            res[i] = (InvocableMap.EntryProcessor)this.m_results[i];
        }
        return new CompositeProcessor(res);
    }

    public InvocableMap.EntryProcessor makeSetList() {
        this.m_out = null;
        this.m_results = new Object[this.m_target.length()];
        this.acceptTarget();
        return this.getResultAsEntryProcessor();
    }

    public InvocableMap.EntryProcessor makeSetList(NodeTerm node) {
        this.m_target = node;
        this.m_out = null;
        this.m_results = new Object[this.m_target.length()];
        this.acceptTarget();
        return this.getResultAsEntryProcessor();
    }

    public Object makeObject(NodeTerm node) {
        this.m_target = node;
        this.m_out = null;
        this.m_results = null;
        this.m_fRValueExpected = true;
        this.m_target.accept(this);
        String functor = node.getFunctor();
        if (this.needsObjectCreation(functor, node)) {
            this.m_out = this.reflectiveMakeObject(false, this.m_out);
        }
        return this.m_out;
    }

    public Object makeObjectForKey(NodeTerm node, Object ctx) {
        this.m_target = node;
        this.m_out = null;
        this.m_results = null;
        this.m_fRValueExpected = true;
        this.m_target.accept(this);
        String functor = node.getFunctor();
        if (functor.equals("unaryOperatorNode")) {
            return this.m_out;
        }
        if (functor.equals("callNode") && this.m_out instanceof ValueExtractor) {
            ValueExtractor ve = this.makeValueExtractor(this.m_out);
            this.m_out = ve.extract(ctx);
            return this.m_out;
        }
        if (functor.equals("identifier") && this.m_out instanceof String) {
            ValueExtractor ve = this.makeValueExtractor(this.m_out);
            this.m_out = ve.extract(ctx);
            return this.m_out;
        }
        if (functor.equals("derefNode")) {
            Object[] path = (Object[])this.m_out;
            int count = path.length;
            boolean fUseExtractor = false;
            if (!(path[count - 1] instanceof ReflectionExtractor)) {
                fUseExtractor = true;
            } else {
                for (int i = 0; i < count - 1; ++i) {
                    if (!(path[i] instanceof ReflectionExtractor)) continue;
                    fUseExtractor = true;
                    break;
                }
            }
            if (fUseExtractor) {
                ValueExtractor ve = this.makeValueExtractor(this.m_out);
                this.m_out = ve.extract(ctx);
                return this.m_out;
            }
        }
        try {
            if (this.needsObjectCreation(functor, node)) {
                this.m_out = this.reflectiveMakeObject(false, this.m_out);
            }
        }
        catch (Exception e) {
            if (functor.equals(".object.")) {
                throw new RuntimeException(e.getMessage());
            }
            ValueExtractor ve = this.makeValueExtractor(this.m_out);
            this.m_out = ve.extract(ctx);
        }
        return this.m_out;
    }

    @Override
    public void acceptNode(String functor, NodeTerm node) {
        if (this.m_fExtendedLanguage) {
            if (functor.equals(".list.")) {
                super.acceptNode("callNode", new NodeTerm("callNode", node));
            } else if (functor.equals(".bag.")) {
                super.acceptNode("callNode", new NodeTerm("callNode", node));
            } else if (functor.equals(".pair.")) {
                super.acceptNode("callNode", new NodeTerm("callNode", node));
            } else if (functor.equals(".object.")) {
                super.acceptNode("callNode", new NodeTerm("callNode", node));
            } else {
                super.acceptNode(functor, node);
            }
        } else {
            super.acceptNode(functor, node);
        }
    }

    @Override
    public void acceptAtom(String functor, AtomicTerm atom) {
        this.m_out = atom.getObject();
        this.m_atom = atom;
    }

    @Override
    protected void acceptLiteral(AtomicTerm l) {
        this.m_out = l.getObject();
        this.m_atom = l;
    }

    @Override
    protected void acceptList(NodeTerm list) {
        int count = list.length();
        Object[] ll = new Object[count];
        for (int i = 1; i <= count; ++i) {
            list.termAt(i).accept(this);
            ll[i - 1] = this.m_out;
        }
        this.m_out = ll;
    }

    @Override
    protected void acceptIdentifier(String s) {
        this.m_out = s.equalsIgnoreCase("null") ? null : (s.equalsIgnoreCase("true") ? Boolean.TRUE : (s.equalsIgnoreCase("false") ? Boolean.FALSE : s));
    }

    @Override
    protected void acceptBinaryOperator(String opName, Term left, Term right) {
        if (opName.equals("==")) {
            this.m_fRValueExpected = false;
            left.accept(this);
            ValueUpdater id = this.makeValueUpdater(this.m_out);
            this.m_fRValueExpected = true;
            right.accept(this);
            if (this.needsObjectCreation(right.getFunctor(), right)) {
                this.m_out = this.reflectiveMakeObject(false, this.m_out);
            }
            this.m_out = new UpdaterProcessor(id, this.m_out);
        } else if (opName.equals("+")) {
            left.accept(this);
            String id = this.makePathString(this.m_out);
            right.accept(this);
            if (right.isLeaf()) {
                this.m_out = new NumberIncrementor(id, (Number)this.m_out, false);
            } else {
                this.shouldNotSee("Argument to binary operator '+' not atomic");
            }
        } else if (opName.equals("*")) {
            left.accept(this);
            String id = this.makePathString(this.m_out);
            right.accept(this);
            if (right.isLeaf()) {
                this.m_out = new NumberMultiplier(id, (Number)this.m_out, false);
            } else {
                this.shouldNotSee("Argument to binary operator '*' not atomic");
            }
        } else {
            this.shouldNotSee("Unknown binary operator: " + opName);
        }
    }

    @Override
    protected void acceptUnaryOperator(String op, Term arg) {
        if (op.equals("new")) {
            arg.accept(this);
            this.m_out = this.reflectiveMakeObject(true, this.m_out);
        } else if (op.equals("-")) {
            arg.accept(this);
            if (this.m_atom.isNumber()) {
                this.m_out = this.m_atom.negativeNumber((Number)this.m_out);
            }
        } else if (op.equals("+")) {
            arg.accept(this);
        } else {
            this.shouldNotSee("Unknown unary operator: " + op);
        }
    }

    @Override
    protected void acceptNumericBinding(int offset) {
        this.m_out = this.m_bindings[offset - 1];
    }

    @Override
    protected void acceptKeyedBinding(String key) {
        this.m_out = this.m_bindingEnv.get(key);
    }

    @Override
    protected void acceptCall(String function, NodeTerm args) {
        int count = args.length();
        Object[] oList = new Object[count];
        for (int i = 1; i <= count; ++i) {
            Term trm = args.termAt(i);
            trm.accept(this);
            if (this.needsObjectCreation(trm.getFunctor(), trm)) {
                this.m_out = this.reflectiveMakeObject(false, this.m_out);
            }
            oList[i - 1] = this.m_out;
        }
        this.m_out = function.equalsIgnoreCase("key") && count == 0 ? new KeyExtractor(IdentityExtractor.INSTANCE) : (function.equalsIgnoreCase("value") && count == 0 ? IdentityExtractor.INSTANCE : (this.m_fExtendedLanguage ? (function.equals(".list.") ? this.makeListLiteral(oList) : (function.equals(".bag.") ? this.makeSetOrMapLiteral(oList) : (function.equals(".pair.") ? this.makePairLiteral(oList) : (function.equals("List") ? this.makeListLiteral(oList) : (function.equals("Set") ? this.makeSetLiteral(oList) : (function.equals("Map") ? this.makeMapLiteral(oList) : new ReflectionExtractor(function, oList))))))) : new ReflectionExtractor(function, oList)));
    }

    @Override
    protected void acceptPath(NodeTerm list) {
        int count = list.length();
        Object[] ao = new Object[count];
        for (int i = 1; i <= count; ++i) {
            list.termAt(i).accept(this);
            ao[i - 1] = this.m_out;
        }
        this.m_out = ao;
    }

    public void setExtendedLanguage(boolean fExtendedLanguage) {
        this.m_fExtendedLanguage = fExtendedLanguage;
    }

    protected void acceptTarget() {
        int count = this.m_target.length();
        for (int i = 1; i <= count; ++i) {
            this.m_target.termAt(i).accept(this);
            this.m_results[i - 1] = this.m_out;
        }
    }

    public String makePathString(Object obj) {
        if (obj instanceof IdentityExtractor) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof ReflectionExtractor) {
            ReflectionExtractor re = (ReflectionExtractor)obj;
            return re.getMethodName();
        }
        if (obj instanceof Object[]) {
            Object[] parts = (Object[])obj;
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < parts.length; ++i) {
                String s = this.makePathString(parts[i]);
                sb.append('.').append(s);
            }
            return sb.substring(1);
        }
        return null;
    }

    public ValueUpdater makeValueUpdater(Object obj) {
        if (obj instanceof IdentityExtractor) {
            return null;
        }
        if (obj instanceof String) {
            return new ReflectionUpdater(this.m_pb.updaterStringFor((String)obj));
        }
        if (obj instanceof ReflectionExtractor) {
            ReflectionExtractor re = (ReflectionExtractor)obj;
            return new ReflectionUpdater(re.getMethodName());
        }
        if (obj instanceof Object[]) {
            ValueUpdater vu;
            Object[] objs = (Object[])obj;
            ValueExtractor[] ve = new ValueExtractor[objs.length - 1];
            for (int i = 0; i < objs.length - 1; ++i) {
                Object o = objs[i];
                ve[i] = o instanceof String ? new ReflectionExtractor(this.m_pb.extractorStringFor((String)o)) : (ValueExtractor)o;
            }
            Object o = objs[objs.length - 1];
            if (o instanceof String) {
                vu = new ReflectionUpdater(this.m_pb.updaterStringFor((String)o));
            } else if (o instanceof ReflectionExtractor) {
                ReflectionExtractor re = (ReflectionExtractor)o;
                vu = new ReflectionUpdater(re.getMethodName());
            } else {
                vu = (ValueUpdater)o;
            }
            return new CompositeUpdater(new ChainedExtractor(ve), vu);
        }
        this.shouldNotSee("Unable to determine field to set from: " + obj);
        return null;
    }

    public ValueExtractor makeValueExtractor(Object obj) {
        if (obj instanceof String) {
            return new ReflectionExtractor(this.m_pb.extractorStringFor((String)obj));
        }
        if (obj instanceof ValueExtractor) {
            return (ValueExtractor)obj;
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            ValueExtractor[] ve = new ValueExtractor[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                Object o = objs[i];
                ve[i] = o instanceof String ? new ReflectionExtractor(this.m_pb.extractorStringFor((String)o)) : (ValueExtractor)o;
            }
            return new ChainedExtractor(ve);
        }
        this.shouldNotSee("Unable to determine extractor for: " + obj);
        return null;
    }

    private Object reflectiveMakeObject(boolean fuseNew, Object o) {
        ReflectionExtractor re;
        String cname = null;
        String sPath = "";
        String sMethod = "";
        Object[] args = null;
        if (o instanceof ReflectionExtractor) {
            re = (ReflectionExtractor)o;
            sMethod = re.getMethodName();
            args = re.getParameters();
        } else if (o instanceof Object[]) {
            Object[] objs = (Object[])this.m_out;
            int c = objs.length - 1;
            for (int i = 0; i < c; ++i) {
                sPath = sPath.length() > 0 ? sPath + "." + objs[i] : "" + objs[i];
            }
            re = (ReflectionExtractor)objs[objs.length - 1];
            sMethod = re.getMethodName();
            args = re.getParameters();
        }
        try {
            Class<?> objectClass;
            if (fuseNew) {
                cname = sPath.length() > 0 ? sPath + "." + sMethod : sMethod;
                objectClass = Class.forName(cname);
                return ClassHelper.newInstance(objectClass, args);
            }
            if (this.m_fExtendedLanguage && sMethod.equals(".object.")) {
                String cn = (String)args[0];
                cname = sPath.length() > 0 ? sPath + "." + cn : cn;
                objectClass = Class.forName(cname);
                Object inst = ClassHelper.newInstance(objectClass, new Object[0]);
                Map map = null;
                if (args.length != 2) {
                    throw new RuntimeException("Malformed object creation " + cname);
                }
                if (args[1] instanceof Map) {
                    map = (Map)args[1];
                    for (Map.Entry e : map.entrySet()) {
                        String setter = this.m_pb.updaterStringFor((String)e.getKey());
                        Object value = e.getValue();
                        ClassHelper.invoke(objectClass, inst, setter, new Object[]{value});
                    }
                }
                return inst;
            }
            if (sPath.length() == 0) {
                throw new RuntimeException("Malformed static call " + sMethod);
            }
            cname = sPath;
            objectClass = Class.forName(cname);
            return ClassHelper.invokeStatic(objectClass, sMethod, args);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.getMessage() + ": Unable to find class " + cname);
        }
        catch (InstantiationException e) {
            StringBuffer sb = new StringBuffer();
            sb.append(" Unable to instantiate ");
            sb.append(cname);
            sb.append(" with ");
            for (int indx = 0; indx < args.length; ++indx) {
                if (indx > 0) {
                    sb.append(", ");
                }
                sb.append(args[indx]);
            }
            throw new RuntimeException(e.getMessage() + " :" + sb.toString());
        }
        catch (InvocationTargetException e) {
            System.out.println(e);
            throw new RuntimeException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            StringBuffer sb = new StringBuffer();
            sb.append("Unable to find method ");
            sb.append(sMethod);
            sb.append(" on ");
            sb.append(cname);
            sb.append(" with: ");
            for (int indx = 0; indx < args.length; ++indx) {
                if (indx > 0) {
                    sb.append(", ");
                }
                sb.append(args[indx]);
            }
            throw new RuntimeException(e.getMessage() + " : " + sb.toString());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    protected void shouldNotSee(String message) {
        throw new RuntimeException(message);
    }

    protected void shouldNotSee() {
        throw new RuntimeException("unexpected error during tree processing");
    }

    protected boolean needsObjectCreation(String sfunctor, Term trm) {
        if (sfunctor.equals("derefNode")) {
            return true;
        }
        if (sfunctor.equals("callNode")) {
            if (this.m_fExtendedLanguage) {
                String sf = trm.termAt(1).getFunctor();
                return !sf.equals("List") && !sf.equals("Set") && !sf.equals("Map");
            }
            return true;
        }
        return this.m_fExtendedLanguage && sfunctor.equals(".object.");
    }

    protected Object makePairLiteral(Object[] args) {
        int count = args.length;
        if (count == 2) {
            return args;
        }
        throw new RuntimeException("Pairs must be lenght 2 instead of length 3");
    }

    protected Object makeListLiteral(Object[] args) {
        int count = args.length;
        ArrayList<Object> list = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            list.add(args[i]);
        }
        return list;
    }

    protected Object makeSetLiteral(Object[] args) {
        int count = args.length;
        HashSet<Object> set = new HashSet<Object>(count);
        for (int i = 0; i < count; ++i) {
            set.add(args[i]);
        }
        return set;
    }

    protected Object makeSetOrMapLiteral(Object[] args) {
        int count = args.length;
        if (count > 0 && this.isAllPairs(args)) {
            HashMap<Object, Object> map = new HashMap<Object, Object>(count);
            for (int i = 0; i < count; ++i) {
                Object[] aobj = (Object[])args[i];
                map.put(aobj[0], aobj[1]);
            }
            return map;
        }
        return this.makeSetLiteral(args);
    }

    private boolean isAllPairs(Object[] args) {
        for (Object obj : args) {
            Object[] aobj = null;
            if (obj instanceof Object[]) {
                aobj = (Object[])obj;
            }
            if (aobj != null && aobj.length == 2) continue;
            return false;
        }
        return true;
    }

    protected Object makeMapLiteral(Object[] args) {
        int count = args.length;
        HashMap<Object, Object> map = new HashMap<Object, Object>(count);
        for (int i = 0; i < count; ++i) {
            Object obj = args[i];
            Object[] aobj = null;
            if (obj instanceof Object[]) {
                aobj = (Object[])obj;
            }
            if (aobj == null || aobj.length != 2) {
                throw new RuntimeException("Incorrect for argument to literal Map :" + obj);
            }
            map.put(aobj[0], aobj[1]);
        }
        return map;
    }
}

