/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.mvel.ast;

import com.tangosol.coherence.mvel.CompileException;
import com.tangosol.coherence.mvel.DataConversion;
import com.tangosol.coherence.mvel.MVEL;
import com.tangosol.coherence.mvel.ParserContext;
import com.tangosol.coherence.mvel.ast.ASTNode;
import com.tangosol.coherence.mvel.compiler.ExecutableStatement;
import com.tangosol.coherence.mvel.integration.VariableResolverFactory;
import com.tangosol.coherence.mvel.util.ParseTools;

public class TypeCast
extends ASTNode {
    private ExecutableStatement statement;
    private boolean widen;

    public TypeCast(char[] expr, Class cast, int fields, ParserContext pCtx) {
        this.egressType = cast;
        this.name = expr;
        if ((fields & 0x10) != 0 && (this.statement = (ExecutableStatement)ParseTools.subCompileExpression(this.name, pCtx)).getKnownEgressType() != Object.class && !DataConversion.canConvert(cast, this.statement.getKnownEgressType())) {
            if (this.statement.getKnownEgressType().isAssignableFrom(cast)) {
                this.widen = true;
            } else {
                throw new CompileException("unable to cast type: " + this.statement.getKnownEgressType() + "; to: " + cast);
            }
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.widen ? TypeCast.typeCheck(this.statement.getValue(ctx, thisValue, factory), this.egressType) : DataConversion.convert(this.statement.getValue(ctx, thisValue, factory), this.egressType);
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.widen ? TypeCast.typeCheck(MVEL.eval(this.name, ctx, factory), this.egressType) : DataConversion.convert(MVEL.eval(this.name, ctx, factory), this.egressType);
    }

    private static Object typeCheck(Object inst, Class type) {
        if (inst == null) {
            return null;
        }
        if (type.isInstance(inst)) {
            return inst;
        }
        throw new ClassCastException(inst.getClass().getName() + " cannot be cast to: " + type.getClass().getName());
    }
}

