/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.coherence.reporter.DataSource;
import com.tangosol.coherence.reporter.FilterFactory;
import com.tangosol.coherence.reporter.MBeanQuery;
import com.tangosol.coherence.reporter.QueryHandler;
import com.tangosol.coherence.reporter.Reporter;
import com.tangosol.coherence.reporter.locator.ColumnLocator;
import com.tangosol.coherence.reporter.locator.CorrelatedLocator;
import com.tangosol.run.xml.SimpleElement;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import com.tangosol.util.ValueExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JMXQueryHandler
implements QueryHandler,
Constants {
    protected long m_lBatch;
    protected long m_ldtStartTime;
    protected List m_listColumns = null;
    protected List m_listQueryCol = null;
    protected Map m_mapColumns = null;
    protected List m_listXmlCol = null;
    protected String m_sQueryTemp;
    protected XmlElement m_xml;
    protected XmlElement m_xmlFilter;
    protected XmlElement m_xmlColumns;
    protected MBeanQuery m_mbeanQuery;
    protected DataSource m_source;
    protected Set m_setKeys;
    protected Object m_oCorrelated;
    protected boolean m_fGroupBy;
    public static Map m_mapColumnClass = new HashMap();

    @Override
    public void setContext(XmlElement xmlQuery, XmlElement xmlReportCfg) {
        if (this.m_xml == null) {
            this.m_xml = xmlReportCfg;
            this.m_xmlColumns = xmlReportCfg.getElement("row");
            this.m_sQueryTemp = xmlQuery.getSafeElement("pattern").getString();
            this.m_xmlFilter = xmlQuery.getSafeElement("filter-ref");
            this.m_listQueryCol = xmlQuery.getSafeElement("params").getElementList();
            this.m_listXmlCol = this.m_xmlColumns.getElementList();
            boolean fQueryEmpty = false;
            if (this.m_listQueryCol.size() == 0) {
                fQueryEmpty = true;
                this.m_listQueryCol = new ArrayList();
            }
            List listXmlCol = this.m_listXmlCol;
            for (XmlElement xmlColumn : listXmlCol) {
                boolean fSubQuery = xmlColumn.getSafeElement("subquery").getBoolean(false);
                if (fQueryEmpty && !fSubQuery) {
                    String sColumnRef = xmlColumn.getSafeAttribute("id").getString();
                    SimpleElement xmlTemp = new SimpleElement("column-ref", sColumnRef);
                    this.m_listQueryCol.add(xmlTemp);
                }
                this.m_fGroupBy |= xmlColumn.getSafeElement("group-by").getBoolean(false);
            }
        }
    }

    @Override
    public XmlElement getContext() {
        return this.m_xml;
    }

    public void setPattern(String sPattern) {
        this.m_sQueryTemp = sPattern;
    }

    @Override
    public void postProcess() {
        List listColumn = this.ensureColumnList();
        Set setKeys = this.m_setKeys;
        for (ColumnLocator columnLocator : listColumn) {
            if (columnLocator == null) continue;
            columnLocator.reset(setKeys);
        }
        this.m_source.postProcesS();
    }

    @Override
    public void execute() {
        this.m_ldtStartTime = System.currentTimeMillis();
        this.m_source = new DataSource();
        this.m_source.setGroupBy(this.m_fGroupBy);
        this.initColumns();
        MBeanQuery query = this.ensureBeanQuery();
        Set setKeys = (Set)this.getKeys();
        this.m_source.execute(query, setKeys);
    }

    @Override
    public Object getKeys() {
        Set setKeys;
        MBeanQuery mapBeans = this.ensureBeanQuery();
        XmlElement xmlFilters = this.m_xml.getElement("filters");
        if (xmlFilters == null) {
            setKeys = mapBeans.keySet();
        } else {
            Filter filter;
            FilterFactory configfilter = new FilterFactory(this, xmlFilters);
            String sId = this.m_xmlFilter.getString("");
            setKeys = sId.length() == 0 ? mapBeans.keySet() : ((filter = configfilter.getFilter(sId)) == null ? mapBeans.keySet() : mapBeans.keySet(filter));
        }
        this.m_setKeys = setKeys;
        return setKeys;
    }

    @Override
    public Set getGroupKeys() {
        return this.m_source.getGroupKeys();
    }

    @Override
    public Object getValue(Object key, Object oSourceId) {
        Map mapSources = this.ensureSourceMap();
        ColumnLocator qc = (ColumnLocator)mapSources.get(oSourceId);
        return qc == null ? null : qc.getValue(key);
    }

    @Override
    public boolean isAggregate(Object column) {
        Map mapColumns = this.ensureSourceMap();
        ColumnLocator qc = (ColumnLocator)mapColumns.get(column);
        return qc != null && qc.isAggregate();
    }

    @Override
    public boolean isDetail(Object column) {
        Map mapColumns = this.ensureSourceMap();
        ColumnLocator qc = (ColumnLocator)mapColumns.get(column);
        return qc != null && qc.isRowDetail();
    }

    protected void initColumns() {
        List listXmlCol = this.m_listQueryCol;
        Map mapColumns = this.ensureSourceMap();
        List listColumn = this.ensureColumnList();
        if (mapColumns.isEmpty()) {
            for (XmlElement xmlRef : listXmlCol) {
                String sColRef;
                ColumnLocator locator = this.ensureColumnLocator(xmlRef, sColRef = xmlRef.getString());
                if (locator == null) continue;
                listColumn.add(locator);
                mapColumns.put(locator.getId(), locator);
                if (!(locator instanceof CorrelatedLocator)) continue;
                ((CorrelatedLocator)locator).setCorrellatedObject(this.m_oCorrelated);
            }
        } else {
            for (ColumnLocator cl : listColumn) {
                cl.configure(cl.getConfig());
                cl.setDataSource(this.m_source);
                if (!(cl instanceof CorrelatedLocator)) continue;
                ((CorrelatedLocator)cl).setCorrellatedObject(this.m_oCorrelated);
            }
        }
    }

    public ColumnLocator ensureColumnLocator(XmlElement xmlColumn) {
        ColumnLocator columnLocator;
        XmlValue xmlId = xmlColumn.getAttribute("id");
        Map mapColumns = this.ensureSourceMap();
        XmlElement xmlColDef = xmlColumn;
        if (xmlId != null) {
            String sId = xmlId.getString();
            xmlColDef = this.getColumnCfg(xmlColumn, sId);
        }
        if ((columnLocator = (ColumnLocator)mapColumns.get(JMXQueryHandler.getColumnKey(xmlColumn))) == null) {
            try {
                columnLocator = JMXQueryHandler.newColumnLocator(xmlColDef);
                columnLocator.configure(xmlColDef, this, this.m_source);
                mapColumns.put(JMXQueryHandler.getColumnKey(xmlColDef), columnLocator);
            }
            catch (Exception e) {
                Base.log(e);
                return null;
            }
        }
        return columnLocator;
    }

    public Map ensureSourceMap() {
        HashMap mapColumns = this.m_mapColumns;
        if (mapColumns == null) {
            this.m_mapColumns = mapColumns = new HashMap();
        }
        return mapColumns;
    }

    public static ColumnLocator newColumnLocator(XmlElement xmlColumn) {
        String sClass;
        String sTypeValue = xmlColumn.getSafeElement("type").getString("attribute");
        if (sTypeValue.equals("custom")) {
            sClass = xmlColumn.getSafeElement("column-class").getString();
        } else {
            int nType = JMXQueryHandler.columnFromString(sTypeValue);
            switch (nType) {
                case 4: {
                    sTypeValue = sTypeValue + "," + xmlColumn.getSafeElement("name").getString();
                    break;
                }
                case 1: {
                    sTypeValue = sTypeValue + "," + xmlColumn.getSafeElement("function-name").getString();
                }
            }
            sClass = (String)m_mapColumnClass.get(sTypeValue);
        }
        if (sClass == null || sClass.length() == 0) {
            sClass = sTypeValue;
        }
        try {
            return (ColumnLocator)Class.forName(sClass).newInstance();
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Failed to instantiate QueryColumn " + sClass);
        }
    }

    protected List ensureColumnList() {
        LinkedList listColumns = this.m_listColumns;
        if (listColumns == null) {
            this.m_listColumns = listColumns = new LinkedList();
        }
        return listColumns;
    }

    protected XmlElement getColumnCfg(XmlElement xmlColumn, String sId) {
        XmlElement xmlColumnList = this.m_xmlColumns;
        List listXml = xmlColumnList.getElementList();
        for (XmlElement xmlSub : listXml) {
            String sTemp = xmlSub.getSafeAttribute("id").getString();
            if (!sTemp.equals(sId)) continue;
            return xmlSub;
        }
        Base.log("Unable to locate column-ref \"" + sId + "\"");
        return null;
    }

    protected static Object getColumnKey(XmlElement xmlColumn) {
        XmlValue xmlTemp = xmlColumn.getAttribute("id");
        if (xmlTemp == null) {
            return xmlColumn;
        }
        return xmlTemp.getString();
    }

    @Override
    public String replaceMacros(String sTemplate, Object oSource) {
        String sRet = sTemplate;
        Set setMacros = Reporter.getMacros(sTemplate);
        for (String sId : setMacros) {
            ValueExtractor ve = this.ensureExtractor(sId);
            Object oValue = ve.extract(oSource);
            if (oValue == null) continue;
            sRet = sRet.replaceAll("\\{" + sId + "\\}", oValue.toString());
        }
        return sRet;
    }

    public ColumnLocator ensureColumnLocator(XmlElement xmlColRef, String sId) {
        return this.ensureColumnLocator(this.getColumnCfg(xmlColRef, sId));
    }

    protected MBeanQuery ensureBeanQuery() {
        MBeanQuery query = this.m_mbeanQuery;
        if (query == null) {
            String sTemplate = this.m_sQueryTemp;
            String sQuery = this.replaceMacros(sTemplate, null);
            this.m_mbeanQuery = query = new MBeanQuery(sQuery);
        }
        return query;
    }

    public ValueExtractor ensureExtractor(XmlElement xmlColumn) {
        String sId = xmlColumn.getAttribute("id").getString();
        this.ensureColumnLocator(xmlColumn);
        return this.ensureExtractor(sId);
    }

    public ValueExtractor ensureExtractor(String sExtractorId) {
        ColumnLocator qc = this.ensureColumnLocator(null, sExtractorId);
        return qc.getExtractor();
    }

    @Override
    public void setCorrelated(Object oTarget) {
        this.m_oCorrelated = oTarget;
    }

    public long getBatch() {
        return this.m_lBatch;
    }

    protected void setBatch(long lBatch) {
        this.m_lBatch = lBatch;
    }

    public long getStartTime() {
        return this.m_ldtStartTime;
    }

    protected static int columnFromString(String sType) {
        if (sType.equals("global")) {
            return 4;
        }
        if (sType.equals("function")) {
            return 1;
        }
        if (sType.equals("method")) {
            return 2;
        }
        if (sType.equals("key")) {
            return 3;
        }
        if (sType.equals("")) {
            return 0;
        }
        if (sType.equals("attribute")) {
            return 0;
        }
        return -1;
    }

    static {
        String sBase = "com.tangosol.coherence.reporter.locator.";
        m_mapColumnClass.put("attribute", sBase + "AttributeLocator");
        m_mapColumnClass.put("subquery", sBase + "SubQueryLocator");
        m_mapColumnClass.put("constant", sBase + "ConstantLocator");
        m_mapColumnClass.put("correlated", sBase + "CorrelatedLocator");
        m_mapColumnClass.put("property", sBase + "PropertyLocator");
        m_mapColumnClass.put("global,{batch-counter}", sBase + "BatchLocator");
        m_mapColumnClass.put("global,{report-time}", sBase + "DateTimeLocator");
        m_mapColumnClass.put("key", sBase + "KeyLocator");
        m_mapColumnClass.put("function,sum", sBase + "SumLocator");
        m_mapColumnClass.put("function,count", sBase + "CountLocator");
        m_mapColumnClass.put("function,avg", sBase + "AverageLocator");
        m_mapColumnClass.put("function,min", sBase + "MinLocator");
        m_mapColumnClass.put("function,max", sBase + "MaxLocator");
        m_mapColumnClass.put("function,delta", sBase + "DeltaLocator");
        m_mapColumnClass.put("function,divide", sBase + "DivideLocator");
        m_mapColumnClass.put("function,add", sBase + "AddLocator");
        m_mapColumnClass.put("function,subtract", sBase + "SubtractLocator");
        m_mapColumnClass.put("function,multiply", sBase + "MultiplyLocator");
    }
}

