/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter;

import com.tangosol.coherence.reporter.ReportControl;
import com.tangosol.coherence.reporter.Reporter;
import com.tangosol.net.CacheFactory;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.TaskDaemon;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class ReportBatch
extends Base
implements Runnable,
ReportControl {
    private String m_sState = "Stopped";
    private String m_sLastReport;
    private String m_sOutputDir;
    private String m_sConfigFile;
    private long m_nCurrentBatch;
    private boolean m_fRun;
    private String[] m_asReports;
    private long m_nInterval;
    private XmlDocument m_xml;
    protected TaskDaemon m_daemon;
    private long m_ldtLastExectionMillis;
    private boolean m_fAutoStart;
    private boolean m_fCentralized = true;
    private XmlElement[] m_aParams;
    protected Map m_mapReporters = new HashMap();
    protected long m_lastRuntimeMillis;
    protected long m_maxRuntimeMillis;
    protected long m_cExecutionCount;
    protected long m_totalRuntimeMillis;
    public static final String STATE_STARTED = "Started";
    public static final String STATE_STOPPING = "Stopping";
    public static final String STATE_STOPPED = "Stopped";
    public static final String STATE_WAITING = "Sleeping";
    public static final String STATE_RUNNING = "Running";
    public static final String STATE_ERROR = "Error";
    public static final String TAG_FREQ = "frequency";
    public static final String TAG_LOCATION = "location";
    public static final String TAG_PARAMS = "init-params";
    public static final String TAG_DIR = "output-directory";
    public static final String TAG_LIST = "report-list";
    public static final String DEFAULT_FREQ = "60s";
    private ReportControl.Dependencies m_dependencies;
    protected DateFormat m_dateFormat;

    public static void main(String[] asArg) {
        if (asArg.length == 0) {
            ReportBatch.showUsage();
            return;
        }
        String sFile = asArg[0];
        System.setProperty("tangosol.coherence.management.report.configuration", sFile);
        System.setProperty("tangosol.coherence.management.report.autostart", "true");
        System.setProperty("tangosol.coherence.management.report.distributed", "false");
        while (true) {
            CacheFactory.ensureCluster();
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return;
            }
        }
    }

    @Override
    public void run() {
        long ldtStart = System.currentTimeMillis();
        ReportBatch model = this;
        Map map = this.m_mapReporters;
        model.setCurrentBatch(model.getCurrentBatch() + 1L);
        long nBatchId = model.getCurrentBatch();
        String[] aReport = model.getReports();
        XmlElement[] aParam = model.getParams();
        String sPath = this.m_sOutputDir;
        long cReports = aReport.length;
        model.setLastExectionMillis(System.currentTimeMillis());
        model.setState(STATE_RUNNING);
        int i = 0;
        while ((long)i < cReports) {
            Integer nKey = Base.makeInteger(i);
            String sDefFile = aReport[i];
            XmlElement xmlParam = aParam[i];
            Reporter reporter = (Reporter)map.get(nKey);
            if (reporter == null) {
                reporter = new Reporter();
                map.put(nKey, reporter);
            }
            reporter.setDateFormat(this.m_dateFormat);
            model.setLastReport(sDefFile);
            reporter.run(sDefFile, sPath, nBatchId, xmlParam, ReportBatch.class.getClassLoader());
            ++i;
        }
        this.updateStats(ldtStart);
        model.setState(STATE_WAITING);
    }

    public static void showUsage() {
        ReportBatch.out();
        ReportBatch.out("java com.tangosol.coherence.reporter.ReportBatch <config-file>");
        ReportBatch.out();
        ReportBatch.out("command option descriptions:");
        ReportBatch.out("\t<config-file> the file containing the report configuration XML");
        ReportBatch.out();
    }

    @Override
    public void configure() {
        String sFile = System.getProperty("tangosol.coherence.management.report.configuration");
        if (sFile != null && sFile.length() != 0) {
            Base.log("Configuring Report batch with file : " + sFile);
            boolean fStart = Boolean.valueOf(System.getProperty("tangosol.coherence.management.report.autostart"));
            boolean fCentral = Boolean.valueOf(System.getProperty("tangosol.coherence.management.report.distributed")) == false;
            DefaultReporterDependencies deps = new DefaultReporterDependencies();
            deps.setAutoStart(fStart);
            deps.setDistributed(fCentral);
            deps.setConfigFile(sFile);
            this.setDependencies(deps);
        }
    }

    @Override
    public TaskDaemon getDaemon() {
        return this.m_daemon;
    }

    @Override
    public void setDaemon(TaskDaemon daemon) {
        this.m_daemon = daemon;
    }

    @Override
    public boolean isRunning() {
        return this.m_fRun;
    }

    @Override
    public void setLastReport(String sLastReport) {
        this.m_sLastReport = sLastReport;
    }

    @Override
    public void setReports(String[] asReports) {
        this.m_asReports = asReports;
    }

    @Override
    public void setLastExectionMillis(long ldtTime) {
        this.m_ldtLastExectionMillis = ldtTime;
    }

    @Override
    public long getLastExectionMillis() {
        return this.m_ldtLastExectionMillis;
    }

    @Override
    public void setState(String sState) {
        this.m_sState = sState;
    }

    @Override
    public XmlDocument get_xml() {
        return this.m_xml;
    }

    @Override
    public void set_xml(XmlDocument xml) {
        this.m_xml = xml;
    }

    private String[] makeReportArray(XmlElement xmlReports) {
        List listReports = xmlReports.getElementList();
        String[] asReports = new String[listReports.size()];
        XmlElement[] axmlParam = new XmlElement[listReports.size()];
        int c = 0;
        for (XmlElement o : listReports) {
            asReports[c] = o.getSafeElement(TAG_LOCATION).getString();
            axmlParam[c] = o.getElement(TAG_PARAMS);
            ++c;
        }
        this.m_aParams = axmlParam;
        return asReports;
    }

    @Override
    public long getCurrentBatch() {
        return this.m_nCurrentBatch;
    }

    @Override
    public void setCurrentBatch(long nNewBatch) {
        this.m_nCurrentBatch = nNewBatch;
    }

    @Override
    public long getIntervalSeconds() {
        return this.m_nInterval / 1000L;
    }

    @Override
    public String getOutputPath() {
        return this.m_sOutputDir == null ? "" : new File(this.m_sOutputDir).getAbsolutePath();
    }

    @Override
    public void setOutputPath(String sPath) {
        this.m_sOutputDir = sPath;
    }

    @Override
    public void setIntervalSeconds(long nInterval) {
        this.m_nInterval = nInterval * 1000L;
    }

    @Override
    public String getConfigFile() {
        return this.m_sConfigFile;
    }

    @Override
    public String getState() {
        return this.m_sState;
    }

    public void setAutoStart(boolean fAutoStart) {
        this.m_fAutoStart = fAutoStart;
    }

    @Override
    public boolean isAutoStart() {
        return this.m_fAutoStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (!this.getState().equals(STATE_ERROR)) {
            ReportBatch reportBatch = this;
            synchronized (reportBatch) {
                this.m_fRun = false;
                this.setState(STATE_STOPPING);
                this.getDaemon().stop();
                this.setState(STATE_STOPPED);
                this.setDaemon(null);
                Base.log("anagement Reporting - Stopped");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.getState().equals(STATE_ERROR)) {
            Base.log("Management Reporting - An unrecoverable error has occurred. Reporter not started.");
        } else {
            ReportBatch reportBatch = this;
            synchronized (reportBatch) {
                TaskDaemon daemon = this.getDaemon();
                if (this.m_daemon == null && this.m_sConfigFile != null) {
                    ReportBatch oReport = this;
                    daemon = new TaskDaemon("Reporter");
                    daemon.schedulePeriodicTask(oReport, System.currentTimeMillis() + this.getIntervalSeconds() * 1000L, this.getIntervalSeconds() * 1000L);
                    Base.log("Management Reporting -  Started");
                    daemon.start();
                    this.setState(STATE_STARTED);
                    this.m_fRun = true;
                }
                this.setDaemon(daemon);
            }
        }
    }

    @Override
    public String[] getReports() {
        return this.m_asReports;
    }

    @Override
    public XmlElement[] getParams() {
        return this.m_aParams;
    }

    @Override
    public void setParams(XmlElement[] aXml) {
        this.m_aParams = aXml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConfigFile(String sInputFilename) {
        try {
            ReportBatch reportBatch = this;
            synchronized (reportBatch) {
                XmlDocument xml = XmlHelper.loadFileOrResource(sInputFilename, "Reporter configuration", ReportBatch.class.getClassLoader());
                this.set_xml(xml);
                this.m_sConfigFile = sInputFilename;
                this.setOutputPath(xml.getSafeElement(TAG_DIR).getString(""));
                this.setIntervalSeconds(Base.parseTime(xml.getSafeElement(TAG_FREQ).getString(DEFAULT_FREQ)) / 1000L);
                this.m_asReports = this.makeReportArray(xml.getSafeElement(TAG_LIST));
                this.m_mapReporters = new HashMap();
            }
        }
        catch (Exception e) {
            this.setState(STATE_ERROR);
            Base.log("Failed to start Reporter " + e);
        }
    }

    @Override
    public void runReport(String sReportFile) {
        if (!this.getState().equals(STATE_ERROR)) {
            new Reporter().run(sReportFile, this.m_sOutputDir, this.m_nCurrentBatch, null, ReportBatch.class.getClassLoader());
        }
    }

    @Override
    public String getLastReport() {
        return this.m_sLastReport;
    }

    @Override
    public Date getLastExecuteTime() {
        long ldtLastExeTime = this.getLastExectionMillis();
        if (ldtLastExeTime == 0L) {
            return null;
        }
        return new Date(ldtLastExeTime);
    }

    @Override
    public long getRunLastMillis() {
        return this.m_lastRuntimeMillis;
    }

    @Override
    public long getRunMaxMillis() {
        return this.m_maxRuntimeMillis;
    }

    @Override
    public double getRunAverageMillis() {
        return this.m_cExecutionCount == 0L ? 0.0 : (double)(this.m_totalRuntimeMillis / this.m_cExecutionCount);
    }

    @Override
    public void resetStatistics() {
        this.m_lastRuntimeMillis = 0L;
        this.m_maxRuntimeMillis = 0L;
        this.m_cExecutionCount = 0L;
        this.m_totalRuntimeMillis = 0L;
    }

    @Override
    public boolean isCentralized() {
        return this.m_fCentralized;
    }

    protected void updateStats(long ldtStart) {
        long lRuntime = System.currentTimeMillis() - ldtStart;
        ++this.m_cExecutionCount;
        this.m_maxRuntimeMillis = this.m_maxRuntimeMillis < lRuntime ? lRuntime : this.m_maxRuntimeMillis;
        this.m_totalRuntimeMillis += lRuntime;
        this.m_lastRuntimeMillis = lRuntime;
    }

    @Override
    public void setDependencies(ReportControl.Dependencies dps) {
        if (this.getDependencies() != null) {
            throw new IllegalStateException("Reporter dependencies cannot be reset");
        }
        this.m_dependencies = dps = new DefaultReporterDependencies(dps).validate();
        this.setAutoStart(dps.isAutoStart());
        this.setConfigFile(dps.getConfigFile());
        this.m_fCentralized = dps.isDistributed();
        String sTimezone = dps.getTimeZone();
        String sTimeStampFormat = dps.getDateFormat();
        this.m_dateFormat = new SimpleDateFormat(sTimeStampFormat);
        if (!sTimezone.isEmpty()) {
            this.m_dateFormat.setTimeZone(TimeZone.getTimeZone(sTimezone));
        }
    }

    @Override
    public ReportControl.Dependencies getDependencies() {
        return this.m_dependencies;
    }

    public static class LegacyXmlReporterDependencies
    extends DefaultReporterDependencies {
        public LegacyXmlReporterDependencies fromXml(XmlElement xml) {
            Base.azzert(xml.getName().equals("reporter"));
            this.setConfigFile(xml.getSafeElement("configuration").getString(this.getConfigFile()));
            this.setAutoStart(xml.getSafeElement("autostart").getBoolean(this.isAutoStart()));
            this.setDistributed(xml.getSafeElement("distributed").getBoolean(this.isDistributed()));
            this.setTimeZone(xml.getSafeElement("timezone").getString(this.getTimeZone()));
            this.setDateFormat(xml.getSafeElement("timeformat").getString(this.getDateFormat()));
            return this;
        }
    }

    private static class DefaultReporterDependencies
    implements ReportControl.Dependencies {
        protected String m_sConfigFile = "reports/report-group.xml";
        protected boolean m_autoStart = false;
        protected boolean m_distributed = false;
        protected String m_sTimezone = "";
        protected String m_sDateFormat = "EEE MMM dd HH:mm:ss zzz yyyy";

        public DefaultReporterDependencies() {
        }

        public DefaultReporterDependencies(ReportControl.Dependencies deps) {
            if (deps != null) {
                this.m_sConfigFile = deps.getConfigFile();
                this.m_autoStart = deps.isAutoStart();
                this.m_distributed = deps.isDistributed();
                this.m_sTimezone = deps.getTimeZone();
                this.m_sDateFormat = deps.getDateFormat();
            }
        }

        @Override
        public String getConfigFile() {
            return this.m_sConfigFile;
        }

        public DefaultReporterDependencies setConfigFile(String sConfFile) {
            this.m_sConfigFile = sConfFile;
            return this;
        }

        @Override
        public boolean isAutoStart() {
            return this.m_autoStart;
        }

        public DefaultReporterDependencies setAutoStart(boolean fAutoStart) {
            this.m_autoStart = fAutoStart;
            return this;
        }

        @Override
        public boolean isDistributed() {
            return this.m_distributed;
        }

        public DefaultReporterDependencies setDistributed(boolean fDistributed) {
            this.m_distributed = fDistributed;
            return this;
        }

        @Override
        public String getTimeZone() {
            return this.m_sTimezone;
        }

        public DefaultReporterDependencies setTimeZone(String sTimeZone) {
            this.m_sTimezone = sTimeZone;
            return this;
        }

        @Override
        public String getDateFormat() {
            return this.m_sDateFormat;
        }

        public DefaultReporterDependencies setDateFormat(String sTimeFormat) {
            this.m_sDateFormat = sTimeFormat;
            return this;
        }

        public DefaultReporterDependencies validate() {
            Base.checkNotNull(this.m_sConfigFile, "configuration");
            return this;
        }
    }
}

