/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.locator;

import com.tangosol.coherence.reporter.extractor.DeltaExtractor;
import com.tangosol.coherence.reporter.locator.BaseLocator;
import com.tangosol.coherence.reporter.locator.ColumnLocator;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ListMap;
import com.tangosol.util.ValueExtractor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DeltaLocator
extends BaseLocator {
    protected Map m_mapPrior = new HashMap();
    protected ColumnLocator m_columnLocator;
    protected ValueExtractor m_veSource;
    protected DeltaExtractor m_veDelta;
    protected Map m_mapKey = new ListMap();
    protected String m_sSourceId;

    @Override
    public void configure(XmlElement xml) {
        super.configure(xml);
        String sId = xml.getSafeElement("column-ref").getString();
        this.m_columnLocator = this.m_queryHandler.ensureColumnLocator(xml, sId);
        this.m_sSourceId = sId;
        this.buildExtractors();
        XmlElement xmlColumns = xml.getSafeElement("params");
        List listColumns = xmlColumns.getElementList();
        if (listColumns != null) {
            Iterator iter = listColumns.iterator();
            while (iter.hasNext()) {
                sId = ((XmlElement)iter.next()).getString();
                ValueExtractor ve = this.m_queryHandler.ensureExtractor(sId);
                this.m_mapKey.put(sId, ve);
            }
        }
    }

    @Override
    public ValueExtractor getExtractor() {
        super.getExtractor();
        return this.buildExtractors();
    }

    @Override
    public void reset(Set setResults) {
        ValueExtractor veSource = this.m_veSource;
        DeltaExtractor veDelta = this.m_veDelta;
        this.m_mapPrior.clear();
        for (Map.Entry entry : setResults) {
            Object oValue = veSource.extract(entry.getKey());
            Object oKey = veDelta.getKey(entry.getKey());
            this.putPrior(oKey, oValue);
        }
        this.m_veExtractor = null;
        this.m_veSource = null;
        this.m_veDelta = null;
    }

    @Override
    public boolean isRowDetail() {
        return this.m_columnLocator.isRowDetail();
    }

    public void putPrior(Object oKey, Object oValue) {
        this.m_mapPrior.put(oKey, oValue);
    }

    protected ValueExtractor buildExtractors() {
        if (this.m_veSource == null) {
            this.m_veSource = this.m_queryHandler.ensureExtractor(this.m_sSourceId);
        }
        if (this.m_veDelta == null) {
            this.m_veDelta = new DeltaExtractor(this.m_mapPrior, this.m_veSource, this.m_mapKey);
        }
        return this.m_veDelta;
    }
}

