/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.reporter.locator;

import com.tangosol.coherence.reporter.Constants;
import com.tangosol.coherence.reporter.Reporter;
import com.tangosol.coherence.reporter.extractor.SubQueryExtractor;
import com.tangosol.coherence.reporter.locator.BaseLocator;
import com.tangosol.coherence.reporter.locator.ColumnLocator;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.util.ValueExtractor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class SubQueryLocator
extends BaseLocator
implements Constants {
    protected XmlElement m_xmlQuery;
    protected List m_filterColumns;
    protected ColumnLocator m_asColumnLocator;
    protected String m_sSourceId;
    protected boolean m_fCorrelated;

    @Override
    public void configure(XmlElement xmlConfig) {
        super.configure(xmlConfig);
        this.m_xmlQuery = xmlConfig.getSafeElement("query");
        XmlElement xmlColumns = xmlConfig.getSafeElement("params");
        XmlElement xmlRef = xmlConfig.getSafeElement("column-ref");
        String sColumnRef = xmlRef.getString();
        List listColumns = xmlColumns.getElementList();
        int nParamCount = listColumns.size();
        this.m_filterColumns = new ArrayList(nParamCount);
        this.m_sSourceId = sColumnRef;
    }

    @Override
    public ValueExtractor getExtractor() {
        if (this.m_veExtractor == null) {
            String sPattern = this.m_xmlQuery.getSafeElement("pattern").getString();
            Set setMacros = Reporter.getMacros(sPattern);
            ValueExtractor[] veCorrelated = new ValueExtractor[setMacros.size()];
            int c = 0;
            for (String sId : setMacros) {
                veCorrelated[c] = this.m_queryHandler.ensureExtractor(sId);
            }
            this.m_fCorrelated = setMacros.size() > 0;
            this.m_veExtractor = new SubQueryExtractor(veCorrelated, this.m_xmlQuery, this.m_queryHandler, this.m_sSourceId);
        }
        return this.m_veExtractor;
    }

    @Override
    public boolean isRowDetail() {
        return this.m_fCorrelated;
    }
}

