/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.SimpleXid;
import com.tangosol.coherence.transaction.internal.ValuesKeyExtractor;
import com.tangosol.coherence.transaction.internal.ValuesKeyIndex;
import com.tangosol.coherence.transaction.internal.XidManager;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.storage.TableInfo;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMapHelper;
import com.tangosol.util.MapIndex;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.filter.ArrayFilter;
import com.tangosol.util.filter.IndexAwareFilter;
import com.tangosol.util.filter.KeyFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FilterWrapper
implements IndexAwareFilter,
ExternalizableLite,
PortableObject {
    private Filter m_filter;
    private String m_sTable;
    private transient ServiceContext m_context;
    private long m_lVersion;
    private TransactionId m_currentXid;
    private Set m_currentXidSynKeys = new HashSet();
    private transient LocalPartitionState m_localPartitionState = null;

    public FilterWrapper() {
    }

    public FilterWrapper(Filter filter, ServiceContext context, String sTable) {
        this.m_filter = filter;
        this.m_context = context;
        this.m_sTable = sTable;
    }

    public FilterWrapper(Filter filter, ServiceContext context, String sTable, long lVersion, TransactionId currentXid, Set currentXidSynKeys) {
        this.m_filter = filter;
        this.m_context = context;
        this.m_sTable = sTable;
        this.m_lVersion = lVersion;
        this.m_currentXid = currentXid;
        this.m_currentXidSynKeys = currentXidSynKeys;
    }

    @Override
    public boolean evaluate(Object o) {
        return this.m_filter.evaluate(o);
    }

    @Override
    public boolean evaluateEntry(Map.Entry entry) {
        String sService;
        TableInfoImpl info;
        XidSyntheticKey xidSynKey;
        Object oValue = entry.getValue();
        if (!Storage.NIL.equals(oValue) && this.includeInResults(xidSynKey = XidManager.getXidSynKeyFromEntry((BinaryEntry)entry, info = new TableInfoImpl(this.m_sTable, sService = this.m_context.getServiceName())), info, this.getVersion(sService))) {
            Object oNaturalKey = XidManager.getNaturalKey(xidSynKey, info);
            return InvocableMapHelper.evaluateEntry(this.m_filter, new SimpleMapEntry(oNaturalKey, oValue));
        }
        return false;
    }

    @Override
    public int calculateEffectiveness(Map map, Set set) {
        if (this.m_filter instanceof IndexAwareFilter) {
            return ((IndexAwareFilter)this.m_filter).calculateEffectiveness(map, set);
        }
        return 1;
    }

    @Override
    public Filter applyIndex(Map map, Set set) {
        if (this.m_filter instanceof IndexAwareFilter) {
            Filter filter = ((IndexAwareFilter)this.m_filter).applyIndex(map, set);
            HashSet<Binary> setKeep = new HashSet<Binary>();
            String sService = this.m_context.getServiceName();
            TableInfoImpl info = new TableInfoImpl(this.m_sTable, sService);
            ValuesKeyIndex keyIndex = ValuesKeyExtractor.getIndex(info);
            for (Object oKey : set) {
                Binary binKey = (Binary)oKey;
                XidSyntheticKey xidSynKey = this.getXidSyntheticKey(binKey, keyIndex);
                if (!this.includeInResults(xidSynKey, info, this.getVersion(sService))) continue;
                setKeep.add(binKey);
            }
            set.retainAll(setKeep);
            return filter == null ? null : new FilterWrapper(this.convertFilterKeys(filter, keyIndex, info), this.m_context, this.m_sTable, this.m_lVersion, this.m_currentXid, this.m_currentXidSynKeys);
        }
        return this;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_filter = (Filter)ExternalizableHelper.readObject(in);
        this.m_context = (ServiceContext)ExternalizableHelper.readExternalizableLite(in);
        this.m_sTable = (String)ExternalizableHelper.readObject(in);
        this.m_lVersion = in.readLong();
        this.m_currentXid = (TransactionId)ExternalizableHelper.readObject(in);
        this.m_currentXidSynKeys = new HashSet();
        ExternalizableHelper.readCollection(in, this.m_currentXidSynKeys, null);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_filter);
        ExternalizableHelper.writeExternalizableLite(out, this.m_context);
        ExternalizableHelper.writeObject(out, this.m_sTable);
        out.writeLong(this.m_lVersion);
        ExternalizableHelper.writeObject(out, this.m_currentXid);
        ExternalizableHelper.writeCollection(out, this.m_currentXidSynKeys);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_filter = (Filter)in.readObject(1);
        this.m_context = (ServiceContext)in.readObject(2);
        this.m_sTable = in.readString(3);
        this.m_lVersion = in.readLong(4);
        this.m_currentXid = new SimpleXid(in.readLong(5));
        in.readCollection(6, this.m_currentXidSynKeys);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(1, this.m_filter);
        out.writeObject(2, this.m_context);
        out.writeString(3, this.m_sTable);
        out.writeLong(4, this.m_lVersion);
        out.writeLong(5, this.m_currentXid.getId());
        out.writeCollection(6, this.m_currentXidSynKeys);
    }

    public void setVersion(long lVersion) {
        this.m_lVersion = lVersion;
    }

    public void setCurrentXid(TransactionId currentXid) {
        this.m_currentXid = currentXid;
    }

    public void setCurrentXidSynKeys(Set currentXidSynKeys) {
        if (currentXidSynKeys == null) {
            currentXidSynKeys = new HashSet();
        }
        this.m_currentXidSynKeys = currentXidSynKeys;
    }

    private boolean includeInResults(XidSyntheticKey xidSynKey, TableInfo tableInfo, long lVersion) {
        return XidManager.isKeyVisibleByTx(xidSynKey, this.m_currentXid, this.m_currentXidSynKeys, lVersion, tableInfo);
    }

    private long getVersion(String sService) {
        return this.m_lVersion == Long.MAX_VALUE ? LocalMemberState.getMemberState(sService).getCurrentWriteVersion() : this.m_lVersion;
    }

    private Filter convertFilterKeys(Filter filter, MapIndex index, TableInfo info) {
        if (filter instanceof KeyFilter) {
            HashSet<Object> newKeys = new HashSet<Object>();
            Set setKeys = ((KeyFilter)filter).getKeys();
            for (Object oKey : setKeys) {
                if (oKey instanceof Binary) {
                    XidSyntheticKey xidSynKey = this.getXidSyntheticKey((Binary)oKey, index);
                    Object oNaturalKey = XidManager.getNaturalKey(xidSynKey, info);
                    newKeys.add(oNaturalKey);
                    continue;
                }
                return filter;
            }
            return new KeyFilter(newKeys);
        }
        if (filter instanceof ArrayFilter) {
            Filter[] aFilter = ((ArrayFilter)filter).getFilters();
            for (int i = 0; i < aFilter.length; ++i) {
                aFilter[i] = this.convertFilterKeys(aFilter[i], index, info);
            }
        }
        return filter;
    }

    private XidSyntheticKey getXidSyntheticKey(Binary binKey, MapIndex index) {
        XidSyntheticKey xidSynKey = null;
        if (index != null) {
            xidSynKey = (XidSyntheticKey)index.get(binKey);
        }
        Serializer serializer = this.m_context.getSchema().getStorageSerializer();
        return xidSynKey == null ? (XidSyntheticKey)ExternalizableHelper.fromBinary(binKey, serializer) : xidSynKey;
    }
}

