/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.MapEventValue;
import com.tangosol.coherence.transaction.internal.storage.KeyIndex;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.storage.StorageImpl;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfo;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapEventTransformer;
import com.tangosol.util.NullImplementation;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MapEventTransformerImpl
implements MapEventTransformer,
ExternalizableLite,
PortableObject {
    private String m_sTable;
    private String m_sService;
    private boolean m_fFilterOnKey = false;
    private Object m_oKey;
    private Filter m_filter;

    public MapEventTransformerImpl() {
    }

    MapEventTransformerImpl(String sTable, String sService) {
        this.m_sTable = sTable;
        this.m_sService = sService;
    }

    MapEventTransformerImpl(String sTable, String sService, Object oKey) {
        this.m_sTable = sTable;
        this.m_sService = sService;
        this.m_oKey = oKey;
        this.m_fFilterOnKey = true;
    }

    MapEventTransformerImpl(String sTable, String sService, Filter filter) {
        this.m_sTable = sTable;
        this.m_sService = sService;
        this.m_filter = filter;
    }

    @Override
    public MapEvent transform(MapEvent event) {
        Object naturalKey = this.getNaturalKey(event);
        MapEvent newEvent = null;
        if (!this.m_fFilterOnKey || Base.equals(this.m_oKey, naturalKey)) {
            Storage storage = this.getStorage();
            TableInfoImpl info = new TableInfoImpl(this.m_sTable, this.m_sService);
            Object oVal = this.getValue(event, storage, info);
            Object oOldVal = this.getOldValue(event, storage, info);
            int nId = 2;
            if (Storage.NIL.equals(oVal)) {
                if (Storage.NIL.equals(oOldVal)) {
                    return null;
                }
                nId = 3;
                oVal = null;
            } else if (Storage.NIL.equals(oOldVal)) {
                nId = 1;
                oOldVal = null;
            }
            if (this.m_filter == null || this.m_filter.evaluate(new MapEvent(NullImplementation.getObservableMap(), nId, naturalKey, oOldVal, oVal))) {
                newEvent = this.getNewEvent(event, nId, naturalKey, oOldVal, oVal);
            }
        }
        return newEvent;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sTable = (String)ExternalizableHelper.readObject(in);
        this.m_sService = (String)ExternalizableHelper.readObject(in);
        this.m_fFilterOnKey = in.readBoolean();
        this.m_oKey = ExternalizableHelper.readObject(in);
        this.m_filter = (Filter)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_sTable);
        ExternalizableHelper.writeObject(out, this.m_sService);
        out.writeBoolean(this.m_fFilterOnKey);
        ExternalizableHelper.writeObject(out, this.m_oKey);
        ExternalizableHelper.writeObject(out, this.m_filter);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sTable = in.readString(1);
        this.m_sService = in.readString(2);
        this.m_fFilterOnKey = in.readBoolean(3);
        this.m_oKey = in.readObject(4);
        this.m_filter = (Filter)in.readObject(5);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(1, this.m_sTable);
        out.writeString(2, this.m_sService);
        out.writeBoolean(3, this.m_fFilterOnKey);
        out.writeObject(4, this.m_oKey);
        out.writeObject(5, this.m_filter);
    }

    protected LocalPartitionState getLocalPartitionState(int iPartition) {
        return LocalMemberState.getMemberState(this.m_sService).ensureLocalPartitionState(iPartition);
    }

    protected synchronized Storage getStorage() {
        return new StorageImpl();
    }

    private MapEvent getNewEvent(MapEvent event, int nId, Object newKey, Object oOldVal, Object oVal) {
        return new MapEvent(event.getMap(), event.getId(), newKey, oOldVal, new MapEventValue(oVal, nId));
    }

    private Object getNaturalKey(MapEvent event) {
        XidSyntheticKey xidKey = (XidSyntheticKey)event.getKey();
        long lKey = xidKey.getKey();
        int iPartition = SyntheticKey.getPartition(lKey);
        long index = SyntheticKey.getIndex(lKey);
        LocalPartitionState lps = this.getLocalPartitionState(iPartition);
        KeyIndex keyIndex = lps.getKeyIndex(this.m_sTable);
        Object oNaturalKey = keyIndex.getNaturalKey(index);
        if (oNaturalKey != null || keyIndex.containsNaturalKey(index)) {
            return oNaturalKey;
        }
        CacheFactory.log(String.format("%s %s", "Can't find natural key for event transformation. Event:", event.toString()), 2);
        return null;
    }

    private Object getValue(MapEvent event, Storage storage, TableInfo info) {
        return storage.read(info, event.getKey());
    }

    private Object getOldValue(MapEvent event, Storage storage, TableInfo info) {
        XidSyntheticKey xidKey = (XidSyntheticKey)event.getKey();
        int iPartition = SyntheticKey.getPartition(xidKey.getKey());
        SyntheticKey synKey = new SyntheticKey(xidKey.getKey());
        TransactionId xidOld = this.getLocalPartitionState(iPartition).ensureVersionIndex(this.m_sTable).getPreviousXid(synKey, xidKey.getXid());
        Object oOldVal = Storage.NIL;
        if (xidOld != null) {
            XidSyntheticKey xidKeyOld = new XidSyntheticKey(synKey, xidOld);
            oOldVal = storage.read(info, xidKeyOld);
        }
        return oOldVal;
    }
}

