/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Results
implements Map,
ExternalizableLite,
PortableObject {
    private Map m_mapClientData = new HashMap();
    private Map m_mapUpdatedCacheData = new HashMap();
    private SessionData m_sessionData = new SessionData();
    private RuntimeException m_exception;

    public boolean wasRowModified(String sTable, Object oNatKey) {
        return this.getSessionData().containsKey(sTable, oNatKey);
    }

    public void addClientData(Object oKey, Object oVal) {
        this.put(oKey, oVal);
    }

    public void addClientData(Map mapVals) {
        this.putAll(mapVals);
    }

    public void addSyntheticKey(String sTable, Object oNatKey, Object oSynKey) {
        this.m_sessionData.addSyntheticKey(sTable, oNatKey, oSynKey);
    }

    public void addInvokeData(Object oKey, Object oVal) {
        this.m_mapUpdatedCacheData.put(oKey, oVal);
    }

    public void applyToSession(Transaction tx) {
        this.m_sessionData.applyToSession(tx);
    }

    public Results combine(Results other) {
        if (other == null) {
            return this;
        }
        if (other.m_mapClientData != null) {
            this.m_mapClientData.putAll(other.m_mapClientData);
        }
        if (other.m_mapUpdatedCacheData != null) {
            this.m_mapUpdatedCacheData.putAll(other.m_mapUpdatedCacheData);
        }
        for (Map.Entry entry : other.getSessionData().m_mapSynKeys.entrySet()) {
            String sTable = (String)entry.getKey();
            Map map = (Map)entry.getValue();
            this.m_sessionData.addSyntheticKeys(sTable, map);
        }
        this.m_sessionData.setPartitionVersion(Math.max(this.getSessionData().getPartitionVersion(), other.getSessionData().getPartitionVersion()));
        if (other.hasError()) {
            this.m_exception = other.getException();
        }
        return this;
    }

    public boolean hasError() {
        return this.m_exception != null;
    }

    public void setPartitionVersion(long lVersion) {
        this.m_sessionData.setPartitionVersion(lVersion);
    }

    public Map getClientData() {
        RuntimeException ex = this.getException();
        if (ex == null) {
            return this.m_mapClientData;
        }
        throw ex;
    }

    public SessionData getSessionData() {
        return this.m_sessionData;
    }

    public Map getInvokeData() {
        return this.m_mapUpdatedCacheData;
    }

    public void setException(RuntimeException e) {
        this.m_exception = e;
    }

    public RuntimeException getException() {
        return this.m_exception;
    }

    @Override
    public int size() {
        return this.m_mapClientData.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_mapClientData.isEmpty();
    }

    @Override
    public boolean containsKey(Object oKey) {
        return this.m_mapClientData.containsKey(oKey);
    }

    @Override
    public boolean containsValue(Object oVal) {
        return this.m_mapClientData.containsValue(oVal);
    }

    public Object get(Object oKey) {
        return this.m_mapClientData.get(oKey);
    }

    public Object put(Object oKey, Object oVal) {
        return this.m_mapClientData.put(oKey, oVal);
    }

    public Object remove(Object oKey) {
        return this.m_mapClientData.remove(oKey);
    }

    public void putAll(Map map) {
        this.m_mapClientData.putAll(map);
    }

    @Override
    public void clear() {
        this.m_mapClientData.clear();
    }

    public Set keySet() {
        return this.m_mapClientData.keySet();
    }

    public Collection values() {
        return this.m_mapClientData.values();
    }

    public Set entrySet() {
        return this.m_mapClientData.entrySet();
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        ExternalizableHelper.readMap(in, this.m_mapClientData, null);
        ExternalizableHelper.readMap(in, this.m_mapUpdatedCacheData, null);
        this.m_sessionData.m_lPartitionVersion = ExternalizableHelper.readLong(in);
        ExternalizableHelper.readMap(in, this.m_sessionData.m_mapSynKeys, null);
        this.m_exception = (RuntimeException)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeMap(out, this.m_mapClientData);
        ExternalizableHelper.writeMap(out, this.m_mapUpdatedCacheData);
        ExternalizableHelper.writeLong(out, this.m_sessionData.m_lPartitionVersion);
        ExternalizableHelper.writeMap(out, this.m_sessionData.m_mapSynKeys);
        ExternalizableHelper.writeObject(out, this.m_exception);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        in.readMap(1, this.m_mapClientData);
        in.readMap(2, this.m_mapUpdatedCacheData);
        this.m_sessionData.m_lPartitionVersion = in.readLong(3);
        in.readMap(4, this.m_sessionData.m_mapSynKeys);
        byte[] bytes = in.readByteArray(5);
        if (bytes != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            try {
                this.m_exception = (RuntimeException)ois.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Unable to de-serialize Exception: " + e);
            }
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeMap(1, this.m_mapClientData);
        out.writeMap(2, this.m_mapUpdatedCacheData);
        out.writeLong(3, this.m_sessionData.m_lPartitionVersion);
        out.writeMap(4, this.m_sessionData.m_mapSynKeys);
        if (this.m_exception == null) {
            out.writeByteArray(5, null);
        } else {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oas = new ObjectOutputStream(baos);
            oas.writeObject(this.m_exception);
            oas.close();
            out.writeByteArray(5, baos.toByteArray());
        }
    }

    public class SessionData {
        private long m_lPartitionVersion = -1L;
        private final Map<String, Map<Object, Object>> m_mapSynKeys = new HashMap<String, Map<Object, Object>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSyntheticKey(String sTable, Object oNatKey, Object oSynKey) {
            Map<String, Map<Object, Object>> map = this.m_mapSynKeys;
            synchronized (map) {
                Map<Object, Object> map2 = this.m_mapSynKeys.get(sTable);
                if (map2 == null) {
                    map2 = new HashMap<Object, Object>();
                    this.m_mapSynKeys.put(sTable, map2);
                }
                map2.put(oNatKey, oSynKey);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSyntheticKeys(String sTable, Map mapKeys) {
            Map<String, Map<Object, Object>> map = this.m_mapSynKeys;
            synchronized (map) {
                Map<Object, Object> map2 = this.m_mapSynKeys.get(sTable);
                if (map2 == null) {
                    this.m_mapSynKeys.put(sTable, mapKeys);
                } else {
                    map2.putAll(mapKeys);
                }
            }
        }

        public void applyToSession(Transaction tx) {
            tx.setCommitVersion(this.getPartitionVersion() + 1L);
            for (Map.Entry<String, Map<Object, Object>> entry : this.m_mapSynKeys.entrySet()) {
                String sTable = entry.getKey();
                Map<Object, Object> mapNatSynKeys = entry.getValue();
                Collection<Object> synKeys = mapNatSynKeys.values();
                HashSet<XidSyntheticKey> xidSynKeys = new HashSet<XidSyntheticKey>(synKeys.size());
                Iterator<Object> synKeyIter = synKeys.iterator();
                while (synKeyIter.hasNext()) {
                    xidSynKeys.add(new XidSyntheticKey((SyntheticKey)synKeyIter.next(), tx.getXid()));
                }
                tx.getSession().recordSyntheticKeys(sTable, xidSynKeys);
            }
        }

        public void setPartitionVersion(long lVersion) {
            this.m_lPartitionVersion = lVersion;
        }

        public long getPartitionVersion() {
            return this.m_lPartitionVersion;
        }

        private boolean containsKey(String sTable, Object oNatKey) {
            Map<Object, Object> map = this.m_mapSynKeys.get(sTable);
            return map != null && map.containsKey(oNatKey);
        }
    }
}

