/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.Isolation;
import com.tangosol.coherence.transaction.Status;
import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.TransactionState;
import com.tangosol.coherence.transaction.exception.RollbackException;
import com.tangosol.coherence.transaction.internal.Endpoint;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.Transaction;
import com.tangosol.coherence.transaction.internal.operation.CommitOperation;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.operation.RollbackOperation;
import com.tangosol.coherence.transaction.internal.storage.JmxStats;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.Session;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class TransactionImpl
implements Transaction,
TransactionState {
    private ServiceContext m_context;
    private Isolation m_isolation = Isolation.READ_COMMITTED;
    private State m_state = State.ACTIVE;
    private final boolean m_fAutoCommit;
    private boolean m_fEager;
    private int m_nTimeout = 300;
    private TransactionId m_xid;
    private final Session m_session;
    private Set<Transaction.TransactionStateListener> m_setStateListeners = new HashSet<Transaction.TransactionStateListener>();
    private final Lock m_lock = new ReentrantLock();
    private String m_sRollbackMsg;

    public TransactionImpl(TransactionId xid, Session session, boolean fEager, boolean fAutoCommit, ServiceContext context) {
        this.m_xid = xid;
        this.m_session = session;
        this.m_fAutoCommit = fAutoCommit;
        this.m_context = context;
        this.m_fEager = fEager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        this.m_lock.lock();
        try {
            State stateInitial = this.getState();
            this.setState(stateInitial.commit(this));
            if (this.m_state == State.ROLLEDBACK) {
                StringBuilder msg = new StringBuilder("The transaction was rolled back. ");
                if (this.m_sRollbackMsg != null) {
                    msg.append(this.m_sRollbackMsg);
                }
                throw new RollbackException(msg.toString());
            }
            this.assertStateChange(stateInitial);
        }
        finally {
            this.m_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() {
        this.m_lock.lock();
        try {
            State stateInitial = this.getState();
            this.setState(stateInitial.rollback(this));
            this.assertStateChange(stateInitial);
        }
        finally {
            this.m_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setRollbackOnly(String sMsg) {
        if (!this.m_lock.tryLock()) {
            return false;
        }
        try {
            this.setState(this.getState().setRollbackOnly(this, sMsg));
            boolean bl = this.m_state == State.RB_ONLY;
            return bl;
        }
        finally {
            this.m_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCommitted() {
        this.m_lock.lock();
        try {
            State stateInitial = this.getState();
            this.setState(stateInitial.setCommitted());
            this.assertStateChange(stateInitial);
        }
        finally {
            this.m_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRolledback() {
        this.m_lock.lock();
        try {
            State stateInitial = this.getState();
            this.setState(stateInitial.setRolledback(this));
            this.assertStateChange(stateInitial);
        }
        finally {
            this.m_lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setCommitVersion(long lVersion) {
        if (!this.m_lock.tryLock()) {
            return false;
        }
        try {
            State state = this.getState().setCommitVersion(this, lVersion);
            boolean bl = state != State.ERROR;
            return bl;
        }
        finally {
            this.m_lock.unlock();
        }
    }

    @Override
    public void setIsolation(Isolation isolation) {
        this.m_isolation = isolation;
    }

    @Override
    public Session getSession() {
        return this.m_session;
    }

    @Override
    public long getTimestamp() {
        return this.getSession().getTimestamp();
    }

    @Override
    public void setEager(boolean fEager) {
        this.m_fEager = fEager;
    }

    @Override
    public boolean isEager() {
        return this.m_fEager;
    }

    @Override
    public void setTimeout(int nSeconds) {
        this.m_nTimeout = nSeconds;
    }

    @Override
    public int getTimeout() {
        return this.m_nTimeout;
    }

    @Override
    public void registerStateChangeListener(Transaction.TransactionStateListener listener) {
        this.m_setStateListeners.add(listener);
    }

    @Override
    public Isolation getIsolation() {
        return this.m_isolation;
    }

    @Override
    public TransactionId getXid() {
        return this.m_xid;
    }

    @Override
    public Status getStatus() {
        return Status.values()[this.m_state.ordinal()];
    }

    @Override
    public boolean isAutoCommit() {
        return this.m_fAutoCommit;
    }

    @Override
    public boolean isTimedOut() {
        return this.m_session.getActiveMillis() >= (long)(this.m_nTimeout * 1000);
    }

    private void assertStateChange(State state) {
        if (this.getState() == State.ERROR) {
            throw new IllegalStateException("Operation called in illegal state: " + (Object)((Object)state));
        }
    }

    private void handleCommit() {
        Session session = this.getSession();
        String sService = this.getContext().getServiceName();
        Set<String> setTables = session.getModifiedTables();
        if (!setTables.isEmpty()) {
            for (String sTable : setTables) {
                CommitOperation commitOp = new CommitOperation(sService);
                this.dispatchOpertation(commitOp, sTable);
            }
        }
        JmxStats jmxStats = LocalMemberState.getMemberState(sService).getJmxStats();
        jmxStats.incrementCommitCount();
        jmxStats.incrementTotalTransactionMillis(this.getSession().getActiveMillis());
    }

    private void handleRollback() {
        Session session = this.getSession();
        session.flushPendingTranscript();
        Set<String> setTables = session.getModifiedTables();
        String sService = this.getContext().getServiceName();
        if (!setTables.isEmpty()) {
            for (String sTable : setTables) {
                RollbackOperation rollbackOp = new RollbackOperation(sService);
                this.dispatchOpertation(rollbackOp, sTable);
            }
        }
        JmxStats jmxStats = LocalMemberState.getMemberState(sService).getJmxStats();
        jmxStats.incrementRollbackCount();
        jmxStats.incrementTotalTransactionMillis(session.getActiveMillis());
    }

    protected void dispatchOpertation(Operation op, String sTable) {
        op.setTableName(sTable);
        op.setXid(this.getXid());
        Message msg = new Message(op);
        msg.setContext(this);
        Endpoint ep = this.getContext().getCompositionManager().getEndpoint("local-director");
        ep.dispatch(msg);
    }

    protected void handlePrepare() {
        throw new UnsupportedOperationException("Prepare is only supported for XA transaction branches");
    }

    protected void setState(State state) {
        this.m_state = state;
        this.fireStateChangedEvent(this.getStatus());
    }

    protected State getState() {
        return this.m_state;
    }

    protected ServiceContext getContext() {
        return this.m_context;
    }

    private void fireStateChangedEvent(Status status) {
        for (Transaction.TransactionStateListener listener : this.m_setStateListeners) {
            listener.stateChanged(status);
        }
    }

    protected static enum State {
        ACTIVE{

            @Override
            public State prepare(TransactionImpl tx) {
                tx.setState(PREPARING);
                tx.handlePrepare();
                return PREPARED;
            }

            @Override
            public State commit(TransactionImpl tx) {
                tx.setState(COMMITTING);
                tx.handleCommit();
                return COMMITTED;
            }

            @Override
            public State rollback(TransactionImpl tx) {
                tx.setState(ROLLINGBACK);
                tx.handleRollback();
                return ROLLEDBACK;
            }

            @Override
            public State setRollbackOnly(TransactionImpl tx, String sMsg) {
                tx.m_sRollbackMsg = sMsg;
                return RB_ONLY;
            }

            @Override
            public State setCommitted() {
                return COMMITTED;
            }

            @Override
            public State setRolledback(TransactionImpl tx) {
                return ROLLEDBACK;
            }

            @Override
            public State setCommitVersion(TransactionImpl tx, long lVersion) {
                tx.getSession().setCommitVersion(lVersion);
                return this;
            }
        }
        ,
        COMMITTING{

            @Override
            public State setCommitted() {
                return ACTIVE.setCommitted();
            }

            @Override
            public State setCommitVersion(TransactionImpl tx, long lVersion) {
                tx.getSession().setCommitVersion(lVersion);
                return this;
            }

            @Override
            public State rollback(TransactionImpl tx) {
                return ACTIVE.rollback(tx);
            }
        }
        ,
        ROLLINGBACK{

            @Override
            public State setRolledback(TransactionImpl tx) {
                return ACTIVE.setRolledback(tx);
            }
        }
        ,
        PREPARING{

            @Override
            public State rollback(TransactionImpl tx) {
                return ACTIVE.rollback(tx);
            }

            @Override
            public State setCommitVersion(TransactionImpl tx, long lVersion) {
                tx.getSession().setCommitVersion(lVersion);
                return this;
            }
        }
        ,
        COMMITTED{}
        ,
        ROLLEDBACK{}
        ,
        PREPARED{

            @Override
            public State commit(TransactionImpl tx) {
                return ACTIVE.commit(tx);
            }

            @Override
            public State rollback(TransactionImpl tx) {
                return ACTIVE.rollback(tx);
            }
        }
        ,
        RB_ONLY{

            @Override
            public State commit(TransactionImpl tx) {
                return ACTIVE.rollback(tx);
            }

            @Override
            public State rollback(TransactionImpl tx) {
                return ACTIVE.rollback(tx);
            }

            @Override
            public State prepare(TransactionImpl tx) {
                return ACTIVE.rollback(tx);
            }
        }
        ,
        ERROR{};


        public State commit(TransactionImpl tx) {
            return ERROR;
        }

        public State rollback(TransactionImpl tx) {
            return ERROR;
        }

        public State prepare(TransactionImpl tx) {
            return ERROR;
        }

        public State setRollbackOnly(TransactionImpl tx, String sMsg) {
            return this;
        }

        public State setCommitted() {
            return ERROR;
        }

        public State setRolledback(TransactionImpl tx) {
            return ERROR;
        }

        public State setCommitVersion(TransactionImpl tx, long lVersion) {
            return ERROR;
        }
    }
}

