/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal;

import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.SessionManager;
import com.tangosol.coherence.transaction.internal.storage.FixedPartitionKey;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.PartitionIdentity;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.VersionDependencyManager;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Member;
import com.tangosol.net.MemberEvent;
import com.tangosol.net.MemberListener;
import com.tangosol.net.NamedCache;
import com.tangosol.net.PartitionedService;
import com.tangosol.net.Service;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.aggregator.AbstractAggregator;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.extractor.KeyExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class VersionManager
implements Runnable,
MemberListener {
    private volatile PartitionedService m_service;
    private volatile boolean m_fStarted = false;
    private volatile boolean m_fRun = true;
    private volatile Set<FixedPartitionKey> m_setPartitions = null;
    private ServiceContext m_serviceContext;
    private Schema m_schema;
    private volatile boolean m_fListenerRegistered;
    private volatile Member m_localMember;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberJoined(MemberEvent event) {
        this.ensureInitialized(event.getService());
        Member evtMember = event.getMember();
        if (evtMember.equals(this.m_localMember)) {
            VersionManager versionManager = this;
            synchronized (versionManager) {
                if (!this.isRunning()) {
                    this.start();
                }
            }
        }
    }

    @Override
    public void memberLeft(MemberEvent event) {
        Member evtMember = event.getMember();
        if (evtMember.equals(this.m_localMember)) {
            this.stop();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void memberLeaving(MemberEvent event) {
    }

    @Override
    public void run() {
        CacheFactory.log("Started version manager", 3);
        SessionManager sessionManager = this.m_serviceContext.getSessionManager();
        long lCRVersion = -1L;
        while (this.shouldThreadContinue()) {
            block5: {
                try {
                    if (this.m_serviceContext.hasOwnershipEnabledMembers()) {
                        this.ensureListenerRegistered();
                        if (this.isVersionSenior()) {
                            lCRVersion = this.aggregateConsistentReadVersion(lCRVersion);
                        }
                        sessionManager.doSessionManagement();
                    }
                }
                catch (Exception e) {
                    if (!this.m_serviceContext.hasOwnershipEnabledMembers()) break block5;
                    CacheFactory.log("Transaction Version Manager caught exception: " + e, 2);
                    CacheFactory.log(e);
                }
            }
            this.sleep();
        }
        this.m_fStarted = false;
    }

    private boolean isVersionSenior() {
        return this.m_localMember.equals(this.m_service.getKeyOwner("KEY"));
    }

    private boolean shouldThreadContinue() {
        return this.m_fRun && !Thread.currentThread().isInterrupted() && CacheFactory.getCluster().isRunning();
    }

    private void ensureListenerRegistered() {
        if (!this.m_fListenerRegistered) {
            VersionListener versionListener = new VersionListener(this.m_serviceContext.getServiceName());
            this.m_schema.getVersionManagerTable().addMapListener((MapListener)versionListener, "KEY", false);
            this.m_fListenerRegistered = true;
        }
    }

    private void start() {
        this.m_fStarted = true;
        this.m_serviceContext.getThreadPool().execute(this);
    }

    private void stop() {
        this.m_fRun = false;
        this.m_fListenerRegistered = false;
    }

    private long aggregateConsistentReadVersion(long lCRVersion) {
        long[] laVersion;
        NamedCache versionCache = this.m_schema.getVersionManagerTable();
        if ((lCRVersion = this.ensureVersionInitialized(lCRVersion, versionCache)) < (laVersion = (long[])versionCache.aggregate(this.getVersionAggregationKeys(), (InvocableMap.EntryAggregator)new VersionAggregator(this.m_serviceContext.getServiceName())))[0]) {
            lCRVersion = laVersion[0];
        } else {
            laVersion[0] = lCRVersion;
        }
        versionCache.put("KEY", laVersion);
        return lCRVersion;
    }

    private Set<FixedPartitionKey> getVersionAggregationKeys() {
        if (this.m_setPartitions == null) {
            this.m_setPartitions = this.m_schema.getPartitionSetKeys();
        }
        return this.m_setPartitions;
    }

    private long ensureVersionInitialized(long lCRVersion, NamedCache versionCache) {
        if (lCRVersion == -1L) {
            Object oVersions = versionCache.get("KEY");
            lCRVersion = oVersions == null ? 0L : ((long[])oVersions)[0];
        }
        return lCRVersion;
    }

    public boolean isRunning() {
        return this.m_fStarted;
    }

    private void sleep() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            CacheFactory.log("VersionManager sleep interrupted", 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureInitialized(Service service) {
        if (this.m_localMember == null) {
            VersionManager versionManager = this;
            synchronized (versionManager) {
                if (this.m_localMember == null) {
                    this.m_service = (PartitionedService)service;
                    this.m_serviceContext = ServiceContext.getContext(this.m_service.getInfo().getServiceName());
                    if (this.m_serviceContext != null) {
                        this.m_schema = this.m_serviceContext.getSchema();
                        this.m_localMember = this.m_schema.getLocalMember();
                    }
                }
            }
        }
    }

    private static class VersionListener
    implements MapListener {
        private LocalMemberState m_lms;

        public VersionListener(String sService) {
            this.m_lms = LocalMemberState.getMemberState(sService);
        }

        @Override
        public void entryDeleted(MapEvent evt) {
        }

        @Override
        public void entryInserted(MapEvent evt) {
            this.updateLocalMemberState(evt);
        }

        @Override
        public void entryUpdated(MapEvent evt) {
            this.updateLocalMemberState(evt);
        }

        private void updateLocalMemberState(MapEvent evt) {
            long[] laVersions = (long[])evt.getNewValue();
            this.m_lms.setConsistentReadVersion(laVersions[0]);
            this.m_lms.setCurrentWriteVersion(laVersions[1]);
        }
    }

    public static class VersionAggregator
    extends AbstractAggregator
    implements ExternalizableLite,
    PortableObject {
        private String m_sService;
        private long[] m_laVersions = new long[]{Long.MAX_VALUE, -1L};

        public VersionAggregator() {
        }

        public VersionAggregator(String sService) {
            super(new KeyExtractor(IdentityExtractor.INSTANCE));
            this.m_sService = sService;
        }

        @Override
        protected void init(boolean fFinal) {
        }

        @Override
        protected void process(Object oKey, boolean fFinal) {
            PartitionIdentity key = (PartitionIdentity)oKey;
            int iPartition = key.getPartition();
            LocalMemberState lms = LocalMemberState.getMemberState(this.m_sService);
            LocalPartitionState lps = lms.ensureLocalPartitionState(iPartition);
            VersionDependencyManager dependencyManager = lps.getDependencyManager();
            this.compareVersions(this.m_laVersions, dependencyManager.getLastStableVersion(), lms.getCurrentWriteVersion());
        }

        @Override
        public Object aggregateResults(Collection collResults) {
            this.init(true);
            long[] laAggregatedVersions = new long[2];
            long lMinStable = Long.MAX_VALUE;
            long lMaxCurrent = -1L;
            laAggregatedVersions[0] = lMinStable;
            laAggregatedVersions[1] = lMaxCurrent;
            for (Object collResult : collResults) {
                long[] laVersions = (long[])collResult;
                this.compareVersions(laAggregatedVersions, laVersions[0], laVersions[1]);
            }
            return laAggregatedVersions;
        }

        @Override
        protected Object finalizeResult(boolean fFinal) {
            return this.m_laVersions;
        }

        private void compareVersions(long[] la, long lStableVer, long lCurrentVer) {
            if (lStableVer < la[0]) {
                la[0] = lStableVer;
            }
            if (lCurrentVer > la[1]) {
                la[1] = lCurrentVer;
            }
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
            super.readExternal(in);
            this.m_sService = (String)ExternalizableHelper.readObject(in);
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
            super.writeExternal(out);
            ExternalizableHelper.writeObject(out, this.m_sService);
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
            super.readExternal(in);
            this.m_sService = in.readString(10);
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
            super.writeExternal(out);
            out.writeString(10, this.m_sService);
        }
    }
}

