/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.LockManager;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfo;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.util.InvocableMap;
import java.util.Set;

public class StorageLock
implements Component {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message invoke(Message msg) {
        Operation op = msg.getOperation();
        TransactionId xid = op.getXid();
        Set entries = (Set)msg.getContext();
        TableInfoImpl tableInfo = new TableInfoImpl(op.getTableName(), op.getServiceName());
        for (Object oEntry : entries) {
            InvocableMap.Entry entry = (InvocableMap.Entry)oEntry;
            SyntheticKey syntheticKey = this.ensureSyntheticKey(entry, tableInfo);
            boolean fNewlyLocked = false;
            try {
                fNewlyLocked = new LockManager().acquireLock(xid, tableInfo, syntheticKey);
            }
            finally {
                if (fNewlyLocked) continue;
                msg.bind("newly-locked", false);
            }
        }
        return msg;
    }

    private SyntheticKey ensureSyntheticKey(InvocableMap.Entry entry, TableInfo tableInfo) {
        Object oNaturalKey = entry.getKey();
        SyntheticKey synKey = (SyntheticKey)entry.getValue();
        if (synKey == null) {
            String sTable = tableInfo.getTableName();
            Schema schema = ServiceContext.getContext(tableInfo.getServiceName()).getSchema();
            int iPartition = schema.getPartition(oNaturalKey);
            LocalPartitionState lps = LocalMemberState.getMemberState(tableInfo.getServiceName()).getLocalPartitionState(iPartition);
            synKey = lps.getKeyIndex(sTable).takeSyntheticKey(oNaturalKey);
            lps.getKeyIndex(sTable).addKey(synKey.getIndex(), oNaturalKey);
            entry.setValue(synKey);
        }
        return synKey;
    }
}

