/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.component;

import com.tangosol.coherence.transaction.internal.Message;
import com.tangosol.coherence.transaction.internal.Results;
import com.tangosol.coherence.transaction.internal.component.Component;
import com.tangosol.coherence.transaction.internal.operation.Operation;
import com.tangosol.coherence.transaction.internal.storage.KeyIndex;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import java.util.Map;
import java.util.Set;

public abstract class StorageQuery
implements Component {
    @Override
    public Message invoke(Message msg) {
        Results results = msg.getResults();
        Operation operation = msg.getOperation();
        String sService = operation.getServiceName();
        Set entries = (Set)msg.getContext();
        for (Map.Entry entry : entries) {
            long key = ((XidSyntheticKey)entry.getKey()).getKey();
            SyntheticKey syntheticKey = new SyntheticKey(key);
            int iPartition = SyntheticKey.getPartition(key);
            LocalPartitionState lps = LocalMemberState.getMemberState(sService).ensureLocalPartitionState(iPartition);
            KeyIndex keyIndex = lps.getKeyIndex(operation.getTableName());
            Object oNaturalKey = keyIndex.getNaturalKey(syntheticKey.getIndex());
            Object oVal = entry.getValue();
            if (Storage.NIL.equals(oVal)) continue;
            this.addEntry(results, oNaturalKey, oVal);
        }
        msg.setResults(results);
        return msg;
    }

    public abstract void addEntry(Results var1, Object var2, Object var3);
}

