/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.net.cache.CacheStatistics;
import java.io.Serializable;

public class JmxTableStats
implements CacheStatistics,
Serializable {
    private volatile long m_lGets;
    private volatile long m_lPuts;
    private volatile long m_lGetMillis;
    private volatile long m_lPutMillis;

    @Override
    public long getTotalGets() {
        return this.m_lGets;
    }

    @Override
    public long getTotalGetsMillis() {
        return this.m_lGetMillis;
    }

    @Override
    public double getAverageGetMillis() {
        return this.m_lGets == 0L ? 0.0 : (double)(this.m_lGetMillis / this.m_lGets);
    }

    @Override
    public long getTotalPuts() {
        return this.m_lPuts;
    }

    @Override
    public long getTotalPutsMillis() {
        return this.m_lPutMillis;
    }

    @Override
    public double getAveragePutMillis() {
        return this.m_lPuts == 0L ? 0.0 : (double)(this.m_lPutMillis / this.m_lPuts);
    }

    @Override
    public void resetHitStatistics() {
        this.reset();
    }

    @Override
    public long getCacheHits() {
        return -1L;
    }

    @Override
    public long getCacheHitsMillis() {
        return -1L;
    }

    @Override
    public double getAverageHitMillis() {
        return -1.0;
    }

    @Override
    public long getCacheMisses() {
        return -1L;
    }

    @Override
    public long getCacheMissesMillis() {
        return -1L;
    }

    @Override
    public double getAverageMissMillis() {
        return -1.0;
    }

    @Override
    public double getHitProbability() {
        return -1.0;
    }

    @Override
    public long getCachePrunes() {
        return -1L;
    }

    @Override
    public long getCachePrunesMillis() {
        return -1L;
    }

    public void incrementTotalGets() {
        ++this.m_lGets;
    }

    public void incrementTotalPuts() {
        ++this.m_lPuts;
    }

    public void incrementTotalGetMillis(long lMillis) {
        this.m_lGetMillis += lMillis;
    }

    public void incrementTotalPutMillis(long lMillis) {
        this.m_lPutMillis += lMillis;
    }

    public long getTotalPutMillis() {
        return this.m_lPutMillis;
    }

    public void reset() {
        this.m_lGets = 0L;
        this.m_lPuts = 0L;
        this.m_lGetMillis = 0L;
        this.m_lPutMillis = 0L;
    }
}

