/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.util.LongArray;
import com.tangosol.util.SparseArray;

public class KeyIndex {
    private int m_iPartition;
    private final LongArray m_naturalKeys = new SparseArray();

    public KeyIndex(int iPartition) {
        this.m_iPartition = iPartition;
    }

    public synchronized SyntheticKey takeSyntheticKey(Object oNatural) {
        long lIndex = this.m_naturalKeys.indexOf(oNatural);
        if (lIndex < 0L) {
            lIndex = this.m_naturalKeys.add(oNatural);
        }
        return new SyntheticKey(this.m_iPartition, lIndex);
    }

    public synchronized SyntheticKey getSyntheticKey(Object oNatural) {
        long lIndex = this.m_naturalKeys.indexOf(oNatural);
        return lIndex >= 0L ? new SyntheticKey(this.m_iPartition, lIndex) : null;
    }

    public synchronized Object getNaturalKey(long lSynthetic) {
        return this.m_naturalKeys.get(lSynthetic);
    }

    public synchronized boolean containsNaturalKey(long lSynthetic) {
        return this.m_naturalKeys.exists(lSynthetic);
    }

    public synchronized void addKey(long lSynthetic, Object oNatural) {
        this.m_naturalKeys.set(lSynthetic, oNatural);
    }
}

