/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.exception.UnableToAcquireLockException;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfo;

public class LockManager {
    public boolean acquireLock(TransactionId xid, TableInfo tableInfo, SyntheticKey key) {
        int iPartition = key.getPartition();
        String sTable = tableInfo.getTableName();
        String sService = tableInfo.getServiceName();
        LocalPartitionState lps = LocalMemberState.getMemberState(sService).getLocalPartitionState(iPartition);
        try {
            return lps.ensureVersionIndex(sTable).setWriteLock(key, xid);
        }
        catch (UnableToAcquireLockException e) {
            Object oNaturalKey = lps.getKeyIndex(sTable).getNaturalKey(key.getIndex());
            throw new UnableToAcquireLockException("Unable to acquire write lock for key:" + oNaturalKey, e);
        }
    }

    public void unlock(TableInfo tableInfo, SyntheticKey key) {
        LocalMemberState lms = LocalMemberState.getMemberState(tableInfo.getServiceName());
        LocalPartitionState lps = lms.getLocalPartitionState(key.getPartition());
        lps.ensureVersionIndex(tableInfo.getTableName()).releaseWriteLock(key);
    }

    public boolean isLocked(TableInfo tableInfo, SyntheticKey key) {
        LocalMemberState lms = LocalMemberState.getMemberState(tableInfo.getServiceName());
        LocalPartitionState lps = lms.getLocalPartitionState(key.getPartition());
        return lps.ensureVersionIndex(tableInfo.getTableName()).getLockOwner(key) != null;
    }
}

