/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.storage.PartitionIdentity;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class SyntheticKey
implements PartitionIdentity,
ExternalizableLite,
PortableObject {
    private long m_lKey;
    private static final int NUM_PARTITION_BITS = 14;
    private static final int NUM_INDEX_BITS = 49;
    private static final long MAX_INDEX = 0x1FFFFFFFFFFFFL;
    private static final long MAX_PARTITION = 16383L;
    private static final long MASK_INDEX = 0x1FFFFFFFFFFFFL;

    public SyntheticKey() {
    }

    public SyntheticKey(int iPartition, long lIndex) {
        Base.azzert(iPartition >= 0 && (long)iPartition <= 16383L);
        Base.azzert(lIndex >= 0L && lIndex <= 0x1FFFFFFFFFFFFL);
        this.m_lKey = (long)iPartition << 49 | lIndex;
    }

    public SyntheticKey(long lKey) {
        this.m_lKey = lKey;
    }

    @Override
    public int getPartition() {
        return SyntheticKey.getPartition(this.m_lKey);
    }

    public long getIndex() {
        return SyntheticKey.getIndex(this.m_lKey);
    }

    public long toLong() {
        return this.m_lKey;
    }

    public static int getPartition(long lKey) {
        return (int)(lKey >> 49);
    }

    public static long getIndex(long lKey) {
        return lKey & 0x1FFFFFFFFFFFFL;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof SyntheticKey && this.m_lKey == ((SyntheticKey)other).m_lKey;
    }

    public int hashCode() {
        return (int)(this.m_lKey ^ this.m_lKey >>> 32);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_lKey = ExternalizableHelper.readLong(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeLong(out, this.m_lKey);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_lKey = in.readLong(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_lKey);
    }
}

