/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.LockManager;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.SyntheticKey;
import com.tangosol.coherence.transaction.internal.storage.TableInfo;
import com.tangosol.coherence.transaction.internal.storage.TableInfoImpl;
import com.tangosol.coherence.transaction.internal.storage.ValuesEvictionPolicy;
import com.tangosol.coherence.transaction.internal.storage.VersionDependencyManager;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.DefaultConfigurableCacheFactory;
import com.tangosol.net.cache.LocalCache;

public class ValueBackingMap
extends LocalCache {
    private TableInfo m_tableInfo;
    private BackingMapManagerContext m_context;

    public ValueBackingMap(String sTable, BackingMapManagerContext context, String sHighUnits) {
        CacheFactory.log("Transactional Storage High Units: " + sHighUnits, 5);
        this.m_context = context;
        this.m_tableInfo = new TableInfoImpl(Schema.getLogicalTableName(sTable), context.getCacheService().getInfo().getServiceName());
        this.setUnitCalculator(INSTANCE_BINARY);
        this.setHighUnits((int)DefaultConfigurableCacheFactory.parseMemorySize(sHighUnits));
        this.setEvictionPolicy(new ValuesEvictionPolicy(this.m_tableInfo));
    }

    @Override
    public Object put(Object key, Object value) {
        Object lock;
        if (!this.m_context.isKeyOwned(key) && (lock = this.m_context.getInternalValueDecoration(value, 3)) != null) {
            XidSyntheticKey xidKey = (XidSyntheticKey)this.m_context.getKeyFromInternalConverter().convert(key);
            this.ensureWriteLock(xidKey);
            this.ensureWriteVersionDependency(lock, xidKey);
        }
        return super.put(key, value);
    }

    private void ensureWriteVersionDependency(Object lock, XidSyntheticKey xidKey) {
        long lVersion = (Long)lock;
        LocalMemberState lms = LocalMemberState.getMemberState(this.m_tableInfo.getServiceName());
        LocalPartitionState lps = lms.ensureLocalPartitionState(SyntheticKey.getPartition(xidKey.getKey()));
        VersionDependencyManager dependencyManager = lps.getDependencyManager();
        lms.setCurrentWriteVersion(lVersion);
        dependencyManager.addDependency(xidKey.getXid(), lVersion);
    }

    private void ensureWriteLock(XidSyntheticKey xidKey) {
        SyntheticKey synKey = new SyntheticKey(xidKey.getKey());
        LockManager lockManager = ServiceContext.getContext(this.m_tableInfo.getServiceName()).getLockManager();
        lockManager.acquireLock(xidKey.getXid(), this.m_tableInfo, synKey);
    }
}

