/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.storage;

import com.tangosol.coherence.transaction.internal.ServiceContext;
import com.tangosol.coherence.transaction.internal.storage.FixedPartitionKey;
import com.tangosol.coherence.transaction.internal.storage.LocalMemberState;
import com.tangosol.coherence.transaction.internal.storage.LocalPartitionState;
import com.tangosol.coherence.transaction.internal.storage.PartitionIdentity;
import com.tangosol.coherence.transaction.internal.storage.Schema;
import com.tangosol.coherence.transaction.internal.storage.TableInfo;
import com.tangosol.coherence.transaction.internal.storage.VersionIndex;
import com.tangosol.coherence.transaction.internal.storage.XidSyntheticKey;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.Service;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.OldCache;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class ValuesEvictionPolicy
implements OldCache.EvictionPolicy,
Runnable {
    private static final double GC_THRESHOLD = 0.25;
    private static final long GC_MIN_VERSIONS = 5L;
    private final ServiceContext m_context;
    private final LocalMemberState m_memberState;
    private final TableInfo m_tableInfo;
    private final String m_sTable;

    public ValuesEvictionPolicy(TableInfo tableInfo) {
        this.m_tableInfo = tableInfo;
        this.m_sTable = tableInfo.getTableName();
        this.m_context = ServiceContext.getContext(tableInfo.getServiceName());
        this.m_memberState = this.m_context.getMemberState();
        this.m_context.getThreadPool().execute(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestEviction(int cMaximum) {
        ValuesEvictionPolicy valuesEvictionPolicy = this;
        synchronized (valuesEvictionPolicy) {
            this.notify();
        }
    }

    @Override
    public void entryTouched(ConfigurableCacheMap.Entry entry) {
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.waitToBeNotified();
                CacheFactory.log("Starting Transactional Storage Prune.", 5);
                try {
                    Collection<LocalPartitionState> collPartitons = this.m_memberState.getAllPartitions();
                    long lCeiling = this.determineCeiling(collPartitons);
                    long lCeilingCap = this.m_memberState.getCurrentWriteVersion() - 5L;
                    if (lCeiling > lCeilingCap) {
                        CacheFactory.log("Excessive transactional storage reaping (" + this.m_tableInfo.getServiceName() + ":" + this.m_tableInfo.getTableName() + ").  Check high-units setting may be too low.", 2);
                        lCeiling = lCeilingCap;
                    }
                    for (LocalPartitionState lps : collPartitons) {
                        this.sendGcRequest(lps.getPartition(), lCeiling);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    CacheFactory.log("An exception was caught by the Storage Reaper: " + e, 2);
                }
                CacheFactory.log("Completed Transactional Storage Prune.", 5);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void sendGcRequest(int iPartition, long lCeiling) {
        NamedCache valuesTable = this.m_context.getSchema().getValuesTableByName(this.m_sTable);
        valuesTable.invoke(new FixedPartitionKey(iPartition, 0), new StorageReaperProcessor(lCeiling, this.m_tableInfo));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitToBeNotified() throws InterruptedException {
        ValuesEvictionPolicy valuesEvictionPolicy = this;
        synchronized (valuesEvictionPolicy) {
            this.wait();
        }
    }

    private long determineCeiling(Collection<LocalPartitionState> collPartitons) {
        long lMin = Long.MAX_VALUE;
        long lMax = -1L;
        for (LocalPartitionState lps : collPartitons) {
            lMax = this.m_memberState.getCurrentWriteVersion();
            long lLastGcCeiling = lps.getLastGcCeiling();
            if (lLastGcCeiling != -1L) {
                lMin = Math.min(lMin, lLastGcCeiling + 1L);
                continue;
            }
            for (VersionIndex index : lps.getExistingVersionIndexes().values()) {
                lMin = index.getOldestHistoricalVersion();
            }
        }
        return Math.round((double)(lMax - lMin) * 0.25 + (double)lMin + 0.5);
    }

    public static class StorageReaperProcessor
    extends AbstractProcessor
    implements PortableObject {
        private transient long m_lCeiling;
        private transient TableInfo m_tableInfo;

        public StorageReaperProcessor() {
        }

        public StorageReaperProcessor(long lCeiling, TableInfo tableInfo) {
            this.m_lCeiling = lCeiling;
            this.m_tableInfo = tableInfo;
        }

        @Override
        public Object process(InvocableMap.Entry entry) {
            if (this.m_tableInfo == null) {
                return null;
            }
            this.deleteFromStorage(((PartitionIdentity)entry.getKey()).getPartition(), this.m_lCeiling);
            return null;
        }

        private void deleteFromStorage(int iPartition, long lCeiling) {
            String sService = this.m_tableInfo.getServiceName();
            ServiceContext ctx = ServiceContext.getContext(sService);
            LocalMemberState lms = ctx.getMemberState();
            Service service = ctx.getService();
            LocalPartitionState lps = lms.getLocalPartitionState(iPartition);
            Collection<VersionIndex> collIndexes = lps.getExistingVersionIndexes().values();
            lps.setLastGcCeiling(lCeiling);
            for (VersionIndex index : collIndexes) {
                Set<XidSyntheticKey> setKeys = index.pruneVersions(lCeiling);
                String sTable = index.getTable();
                BackingMapManagerContext context = ((CacheService)service).getBackingMapManager().getContext();
                this.deleteFromVersions(context, sTable, setKeys, index);
                this.deleteFromValues(context, sTable, setKeys);
            }
        }

        private void deleteFromVersions(BackingMapManagerContext context, String sTable, Set<XidSyntheticKey> setKeys, VersionIndex index) {
            sTable = Schema.getPhysicalVersionsTableName(sTable);
            Map map = context.getBackingMap(sTable);
            for (XidSyntheticKey key : setKeys) {
                Object binKey = context.getKeyToInternalConverter().convert(key);
                if (index.isInitialKey(key)) {
                    long lVersion = (Long)context.getValueFromInternalConverter().convert(map.get(binKey));
                    map.put(binKey, context.getValueToInternalConverter().convert(lVersion * -1L));
                    continue;
                }
                map.remove(binKey);
            }
        }

        private void deleteFromValues(BackingMapManagerContext context, String sTable, Set<XidSyntheticKey> setKeys) {
            sTable = Schema.getPhysicalValuesTableName(sTable);
            Map map = context.getBackingMap(sTable);
            for (XidSyntheticKey key : setKeys) {
                map.remove(context.getKeyToInternalConverter().convert(key));
            }
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
        }
    }
}

