/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.util;

import com.tangosol.coherence.transaction.internal.OptimisticNamedCacheImpl;
import com.tangosol.coherence.transaction.internal.operation.QueryOperation;
import com.tangosol.coherence.transaction.internal.storage.Storage;
import com.tangosol.coherence.transaction.internal.util.PartitionedSetWrapper;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.SimpleMapEntry;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.AbstractExtractor;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.InFilter;
import com.tangosol.util.filter.NotFilter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class PartitionedEntrySetWrapper
extends PartitionedSetWrapper {
    public PartitionedEntrySetWrapper(QueryOperation operation, OptimisticNamedCacheImpl cache) {
        super(operation, cache);
    }

    @Override
    protected Set getSet(Map results) {
        return results.entrySet();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)o;
            Object oValue = this.getCache().get(entry.getKey());
            return Base.equals(entry.getValue(), oValue);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection collection) {
        LinkedList keyCollection = new LinkedList();
        for (Object o : collection) {
            if (o instanceof Map.Entry) {
                return false;
            }
            keyCollection.add(((Map.Entry)o).getKey());
        }
        Map map = this.getCache().getAll(keyCollection);
        if (map.size() != keyCollection.size()) {
            return false;
        }
        for (Object o : collection) {
            Map.Entry entry = (Map.Entry)o;
            Object oValue = map.get(entry.getKey());
            if ((oValue != null || map.containsKey(entry.getKey())) && entry.getValue().equals(oValue)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Map.Entry) {
            Object oKey = ((Map.Entry)o).getKey();
            return this.getCache().remove(oKey) != null;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        return c != null && c.size() != 0 && this.updateAll(new InFilter((ValueExtractor)new EntryExtractor(), this.getSerializableEntrySet(c)), Storage.NIL);
    }

    @Override
    public boolean retainAll(Collection c) {
        AlwaysFilter filter = c == null || c.size() == 0 ? AlwaysFilter.INSTANCE : new NotFilter(new InFilter((ValueExtractor)new EntryExtractor(), this.getSerializableEntrySet(c)));
        return this.updateAll(filter, Storage.NIL);
    }

    private Set getSerializableEntrySet(Collection c) {
        HashSet<SimpleMapEntry> set = new HashSet<SimpleMapEntry>();
        for (Object o : c) {
            if (!(o instanceof Map.Entry)) continue;
            Map.Entry entry = (Map.Entry)o;
            set.add(new SimpleMapEntry(entry.getKey(), entry.getValue()));
        }
        return set;
    }

    public class EntryExtractor
    extends AbstractExtractor
    implements ExternalizableLite,
    PortableObject {
        @Override
        public Object extractFromEntry(Map.Entry entry) {
            return new SimpleMapEntry(entry.getKey(), entry.getValue());
        }

        @Override
        public void readExternal(DataInput in) throws IOException {
        }

        @Override
        public void writeExternal(DataOutput out) throws IOException {
        }

        @Override
        public void readExternal(PofReader in) throws IOException {
        }

        @Override
        public void writeExternal(PofWriter out) throws IOException {
        }
    }
}

