/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.xa;

import com.tangosol.coherence.transaction.TransactionId;
import com.tangosol.coherence.transaction.internal.xa.RecoveryTransactionFactory;
import com.tangosol.coherence.transaction.internal.xa.TxBranchState;
import com.tangosol.coherence.transaction.internal.xa.XABranch;
import com.tangosol.coherence.transaction.internal.xa.XAConnection;
import com.tangosol.coherence.transaction.internal.xa.XAResourceAction;
import com.tangosol.coherence.transaction.internal.xa.XidWrapper;
import com.tangosol.net.Service;
import com.tangosol.util.Base;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class XAResourceImpl
implements XAResource {
    private XAConnection m_connection;
    private boolean m_fLastCommitOption;
    private int m_nLastTimeout = -1;
    private TxBranchState m_branchState;
    private Map<XidWrapper, TransactionId> m_mapPreparedXids;
    private static Map<Xid, TxBranchState> m_mapTxBranchState = new HashMap<Xid, TxBranchState>();
    private static Map<GlobalTransactionId, GlobalTransactionState> m_mapGlobalTxState = new HashMap<GlobalTransactionId, GlobalTransactionState>();
    private static final int NO_TRANSACTION_TIMEOUT_VALUE = -1;

    public XAResourceImpl(XAConnection conn, Map mapXids) {
        Base.azzert(conn != null, "connection can not be null.");
        Base.azzert(mapXids != null, "mapXids can not be null.");
        this.m_connection = conn;
        this.m_mapPreparedXids = mapXids;
    }

    @Override
    public void start(Xid xid, int nFlags) throws XAException {
        TxBranchState branchState;
        XAResourceAction action = XAResourceAction.actionFromXAResourceStartFlags(nFlags);
        if (nFlags == 0x200000 || nFlags == 0x8000000) {
            branchState = this.assertTxBranchState(xid);
            this.setTransaction(this.assertTransaction(xid));
        } else {
            this.checkDuplicateTxBranch(xid);
            branchState = this.createTxBranchState(xid, TxBranchState.INITIAL_ST);
            this.setTransaction(xid);
        }
        branchState.registerAction(action);
        this.m_branchState = branchState;
    }

    @Override
    public void end(Xid xid, int nFlags) throws XAException {
        XAResourceAction action = XAResourceAction.actionFromXAResourceEndFlags(nFlags);
        TxBranchState branchState = this.assertTxBranchState(xid);
        branchState.registerAction(action);
        this.startNewTransaction(this.m_fLastCommitOption);
        this.restoreTransactionTimeout();
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        TxBranchState branchState = this.assertTxBranchState(xid);
        if (this.isPrepared(xid)) {
            branchState.registerAction(XAResourceAction.PREPARE_RDONLY);
            return 3;
        }
        branchState.registerAction(XAResourceAction.PREPARE);
        this.setPrepared(xid);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean fOnePC) throws XAException {
        try {
            XABranch tx = this.getTransaction(xid);
            if (tx == null) {
                tx = this.recoverPreparedTransaction(xid);
            }
            TxBranchState branchState = this.assertTxBranchState(xid);
            XAResourceAction action = fOnePC ? XAResourceAction.COMMIT_1PC : XAResourceAction.COMMIT_2PC;
            branchState.registerAction(action);
            this.internalCommit(tx, fOnePC);
        }
        finally {
            this.remove(xid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            XABranch tx = this.getTransaction(xid);
            if (tx == null) {
                tx = this.recoverPreparedTransaction(xid);
            }
            TxBranchState branchState = this.assertTxBranchState(xid);
            branchState.registerAction(XAResourceAction.ROLLBACK);
            this.internalRollback(tx);
        }
        finally {
            this.remove(xid);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        TxBranchState branchState = this.getTxBranchState(xid);
        if (branchState != null) {
            branchState.registerAction(XAResourceAction.FORGET);
        }
        this.remove(xid);
    }

    @Override
    public Xid[] recover(int nFlags) throws XAException {
        boolean fEndScan;
        boolean fStartScan = (nFlags & 0x1000000) != 0;
        boolean bl = fEndScan = (nFlags & 0x800000) != 0;
        if (nFlags != 0 && !fStartScan && !fEndScan) {
            XAException ex = new XAException("Invalid nFlags: One of TMSTARTRSCAN, TMENDRSCAN,  TMNOFLAGS must be used.  TMNOFLAGS must be used when  no other flags are set in the parameter. ");
            ex.errorCode = -5;
            throw ex;
        }
        return fStartScan ? this.getPrepared() : new Xid[]{};
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.m_connection.getTransactionTimeout();
    }

    @Override
    public boolean setTransactionTimeout(int nSeconds) throws XAException {
        this.recordTransactionTimeout();
        this.m_connection.setTransactionTimeout(nSeconds == 0 ? 300 : nSeconds);
        return true;
    }

    @Override
    public boolean isSameRM(XAResource resource) throws XAException {
        if (resource == this) {
            return true;
        }
        if (!(resource instanceof XAResourceImpl)) {
            return false;
        }
        Service thisService = this.m_connection.getService();
        Service thatService = ((XAResourceImpl)resource).m_connection.getService();
        return thisService.equals(thatService);
    }

    public boolean isActive() {
        return this.m_branchState != null && this.m_branchState.isActive();
    }

    protected void setTransaction(Xid xid) {
        XABranch tx = this.getTransaction(xid);
        if (tx == null) {
            this.m_fLastCommitOption = this.m_connection.isAutoCommit();
            this.startNewTransaction(false);
            tx = this.m_connection.getXABranch();
            this.putGlobalTransactionState(xid, new GlobalTransactionState(tx));
        } else {
            this.setTransaction(tx);
        }
    }

    protected void setTransaction(XABranch tx) {
        this.m_connection.associateTransaction(tx);
    }

    protected void startNewTransaction(boolean fCommitOption) {
        this.m_connection.associateTransaction(fCommitOption);
    }

    protected XABranch getTransaction(Xid xid) {
        GlobalTransactionState globalTxState = this.getGlobalTransactionState(xid);
        return globalTxState == null ? null : globalTxState.getBranch();
    }

    protected XABranch assertTransaction(Xid xid) throws XAException {
        return this.assertGlobalTransactionState(xid).getBranch();
    }

    protected XABranch recoverPreparedTransaction(Xid xid) throws XAException {
        TransactionId txId = this.m_mapPreparedXids.get(new XidWrapper(xid));
        if (txId == null) {
            XAException ex = new XAException("The XID " + xid + " is not valid.");
            ex.errorCode = -4;
            throw ex;
        }
        XABranch tx = RecoveryTransactionFactory.createTransaction(txId, this.m_connection.getService().getInfo().getServiceName());
        this.createTxBranchState(xid, TxBranchState.PREPARED_ST);
        return tx;
    }

    protected void checkDuplicateTxBranch(Xid xid) throws XAException {
        if (m_mapTxBranchState.get(xid) != null) {
            XAException ex = new XAException("The XID " + xid + " already exists.");
            ex.errorCode = -8;
            throw ex;
        }
    }

    protected TxBranchState getTxBranchState(Xid xid) {
        return m_mapTxBranchState.get(xid);
    }

    protected TxBranchState assertTxBranchState(Xid xid) throws XAException {
        TxBranchState branchState = this.getTxBranchState(xid);
        if (branchState == null) {
            XAException ex = new XAException("Invalid Xid " + xid);
            ex.errorCode = -4;
            throw ex;
        }
        return branchState;
    }

    protected TxBranchState createTxBranchState(Xid xid, TxBranchState.TxBranchStateValue initialState) {
        TxBranchState branchState = new TxBranchState(initialState);
        m_mapTxBranchState.put(xid, branchState);
        return branchState;
    }

    protected Xid[] getPrepared() {
        Set<XidWrapper> setKeys = this.m_mapPreparedXids.keySet();
        Object[] key = setKeys.toArray();
        Xid[] xid = new Xid[key.length];
        for (int i = 0; i < key.length; ++i) {
            xid[i] = ((XidWrapper)key[i]).getXid();
        }
        return xid;
    }

    protected GlobalTransactionState getGlobalTransactionState(Xid xid) {
        GlobalTransactionId key = new GlobalTransactionId(xid);
        return m_mapGlobalTxState.get(key);
    }

    protected GlobalTransactionState assertGlobalTransactionState(Xid xid) throws XAException {
        GlobalTransactionState globalTxState = this.getGlobalTransactionState(xid);
        if (globalTxState == null) {
            XAException ex = new XAException("The XID " + xid + " is not valid.");
            ex.errorCode = -4;
            throw ex;
        }
        return globalTxState;
    }

    protected void putGlobalTransactionState(Xid xid, GlobalTransactionState globalTxState) {
        m_mapGlobalTxState.put(new GlobalTransactionId(xid), globalTxState);
    }

    protected boolean isPrepared(Xid xid) {
        GlobalTransactionState globalTxState = this.getGlobalTransactionState(xid);
        return globalTxState != null && globalTxState.isPrepared();
    }

    protected void setPrepared(Xid xid) throws XAException {
        GlobalTransactionState globalTxState = this.assertGlobalTransactionState(xid);
        globalTxState.setPrepared();
        int nReturn = globalTxState.getBranch().prepare();
        if (nReturn != 0) {
            throw new XAException(nReturn);
        }
        TransactionId transactionId = globalTxState.getBranch().getXid();
        this.m_mapPreparedXids.put(new XidWrapper(xid), transactionId);
    }

    protected void remove(Xid xid) {
        this.removeGlobalTxState(xid);
        m_mapTxBranchState.remove(xid);
        this.m_mapPreparedXids.remove(new XidWrapper(xid));
    }

    public void removeGlobalTxState(Xid xid) {
        m_mapGlobalTxState.remove(new GlobalTransactionId(xid));
    }

    private void recordTransactionTimeout() {
        if (this.m_nLastTimeout == -1) {
            this.m_nLastTimeout = this.m_connection.getTransactionTimeout();
        }
    }

    private void restoreTransactionTimeout() {
        if (this.m_nLastTimeout != -1) {
            this.m_connection.setTransactionTimeout(this.m_nLastTimeout);
            this.m_nLastTimeout = -1;
        }
    }

    protected void internalCommit(XABranch tx, boolean fOnePC) throws XAException {
        try {
            tx.commit();
        }
        catch (Exception e) {
            if (fOnePC) {
                throw new XAException(100);
            }
            throw new XAException(-3);
        }
    }

    protected void internalRollback(XABranch tx) {
        tx.rollback();
    }

    public static class GlobalTransactionState {
        private boolean m_fPrepared;
        private XABranch m_tx;

        public GlobalTransactionState(XABranch tx) {
            this.m_tx = tx;
            this.m_fPrepared = false;
        }

        public XABranch getBranch() {
            return this.m_tx;
        }

        public boolean isPrepared() {
            return this.m_fPrepared;
        }

        public void setPrepared() {
            this.m_fPrepared = true;
        }
    }

    public static class GlobalTransactionId {
        private byte[] m_id;

        public GlobalTransactionId(Xid xid) {
            this.m_id = xid.getGlobalTransactionId();
        }

        public int hashCode() {
            int hash = 37;
            int multiplier = 13;
            for (byte b : this.m_id) {
                hash = hash * multiplier + b;
            }
            return hash;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof GlobalTransactionId && Arrays.equals(this.m_id, ((GlobalTransactionId)o).m_id);
        }
    }
}

