/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.coherence.transaction.internal.xa;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.Base;
import com.tangosol.util.ExternalizableHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.transaction.xa.Xid;

public class XidWrapper
implements ExternalizableLite,
PortableObject {
    private Xid m_xid;

    public XidWrapper() {
    }

    public XidWrapper(Xid xid) {
        this.m_xid = xid;
    }

    public Xid getXid() {
        return this.m_xid;
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_xid = (Xid)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_xid);
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        byte[] bytes = in.readByteArray(1);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        try {
            this.m_xid = (Xid)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unable to de-serialize Xid: " + e);
        }
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oas = new ObjectOutputStream(baos);
        oas.writeObject(this.m_xid);
        oas.close();
        out.writeByteArray(1, baos.toByteArray());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof XidWrapper) {
            XidWrapper that = (XidWrapper)o;
            return Base.equals(this.m_xid, that.m_xid);
        }
        return false;
    }

    public int hashCode() {
        return this.m_xid.hashCode();
    }
}

