/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.MethodConstant;
import com.tangosol.dev.assembler.VMStructure;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class EnclosingMethodAttribute
extends Attribute
implements Constants {
    private MethodConstant m_methEnclosing;
    private boolean m_fModified;

    protected EnclosingMethodAttribute(VMStructure context) {
        super(context, "EnclosingMethod");
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        stream.readInt();
        this.m_methEnclosing = new MethodConstant();
        this.m_methEnclosing.disassemble(stream, pool);
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(super.getNameConstant());
        this.m_methEnclosing.preassemble(pool);
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        stream.writeShort(pool.findConstant(super.getNameConstant()));
        stream.writeInt(4);
        stream.writeShort(pool.findConstant(this.m_methEnclosing.getClassConstant()));
        stream.writeShort(pool.findConstant(this.m_methEnclosing.getSignatureConstant()));
    }

    @Override
    public boolean isModified() {
        return this.m_fModified;
    }

    @Override
    protected void resetModified() {
        this.m_fModified = false;
    }

    @Override
    public String toString() {
        return super.getName() + '=' + this.m_methEnclosing;
    }

    public MethodConstant getEnclosingMethod() {
        return this.m_methEnclosing;
    }

    public void setEnclosingMethod(MethodConstant methEnclosing) {
        this.m_methEnclosing = methEnclosing;
        this.m_fModified = true;
    }
}

