/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.AccessFlags;
import com.tangosol.dev.assembler.Attribute;
import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.ConstantValueAttribute;
import com.tangosol.dev.assembler.Constants;
import com.tangosol.dev.assembler.DeprecatedAttribute;
import com.tangosol.dev.assembler.SyntheticAttribute;
import com.tangosol.dev.assembler.UtfConstant;
import com.tangosol.dev.assembler.VMStructure;
import com.tangosol.util.StringTable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Enumeration;

public class Field
extends VMStructure
implements Constants {
    private static final String CLASS = "Field";
    private static final int ACC_FIELD = 20703;
    private UtfConstant m_utfName;
    private UtfConstant m_utfType;
    private AccessFlags m_flags = new AccessFlags();
    private StringTable m_tblAttribute = new StringTable();
    private boolean m_fModified;

    protected Field() {
    }

    protected Field(String sName, String sType) {
        this(new UtfConstant(sName), new UtfConstant(sType.replace('.', '/')));
    }

    protected Field(UtfConstant constantName, UtfConstant constantType) {
        if (constantName == null || constantType == null) {
            throw new IllegalArgumentException("Field:  Values cannot be null!");
        }
        this.m_utfName = constantName;
        this.m_utfType = constantType;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_flags.disassemble(stream, pool);
        this.m_utfName = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
        this.m_utfType = (UtfConstant)pool.getConstant(stream.readUnsignedShort());
        this.m_tblAttribute.clear();
        int cAttr = stream.readUnsignedShort();
        for (int i = 0; i < cAttr; ++i) {
            Attribute attr = Attribute.loadAttribute(this, stream, pool);
            this.m_tblAttribute.put(attr.getIdentity(), attr);
        }
    }

    @Override
    protected void preassemble(ConstantPool pool) {
        pool.registerConstant(this.m_utfName);
        pool.registerConstant(this.m_utfType);
        this.m_flags.preassemble(pool);
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            ((Attribute)enmr.nextElement()).preassemble(pool);
        }
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        this.m_flags.assemble(stream, pool);
        stream.writeShort(pool.findConstant(this.m_utfName));
        stream.writeShort(pool.findConstant(this.m_utfType));
        stream.writeShort(this.m_tblAttribute.getSize());
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            ((Attribute)enmr.nextElement()).assemble(stream, pool);
        }
    }

    @Override
    public String getIdentity() {
        return this.m_utfName.getValue();
    }

    @Override
    public boolean isModified() {
        if (this.m_fModified || this.m_flags.isModified()) {
            return true;
        }
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            Attribute attr = (Attribute)enmr.nextElement();
            if (!attr.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void resetModified() {
        this.m_flags.resetModified();
        Enumeration enmr = this.m_tblAttribute.elements();
        while (enmr.hasMoreElements()) {
            ((Attribute)enmr.nextElement()).resetModified();
        }
        this.m_fModified = false;
    }

    public int compareTo(Object obj) {
        Field that = (Field)obj;
        int nResult = this.m_utfName.compareTo(that.m_utfName);
        if (nResult == 0) {
            nResult = this.m_utfType.compareTo(that.m_utfType);
        }
        return nResult;
    }

    public String toString() {
        String sMods = this.m_flags.toString(20703);
        String sType = this.getTypeString();
        String sName = this.m_utfName.getValue();
        StringBuffer sb = new StringBuffer();
        if (sMods.length() > 0) {
            sb.append(sMods).append(' ');
        }
        sb.append(sType).append(' ').append(sName);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        try {
            Field that = (Field)obj;
            return this == that || this.getClass() == that.getClass() && this.m_utfName.equals(that.m_utfName) && this.m_utfType.equals(that.m_utfType) && this.m_flags.equals(that.m_flags) && this.m_tblAttribute.equals(that.m_tblAttribute);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public static String toTypeString(String sSig) {
        switch (sSig.charAt(0)) {
            case 'V': {
                return "void";
            }
            case 'Z': {
                return "boolean";
            }
            case 'B': {
                return "byte";
            }
            case 'C': {
                return "char";
            }
            case 'S': {
                return "short";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case 'L': {
                return sSig.substring(1, sSig.indexOf(59)).replace('/', '.');
            }
            case '[': {
                int of = 0;
                while (Field.isDecimal(sSig.charAt(++of))) {
                }
                return Field.toTypeString(sSig.substring(of)) + '[' + sSig.substring(1, of) + ']';
            }
        }
        throw new IllegalArgumentException("JVM Type Signature cannot start with '" + sSig.charAt(0) + "'");
    }

    public String getName() {
        return this.m_utfName.getValue();
    }

    public String getType() {
        return this.m_utfType.getValue();
    }

    public String getTypeString() {
        return Field.toTypeString(this.m_utfType.getValue());
    }

    public UtfConstant getNameConstant() {
        return this.m_utfName;
    }

    public UtfConstant getTypeConstant() {
        return this.m_utfType;
    }

    public int getAccess() {
        return this.m_flags.getAccess();
    }

    public void setAccess(int nAccess) {
        this.m_flags.setAccess(nAccess);
    }

    public boolean isPublic() {
        return this.m_flags.isPublic();
    }

    public void setPublic() {
        this.m_flags.setPublic();
    }

    public boolean isProtected() {
        return this.m_flags.isProtected();
    }

    public void setProtected() {
        this.m_flags.setProtected();
    }

    public boolean isPackage() {
        return this.m_flags.isPackage();
    }

    public void setPackage() {
        this.m_flags.setPackage();
    }

    public boolean isPrivate() {
        return this.m_flags.isPrivate();
    }

    public void setPrivate() {
        this.m_flags.setPrivate();
    }

    public boolean isStatic() {
        return this.m_flags.isStatic();
    }

    public void setStatic(boolean fStatic) {
        this.m_flags.setStatic(fStatic);
    }

    public boolean isFinal() {
        return this.m_flags.isFinal();
    }

    public void setFinal(boolean fFinal) {
        this.m_flags.setFinal(fFinal);
    }

    public boolean isVolatile() {
        return this.m_flags.isVolatile();
    }

    public void setVolatile(boolean fVolatile) {
        this.m_flags.setVolatile(fVolatile);
    }

    public boolean isTransient() {
        return this.m_flags.isTransient();
    }

    public void setTransient(boolean fTransient) {
        this.m_flags.setTransient(fTransient);
    }

    public boolean isEnum() {
        return this.m_flags.isEnum();
    }

    public void setEnum(boolean fEnum) {
        this.m_flags.setEnum(fEnum);
    }

    public Attribute getAttribute(String sName) {
        return (Attribute)this.m_tblAttribute.get(sName);
    }

    public Attribute addAttribute(String sName) {
        Attribute attribute = null;
        attribute = sName.equals("ConstantValue") ? new ConstantValueAttribute(this) : (sName.equals("Deprecated") ? new DeprecatedAttribute(this) : (sName.equals("Synthetic") ? new SyntheticAttribute(this) : new Attribute((VMStructure)this, sName)));
        this.m_tblAttribute.put(attribute.getIdentity(), attribute);
        this.m_fModified = true;
        return attribute;
    }

    public void removeAttribute(String sName) {
        this.m_tblAttribute.remove(sName);
        this.m_fModified = true;
    }

    public Enumeration getAttributes() {
        return this.m_tblAttribute.elements();
    }

    public boolean isConstant() {
        return this.isFinal() && this.m_tblAttribute.contains("ConstantValue");
    }

    public Constant getConstantValue() {
        ConstantValueAttribute attr = (ConstantValueAttribute)this.m_tblAttribute.get("ConstantValue");
        return attr == null ? null : attr.getConstant();
    }

    public void setConstantValue(Constant constant) {
        this.setFinal(true);
        ConstantValueAttribute attr = (ConstantValueAttribute)this.addAttribute("ConstantValue");
        attr.setConstant(constant);
    }

    public boolean isDeprecated() {
        return this.m_tblAttribute.contains("Deprecated");
    }

    public void setDeprecated(boolean fDeprecated) {
        if (fDeprecated) {
            this.addAttribute("Deprecated");
        } else {
            this.removeAttribute("Deprecated");
        }
    }

    public boolean isSynthetic() {
        return this.m_tblAttribute.contains("Synthetic");
    }

    public void setSynthetic(boolean fSynthetic) {
        if (fSynthetic) {
            this.addAttribute("Synthetic");
        } else {
            this.removeAttribute("Synthetic");
        }
    }
}

