/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.assembler;

import com.tangosol.dev.assembler.Constant;
import com.tangosol.dev.assembler.ConstantPool;
import com.tangosol.dev.assembler.Constants;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class UtfConstant
extends Constant
implements Constants {
    private static final String CLASS = "UtfConstant";
    private String m_sText;

    protected UtfConstant() {
        super(1);
    }

    public UtfConstant(String sText) {
        this();
        if (sText == null) {
            throw new IllegalArgumentException("UtfConstant:  Value cannot be null!");
        }
        this.m_sText = sText;
    }

    @Override
    protected void disassemble(DataInput stream, ConstantPool pool) throws IOException {
        this.m_sText = stream.readUTF();
    }

    @Override
    protected void assemble(DataOutput stream, ConstantPool pool) throws IOException {
        super.assemble(stream, pool);
        stream.writeUTF(this.m_sText);
    }

    @Override
    public int compareTo(Object obj) {
        UtfConstant that = (UtfConstant)obj;
        return this.m_sText.compareTo(that.m_sText);
    }

    @Override
    public String toString() {
        return "(Utf) " + UtfConstant.toQuotedStringEscape(this.m_sText);
    }

    @Override
    public String format() {
        return this.m_sText;
    }

    @Override
    public boolean equals(Object obj) {
        try {
            UtfConstant that = (UtfConstant)obj;
            return this == that || this.getClass() == that.getClass() && this.m_sText.equals(that.m_sText);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String getValue() {
        return this.m_sText;
    }
}

