/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.assembler.CodeAttribute;
import com.tangosol.dev.assembler.Ixor;
import com.tangosol.dev.assembler.Lxor;
import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.BitwiseExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.component.DataType;
import com.tangosol.util.ErrorList;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BitXorExpression
extends BitwiseExpression {
    private static final String CLASS = "BitXorExpression";

    public BitXorExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        DualSet setULeft = new DualSet(setUVars);
        left = (Expression)left.precompile(ctx, setULeft, setFVars, mapThrown, errlist);
        DualSet setURight = new DualSet(setULeft);
        right = (Expression)right.precompile(ctx, setURight, setFVars, mapThrown, errlist);
        if (left.getType() == BOOLEAN && right.getType() == BOOLEAN) {
            if (setULeft.isModified() || setURight.isModified()) {
                Set setLeftTrue = setULeft.getTrueSet().getRemoved();
                Set setLeftFalse = setULeft.getFalseSet().getRemoved();
                Set setRightTrue = setURight.getTrueSet().getRemoved();
                Set setRightFalse = setURight.getFalseSet().getRemoved();
                HashSet setAssigned = new HashSet(setLeftTrue);
                setAssigned.retainAll(setRightTrue);
                setUVars.getTrueSet().removeAll(setAssigned);
                setAssigned = new HashSet(setLeftFalse);
                setAssigned.retainAll(setRightFalse);
                setUVars.getTrueSet().removeAll(setAssigned);
                setAssigned = new HashSet(setLeftTrue);
                setAssigned.retainAll(setRightFalse);
                setUVars.getFalseSet().removeAll(setAssigned);
                setAssigned = new HashSet(setLeftFalse);
                setAssigned.retainAll(setRightTrue);
                setUVars.getFalseSet().removeAll(setAssigned);
            }
            this.setType(BOOLEAN);
        } else if (left.checkIntegral(errlist) & right.checkIntegral(errlist)) {
            setURight.resolve();
            setULeft.resolve();
            left = left.promoteNumeric(right);
            right = right.promoteNumeric(left);
            this.setType(left.getType());
        } else {
            this.setType(INT);
        }
        this.setLeftExpression(left);
        this.setRightExpression(right);
        return this;
    }

    @Override
    protected boolean compile(Context ctx, CodeAttribute code, boolean fReached, ErrorList errlist) throws CompilerException {
        if (!ctx.isDebug() && this.isConstant()) {
            return super.compile(ctx, code, fReached, errlist);
        }
        this.getLeftExpression().compile(ctx, code, fReached, errlist);
        this.getRightExpression().compile(ctx, code, fReached, errlist);
        if (this.getType() == DataType.LONG) {
            code.add(new Lxor());
        } else {
            code.add(new Ixor());
        }
        return fReached;
    }

    @Override
    public Object getValue() {
        Object oLeft = this.getLeftExpression().getValue();
        Object oRight = this.getRightExpression().getValue();
        DataType dt = this.getType();
        Serializable oVal = dt == BOOLEAN ? (Serializable)new Boolean((Boolean)oLeft ^ (Boolean)oRight) : (Serializable)(dt == LONG ? (Number)BitXorExpression.makeLong(((Number)oLeft).longValue() ^ ((Number)oRight).longValue()) : (Number)BitXorExpression.makeInteger(((Number)oLeft).intValue() ^ ((Number)oRight).intValue()));
        return oVal;
    }
}

