/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.dev.compiler.java;

import com.tangosol.dev.compiler.CompilerException;
import com.tangosol.dev.compiler.Context;
import com.tangosol.dev.compiler.java.AssignExpression;
import com.tangosol.dev.compiler.java.CastExpression;
import com.tangosol.dev.compiler.java.DualSet;
import com.tangosol.dev.compiler.java.Element;
import com.tangosol.dev.compiler.java.Expression;
import com.tangosol.dev.compiler.java.Token;
import com.tangosol.dev.compiler.java.TypeExpression;
import com.tangosol.util.ErrorList;
import java.util.Map;

public class CastAssignExpression
extends AssignExpression {
    private static final String CLASS = "CastAssignExpression";

    public CastAssignExpression(Expression left, Token operator, Expression right) {
        super(left, operator, right);
    }

    @Override
    protected Element precompile(Context ctx, DualSet setUVars, DualSet setFVars, Map mapThrown, ErrorList errlist) throws CompilerException {
        Expression left = this.getLeftExpression();
        Expression right = this.getRightExpression();
        left = (Expression)left.precompile(ctx, setUVars, setFVars, mapThrown, errlist);
        left.checkAssignable(errlist);
        TypeExpression type = new TypeExpression(this.getBlock(), this.getOperator(), left.getType());
        right = new CastExpression(this.getOperator(), right, type);
        this.setLeftExpression(left);
        this.setRightExpression(right);
        return super.precompile(ctx, setUVars, setFVars, mapThrown, errlist, true);
    }
}

